/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.simple;

import edu.stanford.nlp.simple.Document;
import edu.stanford.nlp.simple.Sentence;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;

public class DocumentTest {
    @Test
    public void testCreateFromText() {
        Document doc = new Document("the quick brown fox jumped over the lazy dog");
        Assert.assertNotNull((Object)doc);
    }

    @Test
    public void testText() {
        Document doc = new Document("the quick brown fox jumped over the lazy dog");
        Assert.assertEquals((Object)"the quick brown fox jumped over the lazy dog", (Object)doc.text());
    }

    @Test
    public void testDocid() {
        Document doc = new Document("the quick brown fox jumped over the lazy dog");
        Assert.assertEquals(Optional.empty(), doc.docid());
        Assert.assertEquals(Optional.of("foo"), doc.setDocid("foo").docid());
    }

    @Test
    public void testSentences() {
        Document doc = new Document("the quick brown fox jumped over the lazy dog. The lazy dog was not impressed.");
        List<Sentence> sentences = doc.sentences();
        Assert.assertEquals((long)2L, (long)sentences.size());
        Assert.assertEquals((Object)"the quick brown fox jumped over the lazy dog.", (Object)sentences.get(0).text());
        Assert.assertEquals((Object)"The lazy dog was not impressed.", (Object)sentences.get(1).text());
    }
}

