/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.simple;

import edu.stanford.nlp.coref.data.CorefChain;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.CoreNLPProtos;
import edu.stanford.nlp.simple.Document;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class FrenchDocument
extends Document {
    static final Properties EMPTY_PROPS = new Properties(){
        {
            try (InputStream is = IOUtils.getInputStreamFromURLOrClasspathOrFileSystem("edu/stanford/nlp/pipeline/StanfordCoreNLP-french.properties");){
                this.load(is);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            this.setProperty("language", "french");
            this.setProperty("annotators", "");
        }
    };

    public FrenchDocument(String text) {
        super(EMPTY_PROPS, text);
    }

    public FrenchDocument(Annotation ann) {
        super(EMPTY_PROPS, ann);
    }

    public FrenchDocument(CoreNLPProtos.Document proto) {
        super(EMPTY_PROPS, proto);
    }

    protected FrenchDocument(Properties props, String text) {
        super(props, text);
    }

    @Override
    protected Document runLemma(Properties props) {
        return this.mockLemma(props);
    }

    @Override
    protected Document runSentiment(Properties props) {
        throw new IllegalArgumentException("Sentiment analysis is not implemented for French");
    }

    @Override
    public Map<Integer, CorefChain> coref(Properties props) {
        throw new IllegalArgumentException("Coreference is not implemented for French");
    }
}

