/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.ConjugatePrior;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.Gamma;
import edu.stanford.nlp.stats.Multinomial;
import java.util.Random;

public class Dirichlet<E>
implements ConjugatePrior<Multinomial<E>, E> {
    private static final long serialVersionUID = 1L;
    private Counter<E> parameters;

    public Dirichlet(Counter<E> parameters) {
        this.checkParameters(parameters);
        this.parameters = new ClassicCounter<E>(parameters);
    }

    private void checkParameters(Counter<E> parameters) {
        for (E o : parameters.keySet()) {
            if (!(parameters.getCount(o) < 0.0)) continue;
            throw new RuntimeException("Parameters must be non-negative!");
        }
        if (parameters.totalCount() <= 0.0) {
            throw new RuntimeException("Parameters must have positive mass!");
        }
    }

    @Override
    public Multinomial<E> drawSample(Random random) {
        return Dirichlet.drawSample(random, this.parameters);
    }

    public static <F> Multinomial<F> drawSample(Random random, Counter<F> parameters) {
        ClassicCounter<F> multParameters = new ClassicCounter<F>();
        double sum = 0.0;
        for (Object o : parameters.keySet()) {
            double parameter = Gamma.drawSample(random, parameters.getCount(o));
            sum += parameter;
            multParameters.setCount(o, parameter);
        }
        for (Object o : multParameters.keySet()) {
            multParameters.setCount(o, multParameters.getCount(o) / sum);
        }
        return new Multinomial(multParameters);
    }

    public static double[] drawSample(Random random, double[] parameters) {
        int i;
        double sum = 0.0;
        double[] result = new double[parameters.length];
        for (i = 0; i < parameters.length; ++i) {
            double parameter = Gamma.drawSample(random, parameters[i]);
            sum += parameter;
            result[i] = parameter;
        }
        i = 0;
        while (i < parameters.length) {
            int n = i++;
            result[n] = result[n] / sum;
        }
        return result;
    }

    public static double sampleBeta(double a, double b, Random random) {
        ClassicCounter<Boolean> c = new ClassicCounter<Boolean>();
        c.setCount(true, a);
        c.setCount(false, b);
        Object beta = new Dirichlet(c).drawSample(random);
        return ((Multinomial)beta).probabilityOf(true);
    }

    @Override
    public double getPredictiveProbability(E object) {
        return this.parameters.getCount(object) / this.parameters.totalCount();
    }

    @Override
    public double getPredictiveLogProbability(E object) {
        return Math.log(this.getPredictiveProbability(object));
    }

    public Dirichlet<E> getPosteriorDistribution(Counter<E> counts) {
        ClassicCounter<E> newParameters = new ClassicCounter<E>(this.parameters);
        Counters.addInPlace(newParameters, counts);
        return new Dirichlet<E>(newParameters);
    }

    @Override
    public double getPosteriorPredictiveProbability(Counter<E> counts, E object) {
        double numerator = this.parameters.getCount(object) + counts.getCount(object);
        double denominator = this.parameters.totalCount() + counts.totalCount();
        return numerator / denominator;
    }

    @Override
    public double getPosteriorPredictiveLogProbability(Counter<E> counts, E object) {
        return Math.log(this.getPosteriorPredictiveProbability(counts, object));
    }

    @Override
    public double probabilityOf(Multinomial<E> object) {
        return 0.0;
    }

    public static double unnormalizedLogProbabilityOf(double[] mult, double[] params) {
        double sum = 0.0;
        for (int i = 0; i < params.length; ++i) {
            if (!(mult[i] > 0.0)) continue;
            sum += (params[i] - 1.0) * Math.log(mult[i]);
        }
        return sum;
    }

    @Override
    public double logProbabilityOf(Multinomial<E> object) {
        return 0.0;
    }

    public String toString() {
        return Counters.toBiggestValuesFirstString(this.parameters, 50);
    }
}

