/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.time;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.pipeline.POSTaggerAnnotator;
import edu.stanford.nlp.pipeline.TokenizerAnnotator;
import edu.stanford.nlp.pipeline.WordsToSentencesAnnotator;
import edu.stanford.nlp.time.TimeAnnotations;
import edu.stanford.nlp.time.TimeAnnotator;
import edu.stanford.nlp.time.Timex;
import edu.stanford.nlp.util.CoreMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.junit.Assert;

public class SUTimeITest
extends TestCase {
    private static AnnotationPipeline pipeline = null;
    private static final String TIME_ANNOTATOR_NAME = "sutime";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        Class<SUTimeITest> clazz = SUTimeITest.class;
        synchronized (SUTimeITest.class) {
            if (pipeline == null) {
                pipeline = new AnnotationPipeline();
                pipeline.addAnnotator(new TokenizerAnnotator(false, "en"));
                pipeline.addAnnotator(new WordsToSentencesAnnotator(false));
                pipeline.addAnnotator(new POSTaggerAnnotator("edu/stanford/nlp/models/pos-tagger/english-left3words/english-left3words-distsim.tagger", false));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected static Properties getDefaultProperties() {
        Properties props = new Properties();
        return props;
    }

    private static TimeAnnotator getTimeAnnotator() {
        return new TimeAnnotator(TIME_ANNOTATOR_NAME, SUTimeITest.getDefaultProperties());
    }

    private static TimeAnnotator getTimeAnnotator(Properties props) {
        return new TimeAnnotator(TIME_ANNOTATOR_NAME, props);
    }

    public void testSUTimeDurations() throws IOException {
        String testText = "It was a 3-year long drought.\nThe four-month old baby slept peacefully.\nOver the past twenty four years, the number of crashes has decreased.\nIn the 2 months following the crash, the investigators checked all the records.\nHe was preoccupied for ten days before leaving.\nSales rose for the fifth straight year.\nBusiness was slow for the third straight month in a row.\nThere are no more than 60 days.\nIn no more than 20 years, the city completely changed.\nIt has been more than 60 days.\nHas it been more than 20 years?\nThere was at least sixty days.\nThe book was completed in four years.\nThat took a decade.\nAfter a few decades, old memories faded.\nAfter a few hundred decades, everything changed.\nIt has been warm in recent weeks.\nDid it rain on the ninth day consecutively?\nThe meeting was two days ago.\n";
        Iterator<Timex> expectedTimexes = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"P3Y\" type=\"DURATION\">3-year</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"P4M\" type=\"DURATION\">four-month old</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"P24Y\" type=\"DURATION\" beginPoint=\"t3\" endPoint=\"t0\">the past twenty four years</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" value=\"P2M\" type=\"DURATION\">the 2 months</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t6\" value=\"P10D\" type=\"DURATION\">ten days</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t8\" value=\"P5Y\" type=\"DURATION\" beginPoint=\"t7\" endPoint=\"t0\">the fifth straight year</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t10\" value=\"P3M\" type=\"DURATION\" beginPoint=\"t9\" endPoint=\"t0\">the third straight month in a row</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t11\" value=\"P60D\" type=\"DURATION\" mod=\"EQUAL_OR_LESS\">no more than 60 days</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t12\" value=\"P20Y\" type=\"DURATION\" mod=\"EQUAL_OR_LESS\">no more than 20 years</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t13\" value=\"P60D\" type=\"DURATION\" mod=\"MORE_THAN\">more than 60 days</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t14\" value=\"P20Y\" type=\"DURATION\" mod=\"MORE_THAN\">more than 20 years</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t15\" value=\"P60D\" type=\"DURATION\" mod=\"EQUAL_OR_MORE\">at least sixty days</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t16\" value=\"P4Y\" type=\"DURATION\">four years</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t17\" value=\"P10Y\" type=\"DURATION\">a decade</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t18\" value=\"PXY\" type=\"DURATION\">a few decades</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t19\" value=\"P1000Y\" type=\"DURATION\">hundred decades</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t20\" value=\"PXW\" type=\"DURATION\">recent weeks</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t22\" value=\"P9D\" type=\"DURATION\" beginPoint=\"t21\" endPoint=\"t0\">the ninth day consecutively</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t23\" alt_value=\"OFFSET P-2D\" type=\"DATE\" temporalFunction=\"true\" valueFromFunction=\"tf0\" anchorTimeID=\"t0\">two days ago</TIMEX3>")).iterator();
        Iterator<Timex> expectedTimexesResolved = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"P3Y\" type=\"DURATION\">3-year</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"P4M\" type=\"DURATION\">four-month old</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"P24Y\" type=\"DURATION\" beginPoint=\"t3\" endPoint=\"t0\">the past twenty four years</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" value=\"P2M\" type=\"DURATION\">the 2 months</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t6\" value=\"P10D\" type=\"DURATION\">ten days</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t8\" value=\"P5Y\" type=\"DURATION\" beginPoint=\"t7\" endPoint=\"t0\">the fifth straight year</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t10\" value=\"P3M\" type=\"DURATION\" beginPoint=\"t9\" endPoint=\"t0\">the third straight month in a row</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t11\" value=\"P60D\" type=\"DURATION\" mod=\"EQUAL_OR_LESS\">no more than 60 days</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t12\" value=\"P20Y\" type=\"DURATION\" mod=\"EQUAL_OR_LESS\">no more than 20 years</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t13\" value=\"P60D\" type=\"DURATION\" mod=\"MORE_THAN\">more than 60 days</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t14\" value=\"P20Y\" type=\"DURATION\" mod=\"MORE_THAN\">more than 20 years</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t15\" value=\"P60D\" type=\"DURATION\" mod=\"EQUAL_OR_MORE\">at least sixty days</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t16\" value=\"P4Y\" type=\"DURATION\">four years</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t17\" value=\"P10Y\" type=\"DURATION\">a decade</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t18\" value=\"PXY\" type=\"DURATION\">a few decades</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t19\" value=\"P1000Y\" type=\"DURATION\">hundred decades</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t20\" value=\"PXW\" type=\"DURATION\">recent weeks</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t22\" value=\"P9D\" type=\"DURATION\" beginPoint=\"t21\" endPoint=\"t0\">the ninth day consecutively</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t23\" value=\"2010-02-15\" type=\"DATE\">two days ago</TIMEX3>")).iterator();
        Annotation document = SUTimeITest.createDocument(testText);
        TimeAnnotator sutime = SUTimeITest.getTimeAnnotator();
        sutime.annotate(document);
        for (CoreMap timexAnn : (List)document.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexes.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        Annotation documentWithRefTime = SUTimeITest.createDocument(testText, "20100217");
        sutime.annotate(documentWithRefTime);
        for (CoreMap timexAnn : (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexesResolved.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
    }

    public void testSUTimeDurations2() throws IOException {
        String testText = "He was away for the first 9 months of 1997.\nIt has been three hours, twenty minutes and 5 seconds.\nHe waited for two years and three months.\nHe waited for 6 and a half months.\nIt was two to three months.\nIt was five hundred and twelve days.\nIt was six and three months.\nSeveral days has already passed.\nFor five hours on Friday, the shop was closed.\nFor more than five hours on Friday, the shop was closed.\n";
        Iterator<Timex> expectedTimexes = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" alt_value=\"1997 INTERSECT P9M\" type=\"DATE\" temporalFunction=\"true\" valueFromFunction=\"tf0\" anchorTimeID=\"t2\">the first 9 months of 1997</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" value=\"PT3H\" type=\"DURATION\">three hours</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"PT20M\" type=\"DURATION\">twenty minutes</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" value=\"PT5S\" type=\"DURATION\">5 seconds</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t6\" value=\"P2Y\" type=\"DURATION\">two years</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t7\" value=\"P3M\" type=\"DURATION\">three months</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t8\" value=\"PXM\" type=\"DURATION\">months</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t9\" alt_value=\"P2M/P3M\" type=\"DURATION\">two to three months</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t10\" value=\"P512D\" type=\"DURATION\">five hundred and twelve days</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t11\" value=\"P3M\" type=\"DURATION\">three months</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t12\" value=\"PXD\" type=\"DURATION\">Several days</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t13\" alt_value=\"XXXX-WXX-5 INTERSECT PT5H\" type=\"DATE\" temporalFunction=\"true\" valueFromFunction=\"tf1\" anchorTimeID=\"t14\">five hours on Friday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t15\" alt_value=\"XXXX-WXX-5 INTERSECT &gt;PT5H\" type=\"DATE\" mod=\"MORE_THAN\" temporalFunction=\"true\" valueFromFunction=\"tf2\" anchorTimeID=\"t14\">more than five hours on Friday</TIMEX3>")).iterator();
        Iterator<Timex> expectedTimexesResolved = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" alt_value=\"1997 INTERSECT P9M\" type=\"DATE\" temporalFunction=\"true\" valueFromFunction=\"tf0\" anchorTimeID=\"t2\">the first 9 months of 1997</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" value=\"PT3H\" type=\"DURATION\">three hours</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"PT20M\" type=\"DURATION\">twenty minutes</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" value=\"PT5S\" type=\"DURATION\">5 seconds</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t6\" value=\"P2Y\" type=\"DURATION\">two years</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t7\" value=\"P3M\" type=\"DURATION\">three months</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t8\" value=\"PXM\" type=\"DURATION\">months</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t9\" alt_value=\"P2M/P3M\" type=\"DURATION\">two to three months</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t10\" value=\"P512D\" type=\"DURATION\">five hundred and twelve days</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t11\" value=\"P3M\" type=\"DURATION\">three months</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t12\" value=\"PXD\" type=\"DURATION\">Several days</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t13\" alt_value=\"2010-02-19-WXX-5 INTERSECT PT5H\" type=\"DATE\" temporalFunction=\"true\" valueFromFunction=\"tf1\" anchorTimeID=\"t14\">five hours on Friday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t15\" alt_value=\"2010-02-19-WXX-5 INTERSECT &gt;PT5H\" type=\"DATE\" mod=\"MORE_THAN\" temporalFunction=\"true\" valueFromFunction=\"tf2\" anchorTimeID=\"t16\">more than five hours on Friday</TIMEX3>")).iterator();
        Annotation document = SUTimeITest.createDocument(testText);
        TimeAnnotator sutime = SUTimeITest.getTimeAnnotator();
        sutime.annotate(document);
        for (CoreMap timexAnn : (List)document.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexes.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
        Annotation documentWithRefTime = SUTimeITest.createDocument(testText, "20100217");
        sutime.annotate(documentWithRefTime);
        for (CoreMap timexAnn : (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexesResolved.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
    }

    public void testSUTimeDurations3() throws IOException {
        String testText = "Claudia had ruled the duchy well in her regency from 1632 to 1646, and was successful in keeping Tyrol out of the Thirty Years War.\nThe focus of today's Daily Eye Candy is the 22-year old fashion supermodel Chad White who is a native of Portland , Oregon.\n";
        Iterator<Timex> expectedTimexes = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t3\" value=\"PT122736H\" type=\"DURATION\" beginPoint=\"t1\" endPoint=\"t2\">from 1632 to 1646</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"P30Y\" type=\"DURATION\">the Thirty Years</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" alt_value=\"THIS P1D INTERSECT P1D\" type=\"DATE\" temporalFunction=\"true\" valueFromFunction=\"tf0\" anchorTimeID=\"t6\">today's Daily</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t7\" value=\"P22Y\" type=\"DURATION\">22-year old</TIMEX3>")).iterator();
        Iterator<Timex> expectedTimexesResolved = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t3\" value=\"PT122736H\" type=\"DURATION\" beginPoint=\"t1\" endPoint=\"t2\">from 1632 to 1646</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"P30Y\" type=\"DURATION\">the Thirty Years</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" value=\"2010-02-17\" type=\"SET\" quant=\"EVERY\" freq=\"P1X\" periodicity=\"P1D\">today's Daily</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t6\" value=\"P22Y\" type=\"DURATION\">22-year old</TIMEX3>")).iterator();
        Annotation document = SUTimeITest.createDocument(testText);
        Properties props = SUTimeITest.getDefaultProperties();
        props.setProperty("sutime.markTimeRanges", "true");
        TimeAnnotator sutime = SUTimeITest.getTimeAnnotator(props);
        sutime.annotate(document);
        for (CoreMap timexAnn : (List)document.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexes.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
        Annotation documentWithRefTime = SUTimeITest.createDocument(testText, "20100217");
        sutime.annotate(documentWithRefTime);
        for (CoreMap timexAnn : (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexesResolved.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
    }

    public void testSUTimeIso() throws IOException {
        String testText = "ISO datetime is 2004-03-04T18:32:56+1600.\nISO datetime is 2004-03-04T18:32:56.\nISO date is 19880217.\nISO date is 1988-02-17.\nEuro date is 19.02.10.\nEuro date is 19.02.2010.\nISO time is T13:23:42.\nIt is 8:43 on 6/12/2008.\nIt is 6:53:32 on 7-16-2010.\nThe date is 12-03-2007.\nISO date without day is 2008-04.\nISO partial datetime 2008-05-16T09.\nIt is 2:14:12\n";
        Iterator<Timex> expectedTimexes = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"2004-03-04T18:32:56+1600\" type=\"TIME\">2004-03-04T18:32:56+1600</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"2004-03-04T18:32:56\" type=\"TIME\">2004-03-04T18:32:56</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" value=\"1988-02-17\" type=\"DATE\">1988-02-17</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"XX10-02-19\" type=\"DATE\">19.02.10</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" value=\"2010-02-19\" type=\"DATE\">19.02.2010</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t6\" value=\"T13:23:42\" type=\"TIME\">T13:23:42</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t7\" value=\"2008-06-12T08:43\" type=\"TIME\">8:43 on 6/12/2008</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t8\" value=\"2010-07-16T06:53:32\" type=\"TIME\">6:53:32 on 7-16-2010</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t9\" value=\"2007-12-03\" type=\"DATE\">12-03-2007</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t10\" value=\"P1D\" type=\"DURATION\">day</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t11\" value=\"2008-04\" type=\"DATE\">2008-04</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t12\" value=\"2008-05-16T09\" type=\"TIME\">2008-05-16T09</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t13\" value=\"T02:14:12\" type=\"TIME\">2:14:12</TIMEX3>")).iterator();
        Iterator<Timex> expectedTimexesResolved = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"2004-03-04T18:32:56+1600\" type=\"TIME\">2004-03-04T18:32:56+1600</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"2004-03-04T18:32:56\" type=\"TIME\">2004-03-04T18:32:56</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" value=\"1988-02-17\" type=\"DATE\">1988-02-17</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"2010-02-19\" type=\"DATE\">19.02.10</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" value=\"2010-02-19\" type=\"DATE\">19.02.2010</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t6\" value=\"2010-02-17T13:23:42\" type=\"TIME\">T13:23:42</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t7\" value=\"2008-06-12T08:43\" type=\"TIME\">8:43 on 6/12/2008</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t8\" value=\"2010-07-16T06:53:32\" type=\"TIME\">6:53:32 on 7-16-2010</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t9\" value=\"2007-12-03\" type=\"DATE\">12-03-2007</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t10\" value=\"P1D\" type=\"DURATION\">day</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t11\" value=\"2008-04\" type=\"DATE\">2008-04</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t12\" value=\"2008-05-16T09\" type=\"TIME\">2008-05-16T09</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t13\" value=\"2010-02-17T02:14:12\" type=\"TIME\">2:14:12</TIMEX3>")).iterator();
        Annotation document = SUTimeITest.createDocument(testText);
        TimeAnnotator sutime = SUTimeITest.getTimeAnnotator();
        sutime.annotate(document);
        for (CoreMap timexAnn : (List)document.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexes.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
        Annotation documentWithRefTime = SUTimeITest.createDocument(testText, "20100217");
        sutime.annotate(documentWithRefTime);
        for (CoreMap timexAnn : (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexesResolved.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
    }

    public void testSUIsoWithTimezone() throws IOException {
        String testText = "ISO datetime is 2004-03-04T18:32:56 Pacific Standard Time.\nISO datetime is 2004-03-04T18:32:56 Eastern Standard Time.\nTime is 4:30pm Mountain Time.\nTime is 9:30 am Pacific Time.\nISO time is T13:23:42 MDT.\nIt is 8:43 PST on 6/12/2008.\nIt is 6:53:32 PDT on 7-16-2010.\nISO partial datetime 2008-05-16T09 Beijing Time.\nIt is 2:14:12 MSK\n";
        Iterator<Timex> expectedTimexes = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"2004-03-04T18:32:56-0800\" type=\"TIME\">2004-03-04T18:32:56 Pacific Standard Time</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"2004-03-04T18:32:56-0500\" type=\"TIME\">2004-03-04T18:32:56 Eastern Standard Time</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" value=\"T16:30\" type=\"TIME\">4:30pm</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"T09:30\" type=\"TIME\">9:30 am</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" value=\"T13:23:42-0700\" type=\"TIME\">T13:23:42 MDT</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t6\" value=\"2008-06-12T08:43-0800\" type=\"TIME\">8:43 PST on 6/12/2008</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t7\" value=\"2010-07-16T06:53:32-0800\" type=\"TIME\">6:53:32 PDT on 7-16-2010</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t8\" value=\"2008-05-16T09\" type=\"TIME\">2008-05-16T09</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t9\" value=\"T02:14:12+0300\" type=\"TIME\">2:14:12 MSK</TIMEX3>")).iterator();
        Iterator<Timex> expectedTimexesResolved = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"2004-03-04T18:32:56-0800\" type=\"TIME\">2004-03-04T18:32:56 Pacific Standard Time</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"2004-03-04T18:32:56-0500\" type=\"TIME\">2004-03-04T18:32:56 Eastern Standard Time</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" value=\"2010-02-17T16:30\" type=\"TIME\">4:30pm</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"2010-02-17T09:30\" type=\"TIME\">9:30 am</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" value=\"2010-02-17T13:23:42-0700\" type=\"TIME\">T13:23:42 MDT</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t6\" value=\"2008-06-12T08:43-0800\" type=\"TIME\">8:43 PST on 6/12/2008</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t7\" value=\"2010-07-16T06:53:32-0800\" type=\"TIME\">6:53:32 PDT on 7-16-2010</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t8\" value=\"2008-05-16T09\" type=\"TIME\">2008-05-16T09</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t9\" value=\"2010-02-17T02:14:12+0300\" type=\"TIME\">2:14:12 MSK</TIMEX3>")).iterator();
        Annotation document = SUTimeITest.createDocument(testText);
        Properties props = SUTimeITest.getDefaultProperties();
        TimeAnnotator sutime = SUTimeITest.getTimeAnnotator(props);
        sutime.annotate(document);
        for (CoreMap timexAnn : (List)document.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexes.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
        Annotation documentWithRefTime = SUTimeITest.createDocument(testText, "20100217");
        sutime.annotate(documentWithRefTime);
        for (CoreMap timexAnn : (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexesResolved.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
    }

    public void testSUTime2() throws IOException {
        String testText = "I'm leaving on vacation two weeks from next Tuesday.\nJohn left 2 days before yesterday.\nIt's almost Thursday.\nI tutored an English student some Thursdays in 1994.\nThe meeting is scheduled for every Monday from 3 to 4 p.m.\nThe concert is at 8:00 pm on Friday.\nThe concert is Friday at 8:00 pm.\nDid you get up before 7:00 am today?\nThe company had its third best second quarter ever.\nMr. Smith left Friday, October 1, 1999.\nMr. Smith arrived on the second of December.\nMr. Smith arrived on the second of June.\nMr. Smith arrived on the second of July.\nMr. Smith arrived on the second of August.\nIn October of 1963, there was a big snow storm.\nYesterday, it was raining.\nShe arrived Saturday night.\nShe spent one dollar ($1) yesterday afternoon.\nThe book was published in nineteen ninety-one.\n";
        Iterator<Timex> expectedTimexes = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" alt_value=\"XXXX-WXX-2 OFFSET P3W\" type=\"DATE\" temporalFunction=\"true\" valueFromFunction=\"tf0\" anchorTimeID=\"t2\">two weeks from next Tuesday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" alt_value=\"OFFSET P-3D\" type=\"DATE\" temporalFunction=\"true\" valueFromFunction=\"tf1\" anchorTimeID=\"t0\">2 days before yesterday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"XXXX-WXX-4\" type=\"DATE\">Thursday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" value=\"1994-WXX-4\" type=\"SET\" periodicity=\"P1W\">Thursdays in 1994</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t6\" value=\"XXXX-WXX-1\" type=\"SET\" quant=\"every\" periodicity=\"P1W\">every Monday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t7\" value=\"T15:57\" type=\"TIME\">3 to 4 p.m</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t8\" value=\"XXXX-WXX-5T20:00\" type=\"TIME\">8:00 pm on Friday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t9\" value=\"XXXX-WXX-5T20:00\" type=\"TIME\">Friday at 8:00 pm</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t10\" alt_value=\"THIS P1D INTERSECT T07:00\" type=\"DATE\" temporalFunction=\"true\" valueFromFunction=\"tf2\" anchorTimeID=\"t11\">7:00 am today</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t12\" value=\"XXXX-Q2\" type=\"DATE\">second quarter</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t13\" value=\"1999-10-01\" type=\"DATE\">Friday, October 1, 1999</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t14\" value=\"XXXX-12-02\" type=\"DATE\">the second of December</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t15\" value=\"XXXX-06-02\" type=\"DATE\">the second of June</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t16\" value=\"XXXX-07-02\" type=\"DATE\">the second of July</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t17\" value=\"XXXX-08-02\" type=\"DATE\">the second of August</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t18\" value=\"1963-10\" type=\"DATE\">October of 1963</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t19\" alt_value=\"OFFSET P-1D\" type=\"DATE\" temporalFunction=\"true\" valueFromFunction=\"tf3\" anchorTimeID=\"t0\">Yesterday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t20\" value=\"XXXX-WXX-6TNI\" type=\"TIME\">Saturday night</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t21\" alt_value=\"OFFSET P-1D INTERSECT AF\" type=\"DATE\" temporalFunction=\"true\" valueFromFunction=\"tf4\" anchorTimeID=\"t19\">yesterday afternoon</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t22\" value=\"1991\" type=\"DATE\">nineteen ninety-one</TIMEX3>")).iterator();
        Iterator<Timex> expectedTimexesResolved = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"1995-08-08\" type=\"DATE\">two weeks from next Tuesday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"1995-07-17\" type=\"DATE\">2 days before yesterday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" value=\"1995-07-20\" type=\"DATE\">Thursday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"1994-WXX-4\" type=\"SET\" periodicity=\"P1W\">Thursdays in 1994</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" value=\"XXXX-WXX-1\" type=\"SET\" quant=\"every\" periodicity=\"P1W\">every Monday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t6\" value=\"1995-07-20T15:57\" type=\"TIME\">3 to 4 p.m</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t7\" value=\"1995-07-21T20:00\" type=\"TIME\">8:00 pm on Friday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t8\" value=\"1995-07-21T20:00\" type=\"TIME\">Friday at 8:00 pm</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t9\" value=\"1995-07-20T07:00\" type=\"TIME\">7:00 am today</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t10\" value=\"1995-Q2\" type=\"DATE\">second quarter</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t11\" value=\"1999-10-01\" type=\"DATE\">Friday, October 1, 1999</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t12\" value=\"1994-12-02\" type=\"DATE\">the second of December</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t13\" value=\"1995-06-02\" type=\"DATE\">the second of June</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t14\" value=\"1995-07-02\" type=\"DATE\">the second of July</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t15\" value=\"1994-08-02\" type=\"DATE\">the second of August</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t16\" value=\"1963-10\" type=\"DATE\">October of 1963</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t17\" value=\"1995-07-19\" type=\"DATE\">Yesterday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t18\" value=\"1995-07-22TNI\" type=\"TIME\">Saturday night</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t19\" value=\"1995-07-19TAF\" type=\"TIME\">yesterday afternoon</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t20\" value=\"1991\" type=\"DATE\">nineteen ninety-one</TIMEX3>")).iterator();
        Annotation document = SUTimeITest.createDocument(testText);
        TimeAnnotator sutime = SUTimeITest.getTimeAnnotator();
        sutime.annotate(document);
        for (CoreMap timexAnn : (List)document.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexes.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
        Annotation documentWithRefTime = SUTimeITest.createDocument(testText, "19950720");
        sutime.annotate(documentWithRefTime);
        for (CoreMap timexAnn : (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexesResolved.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
    }

    public void testSUTimeDate() throws IOException {
        String testText = "Mr Smith left in the summer of 1964.\nHe started working on Tuesday the 14th.\nThis year's summer was very hot.\nIn November 1943, it was very cold.\nAre we meeting two weeks from next Tuesday?\nThe accident happened last week.\nThe year two thousand.\nThe 1997 second quarter and 1998 first quarter were very good.\nMr. Smith moved in nineteen ninety six.\nThe accident was Saturday last week.\nHe went to Japan August last year.\nHe died in 567 bc.\nThe temple was built in the late 5th century B.C. and collapsed in the 3rd century A.D.\nI think 1000 BC was a long time ago\n";
        Iterator<Timex> expectedTimexes = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"1964-SU\" type=\"DATE\">the summer of 1964</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"XXXX-WXX-2\" type=\"DATE\">Tuesday the 14th</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" alt_value=\"THIS P1Y INTERSECT SU\" type=\"DATE\" temporalFunction=\"true\" valueFromFunction=\"tf0\" anchorTimeID=\"t4\">This year's summer</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" value=\"1943-11\" type=\"DATE\">November 1943</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t6\" alt_value=\"XXXX-WXX-2 OFFSET P3W\" type=\"DATE\" temporalFunction=\"true\" valueFromFunction=\"tf1\" anchorTimeID=\"t7\">two weeks from next Tuesday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t8\" alt_value=\"THIS P1W OFFSET P-1W\" type=\"DATE\" temporalFunction=\"true\" valueFromFunction=\"tf2\" anchorTimeID=\"t9\">last week</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t10\" value=\"2000\" type=\"DATE\">The year two thousand</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t11\" value=\"1997-Q2\" type=\"DATE\">The 1997 second quarter</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t12\" value=\"1998-Q1\" type=\"DATE\">1998 first quarter</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t13\" value=\"1996\" type=\"DATE\">nineteen ninety six</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t14\" alt_value=\"THIS P1W OFFSET P-1W INTERSECT XXXX-WXX-6\" type=\"DATE\" temporalFunction=\"true\" valueFromFunction=\"tf3\" anchorTimeID=\"t15\">Saturday last week</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t16\" alt_value=\"THIS P1Y OFFSET P-1Y INTERSECT XXXX-08\" type=\"DATE\" temporalFunction=\"true\" valueFromFunction=\"tf4\" anchorTimeID=\"t17\">August last year</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t18\" value=\"-0566\" type=\"DATE\">567 bc</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t19\" value=\"-04XX\" type=\"DATE\" mod=\"LATE\">the late 5th century B.C.</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t20\" value=\"02XX\" type=\"DATE\">the 3rd century A.D.</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t21\" value=\"-0999\" type=\"DATE\">1000 BC</TIMEX3>")).iterator();
        Iterator<Timex> expectedTimexesResolved = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"1964-SU\" type=\"DATE\">the summer of 1964</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"1999-12-14\" type=\"DATE\">Tuesday the 14th</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" value=\"1999-SU\" type=\"DATE\">This year's summer</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"1943-11\" type=\"DATE\">November 1943</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" value=\"2000-01-18\" type=\"DATE\">two weeks from next Tuesday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t6\" value=\"1999-W51\" type=\"DATE\">last week</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t7\" value=\"2000\" type=\"DATE\">The year two thousand</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t8\" value=\"1997-Q2\" type=\"DATE\">The 1997 second quarter</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t9\" value=\"1998-Q1\" type=\"DATE\">1998 first quarter</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t10\" value=\"1996\" type=\"DATE\">nineteen ninety six</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t11\" value=\"1999-12-25\" type=\"DATE\">Saturday last week</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t12\" value=\"1998-08\" type=\"DATE\">August last year</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t13\" value=\"-0566\" type=\"DATE\">567 bc</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t14\" value=\"-04XX\" type=\"DATE\" mod=\"LATE\">the late 5th century B.C.</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t15\" value=\"02XX\" type=\"DATE\">the 3rd century A.D.</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t16\" value=\"-0999\" type=\"DATE\">1000 BC</TIMEX3>")).iterator();
        Annotation document = SUTimeITest.createDocument(testText);
        TimeAnnotator sutime = SUTimeITest.getTimeAnnotator();
        sutime.annotate(document);
        for (CoreMap timexAnn : (List)document.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexes.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
        Annotation documentWithRefTime = SUTimeITest.createDocument(testText, "1999-12-30");
        sutime.annotate(documentWithRefTime);
        for (CoreMap timexAnn : (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexesResolved.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
    }

    public void testSUTimeTime() throws IOException {
        String testText = "Mr Smith left ten minutes to three.\nHe went for lunch at twenty after twelve.\nHe arrived at half past noon.\nIt happened at eleven in the morning.\nThe meeting is scheduled for 9 a.m. Friday, October 1, 1999.\nHe arrived at a quarter past 6.\n";
        Iterator<Timex> expectedTimexes = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"T02:50\" type=\"TIME\">ten minutes to three</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"T12:20\" type=\"TIME\">twenty after twelve</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" value=\"T12:30\" type=\"TIME\">half past noon</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"T11:00\" type=\"TIME\">eleven in the morning</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" value=\"1999-10-01T09:00\" type=\"TIME\">9 a.m. Friday, October 1, 1999</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t6\" value=\"T06:15\" type=\"TIME\">a quarter past 6</TIMEX3>")).iterator();
        Iterator<Timex> expectedTimexesResolved = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"1998-04-17T02:50\" type=\"TIME\">ten minutes to three</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"1998-04-17T12:20\" type=\"TIME\">twenty after twelve</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" value=\"1998-04-17T12:30\" type=\"TIME\">half past noon</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"1998-04-17T11:00\" type=\"TIME\">eleven in the morning</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" value=\"1999-10-01T09:00\" type=\"TIME\">9 a.m. Friday, October 1, 1999</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t6\" value=\"1998-04-17T06:15\" type=\"TIME\">a quarter past 6</TIMEX3>")).iterator();
        Annotation document = SUTimeITest.createDocument(testText);
        TimeAnnotator sutime = SUTimeITest.getTimeAnnotator();
        sutime.annotate(document);
        for (CoreMap timexAnn : (List)document.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexes.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
        Annotation documentWithRefTime = SUTimeITest.createDocument(testText, "19980417");
        sutime.annotate(documentWithRefTime);
        for (CoreMap timexAnn : (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexesResolved.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
    }

    public void testSUTimeResolveTime() throws IOException {
        Timex expectedTimex;
        String testText = "Mr Smith left ten minutes to three.\nHe went for lunch at twenty after twelve today.\nHe arrived at half past noon Saturday.\nHe is arriving at half past noon Saturday.\nIt happened at eleven in the morning on Tuesday.\nThe meeting is scheduled for 9 a.m. tomorrow.\nHe arrived at a quarter past 6 yesterday.\n";
        Iterator<Timex> expectedTimexes = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"T02:50\" type=\"TIME\">ten minutes to three</TIMEX3>"), Timex.fromXml("<TIMEX3 alt_value=\"THIS P1D INTERSECT T12:20\" anchorTimeID=\"t3\" temporalFunction=\"true\" tid=\"t2\" type=\"DATE\" valueFromFunction=\"tf0\">twenty after twelve today</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" type=\"TIME\" value=\"XXXX-WXX-6T12:30\">half past noon Saturday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" type=\"TIME\" value=\"XXXX-WXX-6T12:30\">half past noon Saturday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t6\" type=\"TIME\" value=\"XXXX-WXX-2T11:00\">eleven in the morning on Tuesday</TIMEX3>"), Timex.fromXml("<TIMEX3 alt_value=\"T09:00 OFFSET P1D\" anchorTimeID=\"t8\" temporalFunction=\"true\" tid=\"t7\" type=\"DATE\" valueFromFunction=\"tf1\">9 a.m. tomorrow</TIMEX3>"), Timex.fromXml("<TIMEX3 alt_value=\"T06:15 OFFSET P-1D\" anchorTimeID=\"t10\" temporalFunction=\"true\" tid=\"t9\" type=\"DATE\" valueFromFunction=\"tf2\">a quarter past 6 yesterday</TIMEX3>")).iterator();
        Iterator<Timex> expectedTimexesResolved1 = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"1998-04-17T02:50\" type=\"TIME\">ten minutes to three</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"1998-04-17T12:20\" type=\"TIME\">twenty after twelve today</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" value=\"1998-04-18T12:30\" type=\"TIME\">half past noon Saturday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"1998-04-18T12:30\" type=\"TIME\">half past noon Saturday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" value=\"1998-04-14T11:00\" type=\"TIME\">eleven in the morning on Tuesday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t6\" value=\"1998-04-18T09:00\" type=\"TIME\">9 a.m. tomorrow</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t7\" value=\"1998-04-16T06:15\" type=\"TIME\">a quarter past 6 yesterday</TIMEX3>")).iterator();
        Iterator<Timex> expectedTimexesResolved2 = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"1998-04-17T02:50\" type=\"TIME\">ten minutes to three</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"1998-04-17T12:20\" type=\"TIME\">twenty after twelve today</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" value=\"1998-04-11T12:30\" type=\"TIME\">half past noon Saturday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"1998-04-18T12:30\" type=\"TIME\">half past noon Saturday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" value=\"1998-04-14T11:00\" type=\"TIME\">eleven in the morning on Tuesday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t6\" value=\"1998-04-18T09:00\" type=\"TIME\">9 a.m. tomorrow</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t7\" value=\"1998-04-16T06:15\" type=\"TIME\">a quarter past 6 yesterday</TIMEX3>")).iterator();
        Iterator<Timex> expectedTimexesResolved3 = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"1998-04T02:50\" type=\"TIME\">ten minutes to three</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"1998-04T12:20\" type=\"TIME\">twenty after twelve today</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" value=\"1998-WXX-6T12:30\" type=\"TIME\">half past noon Saturday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"1998-WXX-6T12:30\" type=\"TIME\">half past noon Saturday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" value=\"1998-WXX-2T11:00\" type=\"TIME\">eleven in the morning on Tuesday</TIMEX3>"), Timex.fromXml("<TIMEX3 alt_value=\"1998-04T09:00 OFFSET P1D\" anchorTimeID=\"t7\" temporalFunction=\"true\" tid=\"t6\" type=\"DATE\" valueFromFunction=\"tf0\">9 a.m. tomorrow</TIMEX3>"), Timex.fromXml("<TIMEX3 alt_value=\"1998-04T06:15 OFFSET P-1D\" anchorTimeID=\"t9\" temporalFunction=\"true\" tid=\"t8\" type=\"DATE\" valueFromFunction=\"tf1\">a quarter past 6 yesterday</TIMEX3>")).iterator();
        Annotation document = SUTimeITest.createDocument(testText);
        TimeAnnotator sutime = SUTimeITest.getTimeAnnotator();
        sutime.annotate(document);
        for (CoreMap timexAnn : (List)document.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex2 = expectedTimexes.next();
            SUTimeITest.checkTimex(testText, expectedTimex2.text(), expectedTimex2, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
        Annotation documentWithRefTime = SUTimeITest.createDocument(testText, "19980417");
        sutime.annotate(documentWithRefTime);
        for (CoreMap timexAnn : (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class)) {
            expectedTimex = expectedTimexesResolved1.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
        documentWithRefTime = SUTimeITest.createDocument(testText, "19980417T11:00");
        sutime.annotate(documentWithRefTime);
        for (CoreMap timexAnn : (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class)) {
            expectedTimex = expectedTimexesResolved2.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
        documentWithRefTime = SUTimeITest.createDocument(testText, "199804XX");
        sutime.annotate(documentWithRefTime);
        for (CoreMap timexAnn : (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class)) {
            expectedTimex = expectedTimexesResolved3.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
    }

    public void testSUTimeRangeWithoutRange() throws IOException {
        String testText = "Archduchess Maria Magdalena ( 17 August 1656 - 21 January 1669 )\n";
        Iterator<Timex> expectedTimexes = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"1656-08-17\" type=\"DATE\">17 August 1656</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"1669-01-21\" type=\"DATE\">21 January 1669</TIMEX3>")).iterator();
        Iterator<Timex> expectedTimexesResolved = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"1656-08-17\" type=\"DATE\">17 August 1656</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"1669-01-21\" type=\"DATE\">21 January 1669</TIMEX3>")).iterator();
        Annotation document = SUTimeITest.createDocument(testText);
        TimeAnnotator sutime = SUTimeITest.getTimeAnnotator();
        sutime.annotate(document);
        for (CoreMap timexAnn : (List)document.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexes.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
        Annotation documentWithRefTime = SUTimeITest.createDocument(testText, "20030414");
        sutime.annotate(documentWithRefTime);
        for (CoreMap timexAnn : (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexesResolved.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
    }

    public void testSUTimeRangeWithRange() throws IOException {
        String testText = "Archduchess Maria Magdalena ( 17 August 1656 - 21 January 1669 )\n";
        Iterator<Timex> expectedTimexes = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"1656-08-17\" type=\"DATE\">17 August 1656</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"1669-01-21\" type=\"DATE\">21 January 1669</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" value=\"PT108960H\" type=\"DURATION\" beginPoint=\"t1\" endPoint=\"t2\">17 August 1656 - 21 January 1669</TIMEX3>")).iterator();
        Iterator<Timex> expectedTimexesResolved = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"1656-08-17\" type=\"DATE\">17 August 1656</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"1669-01-21\" type=\"DATE\">21 January 1669</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" value=\"PT108960H\" type=\"DURATION\" beginPoint=\"t1\" endPoint=\"t2\">17 August 1656 - 21 January 1669</TIMEX3>")).iterator();
        Annotation document = SUTimeITest.createDocument(testText);
        Properties props = SUTimeITest.getDefaultProperties();
        props.setProperty("sutime.markTimeRanges", "true");
        props.setProperty("sutime.includeNested", "true");
        TimeAnnotator sutime = SUTimeITest.getTimeAnnotator(props);
        sutime.annotate(document);
        for (CoreMap timexAnn : (List)document.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexes.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
        Annotation documentWithRefTime = SUTimeITest.createDocument(testText, "20030414");
        sutime.annotate(documentWithRefTime);
        for (CoreMap timexAnn : (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexesResolved.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
    }

    public void testSUTimeRangeConversion() throws IOException {
        String testText = "The morning of January 31 was very cold.\nDecember of 2002.\nThis winter was not as cold.\nThe 1960s.\nHe returned in 1971.\nMeeting in madrid this week.\nThey watched a movie over the weekend.\nBut publicity-shy Gabriel Garcia Marquez , who turned 80 this month, did finally appear Monday at the semi-annual meeting of the Inter American Press Association as it ended with a luncheon\nThe event happens tomorrow night, not Wednesday afternoon.\nWhat is last week, or last month, or even the last 3 months, or just last 3 months?";
        Iterator<Timex> expectedTimexes = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"XXXX-01-31TMO\" type=\"TIME\" range=\"(XXXX-01-31T06:00:00.000,XXXX-01-31T12:00,PT6H)\">The morning of January 31</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"2002-12\" type=\"DATE\" range=\"(2002-12-01,2002-12-31,P1M)\">December of 2002</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" alt_value=\"THIS WI\" type=\"DATE\" temporalFunction=\"true\" valueFromFunction=\"tf0\" anchorTimeID=\"t0\" range=\"(THIS WI,THIS WI,)\">This winter</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"196X\" type=\"DATE\" range=\"(1960-01-01,1969-12-31,P10Y)\">The 1960s</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" value=\"1971\" type=\"DATE\" range=\"(1971-01-01,1971-12-31,P1Y)\">1971</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t6\" alt_value=\"THIS P1W\" type=\"DATE\" temporalFunction=\"true\" valueFromFunction=\"tf1\" anchorTimeID=\"t0\" range=\"(THIS P1W,THIS P1W,)\">this week</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t7\" value=\"XXXX-WE\" type=\"DATE\" range=\"(XXXX-WXX-6,XXXX-WXX-7,P2D)\">the weekend</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t8\" alt_value=\"THIS P1M\" type=\"DATE\" temporalFunction=\"true\" valueFromFunction=\"tf2\" anchorTimeID=\"t0\" range=\"(THIS P1M,THIS P1M,)\">this month</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t9\" value=\"XXXX-WXX-1\" type=\"DATE\" range=\"(XXXX-WXX-1,XXXX-WXX-1,P1D)\">Monday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t10\" value=\"P6M\" type=\"SET\" quant=\"EVERY\" freq=\"P1X\" periodicity=\"P6M\">semi-annual</TIMEX3>"), Timex.fromXml("<TIMEX3 alt_value=\"OFFSET P1D INTERSECT NI\" anchorTimeID=\"t12\" range=\"(OFFSET P1D INTERSECT NI,OFFSET P1D INTERSECT NI,)\" temporalFunction=\"true\" tid=\"t11\" type=\"DATE\" valueFromFunction=\"tf3\">tomorrow night</TIMEX3>"), Timex.fromXml("<TIMEX3 range=\"(XXXX-WXX-3T12:00:00.000,XXXX-WXX-3T18,PT6H)\" tid=\"t13\" type=\"TIME\" value=\"XXXX-WXX-3TAF\">Wednesday afternoon</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t14\" alt_value=\"THIS P1W OFFSET P-1W\" type=\"DATE\" temporalFunction=\"true\" valueFromFunction=\"tf4\" anchorTimeID=\"t15\" range=\"(THIS P1W OFFSET P-1W,THIS P1W OFFSET P-1W,)\">last week</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t16\" alt_value=\"THIS P1M OFFSET P-1M\" type=\"DATE\" temporalFunction=\"true\" valueFromFunction=\"tf5\" anchorTimeID=\"t17\" range=\"(THIS P1M OFFSET P-1M,THIS P1M OFFSET P-1M,)\">last month</TIMEX3>"), Timex.fromXml("<TIMEX3 beginPoint=\"t18\" endPoint=\"t0\" range=\"(UNKNOWN,REF,P3M)\" tid=\"t19\" type=\"DURATION\" value=\"P3M\">the last 3 months</TIMEX3>"), Timex.fromXml("<TIMEX3 alt_value=\"THIS P3M OFFSET P-3M\" anchorTimeID=\"t21\" range=\"(THIS P3M OFFSET P-3M,THIS P3M OFFSET P-3M,)\" temporalFunction=\"true\" tid=\"t20\" type=\"DATE\" valueFromFunction=\"tf6\">last 3 months</TIMEX3>")).iterator();
        Iterator<Timex> expectedTimexesResolved = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"2003-01-31TMO\" type=\"TIME\" range=\"(2003-01-31T06:00:00.000,2003-01-31T12:00,PT6H)\">The morning of January 31</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"2002-12\" type=\"DATE\" range=\"(2002-12-01,2002-12-31,P1M)\">December of 2002</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" value=\"2003-WI\" type=\"DATE\" range=\"(2003-12-01,2003-03,P3M)\">This winter</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"196X\" type=\"DATE\" range=\"(1960-01-01,1969-12-31,P10Y)\">The 1960s</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" value=\"1971\" type=\"DATE\" range=\"(1971-01-01,1971-12-31,P1Y)\">1971</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t6\" value=\"2003-W16\" type=\"DATE\" range=\"(2003-04-14,2003-04-20,P1W)\">this week</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t7\" value=\"2003-W16-WE\" type=\"DATE\" range=\"(2003-04-19,2003-04-20,P2D)\">the weekend</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t8\" value=\"2003-04\" type=\"DATE\" range=\"(2003-04-01,2003-04-30,P1M)\">this month</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t9\" value=\"2003-04-14\" type=\"DATE\" range=\"(2003-04-14-WXX-1,2003-04-14-WXX-1,P1D)\">Monday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t10\" value=\"P6M\" type=\"SET\" quant=\"EVERY\" freq=\"P1X\" periodicity=\"P6M\">semi-annual</TIMEX3>"), Timex.fromXml("<TIMEX3 range=\"(2003-04-15T19:00:00.000,2003-04-16T05:00:00.000,PT10H)\" tid=\"t11\" type=\"TIME\" value=\"2003-04-15TNI\">tomorrow night</TIMEX3>"), Timex.fromXml("<TIMEX3 range=\"(2003-04-16-WXX-3T12:00:00.000,2003-04-16-WXX-3T18,PT6H)\" tid=\"t12\" type=\"TIME\" value=\"2003-04-16TAF\">Wednesday afternoon</TIMEX3>"), Timex.fromXml("<TIMEX3 range=\"(2003-04-07,2003-04-13,P1W)\" tid=\"t13\" type=\"DATE\" value=\"2003-W15\">last week</TIMEX3>"), Timex.fromXml("<TIMEX3 range=\"(2003-03-01,2003-03-31,P1M)\" tid=\"t14\" type=\"DATE\" value=\"2003-03\">last month</TIMEX3>"), Timex.fromXml("<TIMEX3 beginPoint=\"t15\" endPoint=\"t0\" range=\"(UNKNOWN,REF,P3M)\" tid=\"t16\" type=\"DURATION\" value=\"P3M\">the last 3 months</TIMEX3>"), Timex.fromXml("<TIMEX3 range=\"(2003-01-14,2003-04-14,P3M)\" tid=\"t17\" type=\"DATE\" value=\"2003-01-14/2003-04-14\">last 3 months</TIMEX3>")).iterator();
        Annotation document = SUTimeITest.createDocument(testText);
        Properties props = SUTimeITest.getDefaultProperties();
        props.setProperty("sutime.includeRange", "true");
        TimeAnnotator sutime = new TimeAnnotator(TIME_ANNOTATOR_NAME, props);
        sutime.annotate(document);
        for (CoreMap timexAnn : (List)document.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexes.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
        Annotation documentWithRefTime = SUTimeITest.createDocument(testText, "20030414");
        sutime.annotate(documentWithRefTime);
        for (CoreMap timexAnn : (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexesResolved.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
    }

    public void testSUTimeEmptySentence() throws IOException {
        String testText = ".";
        Annotation document = SUTimeITest.createDocument(testText);
        Properties props = SUTimeITest.getDefaultProperties();
        props.setProperty("sutime.includeRange", "true");
        TimeAnnotator sutime = SUTimeITest.getTimeAnnotator(props);
        sutime.annotate(document);
        List timexes = (List)document.get(TimeAnnotations.TimexAnnotations.class);
        SUTimeITest.assertEquals((int)0, (int)timexes.size());
        Annotation documentWithRefTime = SUTimeITest.createDocument(testText, "2007-05-14");
        sutime.annotate(documentWithRefTime);
        timexes = (List)document.get(TimeAnnotations.TimexAnnotations.class);
        SUTimeITest.assertEquals((int)0, (int)timexes.size());
    }

    public void testSUTimeInexactTime() throws IOException {
        String testText = "The morning of January 31 was very cold.\nHe arrived late last night.\nHe arrived last night.\n";
        Iterator<Timex> expectedTimexes = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"XXXX-01-31TMO\" type=\"TIME\">The morning of January 31</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" alt_value=\"TNI OFFSET P-1D\" type=\"DATE\" mod=\"LATE\" temporalFunction=\"true\" valueFromFunction=\"tf0\" anchorTimeID=\"t3\">late last night</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" alt_value=\"TNI OFFSET P-1D\" type=\"DATE\" temporalFunction=\"true\" valueFromFunction=\"tf1\" anchorTimeID=\"t5\">last night</TIMEX3>")).iterator();
        Iterator<Timex> expectedTimexesResolved = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"2003-01-31TMO\" type=\"TIME\">The morning of January 31</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"2003-04-13TNI\" type=\"TIME\" mod=\"LATE\">late last night</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" value=\"2003-04-13TNI\" type=\"TIME\">last night</TIMEX3>")).iterator();
        Annotation document = SUTimeITest.createDocument(testText);
        TimeAnnotator sutime = SUTimeITest.getTimeAnnotator();
        sutime.annotate(document);
        for (CoreMap timexAnn : (List)document.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexes.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
        Annotation documentWithRefTime = SUTimeITest.createDocument(testText, "20030414");
        sutime.annotate(documentWithRefTime);
        for (CoreMap timexAnn : (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexesResolved.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
    }

    public void testSUTimeSet() throws IOException {
        String testText = "John swims twice a week.\nEvery 2 days, he goes jogging.\nEvery third week of October, he goes to the lake.\nOn alternate Fridays, he drives to the park.\n";
        Iterator<Timex> expectedTimexes = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"P1W\" type=\"DURATION\">a week</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"P2D\" type=\"SET\" quant=\"every\" periodicity=\"P2D\">Every 2 days</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" alt_value=\"XXXX-10 INTERSECT P1W-#3\" type=\"SET\" quant=\"every\">Every third week of October</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"XXXX-WXX-5\" type=\"SET\" quant=\"alternate\" periodicity=\"P2W\">alternate Fridays</TIMEX3>")).iterator();
        Iterator<Timex> expectedTimexesResolved = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"P1W\" type=\"DURATION\">a week</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"P2D\" type=\"SET\" quant=\"every\" periodicity=\"P2D\">Every 2 days</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" alt_value=\"XXXX-10 INTERSECT P1W-#3\" type=\"SET\" quant=\"every\">Every third week of October</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"XXXX-WXX-5\" type=\"SET\" quant=\"alternate\" periodicity=\"P2W\">alternate Fridays</TIMEX3>")).iterator();
        Annotation document = SUTimeITest.createDocument(testText);
        TimeAnnotator sutime = SUTimeITest.getTimeAnnotator();
        sutime.annotate(document);
        for (CoreMap timexAnn : (List)document.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexes.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
        Annotation documentWithRefTime = SUTimeITest.createDocument(testText, "20030414");
        sutime.annotate(documentWithRefTime);
        for (CoreMap timexAnn : (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexesResolved.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
    }

    public void testSUTimeDateTime() throws IOException {
        String testText = "The vase of 14 fell early Friday evening.\nThe bus is not coming until 8:00 pm.\nThey were to have lunch at 12:15 on Thursday.\nOr was it quarter to twelve on Wed?\nHe got home at twelve o'clock midnight.\nNext Tuesday is Tuesday the 18th.\nIt happened early yesterday morning.\nIt happened late afternoon.\nIt happened late this afternoon.\nIt happened at 1800 hours.\nThe early nineteen fifties.\nThe story broke in the last week of October.\nIt was 7pm and then 7:20pm.";
        Iterator<Timex> expectedTimexes = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"XXXX-WXX-5TEV\" type=\"TIME\" mod=\"EARLY\">early Friday evening</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"T20:00\" type=\"TIME\">8:00 pm</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" value=\"XXXX-WXX-4T12:15\" type=\"TIME\">12:15 on Thursday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"XXXX-WXX-3T11:45\" type=\"TIME\">quarter to twelve on Wed</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" value=\"T00:00\" type=\"TIME\">twelve o'clock midnight</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t6\" alt_value=\"XXXX-WXX-2 OFFSET P1W\" type=\"DATE\" temporalFunction=\"true\" valueFromFunction=\"tf0\" anchorTimeID=\"t7\">Next Tuesday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t8\" value=\"XXXX-WXX-2\" type=\"DATE\">Tuesday the 18th</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t9\" alt_value=\"OFFSET P-1D INTERSECT MO\" type=\"DATE\" mod=\"EARLY\" temporalFunction=\"true\" valueFromFunction=\"tf1\" anchorTimeID=\"t10\">early yesterday morning</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t11\" value=\"TAF\" type=\"TIME\" mod=\"LATE\">late afternoon</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t12\" alt_value=\"THIS AF\" type=\"DATE\" mod=\"LATE\" temporalFunction=\"true\" valueFromFunction=\"tf2\" anchorTimeID=\"t0\">late this afternoon</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t13\" value=\"T18:00\" type=\"TIME\">1800 hours</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t14\" value=\"195X\" type=\"DATE\" mod=\"EARLY\">The early nineteen fifties</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t15\" alt_value=\"PREV_IMMEDIATE P1W INTERSECT XXXX-10\" type=\"DATE\" temporalFunction=\"true\" valueFromFunction=\"tf3\" anchorTimeID=\"t16\">the last week of October</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t17\" value=\"T19:00\" type=\"TIME\">7pm</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t18\" value=\"T19:20\" type=\"TIME\">7:20pm.</TIMEX3>")).iterator();
        Iterator<Timex> expectedTimexesResolved = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"2005-08-12TEV\" type=\"TIME\" mod=\"EARLY\">early Friday evening</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"2005-08-12T20:00\" type=\"TIME\">8:00 pm</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" value=\"2005-08-11T12:15\" type=\"TIME\">12:15 on Thursday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"2005-08-10T11:45\" type=\"TIME\">quarter to twelve on Wed</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" value=\"2005-08-12T00:00\" type=\"TIME\">twelve o'clock midnight</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t6\" value=\"2005-08-16\" type=\"DATE\">Next Tuesday</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t7\" value=\"2005-08-18\" type=\"DATE\">Tuesday the 18th</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t8\" value=\"2005-08-11TMO\" type=\"TIME\" mod=\"EARLY\">early yesterday morning</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t9\" value=\"2005-08-12TAF\" type=\"TIME\" mod=\"LATE\">late afternoon</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t10\" value=\"2005-08-12TAF\" type=\"TIME\" mod=\"LATE\">late this afternoon</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t11\" value=\"2005-08-12T18:00\" type=\"TIME\">1800 hours</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t12\" value=\"195X\" type=\"DATE\" mod=\"EARLY\">The early nineteen fifties</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t13\" alt_value=\"PREV_IMMEDIATE P1W INTERSECT XXXX-10\" type=\"DATE\" temporalFunction=\"true\" valueFromFunction=\"tf0\" anchorTimeID=\"t14\">the last week of October</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t15\" value=\"2005-08-12T19:00\" type=\"TIME\">7pm</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t16\" value=\"2005-08-12T19:20\" type=\"TIME\">7:20pm.</TIMEX3>")).iterator();
        Annotation document = SUTimeITest.createDocument(testText);
        TimeAnnotator sutime = SUTimeITest.getTimeAnnotator();
        sutime.annotate(document);
        for (CoreMap timexAnn : (List)document.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexes.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
        Annotation documentWithRefTime = SUTimeITest.createDocument(testText, "20050812");
        sutime.annotate(documentWithRefTime);
        for (CoreMap timexAnn : (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexesResolved.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
    }

    public void testSUTimeDateTime2() throws IOException {
        String testText = "The meeting is scheduled for 09/18/05 or 18 Sep '05.\n1 year ago tomorrow.\n3 months ago saturday at 5:00 pm.\n7 hours before tomorrow at noon.\n3rd wednesday in november.\n3rd month next year.\n3rd thursday this september.\n4th day last week.\nfourteenth of june 2010 at eleven o'clock in the evening.\nmay seventh '97 at three in the morning.\nThe third week of april was very hot.\n";
        Iterator<Timex> expectedTimexes = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"XX05-09-18\" type=\"DATE\">09/18/05</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"XX05-09-18\" type=\"DATE\">18 Sep '05</TIMEX3>"), Timex.fromXml("<TIMEX3 alt_value=\"OFFSET P-1Y INTERSECT OFFSET P1D\" anchorTimeID=\"t4\" temporalFunction=\"true\" tid=\"t3\" type=\"DATE\" valueFromFunction=\"tf0\">1 year ago tomorrow</TIMEX3>"), Timex.fromXml("<TIMEX3 alt_value=\"OFFSET P-3M INTERSECT XXXX-WXX-6T17:00\" anchorTimeID=\"t6\" temporalFunction=\"true\" tid=\"t5\" type=\"DATE\" valueFromFunction=\"tf1\">3 months ago saturday at 5:00 pm</TIMEX3>"), Timex.fromXml("<TIMEX3 alt_value=\"OFFSET P1DT-7H INTERSECT T12:00\" anchorTimeID=\"t8\" temporalFunction=\"true\" tid=\"t7\" type=\"DATE\" valueFromFunction=\"tf2\">7 hours before tomorrow at noon</TIMEX3>"), Timex.fromXml("<TIMEX3 alt_value=\"XXXX-11-WXX-3-#3\" tid=\"t9\" type=\"DATE\">3rd wednesday in november</TIMEX3>"), Timex.fromXml("<TIMEX3 alt_value=\"THIS P1Y OFFSET P1Y INTERSECT P1M-#3\" anchorTimeID=\"t11\" temporalFunction=\"true\" tid=\"t10\" type=\"DATE\" valueFromFunction=\"tf3\">3rd month next year</TIMEX3>"), Timex.fromXml("<TIMEX3 alt_value=\"THIS XXXX-09 INTERSECT XXXX-WXX-4-#3\" anchorTimeID=\"t13\" temporalFunction=\"true\" tid=\"t12\" type=\"DATE\" valueFromFunction=\"tf4\">3rd thursday this september</TIMEX3>"), Timex.fromXml("<TIMEX3 alt_value=\"THIS P1W OFFSET P-1W INTERSECT P1D-#4\" anchorTimeID=\"t15\" temporalFunction=\"true\" tid=\"t14\" type=\"DATE\" valueFromFunction=\"tf5\">4th day last week</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t16\" type=\"TIME\" value=\"2010-06-14T23:00\">fourteenth of june 2010 at eleven o'clock in the evening</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t17\" type=\"TIME\" value=\"XX97-05-07T03:00\">may seventh '97 at three in the morning</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t18\" alt_value=\"XXXX-04 INTERSECT P1W-#3\" type=\"DATE\" temporalFunction=\"true\" valueFromFunction=\"tf6\" anchorTimeID=\"t19\">The third week of april</TIMEX3>")).iterator();
        Iterator<Timex> expectedTimexesResolved = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"2005-09-18\" type=\"DATE\">09/18/05</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"2005-09-18\" type=\"DATE\">18 Sep '05</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" value=\"2008-08-13\" type=\"DATE\">1 year ago tomorrow</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"2009-05-12T17:00\" type=\"TIME\">3 months ago saturday at 5:00 pm</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" value=\"2009-08-13T12:00\" type=\"TIME\">7 hours before tomorrow at noon</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t6\" value=\"2009-11-18\" type=\"DATE\">3rd wednesday in november</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t7\" value=\"2010-03\" type=\"DATE\">3rd month next year</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t8\" value=\"2009-09-17\" type=\"DATE\">3rd thursday this september</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t9\" value=\"2009-08-06\" type=\"DATE\">4th day last week</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t10\" value=\"2010-06-14T23:00\" type=\"TIME\">fourteenth of june 2010 at eleven o'clock in the evening</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t11\" value=\"1997-05-07T03:00\" type=\"TIME\">may seventh '97 at three in the morning</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t12\" type=\"DATE\" value=\"2009-W16\">The third week of april</TIMEX3>")).iterator();
        Annotation document = SUTimeITest.createDocument(testText);
        TimeAnnotator sutime = SUTimeITest.getTimeAnnotator();
        sutime.annotate(document);
        for (CoreMap timexAnn : (List)document.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexes.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
        Annotation documentWithRefTime = SUTimeITest.createDocument(testText, "20090812");
        sutime.annotate(documentWithRefTime);
        for (CoreMap timexAnn : (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexesResolved.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
    }

    public void testSUTimeIso2() throws IOException {
        String testText = "ISO date is 6/12/2008, 1988-02-17.\n";
        Iterator<Timex> expectedTimexes = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"2008-06-12\" type=\"DATE\">6/12/2008</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"1988-02-17\" type=\"DATE\">1988-02-17</TIMEX3>")).iterator();
        Iterator<Timex> expectedTimexesResolved = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"2008-06-12\" type=\"DATE\">6/12/2008</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"1988-02-17\" type=\"DATE\">1988-02-17</TIMEX3>")).iterator();
        Annotation document = SUTimeITest.createDocument(testText);
        TimeAnnotator sutime = SUTimeITest.getTimeAnnotator();
        sutime.annotate(document);
        for (CoreMap timexAnn : (List)document.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexes.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
        Annotation documentWithRefTime = SUTimeITest.createDocument(testText, "20100217");
        sutime.annotate(documentWithRefTime);
        for (CoreMap timexAnn : (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexesResolved.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
    }

    public void testSUTimeDate2() throws IOException {
        String testText = "The date is October 15, 2003.\nThe fires started on the first of August 2010.\nIt snowed in November 2004.\nThe year twenty ten is here.\nI was born in 1879\n";
        Iterator<Timex> expectedTimexes = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"2003-10-15\" type=\"DATE\">October 15, 2003</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"2010-08-01\" type=\"DATE\">the first of August 2010</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" value=\"2004-11\" type=\"DATE\">November 2004</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"2010\" type=\"DATE\">The year twenty ten</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" value=\"1879\" type=\"DATE\">1879</TIMEX3>")).iterator();
        Iterator<Timex> expectedTimexesResolved = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"2003-10-15\" type=\"DATE\">October 15, 2003</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"2010-08-01\" type=\"DATE\">the first of August 2010</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" value=\"2004-11\" type=\"DATE\">November 2004</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"2010\" type=\"DATE\">The year twenty ten</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" value=\"1879\" type=\"DATE\">1879</TIMEX3>")).iterator();
        Annotation document = SUTimeITest.createDocument(testText);
        TimeAnnotator sutime = SUTimeITest.getTimeAnnotator();
        sutime.annotate(document);
        for (CoreMap timexAnn : (List)document.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexes.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
        Annotation documentWithRefTime = SUTimeITest.createDocument(testText, "20100217");
        sutime.annotate(documentWithRefTime);
        for (CoreMap timexAnn : (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexesResolved.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
    }

    public void testSUTimeHolidays() throws IOException {
        String testText = "When is mother's day 2012?\nWhen is Christmas 2010?\nWhen is Easter 2011?\n";
        Iterator<Timex> expectedTimexes = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"2012-05-13\" type=\"DATE\">mother's day 2012</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"2010-12-25\" type=\"DATE\">Christmas 2010</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" value=\"2011-04-24\" type=\"DATE\">Easter 2011</TIMEX3>")).iterator();
        Iterator<Timex> expectedTimexesResolved = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"2012-05-13\" type=\"DATE\">mother's day 2012</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"2010-12-25\" type=\"DATE\">Christmas 2010</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" value=\"2011-04-24\" type=\"DATE\">Easter 2011</TIMEX3>")).iterator();
        Annotation document = SUTimeITest.createDocument(testText);
        TimeAnnotator sutime = SUTimeITest.getTimeAnnotator();
        sutime.annotate(document);
        for (CoreMap timexAnn : (List)document.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexes.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
        Annotation documentWithRefTime = SUTimeITest.createDocument(testText, "20100217");
        sutime.annotate(documentWithRefTime);
        for (CoreMap timexAnn : (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexesResolved.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
    }

    public void testSUTime12AmPm() throws IOException {
        String testText = "The hour of 12 in the morning.\nIt is 12 in the morning.  It is 12:00 or is it 12 am.\nIt is 12 in the afternoon.  It is 12 in the evening.\nIt is 12 at night.  It is 12 pm, in 12 hours it will be 24 o'clock (24:00).\nIt is 12:34 p.m.";
        Iterator<Timex> expectedTimexes = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"T00:00\" type=\"TIME\">The hour of 12 in the morning</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"T00:00\" type=\"TIME\">12 in the morning</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" value=\"T12:00\" type=\"TIME\">12:00</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"T00:00\" type=\"TIME\">12 am</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" value=\"T12:00\" type=\"TIME\">12 in the afternoon</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t6\" alt_value=\"T00:00 OFFSET P1D\" type=\"DATE\" temporalFunction=\"true\" valueFromFunction=\"tf0\" anchorTimeID=\"t7\">12 in the evening</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t8\" alt_value=\"T00:00 OFFSET P1D\" type=\"DATE\" temporalFunction=\"true\" valueFromFunction=\"tf1\" anchorTimeID=\"t9\">12 at night</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t10\" value=\"T12:00\" type=\"TIME\">12 pm</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t11\" value=\"PT12H\" type=\"DURATION\">12 hours</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t12\" value=\"T24:00\" type=\"TIME\">24 o'clock</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t13\" value=\"T24:00\" type=\"TIME\">24:00</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t14\" value=\"T12:34\" type=\"TIME\">12:34 p.m.</TIMEX3>")).iterator();
        Iterator<Timex> expectedTimexesResolved = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" value=\"2010-02-17T00:00\" type=\"TIME\">The hour of 12 in the morning</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" value=\"2010-02-17T00:00\" type=\"TIME\">12 in the morning</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" value=\"2010-02-17T12:00\" type=\"TIME\">12:00</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" value=\"2010-02-17T00:00\" type=\"TIME\">12 am</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" value=\"2010-02-17T12:00\" type=\"TIME\">12 in the afternoon</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t6\" value=\"2010-02-18T00:00\" type=\"TIME\">12 in the evening</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t7\" value=\"2010-02-18T00:00\" type=\"TIME\">12 at night</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t8\" value=\"2010-02-17T12:00\" type=\"TIME\">12 pm</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t9\" value=\"PT12H\" type=\"DURATION\">12 hours</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t10\" value=\"2010-02-17T24:00\" type=\"TIME\">24 o'clock</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t11\" value=\"2010-02-17T24:00\" type=\"TIME\">24:00</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t12\" value=\"2010-02-17T12:34\" type=\"TIME\">12:34 p.m.</TIMEX3>")).iterator();
        Annotation document = SUTimeITest.createDocument(testText);
        TimeAnnotator sutime = SUTimeITest.getTimeAnnotator();
        sutime.annotate(document);
        for (CoreMap timexAnn : (List)document.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexes.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
        Annotation documentWithRefTime = SUTimeITest.createDocument(testText, "20100217");
        sutime.annotate(documentWithRefTime);
        for (CoreMap timexAnn : (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexesResolved.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
    }

    public void testOverlaps() throws IOException {
        String testText = "Sun Apr 21\nWed Apr 24\nFri Apr 26\nWed May 1\nFri May 3\nSun May 5\nFri May 10\nSat May 11\nWed May 15\nSat May 18\nWed May 22\nMon May 27\nFri May 31\nMon June 3\n    June 8\nTue Jun 18\nWed Jun 19\n";
        Iterator<Timex> expectedTimexes = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" type=\"DATE\" value=\"XXXX-04-21\">Sun Apr 21</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" type=\"DATE\" value=\"XXXX-04-24\">Wed Apr 24</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" type=\"DATE\" value=\"XXXX-04-26\">Fri Apr 26</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" type=\"DATE\" value=\"XXXX-05-01\">Wed May 1</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" type=\"DATE\" value=\"XXXX-05-03\">Fri May 3</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t6\" type=\"DATE\" value=\"XXXX-05-05\">Sun May 5</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t7\" type=\"DATE\" value=\"XXXX-05-10\">Fri May 10</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t8\" type=\"DATE\" value=\"XXXX-05-11\">Sat May 11</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t9\" type=\"DATE\" value=\"XXXX-05-15\">Wed May 15</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t10\" type=\"DATE\" value=\"XXXX-05-18\">Sat May 18</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t11\" type=\"DATE\" value=\"XXXX-05-22\">Wed May 22</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t12\" type=\"DATE\" value=\"XXXX-05-27\">Mon May 27</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t13\" type=\"DATE\" value=\"XXXX-05-31\">Fri May 31</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t14\" type=\"DATE\" value=\"XXXX-06-03\">Mon June 3</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t15\" type=\"DATE\" value=\"XXXX-06-08\">June 8\nTue</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t16\" type=\"DATE\" value=\"XXXX-06-18\">Jun 18\nWed</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t17\" type=\"DATE\" value=\"XXXX-06-19\">Jun 19</TIMEX3>")).iterator();
        Iterator<Timex> expectedTimexesResolved = Arrays.asList(Timex.fromXml("<TIMEX3 tid=\"t1\" type=\"DATE\" value=\"2010-04-21\">Sun Apr 21</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t2\" type=\"DATE\" value=\"2010-04-24\">Wed Apr 24</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t3\" type=\"DATE\" value=\"2010-04-26\">Fri Apr 26</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t4\" type=\"DATE\" value=\"2010-05-01\">Wed May 1</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t5\" type=\"DATE\" value=\"2010-05-03\">Fri May 3</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t6\" type=\"DATE\" value=\"2010-05-05\">Sun May 5</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t7\" type=\"DATE\" value=\"2010-05-10\">Fri May 10</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t8\" type=\"DATE\" value=\"2010-05-11\">Sat May 11</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t9\" type=\"DATE\" value=\"2010-05-15\">Wed May 15</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t10\" type=\"DATE\" value=\"2010-05-18\">Sat May 18</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t11\" type=\"DATE\" value=\"2010-05-22\">Wed May 22</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t12\" type=\"DATE\" value=\"2010-05-27\">Mon May 27</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t13\" type=\"DATE\" value=\"2010-05-31\">Fri May 31</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t14\" type=\"DATE\" value=\"2010-06-03\">Mon June 3</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t15\" type=\"DATE\" value=\"2010-06-08\">June 8\nTue</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t16\" type=\"DATE\" value=\"2010-06-18\">Jun 18\nWed</TIMEX3>"), Timex.fromXml("<TIMEX3 tid=\"t17\" type=\"DATE\" value=\"2010-06-19\">Jun 19</TIMEX3>")).iterator();
        Annotation document = SUTimeITest.createDocument(testText);
        TimeAnnotator sutime = SUTimeITest.getTimeAnnotator();
        sutime.annotate(document);
        for (CoreMap timexAnn : (List)document.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexes.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
        Annotation documentWithRefTime = SUTimeITest.createDocument(testText, "20100217");
        sutime.annotate(documentWithRefTime);
        for (CoreMap timexAnn : (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class)) {
            Timex expectedTimex = expectedTimexesResolved.next();
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
        }
        SUTimeITest.assertFalse((boolean)expectedTimexes.hasNext());
    }

    public void testResolve1() {
        String[] refTimes = new String[]{"2011-06-03", "2010-06-03", "2010-05-03", "2011-05-03", "1988-01-03"};
        String[] expectedTimexStrsResolved = new String[]{"<TIMEX3 tid=\"t1\" value=\"2011-05-23\" type=\"DATE\">last Monday</TIMEX3>", "<TIMEX3 tid=\"t1\" value=\"2010-05-24\" type=\"DATE\">last Monday</TIMEX3>", "<TIMEX3 tid=\"t1\" value=\"2010-04-26\" type=\"DATE\">last Monday</TIMEX3>", "<TIMEX3 tid=\"t1\" value=\"2011-04-25\" type=\"DATE\">last Monday</TIMEX3>", "<TIMEX3 tid=\"t1\" value=\"1987-12-21\" type=\"DATE\">last Monday</TIMEX3>"};
        String testText = "last Monday";
        for (int i = 0; i < refTimes.length; ++i) {
            String refTime = refTimes[i];
            String expectedTimexStr = expectedTimexStrsResolved[i];
            Timex expectedTimex = Timex.fromXml(expectedTimexStr);
            Annotation documentWithRefTime = SUTimeITest.createDocument(testText, refTime);
            TimeAnnotator sutime = SUTimeITest.getTimeAnnotator();
            sutime.annotate(documentWithRefTime);
            List timexes = (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class);
            SUTimeITest.assertEquals((int)1, (int)timexes.size());
            SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, (CoreMap)timexes.get(0));
        }
    }

    public void testResolve2() {
        String[] refTimes = new String[]{"2011-06-03", "2010-11-23", "1988-01-16"};
        String[] refModifiers = new String[]{"last", "this", "next", "this coming"};
        String[] refExprs = new String[]{"week", "weekend", "fortnight", "month", "quarter", "year", "decade", "century", "spring", "summer", "autumn", "fall", "winter", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "january", "february", "march", "april", "May", "june", "july", "august", "september", "october", "november", "december", "easter", "mother's day"};
        String[][] expectedValuesPrev = new String[][]{{"2011-W21", "2011-W21-WE", "2011-05-20/2011-06-03", "2011-05", "2011-Q1", "2010", "200X", "19XX", "2010-SP", "2010-SU", "2010-FA", "2010-FA", "2010-WI", "2011-05-23", "2011-05-24", "2011-05-25", "2011-05-26", "2011-05-27", "2011-05-28", "2011-05-29", "2010-01", "2010-02", "2010-03", "2010-04", "2010-05", "2010-06", "2010-07", "2010-08", "2010-09", "2010-10", "2010-11", "2010-12", "2010-04-04", "2010-05-09"}, {"2010-W46", "2010-W46-WE", "2010-11-09/2010-11-23", "2010-10", "2010-Q3", "2009", "200X", "19XX", "2009-SP", "2009-SU", "2009-FA", "2009-FA", "2009-WI", "2010-11-15", "2010-11-16", "2010-11-17", "2010-11-18", "2010-11-19", "2010-11-20", "2010-11-21", "2009-01", "2009-02", "2009-03", "2009-04", "2009-05", "2009-06", "2009-07", "2009-08", "2009-09", "2009-10", "2009-11", "2009-12", "2009-04-12", "2009-05-10"}, {"1988-W01", "1988-W01-WE", "1988-01-02/1988-01-16", "1987-12", "1987-Q4", "1987", "197X", "18XX", "1987-SP", "1987-SU", "1987-FA", "1987-FA", "1987-WI", "1988-01-04", "1988-01-05", "1988-01-06", "1988-01-07", "1988-01-08", "1988-01-09", "1988-01-10", "1987-01", "1987-02", "1987-03", "1987-04", "1987-05", "1987-06", "1987-07", "1987-08", "1987-09", "1987-10", "1987-11", "1987-12", "1987-04-19", "1987-05-10"}};
        String[][] expectedValuesThis = new String[][]{{"2011-W22", "2011-W22-WE", "2011-05-27/2011-06-10", "2011-06", "2011-Q2", "2011", "201X", "20XX", "2011-SP", "2011-SU", "2011-FA", "2011-FA", "2011-WI", "2011-05-30", "2011-05-31", "2011-06-01", "2011-06-02", "2011-06-03", "2011-06-04", "2011-06-05", "2011-01", "2011-02", "2011-03", "2011-04", "2011-05", "2011-06", "2011-07", "2011-08", "2011-09", "2011-10", "2011-11", "2011-12", "2011-04-24", "2011-05-08"}, {"2010-W47", "2010-W47-WE", "2010-11-16/2010-11-30", "2010-11", "2010-Q4", "2010", "201X", "20XX", "2010-SP", "2010-SU", "2010-FA", "2010-FA", "2010-WI", "2010-11-22", "2010-11-23", "2010-11-24", "2010-11-25", "2010-11-26", "2010-11-27", "2010-11-28", "2010-01", "2010-02", "2010-03", "2010-04", "2010-05", "2010-06", "2010-07", "2010-08", "2010-09", "2010-10", "2010-11", "2010-12", "2010-04-04", "2010-05-09"}, {"1988-W02", "1988-W02-WE", "1988-01-09/1988-01-23", "1988-01", "1988-Q1", "1988", "198X", "19XX", "1988-SP", "1988-SU", "1988-FA", "1988-FA", "1988-WI", "1988-01-11", "1988-01-12", "1988-01-13", "1988-01-14", "1988-01-15", "1988-01-16", "1988-01-17", "1988-01", "1988-02", "1988-03", "1988-04", "1988-05", "1988-06", "1988-07", "1988-08", "1988-09", "1988-10", "1988-11", "1988-12", "1988-04-03", "1988-05-08"}};
        String[][] expectedValuesNext = new String[][]{{"2011-W23", "2011-W23-WE", "2011-06-03/2011-06-17", "2011-07", "2011-Q3", "2012", "202X", "21XX", "2012-SP", "2012-SU", "2012-FA", "2012-FA", "2012-WI", "2011-06-06", "2011-06-07", "2011-06-08", "2011-06-09", "2011-06-10", "2011-06-11", "2011-06-12", "2012-01", "2012-02", "2012-03", "2012-04", "2012-05", "2012-06", "2012-07", "2012-08", "2012-09", "2012-10", "2012-11", "2012-12", "2012-04-08", "2012-05-13"}, {"2010-W48", "2010-W48-WE", "2010-11-23/2010-12-07", "2010-12", "2011-Q1", "2011", "202X", "21XX", "2011-SP", "2011-SU", "2011-FA", "2011-FA", "2011-WI", "2010-11-29", "2010-11-30", "2010-12-01", "2010-12-02", "2010-12-03", "2010-12-04", "2010-12-05", "2011-01", "2011-02", "2011-03", "2011-04", "2011-05", "2011-06", "2011-07", "2011-08", "2011-09", "2011-10", "2011-11", "2011-12", "2011-04-24", "2011-05-08"}, {"1988-W03", "1988-W03-WE", "1988-01-16/1988-01-30", "1988-02", "1988-Q2", "1989", "199X", "20XX", "1989-SP", "1989-SU", "1989-FA", "1989-FA", "1989-WI", "1988-01-18", "1988-01-19", "1988-01-20", "1988-01-21", "1988-01-22", "1988-01-23", "1988-01-24", "1989-01", "1989-02", "1989-03", "1989-04", "1989-05", "1989-06", "1989-07", "1989-08", "1989-09", "1989-10", "1989-11", "1989-12", "1989-03-26", "1989-05-14"}};
        String[][] expectedValuesNextImme = new String[][]{{"2011-W23", "2011-W23-WE", "2011-06-03/2011-06-17", "2011-07", "2011-Q3", "2012", "202X", "21XX", "2012-SP", "2011-SU", "2011-FA", "2011-FA", "2011-WI", "2011-06-06", "2011-06-07", "2011-06-08", "2011-06-09", "2011-06-10", "2011-06-04", "2011-06-05", "2012-01", "2012-02", "2012-03", "2012-04", "2012-05", "2012-06", "2011-07", "2011-08", "2011-09", "2011-10", "2011-11", "2011-12", "2012-04-08", "2012-05-13"}, {"2010-W48", "2010-W48-WE", "2010-11-23/2010-12-07", "2010-12", "2011-Q1", "2011", "202X", "21XX", "2011-SP", "2011-SU", "2011-FA", "2011-FA", "2010-WI", "2010-11-29", "2010-11-30", "2010-11-24", "2010-11-25", "2010-11-26", "2010-11-27", "2010-11-28", "2011-01", "2011-02", "2011-03", "2011-04", "2011-05", "2011-06", "2011-07", "2011-08", "2011-09", "2011-10", "2011-11", "2010-12", "2011-04-24", "2011-05-08"}, {"1988-W03", "1988-W03-WE", "1988-01-16/1988-01-30", "1988-02", "1988-Q2", "1989", "199X", "20XX", "1988-SP", "1988-SU", "1988-FA", "1988-FA", "1988-WI", "1988-01-18", "1988-01-19", "1988-01-20", "1988-01-21", "1988-01-22", "1988-01-23", "1988-01-17", "1989-01", "1988-02", "1988-03", "1988-04", "1988-05", "1988-06", "1988-07", "1988-08", "1988-09", "1988-10", "1988-11", "1988-12", "1988-04-03", "1988-05-08"}};
        String[][] expectedValuesPrevImme = new String[][]{{"2011-W21", "2011-W21-WE", "2011-05-20/2011-06-03", "2011-05", "2011-Q1", "2010", "200X", "19XX", "2010-SP", "2010-SU", "2010-FA", "2010-FA", "2010-WI", "2011-05-30", "2011-05-31", "2011-06-01", "2011-06-02", "2011-05-27", "2011-05-28", "2011-05-29", "2011-01", "2011-02", "2011-03", "2011-04", "2011-05", "2010-06", "2010-07", "2010-08", "2010-09", "2010-10", "2010-11", "2010-12", "", ""}, {"2010-W46", "2010-W46-WE", "2010-11-09/2010-11-23", "2010-10", "2010-Q3", "2009", "200X", "19XX", "2010-SP", "2010-SU", "2010-FA", "2010-FA", "2009-WI", "2010-11-22", "2010-11-16", "2010-11-17", "2010-11-18", "2010-11-19", "2010-11-20", "2010-11-21", "2010-01", "2010-02", "2010-03", "2010-04", "2010-05", "2010-06", "2010-07", "2010-08", "2010-09", "2010-10", "2009-11", "2009-12", "", ""}, {"1988-W01", "1988-W01-WE", "1988-01-02/1988-01-16,P2W", "1987-12", "1987-Q4", "1987", "197X", "18XX", "1987-SP", "1987-SU", "1987-FA", "1987-FA", "1987-WI", "1988-01-11", "1988-01-12", "1988-01-13", "1988-01-14", "1988-01-15", "1988-01-09", "1988-01-10", "1987-01", "1987-02", "1987-03", "1987-04", "1987-05", "1987-06", "1987-07", "1987-08", "1987-09", "1987-10", "1987-11", "1987-12", "", ""}};
        String[][][] expectedValuesAll = new String[][][]{expectedValuesPrev, expectedValuesThis, expectedValuesNext, expectedValuesNextImme};
        for (int i = 0; i < refTimes.length; ++i) {
            for (int j = 0; j < refModifiers.length; ++j) {
                String refTime = refTimes[i];
                String refMod = refModifiers[j];
                StringBuilder sb = new StringBuilder();
                for (String s : refExprs) {
                    sb.append("It happened " + refMod + " " + s + ". ");
                }
                String testText = sb.toString();
                String[] expectedValues = expectedValuesAll[j][i];
                Timex[] expectedTimexes = new Timex[refExprs.length];
                for (int k = 0; k < refExprs.length; ++k) {
                    String v = expectedValues[k];
                    String expr = refMod + " " + refExprs[k];
                    expectedTimexes[k] = v.contains("=") ? Timex.fromXml("<TIMEX3 tid=\"t" + (k + 1) + "\" " + v + " type=\"DATE\">" + expr + "</TIMEX3>") : Timex.fromXml("<TIMEX3 tid=\"t" + (k + 1) + "\" value=\"" + v + "\" type=\"DATE\">" + expr + "</TIMEX3>");
                }
                Annotation documentWithRefTime = SUTimeITest.createDocument(testText, refTime);
                TimeAnnotator sutime = SUTimeITest.getTimeAnnotator();
                sutime.annotate(documentWithRefTime);
                int k = 0;
                for (CoreMap timexAnn : (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class)) {
                    Timex expectedTimex = expectedTimexes[k];
                    SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
                    ++k;
                }
                SUTimeITest.assertEquals((int)expectedTimexes.length, (int)k);
            }
        }
    }

    public void testResolve3() {
        String[] refTimes = new String[]{"2011-06-03", "2010-11-23", "1988-01-16"};
        String[] refModifiers = new String[]{"", "last", "this", "next", "this coming"};
        String[] todExprs = new String[]{"at 8 p.m.", "at 8 in the morning", "at 8 in the evening", "1:00 pm", "morning", "noon", "afternoon", "evening", "night", "midnight"};
        String[] expectedTodValues = new String[]{"T20:00", "T08:00", "T20:00", "T13:00", "TMO", "T12:00", "TAF", "TEV", "TNI", "T00:00"};
        String[] refExprs = new String[]{"monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday"};
        String[][] expectedValuesPrev = new String[][]{{"2011-05-23", "2011-05-24", "2011-05-25", "2011-05-26", "2011-05-27", "2011-05-28", "2011-05-29"}, {"2010-11-15", "2010-11-16", "2010-11-17", "2010-11-18", "2010-11-19", "2010-11-20", "2010-11-21"}, {"1988-01-04", "1988-01-05", "1988-01-06", "1988-01-07", "1988-01-08", "1988-01-09", "1988-01-10"}};
        String[][] expectedValuesThis = new String[][]{{"2011-05-30", "2011-05-31", "2011-06-01", "2011-06-02", "2011-06-03", "2011-06-04", "2011-06-05"}, {"2010-11-22", "2010-11-23", "2010-11-24", "2010-11-25", "2010-11-26", "2010-11-27", "2010-11-28"}, {"1988-01-11", "1988-01-12", "1988-01-13", "1988-01-14", "1988-01-15", "1988-01-16", "1988-01-17"}};
        String[][] expectedValuesNext = new String[][]{{"2011-06-06", "2011-06-07", "2011-06-08", "2011-06-09", "2011-06-10", "2011-06-11", "2011-06-12"}, {"2010-11-29", "2010-11-30", "2010-12-01", "2010-12-02", "2010-12-03", "2010-12-04", "2010-12-05"}, {"1988-01-18", "1988-01-19", "1988-01-20", "1988-01-21", "1988-01-22", "1988-01-23", "1988-01-24"}};
        String[][] expectedValuesNextImme = new String[][]{{"2011-06-06", "2011-06-07", "2011-06-08", "2011-06-09", "2011-06-10", "2011-06-04", "2011-06-05"}, {"2010-11-29", "2010-11-30", "2010-11-24", "2010-11-25", "2010-11-26", "2010-11-27", "2010-11-28"}, {"1988-01-18", "1988-01-19", "1988-01-20", "1988-01-21", "1988-01-22", "1988-01-23", "1988-01-17"}};
        String[][][] expectedValuesAll = new String[][][]{expectedValuesThis, expectedValuesPrev, expectedValuesThis, expectedValuesNext, expectedValuesNextImme};
        for (int i = 0; i < refTimes.length; ++i) {
            for (int j = 0; j < refModifiers.length; ++j) {
                String refTime = refTimes[i];
                String refMod = refModifiers[j];
                StringBuilder sb = new StringBuilder();
                for (String s : refExprs) {
                    for (String tod : todExprs) {
                        sb.append("It happened " + refMod + " " + s + " " + tod + ". ");
                    }
                }
                String testText = sb.toString();
                String[] expectedValues = expectedValuesAll[j][i];
                Timex[] expectedTimexes = new Timex[refExprs.length * todExprs.length];
                int k = 0;
                for (int k1 = 0; k1 < refExprs.length; ++k1) {
                    for (int k2 = 0; k2 < todExprs.length; ++k2) {
                        String v = expectedValues[k1] + expectedTodValues[k2];
                        String expr = refMod.length() > 0 ? refMod + " " : "";
                        expr = expr + refExprs[k1] + " " + todExprs[k2];
                        expectedTimexes[k] = v.contains("=") ? Timex.fromXml("<TIMEX3 tid=\"t" + (k + 1) + "\" " + v + " type=\"TIME\">" + expr + "</TIMEX3>") : Timex.fromXml("<TIMEX3 tid=\"t" + (k + 1) + "\" value=\"" + v + "\" type=\"TIME\">" + expr + "</TIMEX3>");
                        ++k;
                    }
                }
                Annotation documentWithRefTime = SUTimeITest.createDocument(testText, refTime);
                TimeAnnotator sutime = SUTimeITest.getTimeAnnotator();
                sutime.annotate(documentWithRefTime);
                k = 0;
                for (CoreMap timexAnn : (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class)) {
                    Timex expectedTimex = expectedTimexes[k];
                    SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
                    ++k;
                }
                SUTimeITest.assertEquals((int)expectedTimexes.length, (int)k);
            }
        }
    }

    public void testSet() {
        String[] refModifiers = new String[]{"every", "every other", "each", "alternate", "every 3rd", "every fourth"};
        String[] refExprs = new String[]{"week", "weekend", "fortnight", "month", "year", "decade", "century", "millenium", "spring", "summer", "autumn", "fall", "winter", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "january", "february", "march", "april", "May", "june", "july", "august", "september", "october", "november", "december"};
        String[][] expectedValuesEvery = new String[][]{{"P1W", "P1W"}, {"XXXX-WE", "P1W"}, {"P2W", "P2W"}, {"P1M", "P1M"}, {"P1Y", "P1Y"}, {"P10Y", "P10Y"}, {"P100Y", "P100Y"}, {"P1000Y", "P1000Y"}, {"XXXX-SP", "P1Y"}, {"XXXX-SU", "P1Y"}, {"XXXX-FA", "P1Y"}, {"XXXX-FA", "P1Y"}, {"XXXX-WI", "P1Y"}, {"XXXX-WXX-1", "P1W"}, {"XXXX-WXX-2", "P1W"}, {"XXXX-WXX-3", "P1W"}, {"XXXX-WXX-4", "P1W"}, {"XXXX-WXX-5", "P1W"}, {"XXXX-WXX-6", "P1W"}, {"XXXX-WXX-7", "P1W"}, {"XXXX-01", "P1Y"}, {"XXXX-02", "P1Y"}, {"XXXX-03", "P1Y"}, {"XXXX-04", "P1Y"}, {"XXXX-05", "P1Y"}, {"XXXX-06", "P1Y"}, {"XXXX-07", "P1Y"}, {"XXXX-08", "P1Y"}, {"XXXX-09", "P1Y"}, {"XXXX-10", "P1Y"}, {"XXXX-11", "P1Y"}, {"XXXX-12", "P1Y"}};
        int[] expectedMultiples = new int[]{1, 2, 1, 2, 3, 4};
        Pattern p = Pattern.compile("(\\D+)(\\d+)(\\D+)");
        for (int j = 0; j < refModifiers.length; ++j) {
            String refTime = null;
            String refMod = refModifiers[j];
            StringBuilder sb = new StringBuilder();
            for (String s : refExprs) {
                sb.append("It happens " + refMod + " " + s + ". ");
            }
            String testText = sb.toString();
            Timex[] expectedTimexes = new Timex[refExprs.length];
            int m = expectedMultiples[j];
            for (int k = 0; k < refExprs.length; ++k) {
                String v = expectedValuesEvery[k][0];
                String g = expectedValuesEvery[k][1];
                Matcher matcher = p.matcher(g);
                if (matcher.matches()) {
                    int mg = Integer.parseInt(matcher.group(2));
                    g = matcher.group(1) + (mg *= m) + matcher.group(3);
                }
                String expr = refMod + ' ' + refExprs[k];
                expectedTimexes[k] = Timex.fromXml("<TIMEX3 tid=\"t" + (k + 1) + "\" value=\"" + v + "\" type=\"SET\" quant=\"" + refMod + "\" periodicity=\"" + g + "\">" + expr + "</TIMEX3>");
            }
            Annotation documentWithRefTime = SUTimeITest.createDocument(testText, refTime);
            TimeAnnotator sutime = SUTimeITest.getTimeAnnotator();
            sutime.annotate(documentWithRefTime);
            int k = 0;
            for (CoreMap timexAnn : (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class)) {
                Timex expectedTimex = expectedTimexes[k];
                SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
                ++k;
            }
            SUTimeITest.assertEquals((int)expectedTimexes.length, (int)k);
        }
    }

    public void testSet2() {
        String[] refModifiers = new String[]{"", "bi", "bi-", "bi - "};
        String[] refExprs = new String[]{"annually", "yearly", "annual", "quarterly", "monthly", "weekly", "daily", "nightly", "hourly"};
        String[][] expectedValuesEvery = new String[][]{{"P1Y", "P1Y"}, {"P1Y", "P1Y"}, {"P1Y", "P1Y"}, {"P3M", "P3M"}, {"P1M", "P1M"}, {"P1W", "P1W"}, {"P1D", "P1D"}, {"TNI", "P1D"}, {"PT1H", "PT1H"}};
        int[] expectedMultiples = new int[]{1, 2, 2, 2};
        Pattern p = Pattern.compile("(\\D+)(\\d+)(\\D+)");
        for (int j = 0; j < refModifiers.length; ++j) {
            String refTime = null;
            String refMod = refModifiers[j];
            StringBuilder sb = new StringBuilder();
            for (String s : refExprs) {
                sb.append("It happens " + refMod + s + ". ");
            }
            String testText = sb.toString();
            Timex[] expectedTimexes = new Timex[refExprs.length];
            int m = expectedMultiples[j];
            for (int k = 0; k < refExprs.length; ++k) {
                String v = expectedValuesEvery[k][0];
                String g = expectedValuesEvery[k][1];
                boolean updateV = v.equals(g);
                Matcher matcher = p.matcher(g);
                if (matcher.matches()) {
                    int mg = Integer.parseInt(matcher.group(2));
                    g = matcher.group(1) + (mg *= m) + matcher.group(3);
                }
                if (updateV) {
                    v = g;
                }
                String expr = refMod + refExprs[k];
                expectedTimexes[k] = Timex.fromXml("<TIMEX3 tid=\"t" + (k + 1) + "\" value=\"" + v + "\" type=\"SET\" quant=\"EVERY\" freq=\"P1X\" periodicity=\"" + g + "\">" + expr + "</TIMEX3>");
            }
            Annotation documentWithRefTime = SUTimeITest.createDocument(testText, refTime);
            TimeAnnotator sutime = SUTimeITest.getTimeAnnotator();
            sutime.annotate(documentWithRefTime);
            int k = 0;
            for (CoreMap timexAnn : (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class)) {
                Timex expectedTimex = expectedTimexes[k];
                SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
                ++k;
            }
            SUTimeITest.assertEquals((int)expectedTimexes.length, (int)k);
        }
    }

    public void testSeasons() {
        String[] refModifiers = new String[]{"", "the "};
        String[] refExprs1 = new String[]{"summer", "winter", "autumn", "fall", "spring"};
        String[] refExprs2 = new String[]{"nineteen ninety five", "2005"};
        String[] expected1 = new String[]{"SU", "WI", "FA", "FA", "SP"};
        String[] expected2 = new String[]{"1995", "2005"};
        for (String refModifier : refModifiers) {
            String refTime = null;
            StringBuilder sb = new StringBuilder();
            for (String s : refExprs1) {
                for (String y : refExprs2) {
                    sb.append("It happens " + refModifier + s + " " + y + ". ");
                    sb.append("It happens " + refModifier + s + " of " + y + ". ");
                    sb.append("It happens " + refModifier + y + " " + s + ". ");
                }
            }
            String testText = sb.toString();
            Timex[] expectedTimexes = new Timex[refExprs1.length * refExprs2.length * 3];
            int i = 0;
            for (int k = 0; k < refExprs1.length; ++k) {
                for (int m = 0; m < refExprs2.length; ++m) {
                    String s = expected1[k];
                    String y = expected2[m];
                    String v = y + "-" + s;
                    String expr = refModifier + refExprs1[k] + " " + refExprs2[m];
                    expectedTimexes[i++] = Timex.fromXml("<TIMEX3 tid=\"t" + i + "\" value=\"" + v + "\" type=\"DATE\">" + expr + "</TIMEX3>");
                    expr = refModifier + refExprs1[k] + " of " + refExprs2[m];
                    expectedTimexes[i++] = Timex.fromXml("<TIMEX3 tid=\"t" + i + "\" value=\"" + v + "\" type=\"DATE\">" + expr + "</TIMEX3>");
                    expr = refModifier + refExprs2[m] + " " + refExprs1[k];
                    expectedTimexes[i++] = Timex.fromXml("<TIMEX3 tid=\"t" + i + "\" value=\"" + v + "\" type=\"DATE\">" + expr + "</TIMEX3>");
                }
            }
            Annotation documentWithRefTime = SUTimeITest.createDocument(testText, refTime);
            TimeAnnotator sutime = SUTimeITest.getTimeAnnotator();
            sutime.annotate(documentWithRefTime);
            i = 0;
            for (CoreMap timexAnn : (List)documentWithRefTime.get(TimeAnnotations.TimexAnnotations.class)) {
                Timex expectedTimex = expectedTimexes[i];
                SUTimeITest.checkTimex(testText, expectedTimex.text(), expectedTimex, timexAnn);
                ++i;
            }
            SUTimeITest.assertEquals((int)expectedTimexes.length, (int)i);
        }
    }

    private static void checkTimex(String documentText, String expectedText, Timex expectedTimex, CoreMap timexAnn) {
        String actualText = (String)timexAnn.get(CoreAnnotations.TextAnnotation.class);
        Assert.assertEquals((Object)expectedText, (Object)actualText);
        int begin = (Integer)timexAnn.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
        int end = (Integer)timexAnn.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
        Assert.assertEquals((Object)expectedText, (Object)documentText.substring(begin, end));
        Timex actualTimex = (Timex)timexAnn.get(TimeAnnotations.TimexAnnotation.class);
        Assert.assertEquals((String)("Expected \"" + expectedTimex + "\" but got \"" + actualTimex + '\"'), (Object)expectedTimex.toString(), (Object)actualTimex.toString());
    }

    protected static Annotation createDocument(String text) {
        Annotation annotation = new Annotation(text);
        pipeline.annotate(annotation);
        return annotation;
    }

    protected static Annotation createDocument(String text, String date) {
        Annotation annotation = new Annotation(text);
        annotation.set(CoreAnnotations.DocDateAnnotation.class, date);
        pipeline.annotate(annotation);
        return annotation;
    }
}

