/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.time;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.time.TimeAnnotations;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TimexTreeAnnotator
implements Annotator {
    private MatchType matchType;

    public TimexTreeAnnotator(MatchType matchType) {
        this.matchType = matchType;
    }

    @Override
    public void annotate(Annotation document) {
        for (CoreMap sentence : (List)document.get(CoreAnnotations.SentencesAnnotation.class)) {
            List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            Tree tree = (Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class);
            tree.indexSpans(0);
            for (CoreMap timexAnn : (List)sentence.get(TimeAnnotations.TimexAnnotations.class)) {
                Tree subtree;
                int timexBegin = TimexTreeAnnotator.beginOffset(timexAnn);
                int timexEnd = TimexTreeAnnotator.endOffset(timexAnn);
                switch (this.matchType) {
                    case ExactMatch: {
                        Iterable<Tree> possibleMatches = Iterables.filter(tree, tree1 -> {
                            int treeBegin = TimexTreeAnnotator.beginOffset(tree, tokens);
                            int treeEnd = TimexTreeAnnotator.endOffset(tree, tokens);
                            return treeBegin == timexBegin && timexEnd == treeEnd;
                        });
                        Iterator<Tree> treeIter = possibleMatches.iterator();
                        subtree = treeIter.hasNext() ? treeIter.next() : null;
                        break;
                    }
                    case SmallestEnclosing: {
                        Iterable<Tree> possibleMatches = Iterables.filter(tree, tree1 -> {
                            int treeBegin = TimexTreeAnnotator.beginOffset(tree, tokens);
                            int treeEnd = TimexTreeAnnotator.endOffset(tree, tokens);
                            return treeBegin <= timexBegin && timexEnd <= treeEnd;
                        });
                        List<Tree> sortedMatches = CollectionUtils.toList(possibleMatches);
                        Collections.sort(sortedMatches, (tree1, tree2) -> {
                            Integer width1 = TimexTreeAnnotator.endOffset(tree1, tokens) - TimexTreeAnnotator.beginOffset(tree1, tokens);
                            Integer width2 = TimexTreeAnnotator.endOffset(tree2, tokens) - TimexTreeAnnotator.endOffset(tree2, tokens);
                            return width1.compareTo(width2);
                        });
                        subtree = sortedMatches.get(0);
                        break;
                    }
                    default: {
                        throw new RuntimeException("unexpected match type");
                    }
                }
                if (subtree == null) continue;
                timexAnn.set(TreeCoreAnnotations.TreeAnnotation.class, subtree);
            }
        }
    }

    private static int beginOffset(Tree tree, List<CoreLabel> tokens) {
        CoreMap label = (CoreMap)((Object)tree.label());
        int beginToken = (Integer)label.get(CoreAnnotations.BeginIndexAnnotation.class);
        return TimexTreeAnnotator.beginOffset(tokens.get(beginToken));
    }

    private static int endOffset(Tree tree, List<CoreLabel> tokens) {
        CoreMap label = (CoreMap)((Object)tree.label());
        int endToken = (Integer)label.get(CoreAnnotations.EndIndexAnnotation.class);
        if (endToken > tokens.size()) {
            String msg = "no token %d in tree:\n%s\ntokens:\n%s";
            throw new RuntimeException(String.format(msg, endToken - 1, tree, tokens));
        }
        return TimexTreeAnnotator.endOffset(tokens.get(endToken - 1));
    }

    private static int beginOffset(CoreMap map) {
        return (Integer)map.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
    }

    private static int endOffset(CoreMap map) {
        return (Integer)map.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.CharacterOffsetBeginAnnotation.class, CoreAnnotations.CharacterOffsetEndAnnotation.class, CoreAnnotations.SentencesAnnotation.class)));
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.emptySet();
    }

    public static enum MatchType {
        ExactMatch,
        SmallestEnclosing;

    }
}

