/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.process.Morphology;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.trees.CoordinationTransformer;
import edu.stanford.nlp.trees.EnglishGrammaticalRelations;
import edu.stanford.nlp.trees.EnglishPatterns;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructureConversionUtils;
import edu.stanford.nlp.trees.GrammaticalStructureFromDependenciesFactory;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeGraphNode;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.util.Filters;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Triple;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;

public class EnglishGrammaticalStructure
extends GrammaticalStructure {
    private static Redwood.RedwoodChannels log = Redwood.channels(EnglishGrammaticalStructure.class);
    private static final long serialVersionUID = -1866362375001969402L;
    private static final boolean DEBUG = System.getProperty("EnglishGrammaticalStructure", null) != null;
    private static final Predicate<TypedDependency> extraTreeDepFilter = new ExtraTreeDepFilter();
    private static final SemgrexPattern XCOMP_PATTERN = SemgrexPattern.compile("{}=root >xcomp {}=embedded >/^(dep|dobj)$/ {}=wh ?>/([di]obj)/ {}=obj");
    private static final String[][] MULTIWORD_PREPS = new String[][]{{"according", "to"}, {"across", "from"}, {"ahead", "of"}, {"along", "with"}, {"alongside", "of"}, {"apart", "from"}, {"as", "for"}, {"as", "from"}, {"as", "of"}, {"as", "per"}, {"as", "to"}, {"aside", "from"}, {"away", "from"}, {"based", "on"}, {"because", "of"}, {"close", "by"}, {"close", "to"}, {"contrary", "to"}, {"compared", "to"}, {"compared", "with"}, {"due", "to"}, {"depending", "on"}, {"except", "for"}, {"exclusive", "of"}, {"far", "from"}, {"followed", "by"}, {"inside", "of"}, {"instead", "of"}, {"irrespective", "of"}, {"next", "to"}, {"near", "to"}, {"off", "of"}, {"out", "of"}, {"outside", "of"}, {"owing", "to"}, {"preliminary", "to"}, {"preparatory", "to"}, {"previous", "to"}, {"prior", "to"}, {"pursuant", "to"}, {"regardless", "of"}, {"subsequent", "to"}, {"such", "as"}, {"thanks", "to"}, {"together", "with"}};
    private static final String[][] THREEWORD_PREPS = new String[][]{{"by", "means", "of"}, {"in", "accordance", "with"}, {"in", "addition", "to"}, {"in", "case", "of"}, {"in", "front", "of"}, {"in", "lieu", "of"}, {"in", "place", "of"}, {"in", "spite", "of"}, {"on", "account", "of"}, {"on", "behalf", "of"}, {"on", "top", "of"}, {"with", "regard", "to"}, {"with", "respect", "to"}};

    public EnglishGrammaticalStructure(Tree t) {
        this(t, new PennTreebankLanguagePack().punctuationWordRejectFilter());
    }

    public EnglishGrammaticalStructure(Tree t, Predicate<String> puncFilter) {
        this(t, puncFilter, new SemanticHeadFinder(true));
    }

    public EnglishGrammaticalStructure(Tree t, Predicate<String> puncFilter, HeadFinder hf) {
        super(t, EnglishGrammaticalRelations.values(), EnglishGrammaticalRelations.valuesLock(), new CoordinationTransformer(hf), hf, puncFilter, Filters.acceptFilter());
    }

    public EnglishGrammaticalStructure(List<TypedDependency> projectiveDependencies, TreeGraphNode root) {
        super(projectiveDependencies, root);
    }

    @Override
    protected Predicate<TypedDependency> extraTreeDepFilter() {
        return extraTreeDepFilter;
    }

    @Override
    protected void correctDependencies(List<TypedDependency> list) {
        if (DEBUG) {
            EnglishGrammaticalStructure.printListSorted("At correctDependencies:", list);
        }
        EnglishGrammaticalStructure.correctSubjPass(list);
        if (DEBUG) {
            EnglishGrammaticalStructure.printListSorted("After correctSubjPass:", list);
        }
        EnglishGrammaticalStructure.removeExactDuplicates(list);
        if (DEBUG) {
            EnglishGrammaticalStructure.printListSorted("After removeExactDuplicates:", list);
        }
    }

    private static void printListSorted(String title, Collection<TypedDependency> list) {
        ArrayList<TypedDependency> lis = new ArrayList<TypedDependency>(list);
        Collections.sort(lis);
        if (title != null) {
            log.info(title);
        }
        log.info(lis);
    }

    @Override
    protected void postProcessDependencies(List<TypedDependency> list) {
        if (DEBUG) {
            EnglishGrammaticalStructure.printListSorted("At postProcessDependencies:", list);
        }
        SemanticGraph sg = new SemanticGraph(list);
        EnglishGrammaticalStructure.correctWHAttachment(sg);
        list.clear();
        list.addAll(sg.typedDependencies());
        if (DEBUG) {
            EnglishGrammaticalStructure.printListSorted("After correcting WH movement", list);
        }
        EnglishGrammaticalStructure.convertRel(list);
        if (DEBUG) {
            EnglishGrammaticalStructure.printListSorted("After converting rel:", list);
        }
    }

    @Override
    protected void getExtras(List<TypedDependency> list) {
        EnglishGrammaticalStructure.addRef(list);
        if (DEBUG) {
            EnglishGrammaticalStructure.printListSorted("After adding ref:", list);
        }
        EnglishGrammaticalStructure.addExtraNSubj(list);
        if (DEBUG) {
            EnglishGrammaticalStructure.printListSorted("After adding extra nsubj:", list);
        }
        EnglishGrammaticalStructure.addStrandedPobj(list);
        if (DEBUG) {
            EnglishGrammaticalStructure.printListSorted("After adding stranded pobj:", list);
        }
    }

    private static void addStrandedPobj(List<TypedDependency> list) {
        ArrayList<IndexedWord> depNodes = null;
        ArrayList<TypedDependency> newDeps = null;
        for (TypedDependency rcmod : list) {
            if (rcmod.reln() != EnglishGrammaticalRelations.RELATIVE_CLAUSE_MODIFIER) continue;
            IndexedWord head = rcmod.gov();
            if (depNodes == null) {
                depNodes = Generics.newArrayList();
            } else {
                depNodes.clear();
            }
            depNodes.add(rcmod.dep());
            for (TypedDependency connected : list) {
                if (!connected.gov().equals(rcmod.dep()) || connected.reln() != EnglishGrammaticalRelations.XCLAUSAL_COMPLEMENT && connected.reln() != EnglishGrammaticalRelations.CONJUNCT) continue;
                depNodes.add(connected.dep());
            }
            for (IndexedWord dep : depNodes) {
                for (TypedDependency prep : list) {
                    if (!prep.gov().equals(dep) || prep.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER) continue;
                    boolean found = false;
                    for (TypedDependency other : list) {
                        if (!other.gov().equals(prep.dep()) || other.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT && other.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    if (newDeps == null) {
                        newDeps = Generics.newArrayList();
                    }
                    TypedDependency newDep = new TypedDependency(EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT, prep.dep(), head);
                    newDeps.add(newDep);
                }
            }
        }
        if (newDeps != null) {
            list.addAll(newDeps);
        }
    }

    private static void correctWHAttachment(SemanticGraph sg) {
        if (sg.getRoots().isEmpty()) {
            return;
        }
        SemanticGraph sgCopy = sg.makeSoftCopy();
        SemgrexMatcher matcher = XCOMP_PATTERN.matcher(sgCopy);
        while (matcher.findNextMatchingNode()) {
            SemanticGraphEdge edge;
            IndexedWord root = matcher.getNode("root");
            IndexedWord embeddedVerb = matcher.getNode("embedded");
            IndexedWord wh = matcher.getNode("wh");
            IndexedWord dobj = matcher.getNode("obj");
            if (!wh.tag().startsWith("W")) continue;
            boolean reattach = false;
            if (dobj != null) {
                reattach = true;
            } else {
                String lemma = Morphology.lemmaStatic(root.value(), root.tag());
                if (lemma.matches("(?i:acquiesce|submit|bow|defer|accede|succumb|yield|capitulate|despise|disdain|dislike|regret|like|love|enjoy|fear|hate|pledge|proceed|begin|start|commence|recommence|resume|undertake|ally|collaborate|collude|conspire|discriminate|legislate|partner|protest|rebel|retaliate|scheme|sin|befriend|continue|broadcast|cable|e-mail|fax|modem|netmail|phone|radio|relay|satellite|semaphore|sign|signal|telecast|telegraph|telephone|telex|wire|wireless|ache|crave|fall|hanker|hope|hunger|itch|long|lust|pine|pray|thirst|wish|yearn|dangle|hanker|lust|thirst|yearn|babble|bark|bawl|bellow|bleat|blubber|boom|bray|burble|bluster|cackle|call|carol|chant|chatter|chirp|chortle|chuckle|cluck|coo|croak|croon|crow|cry|drawl|drone|gabble|gasp|gibber|groan|growl|grumble|grunt|hiss|holler|hoot|howl|jabber|keen|lilt|lisp|mewl|moan|mumble|murmur|mutter|nasal|natter|pant|prattle|purr|quaver|rage|rant|rasp|roar|rumble|scream|screech|shout|shriek|sibilate|simper|sigh|sing|smatter|smile|snap|snarl|snivel|snuffle|splutter|squall|squawk|squeak|squeal|stammer|stemmer|stutter|thunder|tisk|trill|trumpet|twang|twitter|vociferate|wail|warble|wheeze|whimper|whine|whisper|whistle|witter|whoop|yammer|yap|yell|yelp|yodel|blare|gurgle|hum|neglect|fail|forego|forgo|flub|overleap|manage|omit|seem|appear|prove|manage|fail|flub|try|attempt|intend|enjoy|expect|wish|hope|intend|mean|plan|propose|think|aim|dream|imagine|yen)")) {
                    reattach = true;
                }
            }
            if (!reattach || (edge = sg.getEdge(root, wh)) == null) continue;
            sg.removeEdge(edge);
            sg.addEdge(embeddedVerb, wh, EnglishGrammaticalRelations.DIRECT_OBJECT, Double.NEGATIVE_INFINITY, false);
        }
    }

    private static void convertRel(List<TypedDependency> list) {
        ArrayList<TypedDependency> newDeps = new ArrayList<TypedDependency>();
        for (TypedDependency rel : list) {
            if (rel.reln() != EnglishGrammaticalRelations.RELATIVE) continue;
            boolean foundPrep = false;
            for (TypedDependency prep : list) {
                if (prep.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER) continue;
                if (!prep.gov().equals(rel.gov())) {
                    boolean hasCompParent = false;
                    for (TypedDependency prep2 : list) {
                        if (prep2.reln() != EnglishGrammaticalRelations.XCLAUSAL_COMPLEMENT && prep2.reln() != EnglishGrammaticalRelations.ADJECTIVAL_COMPLEMENT && prep2.reln() != EnglishGrammaticalRelations.CLAUSAL_COMPLEMENT && prep2.reln() != GrammaticalRelation.ROOT || !prep.gov().equals(prep2.dep()) || !prep2.gov().equals(rel.gov())) continue;
                        hasCompParent = true;
                        break;
                    }
                    if (!hasCompParent) continue;
                }
                boolean foundPobj = false;
                for (TypedDependency pobj : list) {
                    if (pobj.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT && pobj.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT || !pobj.gov().equals(prep.dep())) continue;
                    foundPobj = true;
                    break;
                }
                if (foundPobj) continue;
                foundPrep = true;
                TypedDependency newDep = new TypedDependency(EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT, prep.dep(), rel.dep());
                newDeps.add(newDep);
                rel.setReln(GrammaticalRelation.KILL);
            }
            if (foundPrep) continue;
            rel.setReln(EnglishGrammaticalRelations.DIRECT_OBJECT);
        }
        EnglishGrammaticalStructure.filterKill(list);
        for (TypedDependency dep : newDeps) {
            if (list.contains(dep)) continue;
            list.add(dep);
        }
    }

    private static void filterKill(Collection<TypedDependency> deps) {
        ArrayList<TypedDependency> filtered = Generics.newArrayList();
        for (TypedDependency dep : deps) {
            if (dep.reln() == GrammaticalRelation.KILL) continue;
            filtered.add(dep);
        }
        deps.clear();
        deps.addAll(filtered);
    }

    @Override
    protected void collapseDependencies(List<TypedDependency> list, boolean CCprocess, GrammaticalStructure.Extras includeExtras) {
        if (DEBUG) {
            EnglishGrammaticalStructure.printListSorted("collapseDependencies: CCproc: " + CCprocess + " includeExtras: " + (Object)((Object)includeExtras), list);
        }
        this.correctDependencies(list);
        if (DEBUG) {
            EnglishGrammaticalStructure.printListSorted("After correctDependencies:", list);
        }
        EnglishGrammaticalStructure.eraseMultiConj(list);
        if (DEBUG) {
            EnglishGrammaticalStructure.printListSorted("After collapse multi conj:", list);
        }
        EnglishGrammaticalStructure.collapse2WP(list);
        if (DEBUG) {
            EnglishGrammaticalStructure.printListSorted("After collapse2WP:", list);
        }
        EnglishGrammaticalStructure.collapseFlatMWP(list);
        if (DEBUG) {
            EnglishGrammaticalStructure.printListSorted("After collapseFlatMWP:", list);
        }
        EnglishGrammaticalStructure.collapse2WPbis(list);
        if (DEBUG) {
            EnglishGrammaticalStructure.printListSorted("After collapse2WPbis:", list);
        }
        EnglishGrammaticalStructure.collapse3WP(list);
        if (DEBUG) {
            EnglishGrammaticalStructure.printListSorted("After collapse3WP:", list);
        }
        EnglishGrammaticalStructure.collapsePrepAndPoss(list);
        if (DEBUG) {
            EnglishGrammaticalStructure.printListSorted("After PrepAndPoss:", list);
        }
        EnglishGrammaticalStructure.collapseConj(list);
        if (DEBUG) {
            EnglishGrammaticalStructure.printListSorted("After conj:", list);
        }
        if (includeExtras.doRef) {
            EnglishGrammaticalStructure.addRef(list);
            if (DEBUG) {
                EnglishGrammaticalStructure.printListSorted("After adding ref:", list);
            }
            if (includeExtras.collapseRef) {
                EnglishGrammaticalStructure.collapseReferent(list);
                if (DEBUG) {
                    EnglishGrammaticalStructure.printListSorted("After collapse referent:", list);
                }
            }
        }
        if (CCprocess) {
            EnglishGrammaticalStructure.treatCC(list);
            if (DEBUG) {
                EnglishGrammaticalStructure.printListSorted("After treatCC:", list);
            }
        }
        if (includeExtras.doSubj) {
            EnglishGrammaticalStructure.addExtraNSubj(list);
            if (DEBUG) {
                EnglishGrammaticalStructure.printListSorted("After adding extra nsubj:", list);
            }
            EnglishGrammaticalStructure.correctSubjPass(list);
            if (DEBUG) {
                EnglishGrammaticalStructure.printListSorted("After correctSubjPass:", list);
            }
        }
        EnglishGrammaticalStructure.removeDep(list);
        if (DEBUG) {
            EnglishGrammaticalStructure.printListSorted("After remove dep:", list);
        }
        Collections.sort(list);
        if (DEBUG) {
            EnglishGrammaticalStructure.printListSorted("After all collapse:", list);
        }
    }

    @Override
    protected void collapseDependenciesTree(List<TypedDependency> list) {
        this.collapseDependencies(list, false, GrammaticalStructure.Extras.NONE);
    }

    private static GrammaticalRelation conjValue(String conj) {
        String newConj = conj.toLowerCase();
        if (newConj.equals("not") || newConj.equals("instead") || newConj.equals("rather")) {
            newConj = "negcc";
        } else if (newConj.equals("mention") || newConj.equals("to") || newConj.equals("also") || newConj.contains("well") || newConj.equals("&")) {
            newConj = "and";
        }
        return EnglishGrammaticalRelations.getConj(newConj);
    }

    private static void treatCC(Collection<TypedDependency> list) {
        Map map = Generics.newHashMap();
        Map<IndexedWord, TypedDependency> subjectMap = Generics.newHashMap();
        Set<IndexedWord> withPassiveAuxiliary = Generics.newHashSet();
        ArrayList<IndexedWord> rcmodHeads = Generics.newArrayList();
        ArrayList<IndexedWord> prepcDep = Generics.newArrayList();
        for (TypedDependency typedDep : list) {
            if (!map.containsKey(typedDep.dep())) {
                map.put(typedDep.dep(), new TreeSet());
            }
            ((Set)map.get(typedDep.dep())).add(typedDep);
            if (typedDep.reln().equals(EnglishGrammaticalRelations.AUX_PASSIVE_MODIFIER)) {
                withPassiveAuxiliary.add(typedDep.gov());
            }
            if (!(typedDep.reln().getParent() != EnglishGrammaticalRelations.NOMINAL_SUBJECT && typedDep.reln().getParent() != EnglishGrammaticalRelations.SUBJECT && typedDep.reln().getParent() != EnglishGrammaticalRelations.CLAUSAL_SUBJECT || subjectMap.containsKey(typedDep.gov()))) {
                subjectMap.put(typedDep.gov(), typedDep);
            }
            if (typedDep.reln() == EnglishGrammaticalRelations.RELATIVE_CLAUSE_MODIFIER) {
                rcmodHeads.add(typedDep.gov());
            }
            if (!typedDep.reln().toString().startsWith("prepc")) continue;
            prepcDep.add(typedDep.dep());
        }
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>(list);
        for (TypedDependency td : list) {
            if (!EnglishGrammaticalRelations.getConjs().contains(td.reln())) continue;
            IndexedWord gov = td.gov();
            IndexedWord dep = td.dep();
            Set gov_relations = (Set)map.get(gov);
            if (gov_relations != null) {
                for (TypedDependency td1 : gov_relations) {
                    GrammaticalRelation newRel;
                    IndexedWord newGov = td1.gov();
                    if (newGov.equals(dep) || (newRel = td1.reln()) == GrammaticalRelation.ROOT) continue;
                    if (rcmodHeads.contains(gov) && rcmodHeads.contains(dep)) {
                        if (newRel == EnglishGrammaticalRelations.DIRECT_OBJECT || newRel == EnglishGrammaticalRelations.NOMINAL_SUBJECT) continue;
                        if (DEBUG) {
                            log.info("Adding new " + newRel + " dependency from " + newGov + " to " + dep + " (subj/obj case)");
                        }
                        newTypedDeps.add(new TypedDependency(newRel, newGov, dep));
                        continue;
                    }
                    if (DEBUG) {
                        log.info("Adding new " + newRel + " dependency from " + newGov + " to " + dep);
                    }
                    newTypedDeps.add(new TypedDependency(newRel, newGov, dep));
                }
            }
            String tag = dep.tag();
            if (!subjectMap.containsKey(gov) || !tag.startsWith("VB") && !tag.startsWith("JJ") || subjectMap.containsKey(dep)) continue;
            TypedDependency tdsubj = (TypedDependency)subjectMap.get(gov);
            GrammaticalRelation relation = tdsubj.reln();
            if (relation == EnglishGrammaticalRelations.NOMINAL_PASSIVE_SUBJECT) {
                if (EnglishGrammaticalStructure.isDefinitelyActive(tag)) {
                    relation = EnglishGrammaticalRelations.NOMINAL_SUBJECT;
                }
            } else if (relation == EnglishGrammaticalRelations.CLAUSAL_PASSIVE_SUBJECT) {
                if (EnglishGrammaticalStructure.isDefinitelyActive(tag)) {
                    relation = EnglishGrammaticalRelations.CLAUSAL_SUBJECT;
                }
            } else if (relation == EnglishGrammaticalRelations.NOMINAL_SUBJECT) {
                if (withPassiveAuxiliary.contains(dep)) {
                    relation = EnglishGrammaticalRelations.NOMINAL_PASSIVE_SUBJECT;
                }
            } else if (relation == EnglishGrammaticalRelations.CLAUSAL_SUBJECT && withPassiveAuxiliary.contains(dep)) {
                relation = EnglishGrammaticalRelations.CLAUSAL_PASSIVE_SUBJECT;
            }
            if (DEBUG) {
                log.info("Adding new " + relation + " dependency from " + dep + " to " + tdsubj.dep() + " (subj propagation case)");
            }
            newTypedDeps.add(new TypedDependency(relation, dep, tdsubj.dep()));
        }
        list.clear();
        list.addAll(newTypedDeps);
    }

    private static boolean isDefinitelyActive(String tag) {
        return tag.equals("VB") || tag.equals("VBZ") || tag.equals("VBP") || tag.startsWith("JJ");
    }

    private static void collapseConj(Collection<TypedDependency> list) {
        ArrayList<IndexedWord> govs = Generics.newArrayList();
        for (TypedDependency td : list) {
            if (td.reln() != EnglishGrammaticalRelations.COORDINATION) continue;
            IndexedWord gov = td.gov();
            GrammaticalRelation conj = EnglishGrammaticalStructure.conjValue(td.dep().value());
            if (DEBUG) {
                log.info("Set conj to " + conj + " based on " + td);
            }
            boolean foundOne = false;
            for (TypedDependency td1 : list) {
                if (!td1.gov().equals(gov)) continue;
                if (td1.reln() == EnglishGrammaticalRelations.CONJUNCT) {
                    if (DEBUG) {
                        log.info("Changing " + td1 + " to have relation " + conj);
                    }
                    td1.setReln(conj);
                    foundOne = true;
                    continue;
                }
                if (td1.reln() != EnglishGrammaticalRelations.COORDINATION) continue;
                conj = EnglishGrammaticalStructure.conjValue(td1.dep().value());
                if (!DEBUG) continue;
                log.info("Set conj to " + conj + " based on " + td1);
            }
            if (!foundOne) continue;
            govs.add(gov);
        }
        list.removeIf(td2 -> td2.reln() == EnglishGrammaticalRelations.COORDINATION && govs.contains(td2.gov()));
    }

    private static void collapseReferent(Collection<TypedDependency> list) {
        ArrayList<TypedDependency> refs = new ArrayList<TypedDependency>();
        Iterator<TypedDependency> iter = list.iterator();
        while (iter.hasNext()) {
            TypedDependency td = iter.next();
            if (td.reln() != EnglishGrammaticalRelations.REFERENT) continue;
            refs.add(td);
            iter.remove();
        }
        for (TypedDependency ref : refs) {
            IndexedWord dep = ref.dep();
            IndexedWord ant = ref.gov();
            for (TypedDependency td : list) {
                if (!td.dep().equals(dep) || td.reln() == EnglishGrammaticalRelations.REFERENT || td.gov().equals(ant)) continue;
                if (DEBUG) {
                    log.info("referent: changing " + td);
                }
                td.setDep(ant);
                td.setExtra();
                if (!DEBUG) continue;
                log.info(" to " + td);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void addRef(Collection<TypedDependency> list) {
        ArrayList<void> newDeps = new ArrayList<void>();
        for (TypedDependency rcmod : list) {
            void var8_8;
            if (rcmod.reln() != EnglishGrammaticalRelations.RELATIVE_CLAUSE_MODIFIER) continue;
            IndexedWord head = rcmod.gov();
            IndexedWord modifier = rcmod.dep();
            TypedDependency leftChild = null;
            for (TypedDependency typedDependency : list) {
                if (!typedDependency.gov().equals(modifier) || !EnglishPatterns.RELATIVIZING_WORD_PATTERN.matcher(typedDependency.dep().value()).matches() || leftChild != null && typedDependency.dep().index() >= leftChild.dep().index()) continue;
                leftChild = typedDependency;
            }
            TypedDependency leftGrandchild = null;
            for (TypedDependency child3 : list) {
                if (!child3.gov().equals(modifier)) continue;
                for (TypedDependency grandchild : list) {
                    if (!grandchild.gov().equals(child3.dep()) || !EnglishPatterns.RELATIVIZING_WORD_PATTERN.matcher(grandchild.dep().value()).matches() || leftGrandchild != null && grandchild.dep().index() >= leftGrandchild.dep().index()) continue;
                    leftGrandchild = grandchild;
                }
            }
            Object var8_12 = null;
            if (leftGrandchild != null && (leftChild == null || leftGrandchild.dep().index() < leftChild.dep().index())) {
                TypedDependency typedDependency = new TypedDependency(EnglishGrammaticalRelations.REFERENT, head, leftGrandchild.dep());
            } else if (leftChild != null) {
                TypedDependency typedDependency = new TypedDependency(EnglishGrammaticalRelations.REFERENT, head, leftChild.dep());
            }
            if (var8_8 == null) continue;
            newDeps.add(var8_8);
        }
        for (TypedDependency newDep : newDeps) {
            if (list.contains(newDep)) continue;
            newDep.setExtra();
            list.add(newDep);
        }
    }

    private static void addExtraNSubj(Collection<TypedDependency> list) {
        ArrayList<TypedDependency> newDeps = new ArrayList<TypedDependency>();
        for (TypedDependency xcomp : list) {
            TypedDependency newDep;
            if (xcomp.reln() != EnglishGrammaticalRelations.XCLAUSAL_COMPLEMENT) continue;
            IndexedWord modifier = xcomp.dep();
            IndexedWord head = xcomp.gov();
            boolean hasSubjectDaughter = false;
            boolean hasAux = false;
            ArrayList<IndexedWord> subjects = Generics.newArrayList();
            ArrayList<IndexedWord> objects = Generics.newArrayList();
            for (TypedDependency dep : list) {
                if ((dep.reln() == EnglishGrammaticalRelations.NOMINAL_SUBJECT || dep.reln() == EnglishGrammaticalRelations.NOMINAL_PASSIVE_SUBJECT) && dep.gov().equals(modifier)) {
                    hasSubjectDaughter = true;
                    break;
                }
                if (dep.reln() == EnglishGrammaticalRelations.AUX_MODIFIER && dep.gov().equals(modifier)) {
                    hasAux = true;
                }
                if ((dep.reln() == EnglishGrammaticalRelations.NOMINAL_SUBJECT || dep.reln() == EnglishGrammaticalRelations.NOMINAL_PASSIVE_SUBJECT) && dep.gov().equals(head)) {
                    subjects.add(dep.dep());
                }
                if (dep.reln() != EnglishGrammaticalRelations.DIRECT_OBJECT || !dep.gov().equals(head)) continue;
                objects.add(dep.dep());
            }
            if (hasSubjectDaughter || modifier.value().equalsIgnoreCase("to") && hasAux || !modifier.value().equalsIgnoreCase("to") && !hasAux) continue;
            if (objects.size() > 0) {
                for (IndexedWord object : objects) {
                    newDep = new TypedDependency(EnglishGrammaticalRelations.NOMINAL_SUBJECT, modifier, object);
                    newDeps.add(newDep);
                }
                continue;
            }
            for (IndexedWord subject : subjects) {
                newDep = new TypedDependency(EnglishGrammaticalRelations.NOMINAL_SUBJECT, modifier, subject);
                newDeps.add(newDep);
            }
        }
        for (TypedDependency newDep : newDeps) {
            if (list.contains(newDep)) continue;
            newDep.setExtra();
            list.add(newDep);
        }
    }

    private static void correctSubjPass(Collection<TypedDependency> list) {
        ArrayList<IndexedWord> list_auxpass = new ArrayList<IndexedWord>();
        for (TypedDependency td : list) {
            if (td.reln() != EnglishGrammaticalRelations.AUX_PASSIVE_MODIFIER) continue;
            list_auxpass.add(td.gov());
        }
        for (TypedDependency td : list) {
            if (td.reln() == EnglishGrammaticalRelations.NOMINAL_SUBJECT && list_auxpass.contains(td.gov())) {
                td.setReln(EnglishGrammaticalRelations.NOMINAL_PASSIVE_SUBJECT);
            }
            if (td.reln() != EnglishGrammaticalRelations.CLAUSAL_SUBJECT || !list_auxpass.contains(td.gov())) continue;
            td.setReln(EnglishGrammaticalRelations.CLAUSAL_PASSIVE_SUBJECT);
        }
    }

    private static boolean inConjDeps(TypedDependency td, List<Triple<TypedDependency, TypedDependency, Boolean>> conjs) {
        for (Triple<TypedDependency, TypedDependency, Boolean> trip : conjs) {
            if (!td.equals(trip.first())) continue;
            return true;
        }
        return false;
    }

    private static void collapsePrepAndPoss(Collection<TypedDependency> list) {
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        Map map = Generics.newHashMap();
        ArrayList<IndexedWord> vmod = Generics.newArrayList();
        for (TypedDependency typedDep : list) {
            if (!map.containsKey(typedDep.gov())) {
                map.put(typedDep.gov(), new TreeSet());
            }
            ((SortedSet)map.get(typedDep.gov())).add(typedDep);
            if (typedDep.reln() != EnglishGrammaticalRelations.VERBAL_MODIFIER) continue;
            boolean foundAux = false;
            for (TypedDependency auxDep : list) {
                if (auxDep.reln() != EnglishGrammaticalRelations.AUX_MODIFIER || !auxDep.gov().equals(typedDep.dep()) || !auxDep.dep().value().equalsIgnoreCase("to")) continue;
                foundAux = true;
                break;
            }
            if (foundAux) continue;
            vmod.add(typedDep.dep());
        }
        for (TypedDependency td1 : list) {
            Object reln;
            Iterator td2Dep;
            TypedDependency prepOtherDep;
            Object td22;
            IndexedWord td1Dep;
            SortedSet possibles;
            if (td1.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER || (possibles = (SortedSet)map.get(td1Dep = td1.dep())) == null) continue;
            Pair<TypedDependency, Boolean> prepDep = null;
            TypedDependency ccDep = null;
            ArrayList conjs = new ArrayList();
            TreeSet<TypedDependency> otherDtrs = new TreeSet<TypedDependency>();
            boolean samePrepositionInEachConjunct = true;
            int conjIndex = -1;
            for (Object td22 : possibles) {
                IndexedWord td2Dep2;
                String td2DepPOS;
                if (((TypedDependency)td22).reln() != EnglishGrammaticalRelations.CONJUNCT || !(td2DepPOS = (td2Dep2 = ((TypedDependency)td22).dep()).tag()).equals("IN") && !td2DepPOS.equals("TO")) continue;
                samePrepositionInEachConjunct = samePrepositionInEachConjunct && td2Dep2.value().equals(td1Dep.value());
                Set possibles2 = (Set)map.get(td2Dep2);
                boolean pobj = true;
                prepOtherDep = null;
                if (possibles2 != null) {
                    for (TypedDependency td3 : possibles2) {
                        IndexedWord td3Dep = td3.dep();
                        String td3DepPOS = td3Dep.tag();
                        if (!(td3.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT && td3.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT || td3DepPOS.equals("IN") || td3DepPOS.equals("TO") || prepOtherDep != null)) {
                            prepOtherDep = td3;
                            if (td3.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT) continue;
                            pobj = false;
                            continue;
                        }
                        otherDtrs.add(td3);
                    }
                }
                if (conjIndex < td2Dep2.index()) {
                    conjIndex = td2Dep2.index();
                }
                conjs.add(new Triple<Object, Object, Boolean>(td22, prepOtherDep, pobj));
            }
            if (conjs.isEmpty()) continue;
            String td1DepPOS = td1Dep.tag();
            td22 = possibles.iterator();
            while (td22.hasNext()) {
                TypedDependency td23 = (TypedDependency)td22.next();
                if (td23.reln() == EnglishGrammaticalRelations.COORDINATION && td23.dep().index() < conjIndex) {
                    ccDep = td23;
                    continue;
                }
                td2Dep = td23.dep();
                String td2DepPOS = ((IndexedWord)((Object)td2Dep)).tag();
                if (!(td23.reln() != GrammaticalRelation.DEPENDENT && td23.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT && td23.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT || !td1DepPOS.equals("IN") && !td1DepPOS.equals("TO") && !td1DepPOS.equals("VBG") || prepDep != null || td2DepPOS.equals("RB") || td2DepPOS.equals("IN") || td2DepPOS.equals("TO"))) {
                    prepDep = new Pair<TypedDependency, Boolean>(td23, td23.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT);
                    continue;
                }
                if (EnglishGrammaticalStructure.inConjDeps(td23, conjs)) continue;
                otherDtrs.add(td23);
            }
            if (prepDep == null || ccDep == null) continue;
            if (DEBUG) {
                log.info("!! Conj and prep case:");
                log.info("  td1 (prep): " + td1);
                log.info("  Kids of td1 are: " + possibles);
                log.info("  prepDep: " + prepDep);
                log.info("  ccDep: " + ccDep);
                log.info("  conjs: " + conjs);
                log.info("  samePrepositionInEachConjunct: " + samePrepositionInEachConjunct);
                log.info("  otherDtrs: " + otherDtrs);
            }
            if (samePrepositionInEachConjunct) {
                reln = EnglishGrammaticalStructure.determinePrepRelation(map, vmod, td1, td1, (Boolean)prepDep.second());
                TypedDependency tdNew = new TypedDependency((GrammaticalRelation)reln, td1.gov(), ((TypedDependency)prepDep.first()).dep());
                newTypedDeps.add(tdNew);
                if (DEBUG) {
                    log.info("PrepPoss Conj branch (two parallel PPs) adding: " + tdNew);
                    log.info("  removing: " + td1 + "  " + prepDep + "  " + ccDep);
                }
                td1.setReln(GrammaticalRelation.KILL);
                ((TypedDependency)prepDep.first()).setReln(GrammaticalRelation.KILL);
                ccDep.setReln(GrammaticalRelation.KILL);
                td2Dep = conjs.iterator();
                while (td2Dep.hasNext()) {
                    Triple trip = (Triple)td2Dep.next();
                    TypedDependency conjDep = (TypedDependency)trip.first();
                    prepOtherDep = (TypedDependency)trip.second();
                    if (prepOtherDep == null) {
                        if (DEBUG) {
                            log.info("  apparent misparse: same P twice with only one NP object (prepOtherDep is null)");
                            log.info("  removing: " + conjDep);
                        }
                        ccDep.setReln(GrammaticalRelation.KILL);
                    } else {
                        TypedDependency tdNew2 = new TypedDependency(EnglishGrammaticalStructure.conjValue(ccDep.dep().value()), prepDep.first().dep(), prepOtherDep.dep());
                        newTypedDeps.add(tdNew2);
                        if (DEBUG) {
                            log.info("  adding: " + tdNew2);
                            log.info("  removing: " + conjDep + "  " + prepOtherDep);
                        }
                        prepOtherDep.setReln(GrammaticalRelation.KILL);
                    }
                    conjDep.setReln(GrammaticalRelation.KILL);
                }
                for (TypedDependency otd : otherDtrs) {
                    if (DEBUG) {
                        log.info("Changed " + otd);
                    }
                    otd.setGov(td1.gov());
                    if (!DEBUG) continue;
                    log.info(" to " + otd);
                }
                if (DEBUG) {
                    log.info("td1: " + td1 + "; possibles: " + possibles);
                }
                for (TypedDependency td24 : possibles) {
                    if (td24.reln() == GrammaticalRelation.KILL || !td24.gov().equals(td1.dep())) continue;
                    if (DEBUG) {
                        log.info("Changing " + td24 + " to have governor of " + td1 + " [a]");
                    }
                    td24.setGov(td1.gov());
                }
                continue;
            }
            reln = conjs.iterator();
            while (reln.hasNext()) {
                Triple trip = (Triple)reln.next();
                if (trip.first() == null || trip.second() != null) continue;
                trip.setSecond(new TypedDependency(((TypedDependency)prepDep.first()).reln(), ((TypedDependency)trip.first()).dep(), ((TypedDependency)prepDep.first()).dep()));
                trip.setThird((Boolean)prepDep.second());
            }
            IndexedWord conjHead = td1.gov();
            for (TypedDependency td3 : list) {
                if (!td3.dep().equals(td1.gov()) || !td3.reln().equals(EnglishGrammaticalRelations.CONJUNCT)) continue;
                conjHead = td3.gov();
            }
            GrammaticalRelation reln2 = EnglishGrammaticalStructure.determinePrepRelation(map, vmod, td1, td1, (Boolean)prepDep.second());
            TypedDependency tdNew = new TypedDependency(reln2, td1.gov(), ((TypedDependency)prepDep.first()).dep());
            newTypedDeps.add(tdNew);
            if (DEBUG) {
                log.info("ConjPP (different preps) adding: " + tdNew);
                log.info("  deleting: " + td1 + "  " + prepDep.first() + "  " + ccDep);
            }
            td1.setReln(GrammaticalRelation.KILL);
            prepDep.first().setReln(GrammaticalRelation.KILL);
            ccDep.setReln(GrammaticalRelation.KILL);
            int copyNumber = 1;
            Iterator iterator = conjs.iterator();
            while (iterator.hasNext()) {
                Triple trip = (Triple)iterator.next();
                TypedDependency conjDep = (TypedDependency)trip.first();
                TypedDependency prepOtherDep2 = (TypedDependency)trip.second();
                boolean pobj = (Boolean)trip.third();
                IndexedWord label = td1.gov().makeSoftCopy(copyNumber);
                ++copyNumber;
                TypedDependency tdNew2 = new TypedDependency(EnglishGrammaticalStructure.conjValue(ccDep.dep().value()), td1.gov(), label);
                newTypedDeps.add(tdNew2);
                GrammaticalRelation reln22 = EnglishGrammaticalStructure.determinePrepRelation(map, vmod, conjDep, td1, pobj);
                TypedDependency tdNew3 = new TypedDependency(reln22, label, prepOtherDep2.dep());
                newTypedDeps.add(tdNew3);
                if (DEBUG) {
                    log.info("  adding: " + tdNew2 + "  " + tdNew3);
                    log.info("  deleting: " + conjDep + "  " + prepOtherDep2);
                }
                conjDep.setReln(GrammaticalRelation.KILL);
                prepOtherDep2.setReln(GrammaticalRelation.KILL);
                for (TypedDependency otd : otherDtrs) {
                    if (otd.dep().tag().equals("IN")) {
                        otd.setReln(EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER);
                    }
                    otd.setGov(td1.gov());
                }
            }
            for (TypedDependency td25 : possibles) {
                if (td25.reln() == GrammaticalRelation.KILL) continue;
                if (DEBUG) {
                    log.info("Changing " + td25 + " to have governor of " + td1 + " [b]");
                }
                td25.setGov(td1.gov());
            }
        }
        for (TypedDependency td1 : list) {
            if (td1.reln() == GrammaticalRelation.KILL) continue;
            IndexedWord td1Dep = td1.dep();
            String td1DepPOS = td1Dep.tag();
            Set possibles = (Set)map.get(td1Dep);
            if (possibles != null && (td1.reln() == EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER || td1.reln() == EnglishGrammaticalRelations.POSSESSION_MODIFIER || td1.reln() == EnglishGrammaticalRelations.CONJUNCT)) {
                boolean pobj = true;
                for (TypedDependency td2 : possibles) {
                    if (td2.reln() == EnglishGrammaticalRelations.COORDINATION || td2.reln() == EnglishGrammaticalRelations.CONJUNCT) continue;
                    IndexedWord td2Dep = td2.dep();
                    String td2DepPOS = td2Dep.tag();
                    if (td1.reln() == EnglishGrammaticalRelations.POSSESSION_MODIFIER || td1.reln() == EnglishGrammaticalRelations.CONJUNCT) {
                        if (td2.reln() != EnglishGrammaticalRelations.POSSESSIVE_MODIFIER || map.containsKey(td2Dep)) continue;
                        td2.setReln(GrammaticalRelation.KILL);
                        continue;
                    }
                    if (td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT && td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT || !td1DepPOS.equals("IN") && !td1DepPOS.equals("TO") && !td1DepPOS.equals("VBG") || td2DepPOS.equals("RB") || td2DepPOS.equals("IN") || td2DepPOS.equals("TO") || EnglishGrammaticalStructure.isConjWithNoPrep(td2.gov(), possibles)) continue;
                    if (DEBUG) {
                        log.info("(Single prep/poss base case collapsing " + td1 + " and " + td2);
                    }
                    if (td2.reln() == EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT) {
                        pobj = false;
                    }
                    GrammaticalRelation reln = EnglishGrammaticalStructure.determinePrepRelation(map, vmod, td1, td1, pobj);
                    TypedDependency td3 = new TypedDependency(reln, td1.gov(), td2.dep());
                    if (DEBUG) {
                        log.info("PP adding: " + td3 + " deleting: " + td1 + ' ' + td2);
                    }
                    ((SortedSet)map.get(td3.gov())).add(td3);
                    newTypedDeps.add(td3);
                    td1.setReln(GrammaticalRelation.KILL);
                    td2.setReln(GrammaticalRelation.KILL);
                }
            }
            if (possibles == null || td1.reln() != GrammaticalRelation.KILL) continue;
            for (TypedDependency td2 : possibles) {
                if (td2.reln() == GrammaticalRelation.KILL) continue;
                if (DEBUG) {
                    log.info("Changing " + td2 + " to have governor of " + td1 + " [c]");
                }
                td2.setGov(td1.gov());
            }
        }
        Iterator<TypedDependency> iter = list.iterator();
        while (iter.hasNext()) {
            TypedDependency td = iter.next();
            if (td.reln() != GrammaticalRelation.KILL) continue;
            if (DEBUG) {
                log.info("Removing dep killed in poss/prep (conj) collapse: " + td);
            }
            iter.remove();
        }
        list.addAll(newTypedDeps);
    }

    private static GrammaticalRelation determinePrepRelation(Map<IndexedWord, ? extends Set<TypedDependency>> map, List<IndexedWord> vmod, TypedDependency pc, TypedDependency topPrep, boolean pobj) {
        boolean agent = false;
        String preposition = pc.dep().value().toLowerCase();
        if (preposition.equals("by")) {
            Set<TypedDependency> aux_pass_poss = map.get(topPrep.gov());
            if (aux_pass_poss != null) {
                for (TypedDependency td_pass : aux_pass_poss) {
                    if (td_pass.reln() != EnglishGrammaticalRelations.AUX_PASSIVE_MODIFIER) continue;
                    agent = true;
                }
            }
            if (!vmod.isEmpty() && vmod.contains(topPrep.gov())) {
                agent = true;
            }
        }
        GrammaticalRelation reln = agent ? EnglishGrammaticalRelations.AGENT : (pobj ? EnglishGrammaticalRelations.getPrep(preposition) : EnglishGrammaticalRelations.getPrepC(preposition));
        return reln;
    }

    private static boolean isConjWithNoPrep(IndexedWord node, Collection<TypedDependency> list) {
        for (TypedDependency td : list) {
            String tdDepPOS;
            if (!td.gov().equals(node) || td.reln() != EnglishGrammaticalRelations.CONJUNCT || (tdDepPOS = td.dep().tag()).equals("IN") || tdDepPOS.equals("TO")) continue;
            return true;
        }
        return false;
    }

    private static void collapse2WP(Collection<TypedDependency> list) {
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        for (String[] mwp : MULTIWORD_PREPS) {
            EnglishGrammaticalStructure.collapseMultiWordPrep(list, newTypedDeps, mwp[0], mwp[1], mwp[0], mwp[1]);
            EnglishGrammaticalStructure.collapseMultiWordPrep(list, newTypedDeps, mwp[0], mwp[1], mwp[1], mwp[0]);
        }
    }

    private static void collapseMultiWordPrep(Collection<TypedDependency> list, Collection<TypedDependency> newTypedDeps, String str_mwp0, String str_mwp1, String w_mwp0, String w_mwp1) {
        IndexedWord mwp0 = null;
        IndexedWord mwp1 = null;
        TypedDependency dep = null;
        for (TypedDependency td : list) {
            if (!td.gov().value().equalsIgnoreCase(w_mwp0) || !td.dep().value().equalsIgnoreCase(w_mwp1) || Math.abs(td.gov().index() - td.dep().index()) != 1) continue;
            mwp0 = td.gov();
            mwp1 = td.dep();
            dep = td;
        }
        if (mwp0 == null) {
            return;
        }
        IndexedWord governor = null;
        TypedDependency prep = null;
        for (TypedDependency td1 : list) {
            if (td1.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER && td1.reln() != EnglishGrammaticalRelations.ADVERBIAL_MODIFIER && td1.reln() != EnglishGrammaticalRelations.ADJECTIVAL_MODIFIER && td1.reln() != GrammaticalRelation.DEPENDENT && td1.reln() != EnglishGrammaticalRelations.MULTI_WORD_EXPRESSION || !td1.dep().equals(mwp0)) continue;
            prep = td1;
            governor = prep.gov();
        }
        if (prep == null) {
            return;
        }
        TypedDependency pobj = null;
        TypedDependency newtd = null;
        for (TypedDependency td2 : list) {
            if (td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT && td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT || !td2.gov().equals(mwp1) && !td2.gov().equals(mwp0) || pobj != null && pobj.dep().index() <= td2.dep().index()) continue;
            pobj = td2;
            GrammaticalRelation gr = td2.reln() == EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT ? EnglishGrammaticalRelations.getPrepC(str_mwp0 + '_' + str_mwp1) : EnglishGrammaticalRelations.getPrep(str_mwp0 + '_' + str_mwp1);
            if (governor == null) continue;
            newtd = new TypedDependency(gr, governor, pobj.dep());
        }
        if (pobj == null || newtd == null) {
            return;
        }
        if (DEBUG) {
            log.info("Removing " + prep + ", " + dep + ", and " + pobj);
            log.info("  and adding " + newtd);
        }
        prep.setReln(GrammaticalRelation.KILL);
        dep.setReln(GrammaticalRelation.KILL);
        pobj.setReln(GrammaticalRelation.KILL);
        newTypedDeps.add(newtd);
        for (TypedDependency td1 : list) {
            if (td1.reln() == GrammaticalRelation.KILL) continue;
            if (td1.gov().equals(mwp0) || td1.gov().equals(mwp1)) {
                if (td1.reln() == EnglishGrammaticalRelations.TEMPORAL_MODIFIER) {
                    td1.setGov(pobj.dep());
                } else {
                    td1.setGov(governor);
                }
            }
            if (newTypedDeps.contains(td1)) continue;
            newTypedDeps.add(td1);
        }
        list.clear();
        list.addAll(newTypedDeps);
    }

    private static void collapse2WPbis(Collection<TypedDependency> list) {
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        for (String[] mwp : MULTIWORD_PREPS) {
            newTypedDeps.clear();
            IndexedWord mwp0 = null;
            IndexedWord mwp1 = null;
            IndexedWord governor = null;
            TypedDependency prep = null;
            TypedDependency dep = null;
            TypedDependency pobj = null;
            TypedDependency newtd = null;
            for (TypedDependency td : list) {
                if (!td.dep().value().equalsIgnoreCase(mwp[0]) || td.reln() != EnglishGrammaticalRelations.PHRASAL_VERB_PARTICLE && td.reln() != EnglishGrammaticalRelations.ADVERBIAL_MODIFIER && td.reln() != GrammaticalRelation.DEPENDENT && td.reln() != EnglishGrammaticalRelations.MULTI_WORD_EXPRESSION) continue;
                governor = td.gov();
                mwp0 = td.dep();
                dep = td;
            }
            if (mwp0 == null || governor == null) continue;
            for (TypedDependency td1 : list) {
                if (td1.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER || !td1.dep().value().equalsIgnoreCase(mwp[1]) || Math.abs(td1.dep().index() - mwp0.index()) != 1 || !td1.gov().equals(governor)) continue;
                mwp1 = td1.dep();
                prep = td1;
            }
            if (mwp1 == null) continue;
            for (TypedDependency td2 : list) {
                GrammaticalRelation gr;
                if (td2.reln() == EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT && td2.gov().equals(mwp1)) {
                    pobj = td2;
                    gr = EnglishGrammaticalRelations.getPrep(mwp[0] + '_' + mwp[1]);
                    newtd = new TypedDependency(gr, governor, pobj.dep());
                }
                if (td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT || !td2.gov().equals(mwp1)) continue;
                pobj = td2;
                gr = EnglishGrammaticalRelations.getPrepC(mwp[0] + '_' + mwp[1]);
                newtd = new TypedDependency(gr, governor, pobj.dep());
            }
            if (pobj == null) {
                return;
            }
            prep.setReln(GrammaticalRelation.KILL);
            dep.setReln(GrammaticalRelation.KILL);
            pobj.setReln(GrammaticalRelation.KILL);
            newTypedDeps.add(newtd);
            for (TypedDependency td1 : list) {
                if (td1.reln() == GrammaticalRelation.KILL) continue;
                if (td1.gov().equals(mwp0) || td1.gov().equals(mwp1)) {
                    td1.setGov(governor);
                }
                if (newTypedDeps.contains(td1)) continue;
                newTypedDeps.add(td1);
            }
            list.clear();
            list.addAll(newTypedDeps);
        }
    }

    private static void collapse3WP(Collection<TypedDependency> list) {
        GrammaticalRelation gr;
        TypedDependency newtd;
        Object pobj;
        TypedDependency prep;
        Object governor;
        TypedDependency dep2;
        TypedDependency dep1;
        IndexedWord mwp2;
        IndexedWord mwp1;
        IndexedWord mwp0;
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        for (String[] mwp : THREEWORD_PREPS) {
            newTypedDeps.clear();
            mwp0 = null;
            mwp1 = null;
            mwp2 = null;
            dep1 = null;
            dep2 = null;
            for (TypedDependency td : list) {
                if (!td.gov().value().equalsIgnoreCase(mwp[0]) || !td.dep().value().equalsIgnoreCase(mwp[1]) || Math.abs(td.gov().index() - td.dep().index()) != 1) continue;
                mwp0 = td.gov();
                mwp1 = td.dep();
                dep1 = td;
            }
            for (TypedDependency td : list) {
                if (!td.gov().equals(mwp1) || !td.dep().value().equalsIgnoreCase(mwp[2]) || Math.abs(td.gov().index() - td.dep().index()) != 1) continue;
                mwp2 = td.dep();
                dep2 = td;
            }
            if (dep1 == null || dep2 == null) continue;
            governor = null;
            prep = null;
            for (TypedDependency td1 : list) {
                if (td1.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER || !td1.dep().equals(mwp0)) continue;
                prep = td1;
                governor = prep.gov();
            }
            pobj = null;
            newtd = null;
            for (TypedDependency td2 : list) {
                if (td2.reln() == EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT && td2.gov().equals(mwp2)) {
                    pobj = td2;
                    gr = EnglishGrammaticalRelations.getPrep(mwp[0] + '_' + mwp[1] + '_' + mwp[2]);
                    if (governor != null) {
                        newtd = new TypedDependency(gr, (IndexedWord)governor, ((TypedDependency)pobj).dep());
                    }
                }
                if (td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT || !td2.gov().equals(mwp2)) continue;
                pobj = td2;
                gr = EnglishGrammaticalRelations.getPrepC(mwp[0] + '_' + mwp[1] + '_' + mwp[2]);
                if (governor == null) continue;
                newtd = new TypedDependency(gr, (IndexedWord)governor, ((TypedDependency)pobj).dep());
            }
            if (prep == null || pobj == null || newtd == null) continue;
            prep.setReln(GrammaticalRelation.KILL);
            dep1.setReln(GrammaticalRelation.KILL);
            dep2.setReln(GrammaticalRelation.KILL);
            ((TypedDependency)pobj).setReln(GrammaticalRelation.KILL);
            newTypedDeps.add(newtd);
            for (TypedDependency td1 : list) {
                if (td1.reln() == GrammaticalRelation.KILL) continue;
                if (td1.gov().equals(mwp0) || td1.gov().equals(mwp1) || td1.gov().equals(mwp2)) {
                    td1.setGov((IndexedWord)governor);
                }
                if (newTypedDeps.contains(td1)) continue;
                newTypedDeps.add(td1);
            }
            list.clear();
            list.addAll(newTypedDeps);
        }
        for (String[] mwp : THREEWORD_PREPS) {
            newTypedDeps.clear();
            mwp0 = null;
            mwp1 = null;
            mwp2 = null;
            dep1 = null;
            dep2 = null;
            for (TypedDependency td : list) {
                if (!td.gov().value().equalsIgnoreCase(mwp[0]) || !td.dep().value().equalsIgnoreCase(mwp[1]) || Math.abs(td.gov().index() - td.dep().index()) != 1) continue;
                mwp0 = td.gov();
                mwp1 = td.dep();
                dep1 = td;
            }
            for (TypedDependency td : list) {
                if (!td.gov().equals(mwp0) || !td.dep().value().equalsIgnoreCase(mwp[2]) || Math.abs(td.gov().index() - td.dep().index()) != 2) continue;
                mwp2 = td.dep();
                dep2 = td;
            }
            if (dep1 == null || dep2 == null) continue;
            governor = null;
            prep = null;
            for (TypedDependency td1 : list) {
                if (!td1.dep().equals(mwp0) || td1.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER) continue;
                prep = td1;
                governor = prep.gov();
            }
            pobj = null;
            newtd = null;
            for (TypedDependency td2 : list) {
                if (td2.gov().equals(mwp0) && td2.reln() == EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT) {
                    pobj = td2;
                    gr = EnglishGrammaticalRelations.getPrep(mwp[0] + '_' + mwp[1] + '_' + mwp[2]);
                    if (governor != null) {
                        newtd = new TypedDependency(gr, (IndexedWord)governor, ((TypedDependency)pobj).dep());
                    }
                }
                if (!td2.gov().equals(mwp0) || td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT) continue;
                pobj = td2;
                gr = EnglishGrammaticalRelations.getPrepC(mwp[0] + '_' + mwp[1] + '_' + mwp[2]);
                if (governor == null) continue;
                newtd = new TypedDependency(gr, (IndexedWord)governor, ((TypedDependency)pobj).dep());
            }
            if (prep == null || pobj == null || newtd == null) continue;
            prep.setReln(GrammaticalRelation.KILL);
            dep1.setReln(GrammaticalRelation.KILL);
            dep2.setReln(GrammaticalRelation.KILL);
            ((TypedDependency)pobj).setReln(GrammaticalRelation.KILL);
            newTypedDeps.add(newtd);
            for (TypedDependency td1 : list) {
                if (td1.reln() == GrammaticalRelation.KILL) continue;
                if (td1.gov().equals(mwp0) || td1.gov().equals(mwp1) || td1.gov().equals(mwp2)) {
                    td1.setGov((IndexedWord)governor);
                }
                if (newTypedDeps.contains(td1)) continue;
                newTypedDeps.add(td1);
            }
            list.clear();
            list.addAll(newTypedDeps);
        }
    }

    private static void collapseFlatMWP(Collection<TypedDependency> list) {
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        for (String[] mwp : MULTIWORD_PREPS) {
            newTypedDeps.clear();
            IndexedWord mwp1 = null;
            IndexedWord governor = null;
            TypedDependency prep = null;
            TypedDependency dep = null;
            TypedDependency pobj = null;
            for (TypedDependency td : list) {
                if (Math.abs(td.gov().index() - td.dep().index()) != 1 || !td.gov().value().equalsIgnoreCase(mwp[1]) || !td.dep().value().equalsIgnoreCase(mwp[0])) continue;
                mwp1 = td.gov();
                dep = td;
            }
            if (mwp1 == null) continue;
            for (TypedDependency td1 : list) {
                if (!td1.dep().equals(mwp1) || td1.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER) continue;
                prep = td1;
                governor = prep.gov();
            }
            if (prep == null) continue;
            for (TypedDependency td2 : list) {
                GrammaticalRelation gr;
                if (td2.gov().equals(mwp1) && td2.reln() == EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT) {
                    pobj = td2;
                    gr = EnglishGrammaticalRelations.getPrep(mwp[0] + '_' + mwp[1]);
                    newTypedDeps.add(new TypedDependency(gr, governor, pobj.dep()));
                }
                if (!td2.gov().equals(mwp1) || td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT) continue;
                pobj = td2;
                gr = EnglishGrammaticalRelations.getPrepC(mwp[0] + '_' + mwp[1]);
                newTypedDeps.add(new TypedDependency(gr, governor, pobj.dep()));
            }
            if (pobj == null) {
                return;
            }
            prep.setReln(GrammaticalRelation.KILL);
            dep.setReln(GrammaticalRelation.KILL);
            pobj.setReln(GrammaticalRelation.KILL);
            for (TypedDependency td1 : list) {
                if (td1.reln() == GrammaticalRelation.KILL) continue;
                if (td1.gov().equals(mwp1)) {
                    td1.setGov(governor);
                }
                if (newTypedDeps.contains(td1)) continue;
                newTypedDeps.add(td1);
            }
            list.clear();
            list.addAll(newTypedDeps);
        }
    }

    private static void eraseMultiConj(Collection<TypedDependency> list) {
        for (TypedDependency td1 : list) {
            if (td1.reln() != EnglishGrammaticalRelations.COORDINATION) continue;
            IndexedWord x = td1.dep();
            for (TypedDependency td2 : list) {
                if (!td2.gov().equals(x) || td2.reln() != GrammaticalRelation.DEPENDENT && td2.reln() != EnglishGrammaticalRelations.MULTI_WORD_EXPRESSION && td2.reln() != EnglishGrammaticalRelations.COORDINATION && td2.reln() != EnglishGrammaticalRelations.ADVERBIAL_MODIFIER && td2.reln() != EnglishGrammaticalRelations.NEGATION_MODIFIER && td2.reln() != EnglishGrammaticalRelations.AUX_MODIFIER) continue;
                td2.setReln(GrammaticalRelation.KILL);
            }
        }
        EnglishGrammaticalStructure.filterKill(list);
    }

    private static void removeDep(Collection<TypedDependency> list) {
        Set<GrammaticalRelation> prepRels = Generics.newHashSet(EnglishGrammaticalRelations.getPreps());
        prepRels.addAll(EnglishGrammaticalRelations.getPrepsC());
        for (TypedDependency td1 : list) {
            if (!prepRels.contains(td1.reln())) continue;
            IndexedWord gov = td1.gov();
            IndexedWord dep = td1.dep();
            for (TypedDependency td2 : list) {
                if (td2.reln() != GrammaticalRelation.DEPENDENT || !td2.gov().equals(gov) || !td2.dep().equals(dep)) continue;
                td2.setReln(GrammaticalRelation.KILL);
            }
        }
        Iterator<TypedDependency> iter = list.iterator();
        while (iter.hasNext()) {
            TypedDependency td = iter.next();
            if (td.reln() != GrammaticalRelation.KILL) continue;
            if (DEBUG) {
                log.info("Removing duplicate relation: " + td);
            }
            iter.remove();
        }
    }

    private static void removeExactDuplicates(Collection<TypedDependency> list) {
        TreeSet<TypedDependency> set = new TreeSet<TypedDependency>(list);
        list.clear();
        list.addAll(set);
    }

    public static List<GrammaticalStructure> readCoNLLXGrammaticalStructureCollection(String fileName) throws IOException {
        return EnglishGrammaticalStructure.readCoNLLXGrammaticalStructureCollection(fileName, EnglishGrammaticalRelations.shortNameToGRel, new FromDependenciesFactory());
    }

    public static EnglishGrammaticalStructure buildCoNLLXGrammaticalStructure(List<List<String>> tokenFields) {
        return (EnglishGrammaticalStructure)EnglishGrammaticalStructure.buildCoNLLXGrammaticalStructure(tokenFields, EnglishGrammaticalRelations.shortNameToGRel, new FromDependenciesFactory());
    }

    public static void main(String[] args) {
        GrammaticalStructureConversionUtils.convertTrees(args, "en-sd");
    }

    public static class FromDependenciesFactory
    implements GrammaticalStructureFromDependenciesFactory {
        @Override
        public EnglishGrammaticalStructure build(List<TypedDependency> tdeps, TreeGraphNode root) {
            return new EnglishGrammaticalStructure(tdeps, root);
        }
    }

    private static class ExtraTreeDepFilter
    implements Predicate<TypedDependency>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private ExtraTreeDepFilter() {
        }

        @Override
        public boolean test(TypedDependency d) {
            return d != null && d.reln() != EnglishGrammaticalRelations.RELATIVE;
        }
    }
}

