/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.hebrew;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.international.hebrew.HebrewTreeReaderFactory;
import edu.stanford.nlp.trees.international.hebrew.HebrewTreebankLanguagePack;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class SplitMaker {
    private static Redwood.RedwoodChannels log = Redwood.channels(SplitMaker.class);

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.printf("Usage: java %s tree_file%n", SplitMaker.class.getName());
            System.exit(-1);
        }
        HebrewTreebankLanguagePack tlp = new HebrewTreebankLanguagePack();
        String inputFile = args[0];
        File treeFile = new File(inputFile);
        try {
            Tree t;
            HebrewTreeReaderFactory trf = new HebrewTreeReaderFactory();
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(treeFile), tlp.getEncoding()));
            TreeReader tr = trf.newTreeReader(br);
            PrintWriter pwDev = new PrintWriter(new PrintStream((OutputStream)new FileOutputStream(inputFile + ".clean.dev"), false, tlp.getEncoding()));
            PrintWriter pwTrain = new PrintWriter(new PrintStream((OutputStream)new FileOutputStream(inputFile + ".clean.train"), false, tlp.getEncoding()));
            PrintWriter pwTest = new PrintWriter(new PrintStream((OutputStream)new FileOutputStream(inputFile + ".clean.test"), false, tlp.getEncoding()));
            int numTrees = 0;
            while ((t = tr.readTree()) != null) {
                if (numTrees < 483) {
                    pwDev.println(t.toString());
                } else if (numTrees >= 483 && numTrees < 5724) {
                    pwTrain.println(t.toString());
                } else {
                    pwTest.println(t.toString());
                }
                ++numTrees;
            }
            tr.close();
            pwDev.close();
            pwTrain.close();
            pwTest.close();
            System.err.printf("Processed %d trees.%n", numTrees);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

