/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Interner;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class FileBackedCache<KEY extends Serializable, T>
implements Map<KEY, T>,
Iterable<Map.Entry<KEY, T>> {
    public final File cacheDir;
    public final int maxFiles;
    private final Map<KEY, SoftReference<T>> mapping = new ConcurrentHashMap<KEY, SoftReference<T>>();
    private final ReferenceQueue<T> reaper = new ReferenceQueue();
    private static final Interner<File> canonicalFile = new Interner();
    private static final IdentityHashMap<File, FileSemaphore> fileLocks = Generics.newIdentityHashMap();

    public FileBackedCache(File directoryToCacheIn) {
        this(directoryToCacheIn, -1);
    }

    public FileBackedCache(File directoryToCacheIn, int maxFiles) {
        if (!directoryToCacheIn.exists() && !directoryToCacheIn.mkdirs()) {
            throw new IllegalArgumentException("Could not create cache directory: " + directoryToCacheIn);
        }
        if (!directoryToCacheIn.isDirectory()) {
            throw new IllegalArgumentException("Cache directory must be a directory: " + directoryToCacheIn);
        }
        if (!directoryToCacheIn.canRead()) {
            throw new IllegalArgumentException("Cannot read cache directory: " + directoryToCacheIn);
        }
        this.cacheDir = directoryToCacheIn;
        this.maxFiles = maxFiles;
        Thread mappingCleaner = new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        if (FileBackedCache.this.reaper.poll() != null) {
                            while (FileBackedCache.this.reaper.poll() != null) {
                            }
                            LinkedList<Serializable> toRemove = Generics.newLinkedList();
                            try {
                                for (Map.Entry entry : FileBackedCache.this.mapping.entrySet()) {
                                    if (((SoftReference)entry.getValue()).get() != null) continue;
                                    toRemove.add((Serializable)entry.getKey());
                                }
                            }
                            catch (ConcurrentModificationException concurrentModificationException) {
                                // empty catch block
                            }
                            for (Serializable serializable : toRemove) {
                                FileBackedCache.this.mapping.remove(serializable);
                            }
                        }
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeInterruptedException(e);
                }
            }
        };
        mappingCleaner.setDaemon(true);
        mappingCleaner.start();
    }

    public FileBackedCache(File directoryToCacheIn, Map<KEY, T> initialMapping) {
        this(directoryToCacheIn, -1);
        this.putAll(initialMapping);
    }

    public FileBackedCache(File directoryToCacheIn, Map<KEY, T> initialMapping, int maxFiles) {
        this(directoryToCacheIn, maxFiles);
        this.putAll(initialMapping);
    }

    public FileBackedCache(String directoryToCacheIn) {
        this(new File(directoryToCacheIn), -1);
    }

    public FileBackedCache(String directoryToCacheIn, int maxFiles) {
        this(new File(directoryToCacheIn), maxFiles);
    }

    public FileBackedCache(String directoryToCacheIn, Map<KEY, T> initialMapping) {
        this(new File(directoryToCacheIn), initialMapping);
    }

    public FileBackedCache(String directoryToCacheIn, Map<KEY, T> initialMapping, int maxFiles) {
        this(new File(directoryToCacheIn), initialMapping, maxFiles);
    }

    @Override
    public int size() {
        return this.readCache();
    }

    public int sizeInMemory() {
        return this.mapping.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.mapping.containsKey(key)) {
            return true;
        }
        if (!this.tryFile(key)) {
            return false;
        }
        Collection<Pair<KEY, T>> elementsRead = this.readBlock(key);
        for (Pair<KEY, T> pair : elementsRead) {
            if (!((Serializable)pair.first).equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.mapping.containsValue(new SoftReference<Object>(value))) {
            return true;
        }
        return this.values().contains(value);
    }

    @Override
    public T get(Object key) {
        T referenceOrNull;
        SoftReference<T> likelyReferenceOrNull = this.mapping.get(key);
        T t = referenceOrNull = likelyReferenceOrNull == null ? null : (T)likelyReferenceOrNull.get();
        if (likelyReferenceOrNull == null) {
            if (!this.tryFile(key)) {
                return null;
            }
            Collection<Pair<KEY, T>> elemsRead = this.readBlock(key);
            for (Pair<KEY, T> pair : elemsRead) {
                if (!((Serializable)pair.first).equals(key)) continue;
                return (T)pair.second;
            }
            return null;
        }
        if (referenceOrNull == null) {
            this.mapping.remove(key);
            return this.get(key);
        }
        if (referenceOrNull instanceof Collection) {
            return (T)Collections.unmodifiableCollection((Collection)referenceOrNull);
        }
        if (referenceOrNull instanceof Map) {
            return (T)Collections.unmodifiableMap((Map)referenceOrNull);
        }
        return referenceOrNull;
    }

    @Override
    public T put(KEY key, T value) {
        T existing = this.get(key);
        if (existing == value || existing != null && existing.equals(value)) {
            if (existing != null && !existing.equals(value)) {
                this.updateBlockOrDelete(key, value);
            }
            return existing;
        }
        SoftReference<T> ref = new SoftReference<T>(value, this.reaper);
        this.mapping.put(key, ref);
        if (existing == null) {
            this.appendBlock(key, value);
        } else {
            this.updateBlockOrDelete(key, value);
        }
        return existing;
    }

    @Override
    public T remove(Object key) {
        if (!this.tryFile(key)) {
            return null;
        }
        try {
            return this.updateBlockOrDelete((Serializable)key, null);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public void putAll(Map<? extends KEY, ? extends T> m) {
        for (Map.Entry<KEY, T> entry : m.entrySet()) {
            try {
                this.put((KEY)((Serializable)entry.getKey()), entry.getValue());
            }
            catch (RuntimeException e) {
                Redwood.Util.err(e);
            }
        }
    }

    @Override
    public void clear() {
        this.mapping.clear();
    }

    @Override
    public Set<KEY> keySet() {
        this.readCache();
        return this.mapping.keySet();
    }

    @Override
    public Collection<T> values() {
        Set<Map.Entry<KEY, T>> entries = this.entrySet();
        ArrayList<T> values = Generics.newArrayList(entries.size());
        for (Map.Entry<KEY, T> entry : entries) {
            values.add(entry.getValue());
        }
        return values;
    }

    @Override
    public Set<Map.Entry<KEY, T>> entrySet() {
        this.readCache();
        Set<Map.Entry<KEY, SoftReference<T>>> entries = this.mapping.entrySet();
        Set<Map.Entry<KEY, T>> rtn = Generics.newHashSet();
        for (final Map.Entry<KEY, SoftReference<T>> entry : entries) {
            T value = entry.getValue().get();
            if (value == null) {
                value = this.get(entry.getKey());
            }
            final T valueFinal = value;
            rtn.add(new Map.Entry<KEY, T>(){
                private T valueImpl;
                {
                    this.valueImpl = valueFinal;
                }

                @Override
                public KEY getKey() {
                    return (Serializable)entry.getKey();
                }

                @Override
                public T getValue() {
                    return this.valueImpl;
                }

                @Override
                public T setValue(T value) {
                    Object oldValue = this.valueImpl;
                    this.valueImpl = value;
                    return oldValue;
                }
            });
        }
        return rtn;
    }

    @Override
    public Iterator<Map.Entry<KEY, T>> iterator() {
        final File[] files = this.cacheDir.listFiles();
        if (files == null || files.length == 0) {
            return Generics.newLinkedList().iterator();
        }
        for (int i = 0; i < files.length; ++i) {
            try {
                files[i] = canonicalFile.intern(files[i].getCanonicalFile());
                continue;
            }
            catch (IOException e) {
                throw FileBackedCache.throwSafe(e);
            }
        }
        return new Iterator<Map.Entry<KEY, T>>(){
            Iterator<Pair<KEY, T>> elements;
            int index;
            {
                this.elements = FileBackedCache.this.readBlock(files[0]).iterator();
                this.index = 1;
            }

            @Override
            public boolean hasNext() {
                if (this.elements.hasNext()) {
                    return true;
                }
                this.elements = null;
                while (this.index < files.length && this.elements == null) {
                    try {
                        this.elements = FileBackedCache.this.readBlock(files[this.index]).iterator();
                    }
                    catch (OutOfMemoryError e) {
                        Redwood.Util.warn("FileBackedCache", "Caught out of memory error (clearing cache): " + e.getMessage());
                        FileBackedCache.this.clear();
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e2) {
                            throw new RuntimeInterruptedException(e2);
                        }
                        this.elements = FileBackedCache.this.readBlock(files[this.index]).iterator();
                    }
                    catch (RuntimeException e) {
                        Redwood.Util.err(e);
                    }
                    ++this.index;
                }
                return this.elements != null && this.hasNext();
            }

            @Override
            public Map.Entry<KEY, T> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                final Pair pair = this.elements.next();
                return new Map.Entry<KEY, T>(){

                    @Override
                    public KEY getKey() {
                        return (Serializable)pair.first;
                    }

                    @Override
                    public T getValue() {
                        return pair.second;
                    }

                    @Override
                    public T setValue(T value) {
                        throw new RuntimeException("Cannot set entry");
                    }
                };
            }

            @Override
            public void remove() {
                throw new RuntimeException("Remove not implemented");
            }
        };
    }

    public boolean removeFromMemory(KEY key) {
        return this.mapping.remove(key) != null;
    }

    public static Collection<File> locksHeld() {
        ArrayList<File> files = Generics.newArrayList();
        for (Map.Entry<File, FileSemaphore> entry : fileLocks.entrySet()) {
            if (!entry.getValue().isActive()) continue;
            files.add(entry.getKey());
        }
        return files;
    }

    private int readCache() {
        File[] files = this.cacheDir.listFiles();
        if (files == null) {
            return 0;
        }
        for (int i = 0; i < files.length; ++i) {
            try {
                files[i] = canonicalFile.intern(files[i].getCanonicalFile());
                continue;
            }
            catch (IOException e) {
                throw FileBackedCache.throwSafe(e);
            }
        }
        int count = 0;
        for (File f : files) {
            try {
                Collection<Pair<KEY, T>> block = this.readBlock(f);
                count += block.size();
            }
            catch (Exception e) {
                throw FileBackedCache.throwSafe(e);
            }
        }
        return count;
    }

    private boolean tryFile(Object key) {
        try {
            return this.hash2file(key.hashCode(), false).exists();
        }
        catch (IOException e) {
            throw FileBackedCache.throwSafe(e);
        }
    }

    private Collection<Pair<KEY, T>> readBlock(Object key) {
        try {
            return this.readBlock(this.hash2file(key.hashCode(), true));
        }
        catch (IOException e) {
            Redwood.Util.err("Could not read file: " + this.cacheDir.getPath() + File.separator + this.fileRoot(key.hashCode()));
            throw FileBackedCache.throwSafe(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendBlock(KEY key, T value) {
        boolean haveTakenLock = false;
        Pair<OutputStream, CloseAction> writer = null;
        try {
            File toWrite = this.hash2file(key.hashCode(), false);
            boolean exists = toWrite.exists();
            FileBackedCache.robustCreateFile(toWrite);
            File file = toWrite;
            synchronized (file) {
                assert (canonicalFile.intern(toWrite.getCanonicalFile()) == toWrite);
                writer = this.newOutputStream(toWrite, exists);
                haveTakenLock = true;
                this.writeNextObject((OutputStream)writer.first, Pair.makePair(key, value));
                ((CloseAction)writer.second).apply();
                haveTakenLock = false;
            }
        }
        catch (IOException e) {
            try {
                if (haveTakenLock) {
                    ((CloseAction)writer.second).apply();
                }
            }
            catch (IOException e2) {
                throw FileBackedCache.throwSafe(e2);
            }
            throw FileBackedCache.throwSafe(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private T updateBlockOrDelete(KEY key, T valueOrNull) {
        Iterator iterator;
        Object existingValue;
        LinkedList<Pair<KEY, T>> block;
        Pair<InputStream, CloseAction> reader = null;
        Pair<OutputStream, CloseAction> writer = null;
        boolean haveClosedReader = false;
        boolean haveClosedWriter = false;
        try {
            File blockFile;
            File file = blockFile = this.hash2file(key.hashCode(), true);
            synchronized (file) {
                assert (canonicalFile.intern(blockFile.getCanonicalFile()) == blockFile);
                reader = this.newInputStream(blockFile);
                writer = this.newOutputStream(blockFile, false);
                block = Generics.newLinkedList();
                existingValue = null;
            }
        }
        catch (Throwable throwable) {
            try {
                if (reader != null && !haveClosedReader) {
                    ((CloseAction)reader.second).apply();
                }
                if (writer == null) throw throwable;
                if (haveClosedWriter) throw throwable;
                ((CloseAction)writer.second).apply();
                throw throwable;
            }
            catch (IOException e) {
                Redwood.Util.warn(e);
            }
            throw throwable;
        }
        {
            catch (IOException | ClassNotFoundException e) {
                Redwood.Util.err(e);
                throw FileBackedCache.throwSafe(e);
            }
        }
        {
            Pair<KEY, T> element;
            while ((element = this.readNextObjectOrNull((InputStream)reader.first)) != null) {
                if (((Serializable)element.first).equals(key)) {
                    if (valueOrNull == null) continue;
                    existingValue = element.second;
                    element.second = valueOrNull;
                    block.add(element);
                    continue;
                }
                block.add(element);
            }
            ((CloseAction)reader.second).apply();
            haveClosedReader = true;
            for (Pair pair : block) {
                this.writeNextObject((OutputStream)writer.first, pair);
            }
            ((CloseAction)writer.second).apply();
            haveClosedWriter = true;
            iterator = existingValue;
        }
        try {
            if (reader != null && !haveClosedReader) {
                ((CloseAction)reader.second).apply();
            }
            if (writer == null) return (T)iterator;
            if (haveClosedWriter) return (T)iterator;
            ((CloseAction)writer.second).apply();
            return (T)iterator;
        }
        catch (IOException iOException) {
            Redwood.Util.warn(iOException);
        }
        return (T)iterator;
    }

    /*
     * Exception decompiling
     */
    private Collection<Pair<KEY, T>> readBlock(File block) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private File hash2file(int hashCode, boolean create) throws IOException {
        File candidate = canonicalFile.intern(new File(this.cacheDir.getCanonicalPath() + File.separator + this.fileRoot(hashCode) + ".block.ser.gz").getCanonicalFile());
        if (create) {
            FileBackedCache.robustCreateFile(candidate);
        }
        return candidate;
    }

    private int fileRoot(int hashCode) {
        if (this.maxFiles < 0) {
            return hashCode;
        }
        return Math.abs(hashCode) % this.maxFiles;
    }

    private static RuntimeException throwSafe(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        if (e.getCause() == null) {
            return new RuntimeException(e);
        }
        return FileBackedCache.throwSafe(e.getCause());
    }

    private static void robustCreateFile(File candidate) throws IOException {
        int tries = 0;
        while (!candidate.exists()) {
            if (tries > 30) {
                throw new IOException("Could not create file: " + candidate);
            }
            if (candidate.createNewFile()) break;
            ++tries;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Redwood.Util.log(e);
                throw new RuntimeInterruptedException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileSemaphore acquireFileLock(File f) throws IOException {
        assert (canonicalFile.intern(f.getCanonicalFile()) == f);
        File file = f;
        synchronized (file) {
            IdentityHashMap<File, FileSemaphore> identityHashMap = fileLocks;
            synchronized (identityHashMap) {
                if (fileLocks.containsKey(f)) {
                    FileSemaphore sem = fileLocks.get(f);
                    if (sem.isActive()) {
                        sem.take();
                        return sem;
                    }
                    fileLocks.remove(f);
                }
            }
            FileChannel channel = new RandomAccessFile(f, "rw").getChannel();
            FileLock lockOrNull = null;
            for (int i = 0; !(i >= 1000 || (lockOrNull = channel.tryLock()) != null && lockOrNull.isValid()); ++i) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Redwood.Util.log(e);
                    throw new RuntimeInterruptedException(e);
                }
                if (i % 60 != 59) continue;
                Redwood.Util.warn("FileBackedCache", "Lock still busy after " + (i + 1) / 60 + " minutes");
            }
            if (lockOrNull == null) {
                Redwood.Util.warn("FileBackedCache", "Could not acquire file lock! Continuing without lock");
            }
            FileSemaphore sem = new FileSemaphore(lockOrNull, channel);
            IdentityHashMap<File, FileSemaphore> identityHashMap2 = fileLocks;
            synchronized (identityHashMap2) {
                fileLocks.put(f, sem);
            }
            return sem;
        }
    }

    protected Pair<? extends InputStream, CloseAction> newInputStream(File f) throws IOException {
        FileSemaphore lock = this.acquireFileLock(f);
        ObjectInputStream rtn = new ObjectInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(f))));
        return new Pair<ObjectInputStream, CloseAction>(rtn, () -> {
            lock.release();
            rtn.close();
        });
    }

    protected Pair<? extends OutputStream, CloseAction> newOutputStream(File f, boolean isAppend) throws IOException {
        FileOutputStream stream = new FileOutputStream(f, isAppend);
        FileSemaphore lock = this.acquireFileLock(f);
        ObjectOutputStream rtn = isAppend ? new AppendingObjectOutputStream(new GZIPOutputStream(new BufferedOutputStream(stream))) : new ObjectOutputStream(new GZIPOutputStream(new BufferedOutputStream(stream)));
        return new Pair<AppendingObjectOutputStream, CloseAction>((AppendingObjectOutputStream)rtn, () -> {
            rtn.flush();
            lock.release();
            rtn.close();
        });
    }

    protected Pair<KEY, T> readNextObjectOrNull(InputStream input) throws IOException, ClassNotFoundException {
        try {
            return (Pair)((ObjectInputStream)input).readObject();
        }
        catch (EOFException e) {
            return null;
        }
    }

    protected void writeNextObject(OutputStream output, Pair<KEY, T> value) throws IOException {
        ((ObjectOutputStream)output).writeObject(value);
    }

    public static <KEY extends Serializable, T extends Serializable> void merge(FileBackedCache<KEY, T> destination, FileBackedCache<? extends KEY, ? extends T>[] constituents) {
        Redwood.Util.startTrack("Merging Caches");
        Redwood.Util.forceTrack("Reading Constituents");
        Map combinedMapping = Generics.newHashMap();
        try {
            for (int i = 0; i < constituents.length; ++i) {
                FileBackedCache<KEY, T> fileBackedCache = constituents[i];
                for (Map.Entry<KEY, T> entry : fileBackedCache) {
                    String fileToWriteTo = super.hash2file(((Serializable)entry.getKey()).hashCode(), false).getName();
                    if (!combinedMapping.containsKey(fileToWriteTo)) {
                        combinedMapping.put(fileToWriteTo, Generics.newHashMap());
                    }
                    ((Map)combinedMapping.get(fileToWriteTo)).put((Serializable)entry.getKey(), (Serializable)entry.getValue());
                }
                Redwood.Util.log("[" + new DecimalFormat("0000").format(i) + "/" + constituents.length + "] read " + fileBackedCache.cacheDir + " [" + Runtime.getRuntime().freeMemory() / 1000000L + "MB free memory]");
                fileBackedCache.clear();
            }
            for (Map.Entry<Serializable, Serializable> entry : destination) {
                String string = super.hash2file(entry.getKey().hashCode(), false).getName();
                if (!combinedMapping.containsKey(string)) {
                    combinedMapping.put(string, Generics.newHashMap());
                }
                ((Map)combinedMapping.get(string)).put(entry.getKey(), entry.getValue());
            }
        }
        catch (IOException e) {
            Redwood.Util.err("Found exception in merge() -- all data is intact (but passing exception up)");
            throw new RuntimeException(e);
        }
        Redwood.Util.endTrack("Reading Constituents");
        Redwood.Util.forceTrack("Clearing Destination");
        if (!destination.cacheDir.exists() && !destination.cacheDir.mkdirs()) {
            throw new RuntimeException("Could not create cache dir for destination (data is intact): " + destination.cacheDir);
        }
        File[] filesInDestination = destination.cacheDir.listFiles();
        if (filesInDestination == null) {
            throw new RuntimeException("Cannot list files in destination's cache dir (data is intact): " + destination.cacheDir);
        }
        for (File block : filesInDestination) {
            if (block.delete()) continue;
            Redwood.Util.warn("FileBackedCache", "could not delete block: " + block);
        }
        Redwood.Util.endTrack("Clearing Destination");
        Redwood.Util.forceTrack("Writing New Files");
        try {
            for (Map.Entry entry : combinedMapping.entrySet()) {
                File toWrite = canonicalFile.intern(new File(destination.cacheDir + File.separator + (String)entry.getKey()).getCanonicalFile());
                boolean exists = toWrite.exists();
                Pair<OutputStream, CloseAction> writer = destination.newOutputStream(toWrite, exists);
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    destination.writeNextObject((OutputStream)writer.first, Pair.makePair((Serializable)entry2.getKey(), (Serializable)entry2.getValue()));
                }
                ((CloseAction)writer.second).apply();
            }
        }
        catch (IOException iOException) {
            Redwood.Util.err("Could not write constituent files to combined cache (DATA IS LOST)!");
            throw new RuntimeException(iOException);
        }
        Redwood.Util.endTrack("Writing New Files");
        Redwood.Util.endTrack("Merging Caches");
    }

    public static <KEY extends Serializable, T extends Serializable> void merge(FileBackedCache<KEY, T> destination, Collection<FileBackedCache<KEY, T>> constituents) {
        FileBackedCache.merge(destination, constituents.toArray(new FileBackedCache[constituents.size()]));
    }

    public static class FileSemaphore {
        private int licenses = 1;
        private final FileLock lock;
        private final FileChannel channel;

        public FileSemaphore(FileLock lock, FileChannel channel) {
            this.lock = lock;
            this.channel = channel;
        }

        public synchronized boolean isActive() {
            if (this.licenses == 0) assert (this.lock == null || !this.lock.isValid());
            if (this.licenses != 0 && this.lock != null) assert (this.lock.isValid());
            return this.licenses != 0;
        }

        public synchronized void take() {
            if (!this.isActive()) {
                throw new IllegalStateException("Taking a file license when the licenses have all been released");
            }
            ++this.licenses;
        }

        public synchronized void release() throws IOException {
            if (this.licenses <= 0) {
                throw new IllegalStateException("Already released all semaphore licenses");
            }
            --this.licenses;
            if (this.licenses <= 0) {
                if (this.lock != null) {
                    this.lock.release();
                }
                this.channel.close();
            }
        }
    }

    public static interface CloseAction {
        public void apply() throws IOException;
    }

    public static class AppendingObjectOutputStream
    extends ObjectOutputStream {
        public AppendingObjectOutputStream(OutputStream out2) throws IOException {
            super(out2);
        }

        @Override
        protected void writeStreamHeader() throws IOException {
            this.reset();
        }
    }
}

