/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.IterableIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import junit.framework.TestCase;

public class IterableIteratorTest
extends TestCase {
    public void testBasic() {
        String[] strings = new String[]{"do", "re", "mi", "fa", "so", "la", "ti", "do"};
        Iterator<String> it = Arrays.asList(strings).iterator();
        IterableIterator<String> iterit = new IterableIterator<String>(it);
        IterableIteratorTest.assertEquals((String)"do", (String)iterit.next());
        IterableIteratorTest.assertEquals((String)"re", (String)iterit.next());
        IterableIteratorTest.assertEquals((String)"mi", (String)iterit.next());
        IterableIteratorTest.assertEquals((String)"fa", (String)iterit.next());
        IterableIteratorTest.assertEquals((String)"so", (String)iterit.next());
        IterableIteratorTest.assertEquals((String)"la", (String)iterit.next());
        IterableIteratorTest.assertEquals((String)"ti", (String)iterit.next());
        IterableIteratorTest.assertEquals((String)"do", (String)iterit.next());
        IterableIteratorTest.assertFalse((boolean)iterit.hasNext());
    }

    public void testSpliteratorInSequence() {
        ArrayList<Integer> x = new ArrayList<Integer>();
        for (int i = 0; i < 1000; ++i) {
            x.add(i);
        }
        IterableIterator iter = new IterableIterator(x.iterator());
        Spliterator spliterator = iter.spliterator();
        Stream stream = StreamSupport.stream(spliterator, false);
        Integer[] next = new Integer[]{0};
        stream.forEach(elem -> {
            IterableIteratorTest.assertEquals((Object)next[0], (Object)elem);
            next[0] = next[0] + 1;
        });
    }

    public void testSpliteratorInParallel() {
        ArrayList<Integer> x = new ArrayList<Integer>();
        for (int i = 0; i < 1000; ++i) {
            x.add(i);
        }
        IterableIterator iter = new IterableIterator(x.iterator());
        Spliterator spliterator = iter.spliterator();
        Stream stream = StreamSupport.stream(spliterator, true);
        boolean[] seen = new boolean[1000];
        stream.forEach(elem -> {
            IterableIteratorTest.assertFalse((boolean)seen[elem]);
            seen[elem.intValue()] = true;
        });
        for (int i = 0; i < 1000; ++i) {
            IterableIteratorTest.assertTrue((boolean)seen[i]);
        }
    }
}

