/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.RuntimeInterruptedException;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;

public class MemoryMonitor {
    private static Redwood.RedwoodChannels log = Redwood.channels(MemoryMonitor.class);
    public static final int MAX_SWAPS = 50;
    protected long lastPoll = 0L;
    protected long pollEvery;
    protected int freeMem;
    protected int usedSwap;
    protected int swaps;
    protected Runtime r;

    public MemoryMonitor() {
        this(60000L);
    }

    public MemoryMonitor(long millis) {
        this.pollEvery = millis;
        this.freeMem = 0;
        this.usedSwap = 0;
        this.swaps = 0;
        this.r = Runtime.getRuntime();
        this.pollVMstat(true);
    }

    public void pollAtMostEvery(long millis) {
        this.pollEvery = millis;
    }

    public int getMaxMemory() {
        return (int)(this.r.maxMemory() / 1024L);
    }

    public int getMaxAvailableMemory() {
        return this.getMaxAvailableMemory(false);
    }

    public int getMaxAvailableMemory(boolean accurate) {
        if (accurate) {
            System.gc();
        }
        return (int)((this.r.maxMemory() - this.r.totalMemory() + this.r.freeMemory()) / 1024L);
    }

    public int getUsedMemory() {
        return this.getUsedMemory(false);
    }

    public int getUsedMemory(boolean accurate) {
        if (accurate) {
            System.gc();
        }
        return (int)((this.r.totalMemory() - this.r.freeMemory()) / 1024L);
    }

    public int getSystemFreeMemory(boolean accurate) {
        if (accurate) {
            System.gc();
        }
        this.pollVMstat(false);
        return this.freeMem;
    }

    public int getSystemUsedSwap() {
        this.pollVMstat(false);
        return this.usedSwap;
    }

    public double getSystemSwapsPerSec() {
        this.pollVMstat(false);
        return this.swaps;
    }

    protected static ArrayList<String> parseFields(BufferedReader br, String splitStr, int[] lineNums, int[] positions) throws IOException {
        int currLine = 0;
        int processed = 0;
        ArrayList<String> found = new ArrayList<String>();
        block0: while (br.ready()) {
            String[] fields = br.readLine().split(splitStr);
            if (++currLine != lineNums[processed]) continue;
            int currPosition = 0;
            for (String f : fields) {
                if (f.length() <= 0 || ++currPosition != positions[processed]) continue;
                found.add(f);
                if (++processed == positions.length) continue block0;
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollFree(boolean force) {
        long time;
        if (!force && (time = System.currentTimeMillis()) - this.lastPoll < this.pollEvery) {
            return;
        }
        Process p = null;
        int[] freeLines = new int[]{2, 4};
        int[] freePositions = new int[]{4, 3};
        this.lastPoll = System.currentTimeMillis();
        try {
            p = this.r.exec("free");
            p.waitFor();
            BufferedReader bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
            ArrayList<String> l = MemoryMonitor.parseFields(bri, " ", freeLines, freePositions);
            this.freeMem = Integer.parseInt(l.get(1));
            this.usedSwap = Integer.parseInt(l.get(2));
        }
        catch (Exception e) {
            log.info(e);
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollVMstat(boolean force) {
        long time;
        if (!force && (time = System.currentTimeMillis()) - this.lastPoll < this.pollEvery) {
            return;
        }
        Process p = null;
        int[] lines = new int[]{4, 4, 4, 4};
        int[] positions = new int[]{3, 4, 7, 8};
        try {
            p = this.r.exec("vmstat 1 2");
            p.waitFor();
            long time2 = System.currentTimeMillis();
            BufferedReader bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
            ArrayList<String> l = MemoryMonitor.parseFields(bri, " ", lines, positions);
            this.usedSwap = Integer.parseInt(l.get(0));
            this.freeMem = Integer.parseInt(l.get(1));
            this.swaps = Integer.parseInt(l.get(2)) + Integer.parseInt(l.get(3));
            this.lastPoll = time2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
    }

    public boolean systemIsSwapping() {
        return this.getSystemSwapsPerSec() > 50.0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("lastPoll:").append(this.lastPoll);
        sb.append(" pollEvery:").append(this.pollEvery);
        sb.append(" freeMem:").append(this.freeMem);
        sb.append(" usedSwap:").append(this.usedSwap);
        sb.append(" swaps:").append(this.swaps);
        sb.append(" maxAvailable:").append(this.getMaxAvailableMemory(false));
        sb.append(" used:").append(this.getUsedMemory(false));
        return sb.toString();
    }

    public static void main(String[] args) throws InterruptedException {
        Thread pmm = new Thread(new PeakMemoryMonitor());
        pmm.start();
        long time = System.currentTimeMillis();
        MemoryMonitor mm = new MemoryMonitor();
        long time2 = System.currentTimeMillis();
        System.out.println("Created MemoryMonitor.  Took " + (time2 - time) + " milliseconds.");
        System.out.println(mm);
        time = System.currentTimeMillis();
        mm.pollVMstat(true);
        time2 = System.currentTimeMillis();
        System.out.println("Second Poll.  Took " + (time2 - time) + " milliseconds.");
        System.out.println(mm);
        pmm.interrupt();
        pmm.join();
    }

    public static class PeakMemoryMonitor
    implements Runnable {
        private static final float GIGABYTE = 1.0737418E9f;
        private static final int DEFAULT_POLL_FREQUENCY = 1000;
        private static final int DEFAULT_LOG_FREQUENCY = 60000;
        private int pollFrequency;
        private int logFrequency;
        private Timing timer;
        private PrintStream outstream;
        private long peak = 0L;

        public PeakMemoryMonitor() {
            this(1000, 60000);
        }

        public PeakMemoryMonitor(int pollFrequency, int logFrequency) {
            this(pollFrequency, logFrequency, System.err);
        }

        public PeakMemoryMonitor(int pollFrequency, int logFrequency, PrintStream out2) {
            this.pollFrequency = pollFrequency;
            this.logFrequency = logFrequency;
            this.outstream = out2;
            this.timer = new Timing();
        }

        @Override
        public void run() {
            Runtime runtime = Runtime.getRuntime();
            this.timer.start();
            while (true) {
                this.peak = Math.max(this.peak, runtime.totalMemory() - runtime.freeMemory());
                if (this.timer.report() > (long)this.logFrequency) {
                    this.log();
                    this.timer.restart();
                }
                try {
                    Thread.sleep(this.pollFrequency);
                }
                catch (InterruptedException e) {
                    this.log();
                    throw new RuntimeInterruptedException(e);
                }
            }
        }

        public void log() {
            this.outstream.println(String.format("Maximum memory used: %.1f GB", Float.valueOf((float)this.peak / 1.0737418E9f)));
        }
    }
}

