/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.MetaClass;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class MetaClassTest {
    private static final String CLASS = MetaClassTest.class.getName();

    @Test
    public void testBasic() {
        MetaClass.create("java.lang.String");
        Assert.assertEquals(MetaClass.create("java.lang.String").createInstance("hello"), (Object)"hello");
        try {
            MetaClass.create(CLASS + "$SomethingWrapper").createInstance("hello");
        }
        catch (MetaClass.ClassCreationException e) {
            Assert.assertTrue((String)"Should not instantiate Super with String", (boolean)true);
        }
        MetaClass.create(CLASS + "$ManyConstructors").createInstance(new Something(), new Something(), new Something());
        Assert.assertEquals((long)((ManyConstructors)MetaClass.create(CLASS + "$ManyConstructors").createInstance(new Something())).constructorInvoked(), (long)new ManyConstructors(new Something()).constructorInvoked());
        Assert.assertEquals((long)((ManyConstructors)MetaClass.create(CLASS + "$ManyConstructors").createInstance(new Something(), new Something())).constructorInvoked(), (long)new ManyConstructors(new Something(), new Something()).constructorInvoked());
        Assert.assertEquals((long)((ManyConstructors)MetaClass.create(CLASS + "$ManyConstructors").createInstance(new Something(), new Something(), new Something())).constructorInvoked(), (long)new ManyConstructors(new Something(), new Something(), new Something()).constructorInvoked());
        Assert.assertEquals((Object)new ManyConstructors(new String("hi")), MetaClass.create(CLASS + "$ManyConstructors").createInstance(new String("hi")));
        Assert.assertEquals((Object)new ManyConstructors(new Something()), MetaClass.create(CLASS + "$ManyConstructors").createInstance(new Something()));
        Assert.assertEquals((Object)new ManyConstructors(new SSomething()), MetaClass.create(CLASS + "$ManyConstructors").createInstance(new SSomething()));
        Assert.assertEquals((Object)new ManyConstructors(new SubSSomething()), MetaClass.create(CLASS + "$ManyConstructors").createInstance(new SubSSomething()));
    }

    @Test
    public void testInheritance() {
        Object o;
        try {
            o = MetaClass.create(CLASS + "$SomethingWrapper").createInstance(new Something());
            Assert.assertTrue((String)"Returned class should be a SomethingWrapper", (boolean)(o instanceof SomethingWrapper));
            Assert.assertEquals((Object)((SomethingWrapper)o).display(), (Object)"something");
        }
        catch (MetaClass.ClassCreationException e) {
            e.printStackTrace();
            Assert.assertFalse((String)"Should not exception on this call", (boolean)true);
        }
        try {
            o = MetaClass.create(CLASS + "$SomethingWrapper").createInstance(new SInstSomething());
            Assert.assertTrue((String)"Returned class should be a SomethingWrapper", (boolean)(o instanceof SomethingWrapper));
            Assert.assertEquals((Object)((SomethingWrapper)o).displayS(), (Object)"Ssomething");
        }
        catch (MetaClass.ClassCreationException e) {
            e.printStackTrace();
            Assert.assertFalse((String)"Should not exception on this call", (boolean)true);
        }
        try {
            o = MetaClass.create(CLASS + "$SomethingWrapper").createInstance(new AInstSomething());
            Assert.assertTrue((String)"Returned class should be a SomethingWrapper", (boolean)(o instanceof SomethingWrapper));
            Assert.assertEquals((Object)((SomethingWrapper)o).displayA(), (Object)"Asomething");
        }
        catch (MetaClass.ClassCreationException e) {
            e.printStackTrace();
            Assert.assertFalse((String)"Should not exception on this call", (boolean)true);
        }
        try {
            o = MetaClass.create(CLASS + "$SomethingWrapper").createInstance(new IInstSomething());
            Assert.assertTrue((String)"Returned class should be a SomethingWrapper", (boolean)(o instanceof SomethingWrapper));
            Assert.assertEquals((Object)((SomethingWrapper)o).displayI(), (Object)"Isomething");
        }
        catch (MetaClass.ClassCreationException e) {
            e.printStackTrace();
            Assert.assertFalse((String)"Should not exception on this call", (boolean)true);
        }
    }

    private ManyConstructors makeRef(int i, int j) {
        switch (i) {
            case 0: {
                switch (j) {
                    case 0: {
                        return new ManyConstructors((Object)new String("hi"), (Object)new String("hi"));
                    }
                    case 1: {
                        return new ManyConstructors((Object)new String("hi"), new Something());
                    }
                    case 2: {
                        return new ManyConstructors((Object)new String("hi"), new SSomething());
                    }
                    case 3: {
                        return new ManyConstructors((Object)new String("hi"), new SubSSomething());
                    }
                }
                return null;
            }
            case 1: {
                switch (j) {
                    case 0: {
                        return new ManyConstructors(new Something(), (Object)new String("hi"));
                    }
                    case 1: {
                        return new ManyConstructors(new Something(), new Something());
                    }
                    case 2: {
                        return new ManyConstructors(new Something(), new SSomething());
                    }
                    case 3: {
                        return new ManyConstructors(new Something(), new SubSSomething());
                    }
                }
                return null;
            }
            case 2: {
                switch (j) {
                    case 0: {
                        return new ManyConstructors(new SSomething(), (Object)new String("hi"));
                    }
                    case 1: {
                        return new ManyConstructors(new SSomething(), new Something());
                    }
                    case 2: {
                        return new ManyConstructors(new SSomething(), new SSomething());
                    }
                    case 3: {
                        return new ManyConstructors(new SSomething(), new SubSSomething());
                    }
                }
                return null;
            }
            case 3: {
                switch (j) {
                    case 0: {
                        return new ManyConstructors(new SubSSomething(), (Object)new String("hi"));
                    }
                    case 1: {
                        return new ManyConstructors(new SubSSomething(), new Something());
                    }
                    case 2: {
                        return new ManyConstructors(new SubSSomething(), new SSomething());
                    }
                    case 3: {
                        return new ManyConstructors(new SubSSomething(), new SubSSomething());
                    }
                }
                return null;
            }
        }
        return null;
    }

    private static ManyConstructors makeRef(int i) {
        switch (i) {
            case 0: {
                return new ManyConstructors(new String("hi"));
            }
            case 1: {
                return new ManyConstructors(new Something());
            }
            case 2: {
                return new ManyConstructors(new SSomething());
            }
            case 3: {
                return new ManyConstructors(new SubSSomething());
            }
        }
        return null;
    }

    @Test
    public void testConsistencyWithJava() {
        int i;
        Object[] options;
        for (Object option : options = new Object[]{new String("hi"), new Something(), new SSomething(), new SubSSomething()}) {
            ManyConstructors ref = new ManyConstructors(option);
            ManyConstructors test = (ManyConstructors)MetaClass.create(CLASS + "$ManyConstructors").createFactory(Object.class).createInstance(option);
            Assert.assertEquals((long)ref.constructorInvoked(), (long)test.constructorInvoked());
        }
        for (i = 0; i < options.length; ++i) {
            ManyConstructors ref = MetaClassTest.makeRef(i);
            ManyConstructors test = (ManyConstructors)MetaClass.create(CLASS + "$ManyConstructors").createInstance(options[i]);
            Assert.assertEquals((Object)ref, (Object)test);
        }
        for (i = 0; i < options.length; ++i) {
            for (int j = 0; j < options.length; ++j) {
                ManyConstructors ref = this.makeRef(i, j);
                ManyConstructors test = (ManyConstructors)MetaClass.create(CLASS + "$ManyConstructors").createInstance(options[i], options[j]);
                Assert.assertEquals((Object)ref, (Object)test);
            }
        }
    }

    @Test
    public void testPrimitives() {
        MetaClass.create(CLASS + "$Primitive").createInstance(new Integer(7));
        MetaClass.create(CLASS + "$Primitive").createInstance(new Double(7.0));
        MetaClass.create(CLASS + "$Primitive").createInstance(7);
        MetaClass.create(CLASS + "$Primitive").createInstance(2.8);
        try {
            MetaClass.create(CLASS + "$Primitive").createInstance(7L);
        }
        catch (MetaClass.ClassCreationException e) {
            Assert.assertTrue((String)"Should not be able to case Long int Primitive()", (boolean)true);
        }
    }

    @Test
    public void testCastSimple() {
        Assert.assertEquals((Object)new Double(1.0), MetaClass.cast("1.0", Double.class));
        Assert.assertEquals((Object)new Integer(1), MetaClass.cast("1", Integer.class));
        Assert.assertEquals((Object)new Integer(1), MetaClass.cast("1.0", Integer.class));
        Assert.assertEquals((Object)new Long(1L), MetaClass.cast("1.0", Long.class));
        Assert.assertEquals((Object)new Short(1), MetaClass.cast("1.0", Short.class));
        Assert.assertEquals((Object)new Byte(1), MetaClass.cast("1.0", Byte.class));
        Assert.assertEquals((Object)"Hello", MetaClass.cast("Hello", String.class));
        Assert.assertEquals((Object)true, MetaClass.cast("true", Boolean.class));
        Assert.assertEquals((Object)true, MetaClass.cast("1", Boolean.class));
        Assert.assertEquals((Object)false, MetaClass.cast("False", Boolean.class));
        Assert.assertEquals((Object)new File("/path/to/file"), MetaClass.cast("/path/to/file", File.class));
    }

    @Test
    public void testCastArray() {
        Object[] ints1 = (Integer[])MetaClass.cast("[1,2,3]", Integer[].class);
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2, 3}, (Object[])ints1);
        Object[] ints2 = (Integer[])MetaClass.cast("(1,2,3)", Integer[].class);
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2, 3}, (Object[])ints2);
        Object[] ints3 = (Integer[])MetaClass.cast("1, 2, 3", Integer[].class);
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2, 3}, (Object[])ints3);
        Object[] ints4 = (Integer[])MetaClass.cast("1 2 3", Integer[].class);
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2, 3}, (Object[])ints4);
        Object[] ints5 = (Integer[])MetaClass.cast("1   2   3", Integer[].class);
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2, 3}, (Object[])ints5);
        Object[] ints6 = (Integer[])MetaClass.cast("\n1 \n\n  2   3", Integer[].class);
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2, 3}, (Object[])ints6);
        Object[] intsEmpty = (Integer[])MetaClass.cast("", Integer[].class);
        Assert.assertArrayEquals((Object[])new Integer[0], (Object[])intsEmpty);
    }

    @Test
    public void testCastStringArray() throws IOException {
        Object[] strings1 = (String[])MetaClass.cast("[a,b,c]", String[].class);
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c"}, (Object[])strings1);
        String string1 = Files.createTempFile("TestCastString", "tmp", new FileAttribute[0]).toString();
        String string2 = Files.createTempFile("TestCastString", "tmp", new FileAttribute[0]).toString();
        Object[] strings2 = (String[])MetaClass.cast("['" + string1 + "','" + string2 + "']", String[].class);
        Assert.assertArrayEquals((Object[])new String[]{string1, string2}, (Object[])strings2);
        Object[] strings3 = (String[])MetaClass.cast("['a','b','c']", String[].class);
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c"}, (Object[])strings3);
    }

    @Test
    public void testCastEnum() {
        Assert.assertEquals((Object)((Object)Fruits.APPLE), MetaClass.cast("APPLE", Fruits.class));
        Assert.assertEquals((Object)((Object)Fruits.APPLE), MetaClass.cast("apple", Fruits.class));
        Assert.assertEquals((Object)((Object)Fruits.APPLE), MetaClass.cast("Apple", Fruits.class));
        Assert.assertEquals((Object)((Object)Fruits.APPLE), MetaClass.cast("aPPlE", Fruits.class));
        Assert.assertEquals((Object)((Object)Fruits.Orange), MetaClass.cast("orange", Fruits.class));
        Assert.assertEquals((Object)((Object)Fruits.grape), MetaClass.cast("grape", Fruits.class));
        Assert.assertEquals((Object)((Object)Fruits.grape), MetaClass.cast("Grape", Fruits.class));
        Assert.assertEquals((Object)((Object)Fruits.grape), MetaClass.cast("GRAPE", Fruits.class));
    }

    @Test
    public void testCastCollection() {
        HashSet<String> set = new HashSet<String>();
        set.add("apple");
        set.add("banana");
        Set castedSet = (Set)MetaClass.cast("[apple, banana]", Set.class);
        Set castedSet2 = (Set)MetaClass.cast("[apple ,    banana ]", Set.class);
        Set castedSet3 = (Set)MetaClass.cast("{apple ,    banana }", Set.class);
        Assert.assertEquals(set, (Object)castedSet);
        Assert.assertEquals(set, (Object)castedSet2);
        Assert.assertEquals(set, (Object)castedSet3);
        LinkedList<String> list = new LinkedList<String>();
        list.add("apple");
        list.add("banana");
        List castedList = (List)MetaClass.cast("[apple, banana]", List.class);
        Assert.assertEquals(list, (Object)castedList);
    }

    @Test
    public void testCastMap() {
        Map a = (Map)MetaClass.cast("{ a -> 1, b -> 2 }", Map.class);
        Assert.assertEquals((long)2L, (long)a.size());
        Assert.assertEquals((Object)"1", a.get("a"));
        Assert.assertEquals((Object)"2", a.get("b"));
        Map b = (Map)MetaClass.cast("a => 1, b -> 2", Map.class);
        Assert.assertEquals((long)2L, (long)b.size());
        Assert.assertEquals((Object)"1", b.get("a"));
        Assert.assertEquals((Object)"2", b.get("b"));
        Map c = (Map)MetaClass.cast("[a->1;b->2]", Map.class);
        Assert.assertEquals((long)2L, (long)c.size());
        Assert.assertEquals((Object)"1", c.get("a"));
        Assert.assertEquals((Object)"2", c.get("b"));
        Map d = (Map)MetaClass.cast("\n\na->\n1\n\n\nb->2", Map.class);
        Assert.assertEquals((long)2L, (long)d.size());
        Assert.assertEquals((Object)"1", d.get("a"));
        Assert.assertEquals((Object)"2", d.get("b"));
    }

    @Test
    public void testCastRegression() {
        Pointer x1 = (Pointer)MetaClass.cast("1", Pointer.class);
        Assert.assertEquals((long)1L, (long)((Integer)x1.value).intValue());
    }

    @Test
    public void testCastFromString() {
        Assert.assertEquals((Object)new FromStringable("foo"), MetaClass.cast("foo", FromStringable.class));
        Assert.assertEquals((Object)new FromStringable("bar"), MetaClass.cast("bar", FromStringable.class));
    }

    @Test
    public void testCastStream() {
        Assert.assertEquals((Object)System.out, MetaClass.cast("stdout", OutputStream.class));
        Assert.assertEquals((Object)System.out, MetaClass.cast("out", OutputStream.class));
        Assert.assertEquals((Object)System.err, MetaClass.cast("stderr", OutputStream.class));
        Assert.assertEquals((Object)System.err, MetaClass.cast("err", OutputStream.class));
        Assert.assertEquals(ObjectOutputStream.class, MetaClass.cast("err", ObjectOutputStream.class).getClass());
    }

    private static class FromStringable {
        public final String myContents;

        private FromStringable(String contents) {
            this.myContents = contents;
        }

        public static FromStringable fromString(String str) {
            return new FromStringable(str);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FromStringable)) {
                return false;
            }
            FromStringable that = (FromStringable)o;
            return !(this.myContents != null ? !this.myContents.equals(that.myContents) : that.myContents != null);
        }

        public int hashCode() {
            return this.myContents != null ? this.myContents.hashCode() : 0;
        }
    }

    private static class Pointer<E> {
        public E value;

        public Pointer(E value) {
            this.value = value;
        }

        public static <E> Pointer<E> fromString(String value) {
            Object v = MetaClass.castWithoutKnowingType(value);
            return new Pointer(v);
        }
    }

    private static enum Fruits {
        APPLE,
        Orange,
        grape;

    }

    public static class VarArgs {
        public int[] a;

        public VarArgs(int ... args) {
            this.a = args;
        }
    }

    public static class Primitive {
        public Primitive(int i) {
        }

        public Primitive(double d) {
        }
    }

    public static class ManyConstructors {
        private int constructorInvoked = -1;

        public ManyConstructors(Object a) {
            this.constructorInvoked = 0;
        }

        public ManyConstructors(Something a) {
            this.constructorInvoked = 1;
        }

        public ManyConstructors(SSomething a) {
            this.constructorInvoked = 2;
        }

        public ManyConstructors(SubSSomething a) {
            this.constructorInvoked = 3;
        }

        public ManyConstructors(Object a, Object b) {
            this.constructorInvoked = 4;
        }

        public ManyConstructors(Object a, Something b) {
            this.constructorInvoked = 5;
        }

        public ManyConstructors(Object a, SSomething b) {
            this.constructorInvoked = 6;
        }

        public ManyConstructors(Object a, SubSSomething b) {
            this.constructorInvoked = 7;
        }

        public ManyConstructors(Something a, Object b) {
            this.constructorInvoked = 8;
        }

        public ManyConstructors(Something a, Something b) {
            this.constructorInvoked = 9;
        }

        public ManyConstructors(Something a, SSomething b) {
            this.constructorInvoked = 10;
        }

        public ManyConstructors(Something a, SubSSomething b) {
            this.constructorInvoked = 11;
        }

        public ManyConstructors(SSomething a, Object b) {
            this.constructorInvoked = 12;
        }

        public ManyConstructors(SSomething a, Something b) {
            this.constructorInvoked = 13;
        }

        public ManyConstructors(SSomething a, SSomething b) {
            this.constructorInvoked = 14;
        }

        public ManyConstructors(SSomething a, SubSSomething b) {
            this.constructorInvoked = 15;
        }

        public ManyConstructors(SubSSomething a, Object b) {
            this.constructorInvoked = 16;
        }

        public ManyConstructors(SubSSomething a, Something b) {
            this.constructorInvoked = 17;
        }

        public ManyConstructors(SubSSomething a, SSomething b) {
            this.constructorInvoked = 18;
        }

        public ManyConstructors(SubSSomething a, SubSSomething b) {
            this.constructorInvoked = 19;
        }

        public ManyConstructors(Something a, Something b, Something c) {
            this.constructorInvoked = 20;
        }

        public int constructorInvoked() {
            return this.constructorInvoked;
        }

        public boolean equals(Object o) {
            if (o instanceof ManyConstructors) {
                return this.constructorInvoked == ((ManyConstructors)o).constructorInvoked;
            }
            return false;
        }

        public String toString() {
            return "" + this.constructorInvoked;
        }
    }

    public static class SubSSomething
    extends SSomething {
        @Override
        public String display() {
            return "subssomething";
        }
    }

    public static class SomethingWrapper {
        private ISomething isomething;
        private ASomething asomething;
        private SSomething ssomething;
        private Something something;

        public SomethingWrapper(ISomething something) {
            this.isomething = something;
        }

        public SomethingWrapper(ASomething something) {
            this.asomething = something;
        }

        public SomethingWrapper(SSomething something) {
            this.ssomething = something;
        }

        public SomethingWrapper(Something something) {
            this.something = something;
        }

        public String display() {
            return this.something.display();
        }

        public String displayI() {
            return this.isomething.display();
        }

        public String displayA() {
            return this.asomething.display();
        }

        public String displayS() {
            return this.ssomething.display();
        }
    }

    public static class Something {
        public String display() {
            return "something";
        }
    }

    public static class SInstSomething
    extends SSomething {
        @Override
        public String display() {
            return "Ssomething";
        }
    }

    public static class SSomething {
        public String display() {
            return "FAIL";
        }
    }

    public static class AInstSomething
    extends ASomething {
        @Override
        public String display() {
            return "Asomething";
        }
    }

    public static abstract class ASomething {
        public abstract String display();
    }

    public static class IInstSomething
    implements ISomething {
        @Override
        public String display() {
            return "Isomething";
        }
    }

    public static interface ISomething {
        public String display();
    }
}

