/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal.generator;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.internal.generator.GeneratorRepository;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CompositeGenerator
extends Generator<Object> {
    private final List<Generator<?>> components;

    public CompositeGenerator(List<Generator<?>> components) {
        super(Object.class);
        this.components = new ArrayList(components);
    }

    @Override
    public Object generate(SourceOfRandomness random, GenerationStatus status) {
        Generator<?> generator = this.components.size() == 1 ? this.components.get(0) : this.components.get(random.nextInt(0, this.components.size() - 1));
        return generator.generate(random, status);
    }

    public Generator<?> componentGenerator(int index) {
        return this.components.get(index);
    }

    public int numberOfComponentGenerators() {
        return this.components.size();
    }

    @Override
    public void configure(Map<Class<? extends Annotation>, Annotation> configurationsByType) {
        for (Generator<?> each : this.components) {
            each.configure(configurationsByType);
        }
    }

    @Override
    public void provideRepository(GeneratorRepository provided) {
        super.provideRepository(provided);
        for (Generator<?> each : this.components) {
            each.provideRepository(provided);
        }
    }
}

