/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.classify.Dataset;
import edu.stanford.nlp.classify.GeneralDataset;
import edu.stanford.nlp.ling.BasicDatum;
import edu.stanford.nlp.util.Pair;
import java.util.Arrays;
import junit.framework.TestCase;

public class GeneralDatasetTest
extends TestCase {
    public static void testCreateFolds() {
        Dataset<String, String> data = new Dataset<String, String>();
        ((GeneralDataset)data).add(new BasicDatum<String, String>(Arrays.asList("fever", "cough", "congestion"), "cold"));
        ((GeneralDataset)data).add(new BasicDatum<String, String>(Arrays.asList("fever", "cough", "nausea"), "flu"));
        ((GeneralDataset)data).add(new BasicDatum<String, String>(Arrays.asList("cough", "congestion"), "cold"));
        ((GeneralDataset)data).add(new BasicDatum<String, String>(Arrays.asList("cough", "congestion"), "cold"));
        ((GeneralDataset)data).add(new BasicDatum<String, String>(Arrays.asList("fever", "nausea"), "flu"));
        ((GeneralDataset)data).add(new BasicDatum<String, String>(Arrays.asList("cough", "sore throat"), "cold"));
        Pair devTrainTest = ((GeneralDataset)data).split(3, 5);
        GeneralDatasetTest.assertEquals((int)4, (int)devTrainTest.first().size());
        GeneralDatasetTest.assertEquals((int)2, (int)devTrainTest.second().size());
        GeneralDatasetTest.assertEquals((String)"cold", (String)((String)devTrainTest.first().getDatum(devTrainTest.first().size() - 1).label()));
        GeneralDatasetTest.assertEquals((String)"flu", (String)((String)devTrainTest.second().getDatum(devTrainTest.second().size() - 1).label()));
        Pair devTrainTest2 = ((GeneralDataset)data).split(0, 2);
        GeneralDatasetTest.assertEquals((int)4, (int)devTrainTest2.first().size());
        GeneralDatasetTest.assertEquals((int)2, (int)devTrainTest2.second().size());
        Pair devTrainTest3 = ((GeneralDataset)data).split(0.3333333333333333);
        GeneralDatasetTest.assertEquals((int)devTrainTest2.first().size(), (int)devTrainTest3.first().size());
        GeneralDatasetTest.assertEquals(devTrainTest2.first().labelIndex(), devTrainTest3.first().labelIndex());
        GeneralDatasetTest.assertEquals((int)devTrainTest2.second().size(), (int)devTrainTest3.second().size());
        GeneralDatasetTest.assertTrue((boolean)Arrays.equals(devTrainTest2.first().labels, devTrainTest2.first().labels));
        GeneralDatasetTest.assertTrue((boolean)Arrays.equals(devTrainTest2.second().labels, devTrainTest2.second().labels));
        ((GeneralDataset)data).add(new BasicDatum<String, String>(Arrays.asList("fever", "nausea"), "flu"));
        Pair devTrainTest4 = ((GeneralDataset)data).split(0.3333333333333333);
        GeneralDatasetTest.assertEquals((int)5, (int)devTrainTest4.first().size());
        GeneralDatasetTest.assertEquals((int)2, (int)devTrainTest4.second().size());
        Pair devTrainTest5 = ((GeneralDataset)data).split(0.125);
        GeneralDatasetTest.assertEquals((int)7, (int)devTrainTest5.first().size());
        GeneralDatasetTest.assertEquals((int)0, (int)devTrainTest5.second().size());
    }
}

