/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref.hybrid;

import edu.stanford.nlp.coref.data.CorefCluster;
import edu.stanford.nlp.coref.data.Dictionaries;
import edu.stanford.nlp.coref.data.Document;
import edu.stanford.nlp.coref.data.Mention;
import edu.stanford.nlp.coref.hybrid.HybridCorefSystem;
import edu.stanford.nlp.coref.hybrid.sieve.DiscourseMatch;
import edu.stanford.nlp.coref.hybrid.sieve.ExactStringMatch;
import edu.stanford.nlp.coref.hybrid.sieve.PreciseConstructs;
import edu.stanford.nlp.coref.hybrid.sieve.PronounMatch;
import edu.stanford.nlp.coref.hybrid.sieve.RFSieve;
import edu.stanford.nlp.coref.hybrid.sieve.RelaxedExactStringMatch;
import edu.stanford.nlp.coref.hybrid.sieve.RelaxedHeadMatch;
import edu.stanford.nlp.coref.hybrid.sieve.Sieve;
import edu.stanford.nlp.coref.hybrid.sieve.SpeakerMatch;
import edu.stanford.nlp.coref.hybrid.sieve.StrictHeadMatch1;
import edu.stanford.nlp.coref.hybrid.sieve.StrictHeadMatch2;
import edu.stanford.nlp.coref.hybrid.sieve.StrictHeadMatch3;
import edu.stanford.nlp.coref.hybrid.sieve.StrictHeadMatch4;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.math.NumberMatchingRegex;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.FileNotFoundException;
import java.text.DecimalFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;

public class HybridCorefPrinter {
    private static Redwood.RedwoodChannels log = Redwood.channels(HybridCorefPrinter.class);
    public static final DecimalFormat df = new DecimalFormat("#.####");
    public static final SpeakerMatch dcorefSpeaker = new SpeakerMatch();
    public static final DiscourseMatch dcorefDiscourse = new DiscourseMatch();
    public static final ExactStringMatch dcorefExactString = new ExactStringMatch();
    public static final RelaxedExactStringMatch dcorefRelaxedExactString = new RelaxedExactStringMatch();
    public static final PreciseConstructs dcorefPreciseConstructs = new PreciseConstructs();
    public static final StrictHeadMatch1 dcorefHead1 = new StrictHeadMatch1();
    public static final StrictHeadMatch2 dcorefHead2 = new StrictHeadMatch2();
    public static final StrictHeadMatch3 dcorefHead3 = new StrictHeadMatch3();
    public static final StrictHeadMatch4 dcorefHead4 = new StrictHeadMatch4();
    public static final RelaxedHeadMatch dcorefRelaxedHead = new RelaxedHeadMatch();
    public static final PronounMatch dcorefPronounSieve = new PronounMatch();

    public static String printRawDoc(Document document, boolean gold, boolean printClusterID) throws FileNotFoundException {
        StringBuilder sb = new StringBuilder();
        List sentences = (List)document.annotation.get(CoreAnnotations.SentencesAnnotation.class);
        StringBuilder doc = new StringBuilder();
        for (int i = 0; i < sentences.size(); ++i) {
            doc.append(HybridCorefPrinter.sentenceStringWithMention(i, document, gold, printClusterID));
            doc.append("\n");
        }
        sb.append("PRINT RAW DOC START\n");
        sb.append((String)document.annotation.get(CoreAnnotations.DocIDAnnotation.class)).append("\n");
        if (gold) {
            sb.append("New DOC: (GOLD MENTIONS) ==================================================\n");
        } else {
            sb.append("New DOC: (Predicted Mentions) ==================================================\n");
        }
        sb.append(doc.toString()).append("\n");
        sb.append("PRINT RAW DOC END").append("\n");
        return sb.toString();
    }

    public static String printErrorLog(Mention m, Document document, Counter<Integer> probs, int mIdx, Dictionaries dict, RFSieve sieve) throws Exception {
        boolean barePlural;
        int sentIdx;
        int sentDist;
        StringBuilder sb = new StringBuilder();
        sb.append("\nERROR START-----------------------------------------------------------------------\n");
        sb.append("RESOLVER TYPE: mType: " + sieve.mType + ", aType: " + sieve.aType).append("\n");
        sb.append("DOCUMENT: " + document.docInfo.get("DOC_ID") + ", " + document.docInfo.get("DOC_PART")).append("\n");
        ArrayList<Mention> orderedAnts = new ArrayList<Mention>();
        sb.append("\nGOLD CLUSTER ID\n");
        for (sentDist = m.sentNum; sentDist >= 0; --sentDist) {
            if (sentDist == sieve.maxSentDist) {
                sb.append("\tstart compare from here-------------\n");
            }
            sentIdx = m.sentNum - sentDist;
            sb.append("\tSENT " + sentIdx + "\t" + HybridCorefPrinter.sentenceStringWithMention(sentIdx, document, true, true)).append("\n");
        }
        sb.append("\nMENTION ID\n");
        for (sentDist = m.sentNum; sentDist >= 0; --sentDist) {
            if (sentDist == sieve.maxSentDist) {
                sb.append("\tstart compare from here-------------\n");
            }
            sentIdx = m.sentNum - sentDist;
            sb.append("\tSENT " + sentIdx + "\t" + HybridCorefPrinter.sentenceStringWithMention(sentIdx, document, false, false)).append("\n");
        }
        for (sentDist = 0; sentDist <= Math.min(sieve.maxSentDist, m.sentNum); ++sentDist) {
            sentIdx = m.sentNum - sentDist;
            orderedAnts.addAll(Sieve.getOrderedAntecedents(m, sentIdx, mIdx, document.predictedMentions, dict));
        }
        Map<Integer, Integer> orders = Generics.newHashMap();
        for (int i = 0; i < orderedAnts.size(); ++i) {
            Mention ant = (Mention)orderedAnts.get(i);
            orders.put(ant.mentionID, i);
        }
        CorefCluster mC = document.corefClusters.get(m.corefClusterID);
        boolean isFirstMention = HybridCorefPrinter.isFirstMention(m, document);
        boolean foundCorefAnt = probs.size() > 0 && Counters.max(probs) > sieve.thresMerge;
        boolean correctDecision = isFirstMention && !foundCorefAnt || foundCorefAnt && Sieve.isReallyCoref(document, m.mentionID, Counters.argmax(probs));
        boolean bl = barePlural = m.originalSpan.size() == 1 && m.headWord.tag().equals("NNS");
        if (correctDecision) {
            return "";
        }
        sb.append("\nMENTION: " + m.spanToString() + " (" + m.mentionID + ")\tperson: " + (Object)((Object)m.person) + "\tsingleton? " + !m.hasTwin + "\t\tisFirstMention? " + isFirstMention + "\t\tfoundAnt? " + foundCorefAnt + "\t\tcorrectDecision? " + correctDecision + "\tbarePlural? " + barePlural);
        sb.append("\n\ttype: " + (Object)((Object)m.mentionType) + "\tHeadword: " + m.headWord.word() + "\tNEtype: " + m.nerString + "\tnumber: " + (Object)((Object)m.number) + "\tgender: " + (Object)((Object)m.gender) + "\tanimacy: " + (Object)((Object)m.animacy)).append("\n");
        if (m.contextParseTree != null) {
            sb.append(m.contextParseTree.pennString());
        }
        sb.append("\n\n\t\tOracle\t\tDcoref\t\t\tRF\t\tAntecedent\n");
        for (int antID : Counters.toSortedList(probs)) {
            Mention ant = document.predictedMentionsByID.get(antID);
            CorefCluster aC = document.corefClusters.get(ant.corefClusterID);
            boolean oracle = Sieve.isReallyCoref(document, m.mentionID, antID);
            double prob = probs.getCount(antID);
            int order = (Integer)orders.get(antID);
            String oracleStr = oracle ? "coref   " : "notcoref";
            String dcorefStr = "notcoref";
            if (dcorefDiscourse.coreferent(document, mC, aC, m, ant, dict, null)) {
                dcorefStr = "coref-discourse";
            } else if (dcorefExactString.coreferent(document, mC, aC, m, ant, dict, null)) {
                dcorefStr = "coref-exactString";
            } else if (dcorefRelaxedExactString.coreferent(document, mC, aC, m, ant, dict, null)) {
                dcorefStr = "coref-relaxedExact";
            } else if (dcorefPreciseConstructs.coreferent(document, mC, aC, m, ant, dict, null)) {
                dcorefStr = "coref-preciseConstruct";
            } else if (dcorefHead1.coreferent(document, mC, aC, m, ant, dict, null)) {
                dcorefStr = "coref-head1";
            } else if (dcorefHead2.coreferent(document, mC, aC, m, ant, dict, null)) {
                dcorefStr = "coref-head2";
            } else if (dcorefHead3.coreferent(document, mC, aC, m, ant, dict, null)) {
                dcorefStr = "coref-head3";
            } else if (dcorefHead4.coreferent(document, mC, aC, m, ant, dict, null)) {
                dcorefStr = "coref-head4";
            } else if (dcorefRelaxedHead.coreferent(document, mC, aC, m, ant, dict, null)) {
                dcorefStr = "coref-relaxedHead";
            } else if (dcorefPronounSieve.coreferent(document, mC, aC, m, ant, dict, null)) {
                dcorefStr = "coref-pronounSieve";
            } else if (dcorefSpeaker.coreferent(document, mC, aC, m, ant, dict, null)) {
                dcorefStr = "coref-speaker";
            }
            dcorefStr = dcorefStr + "\t" + String.valueOf(order);
            String probStr = df.format(prob);
            sb.append("\t\t" + oracleStr + "\t" + dcorefStr + "\t" + probStr + "\t\t" + ant.spanToString() + " (" + ant.mentionID + ")\n");
        }
        sb.append("ERROR END -----------------------------------------------------------------------\n");
        return sb.toString();
    }

    static boolean isFirstMention(Mention m, Document document) {
        if (!m.hasTwin) {
            return true;
        }
        Mention twinGold = document.goldMentionsByID.get(m.mentionID);
        for (Mention coref : document.goldCorefClusters.get(twinGold.goldCorefClusterID).getCorefMentions()) {
            if (coref == twinGold || !coref.appearEarlierThan(twinGold)) continue;
            return false;
        }
        return true;
    }

    public static String sentenceStringWithMention(int i, Document document, boolean gold, boolean printClusterID) {
        StringBuilder sentStr = new StringBuilder();
        List sentences = (List)document.annotation.get(CoreAnnotations.SentencesAnnotation.class);
        List<List<Mention>> allMentions = gold ? document.goldMentions : document.predictedMentions;
        int previousOffset = 0;
        CoreMap sentence = (CoreMap)sentences.get(i);
        List<Mention> mentions = allMentions.get(i);
        List t = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        String speaker = (String)((CoreLabel)t.get(0)).get(CoreAnnotations.SpeakerAnnotation.class);
        if (NumberMatchingRegex.isDecimalInteger(speaker)) {
            speaker = speaker + ": " + document.predictedMentionsByID.get(Integer.parseInt(speaker)).spanToString();
        }
        sentStr.append("\tspeaker: " + speaker + " (" + ((CoreLabel)t.get(0)).get(CoreAnnotations.UtteranceAnnotation.class) + ") ");
        String[] tokens = new String[t.size()];
        for (CoreLabel c : t) {
            tokens[c.index() - 1] = c.word();
        }
        previousOffset = (Integer)((CoreLabel)t.get(t.size() - 1)).get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
        ClassicCounter<Integer> startCounts = new ClassicCounter<Integer>();
        ClassicCounter<Integer> endCounts = new ClassicCounter<Integer>();
        Map endMentions = Generics.newHashMap();
        for (Mention m : mentions) {
            startCounts.incrementCount(m.startIndex);
            endCounts.incrementCount(m.endIndex);
            if (!endMentions.containsKey(m.endIndex)) {
                endMentions.put(m.endIndex, new ArrayDeque());
            }
            ((Deque)endMentions.get(m.endIndex)).push(m);
        }
        for (int j = 0; j < tokens.length; ++j) {
            if (endMentions.containsKey(j)) {
                for (Mention m : (Deque)endMentions.get(j)) {
                    int id = gold ? m.goldCorefClusterID : m.corefClusterID;
                    id = printClusterID ? id : m.mentionID;
                    sentStr.append("]_").append(id);
                }
            }
            int k = 0;
            while ((double)k < startCounts.getCount(j)) {
                if (sentStr.length() > 0 && sentStr.charAt(sentStr.length() - 1) != '[') {
                    sentStr.append(" ");
                }
                sentStr.append("[");
                ++k;
            }
            if (sentStr.length() > 0 && sentStr.charAt(sentStr.length() - 1) != '[') {
                sentStr.append(" ");
            }
            sentStr.append(tokens[j]);
        }
        if (endMentions.containsKey(tokens.length)) {
            for (Mention m : (Deque)endMentions.get(tokens.length)) {
                int id = gold ? m.goldCorefClusterID : m.corefClusterID;
                id = printClusterID ? id : m.mentionID;
                sentStr.append("]_").append(id);
            }
        }
        return sentStr.toString();
    }

    public static String printMentionDetectionLog(Document document) {
        StringBuilder sbLog = new StringBuilder();
        List sentences = (List)document.annotation.get(CoreAnnotations.SentencesAnnotation.class);
        sbLog.append("\nERROR START-----------------------------------------------------------------------\n");
        for (int i = 0; i < sentences.size(); ++i) {
            sbLog.append("\nSENT ").append(i).append(" GOLD   : ").append(HybridCorefPrinter.sentenceStringWithMention(i, document, true, false)).append("\n");
            sbLog.append("SENT ").append(i).append(" PREDICT: ").append(HybridCorefPrinter.sentenceStringWithMention(i, document, false, false)).append("\n");
            for (Mention p : document.predictedMentions.get(i)) {
                sbLog.append("\n");
                if (!p.hasTwin) {
                    sbLog.append("\tSPURIOUS");
                }
                sbLog.append("\tmention: ").append(p.spanToString()).append("\t\t\theadword: ").append(p.headString).append("\tPOS: ").append(p.headWord.tag()).append("\tmentiontype: ").append((Object)p.mentionType).append("\tnumber: ").append((Object)p.number).append("\tgender: ").append((Object)p.gender).append("\tanimacy: ").append((Object)p.animacy).append("\tperson: ").append((Object)p.person).append("\tNE: ").append(p.nerString);
            }
            sbLog.append("\n");
            for (Mention g : document.goldMentions.get(i)) {
                if (g.hasTwin) continue;
                sbLog.append("\tmissed gold: ").append(g.spanToString()).append("\tPOS: ").append(g.headWord.tag()).append("\tmentiontype: ").append((Object)g.mentionType).append("\theadword: ").append(g.headString).append("\tnumber: ").append((Object)g.number).append("\tgender: ").append((Object)g.gender).append("\tanimacy: ").append((Object)g.animacy).append("\tperson: ").append((Object)g.person).append("\tNE: ").append(g.nerString).append("\n");
                if (g.sentenceWords != null && g.sentenceWords.size() > g.endIndex) {
                    sbLog.append("\tnextword: ").append(g.sentenceWords.get(g.endIndex)).append("\t").append(g.sentenceWords.get(g.endIndex).tag()).append("\n");
                }
                if (g.contextParseTree != null) {
                    sbLog.append(g.contextParseTree.pennString()).append("\n\n");
                    continue;
                }
                sbLog.append("\n\n");
            }
            if (((CoreMap)sentences.get(i)).get(TreeCoreAnnotations.TreeAnnotation.class) != null) {
                sbLog.append("\n\tparse: \n").append(((Tree)((CoreMap)sentences.get(i)).get(TreeCoreAnnotations.TreeAnnotation.class)).pennString());
            }
            sbLog.append("\n\tcollapsedDependency: \n").append(((CoreMap)sentences.get(i)).get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class));
        }
        sbLog.append("ERROR END -----------------------------------------------------------------------\n");
        return sbLog.toString();
    }

    public static String printErrorLogDcoref(Mention m, Mention found, Document document, Dictionaries dict, int mIdx, String whichResolver) throws Exception {
        int sentIdx;
        int sentDist;
        StringBuilder sb = new StringBuilder();
        sb.append("\nERROR START-----------------------------------------------------------------------\n");
        sb.append("RESOLVER TYPE: ").append(whichResolver).append("\n");
        sb.append("DOCUMENT: " + document.docInfo.get("DOC_ID") + ", " + document.docInfo.get("DOC_PART")).append("\n");
        ArrayList<Mention> orderedAnts = new ArrayList<Mention>();
        sb.append("\nGOLD CLUSTER ID\n");
        for (sentDist = m.sentNum; sentDist >= 0; --sentDist) {
            sentIdx = m.sentNum - sentDist;
            sb.append("\tSENT " + sentIdx + "\t" + HybridCorefPrinter.sentenceStringWithMention(sentIdx, document, true, true)).append("\n");
        }
        sb.append("\nMENTION ID\n");
        for (sentDist = m.sentNum; sentDist >= 0; --sentDist) {
            sentIdx = m.sentNum - sentDist;
            sb.append("\tSENT " + sentIdx + "\t" + HybridCorefPrinter.sentenceStringWithMention(sentIdx, document, false, false)).append("\n");
        }
        for (sentDist = 0; sentDist <= m.sentNum; ++sentDist) {
            sentIdx = m.sentNum - sentDist;
            orderedAnts.addAll(Sieve.getOrderedAntecedents(m, sentIdx, mIdx, document.predictedMentions, dict));
        }
        Map<Integer, Integer> orders = Generics.newHashMap();
        for (int i = 0; i < orderedAnts.size(); ++i) {
            Mention ant = (Mention)orderedAnts.get(i);
            orders.put(ant.mentionID, i);
        }
        CorefCluster mC = document.corefClusters.get(m.corefClusterID);
        boolean isFirstMention = HybridCorefPrinter.isFirstMention(m, document);
        boolean foundCorefAnt = true;
        boolean correctDecision = document.isCoref(m, found);
        if (correctDecision) {
            return "";
        }
        sb.append("\nMENTION: " + m.spanToString() + " (" + m.mentionID + ")\tperson: " + (Object)((Object)m.person) + "\tsingleton? " + !m.hasTwin + "\t\tisFirstMention? " + isFirstMention + "\t\tfoundAnt? " + foundCorefAnt + "\t\tcorrectDecision? " + correctDecision);
        sb.append("\n\ttype: " + (Object)((Object)m.mentionType) + "\tHeadword: " + m.headWord.word() + "\tNEtype: " + m.nerString + "\tnumber: " + (Object)((Object)m.number) + "\tgender: " + (Object)((Object)m.gender) + "\tanimacy: " + (Object)((Object)m.animacy)).append("\n");
        if (m.contextParseTree != null) {
            sb.append(m.contextParseTree.pennString());
        }
        sb.append("\n\n\t\tOracle\t\tDcoref\t\t\tRF\t\tAntecedent\n");
        for (Mention ant : orderedAnts) {
            int antID = ant.mentionID;
            CorefCluster aC = document.corefClusters.get(ant.corefClusterID);
            boolean oracle = Sieve.isReallyCoref(document, m.mentionID, antID);
            int order = (Integer)orders.get(antID);
            String oracleStr = oracle ? "coref   " : "notcoref";
            String dcorefStr = "notcoref";
            if (dcorefSpeaker.coreferent(document, mC, aC, m, ant, dict, null)) {
                dcorefStr = "coref-speaker";
            } else if (dcorefDiscourse.coreferent(document, mC, aC, m, ant, dict, null)) {
                dcorefStr = "coref-discourse";
            } else if (dcorefExactString.coreferent(document, mC, aC, m, ant, dict, null)) {
                dcorefStr = "coref-exactString";
            } else if (dcorefRelaxedExactString.coreferent(document, mC, aC, m, ant, dict, null)) {
                dcorefStr = "coref-relaxedExact";
            } else if (dcorefPreciseConstructs.coreferent(document, mC, aC, m, ant, dict, null)) {
                dcorefStr = "coref-preciseConstruct";
            } else if (dcorefHead1.coreferent(document, mC, aC, m, ant, dict, null)) {
                dcorefStr = "coref-head1";
            } else if (dcorefHead2.coreferent(document, mC, aC, m, ant, dict, null)) {
                dcorefStr = "coref-head2";
            } else if (dcorefHead3.coreferent(document, mC, aC, m, ant, dict, null)) {
                dcorefStr = "coref-head3";
            } else if (dcorefHead4.coreferent(document, mC, aC, m, ant, dict, null)) {
                dcorefStr = "coref-head4";
            } else if (dcorefRelaxedHead.coreferent(document, mC, aC, m, ant, dict, null)) {
                dcorefStr = "coref-relaxedHead";
            } else if (dcorefPronounSieve.coreferent(document, mC, aC, m, ant, dict, null)) {
                dcorefStr = "coref-pronounSieve";
            }
            dcorefStr = dcorefStr + "\t" + String.valueOf(order);
            sb.append("\t\t" + oracleStr + "\t" + dcorefStr + "\t\t" + ant.spanToString() + " (" + ant.mentionID + ")\n");
        }
        sb.append("ERROR END -----------------------------------------------------------------------\n");
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static void linkDistanceAnalysis(String[] args) throws Exception {
        props = StringUtils.argsToProperties(args);
        cs = new HybridCorefSystem(props);
        cs.docMaker.resetDocs();
        proper = new ClassicCounter<Integer>();
        common = new ClassicCounter<Integer>();
        pronoun = new ClassicCounter<Integer>();
        list = new ClassicCounter<Integer>();
        while ((document = cs.docMaker.nextDoc()) != null) {
            for (sentIdx = 0; sentIdx < document.predictedMentions.size(); ++sentIdx) {
                predictedInSent = document.predictedMentions.get(sentIdx);
                block8: for (mIdx = 0; mIdx < predictedInSent.size(); ++mIdx) {
                    m = predictedInSent.get(mIdx);
                    for (distance = 0; distance <= sentIdx; ++distance) {
                        candidates = Sieve.getOrderedAntecedents(m, sentIdx - distance, mIdx, document.predictedMentions, cs.dictionaries);
lbl15:
                        // 5 sources

                        for (Mention candidate : candidates) {
                            if (candidate == m || distance == 0 && m.appearEarlierThan(candidate) || candidate.goldCorefClusterID != m.goldCorefClusterID) continue;
                            switch (1.$SwitchMap$edu$stanford$nlp$coref$data$Dictionaries$MentionType[m.mentionType.ordinal()]) {
                                case 1: {
                                    if (candidate.mentionType == Dictionaries.MentionType.NOMINAL || candidate.mentionType == Dictionaries.MentionType.PROPER) {
                                        common.incrementCount(distance);
                                        continue block8;
                                    }
                                    ** GOTO lbl15
                                }
                                case 2: {
                                    if (candidate.mentionType == Dictionaries.MentionType.PROPER) {
                                        proper.incrementCount(distance);
                                        continue block8;
                                    }
                                    ** GOTO lbl15
                                }
                                case 3: {
                                    pronoun.incrementCount(distance);
                                    continue block8;
                                }
                                case 4: {
                                    if (candidate.mentionType == Dictionaries.MentionType.LIST) {
                                        list.incrementCount(distance);
                                        continue block8;
                                    } else {
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        System.out.println("PROPER -------------------------------------------");
        Counters.printCounterSortedByKeys(proper);
        System.out.println("COMMON -------------------------------------------");
        Counters.printCounterSortedByKeys(common);
        System.out.println("PRONOUN -------------------------------------------");
        Counters.printCounterSortedByKeys(pronoun);
        System.out.println("LIST -------------------------------------------");
        Counters.printCounterSortedByKeys(list);
        HybridCorefPrinter.log.info(new Object[0]);
    }

    public static void main(String[] args) throws Exception {
        HybridCorefPrinter.linkDistanceAnalysis(args);
    }
}

