/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.fsm;

import edu.stanford.nlp.fsm.DFSA;
import edu.stanford.nlp.fsm.DFSAState;
import edu.stanford.nlp.fsm.DFSATransition;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.FastDisjointSet;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.UnorderedPair;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DFSAMinimizer {
    private static Redwood.RedwoodChannels log = Redwood.channels(DFSAMinimizer.class);
    static boolean debug = false;

    private DFSAMinimizer() {
    }

    public static <T, S> void unweightedMinimize(DFSA<T, S> dfsa) {
        int j;
        int i;
        Set<DFSAState<T, S>> states = dfsa.states();
        long time = System.currentTimeMillis();
        if (debug) {
            time = System.currentTimeMillis();
            log.info("\nStarting on " + dfsa.dfsaID);
            log.info(" -- " + states.size() + " states.");
        }
        int numStates = states.size();
        int id = 0;
        DFSAState[] state = (DFSAState[])ErasureUtils.uncheckedCast(new DFSAState[numStates]);
        Map<DFSAState<T, S>, Integer> stateToID = Generics.newHashMap();
        Iterator<DFSAState<T, S>> iterator = states.iterator();
        while (iterator.hasNext()) {
            DFSAState<T, S> state1;
            state[id] = state1 = iterator.next();
            stateToID.put(state1, id);
            ++id;
        }
        boolean[][] distinct = new boolean[numStates][numStates];
        List[][] dependentList = (List[][])ErasureUtils.uncheckedCast(new List[numStates][numStates]);
        for (i = 0; i < numStates; ++i) {
            for (j = i + 1; j < numStates; ++j) {
                distinct[i][j] = state[i].isAccepting() != state[j].isAccepting();
            }
        }
        if (debug) {
            log.info("Initialized: " + (System.currentTimeMillis() - time));
            time = System.currentTimeMillis();
        }
        for (i = 0; i < numStates; ++i) {
            for (j = i + 1; j < numStates; ++j) {
                if (distinct[i][j]) continue;
                DFSAState state1 = state[i];
                DFSAState state2 = state[j];
                IntPair ip = new IntPair(i, j);
                Set inputs = Generics.newHashSet();
                inputs.addAll(state1.continuingInputs());
                inputs.addAll(state2.continuingInputs());
                boolean distinguishable = false;
                Set<IntPair> pendingIPairs = Generics.newHashSet();
                Iterator inputI = inputs.iterator();
                while (inputI.hasNext() && !distinguishable) {
                    DFSATransition transition2;
                    Object input = inputI.next();
                    DFSATransition transition1 = state1.transition(input);
                    if (transition1 == null != ((transition2 = state2.transition(input)) == null)) {
                        distinguishable = true;
                    }
                    if (transition1 == null || transition2 == null) continue;
                    DFSAState target1 = transition1.getTarget();
                    DFSAState target2 = transition2.getTarget();
                    int num1 = (Integer)stateToID.get(target1);
                    int num2 = (Integer)stateToID.get(target2);
                    IntPair targetIPair = new IntPair(num1, num2);
                    if (num1 == num2) continue;
                    if (distinct[num1][num2]) {
                        distinguishable = true;
                        continue;
                    }
                    pendingIPairs.add(targetIPair);
                }
                if (distinguishable) {
                    ArrayList<IntPair> markStack = new ArrayList<IntPair>();
                    markStack.add(ip);
                    while (!markStack.isEmpty()) {
                        IntPair ipToMark = (IntPair)markStack.get(markStack.size() - 1);
                        markStack.remove(markStack.size() - 1);
                        distinct[ipToMark.i][ipToMark.j] = true;
                        List addList = dependentList[ipToMark.i][ipToMark.j];
                        if (addList == null) continue;
                        markStack.addAll(addList);
                    }
                    continue;
                }
                for (IntPair pendingIPair : pendingIPairs) {
                    ArrayList<IntPair> dependentList1 = dependentList[pendingIPair.i][pendingIPair.j];
                    if (dependentList1 == null) {
                        dependentList[pendingIPair.i][pendingIPair.j] = dependentList1 = new ArrayList<IntPair>();
                    }
                    dependentList1.add(ip);
                }
            }
        }
        if (debug) {
            log.info("All pairs marked: " + (System.currentTimeMillis() - time));
            time = System.currentTimeMillis();
        }
        FastDisjointSet<DFSAState<DFSAState<T, S>, S>> stateClasses = new FastDisjointSet<DFSAState<DFSAState<T, S>, S>>(states);
        for (int i2 = 0; i2 < numStates; ++i2) {
            for (int j2 = i2 + 1; j2 < numStates; ++j2) {
                if (distinct[i2][j2]) continue;
                DFSAState<T, S> state1 = state[i2];
                DFSAState state2 = state[j2];
                stateClasses.union(state1, state2);
            }
        }
        Map<DFSAState<T, S>, DFSAState<T, S>> stateToRep = Generics.newHashMap();
        for (DFSAState<T, S> state1 : states) {
            DFSAState<T, S> rep = stateClasses.find(state1);
            stateToRep.put(state1, rep);
        }
        if (debug) {
            log.info("Canonical states chosen: " + (System.currentTimeMillis() - time));
            time = System.currentTimeMillis();
        }
        for (DFSAState<T, S> state1 : states) {
            if (!state1.equals(stateToRep.get(state1))) continue;
            for (DFSATransition<T, S> transition : state1.transitions()) {
                transition.target = (DFSAState)stateToRep.get(transition.target);
            }
        }
        dfsa.initialState = (DFSAState)stateToRep.get(dfsa.initialState);
        if (debug) {
            log.info("Done: " + (System.currentTimeMillis() - time));
        }
    }

    static <T, S> void unweightedMinimizeOld(DFSA<T, S> dfsa) {
        Set<DFSAState<T, S>> states = dfsa.states();
        Map stateUPairToDependentUPairList = Generics.newHashMap(states.size() * states.size() / 2 + 1);
        Map<UnorderedPair, Boolean> stateUPairToDistinguished = Generics.newHashMap(states.size() * states.size() / 2 + 1);
        int[] c = new int[states.size() * states.size() / 2 + 1];
        int streak = 0;
        int collisions = 0;
        int entries = 0;
        long time = System.currentTimeMillis();
        if (debug) {
            time = System.currentTimeMillis();
            log.info("Starting on " + dfsa.dfsaID);
            log.info(" -- " + states.size() + " states.");
        }
        int numDone = 0;
        for (DFSAState<T, S> state1 : states) {
            for (DFSAState<T, S> dFSAState : states) {
                int bucket;
                UnorderedPair<DFSAState<T, S>, DFSAState<T, S>> up = new UnorderedPair<DFSAState<T, S>, DFSAState<T, S>>(state1, dFSAState);
                if (state1.equals(dFSAState) || stateUPairToDistinguished.containsKey(up)) continue;
                int n = bucket = (up.hashCode() & Integer.MAX_VALUE) % (states.size() * states.size() / 2 + 1);
                c[n] = c[n] + 1;
                ++entries;
                if (c[bucket] > 1) {
                    ++collisions;
                    streak = 0;
                } else {
                    ++streak;
                }
                if (state1.isAccepting() != dFSAState.isAccepting()) {
                    stateUPairToDistinguished.put(up, Boolean.TRUE);
                    continue;
                }
                stateUPairToDistinguished.put(up, Boolean.FALSE);
            }
            if (++numDone % 20 != 0) continue;
            log.info("\r" + numDone + "  " + (double)collisions / (double)entries);
        }
        if (debug) {
            log.info("\nInitialized: " + (System.currentTimeMillis() - time));
            time = System.currentTimeMillis();
        }
        for (Object up : stateUPairToDistinguished.keySet()) {
            DFSAState state1 = (DFSAState)((UnorderedPair)up).first;
            DFSAState dFSAState = (DFSAState)((UnorderedPair)up).second;
            if (((Boolean)stateUPairToDistinguished.get(up)).equals(Boolean.TRUE)) continue;
            Set inputs = Generics.newHashSet(state1.continuingInputs());
            inputs.addAll(dFSAState.continuingInputs());
            boolean distinguishable = false;
            Set pendingUPairs = Generics.newHashSet();
            Iterator inputI = inputs.iterator();
            while (inputI.hasNext() && !distinguishable) {
                DFSATransition transition2;
                Object input = inputI.next();
                DFSATransition dFSATransition = state1.transition(input);
                if (dFSATransition == null != ((transition2 = dFSAState.transition(input)) == null)) {
                    distinguishable = true;
                }
                if (dFSATransition == null || transition2 == null) continue;
                DFSAState target1 = dFSATransition.getTarget();
                DFSAState target2 = transition2.getTarget();
                UnorderedPair targetUPair = new UnorderedPair(target1, target2);
                if (target1.equals(target2)) continue;
                if (((Boolean)stateUPairToDistinguished.get(targetUPair)).equals(Boolean.TRUE)) {
                    distinguishable = true;
                    continue;
                }
                pendingUPairs.add(targetUPair);
            }
            if (distinguishable) {
                ArrayList<Object> markStack = new ArrayList<Object>();
                markStack.add(up);
                while (!markStack.isEmpty()) {
                    UnorderedPair unorderedPair = (UnorderedPair)markStack.get(markStack.size() - 1);
                    markStack.remove(markStack.size() - 1);
                    stateUPairToDistinguished.put(unorderedPair, Boolean.TRUE);
                    List addList = (List)stateUPairToDependentUPairList.get(unorderedPair);
                    if (addList == null) continue;
                    markStack.addAll(addList);
                    ((List)stateUPairToDependentUPairList.get(unorderedPair)).clear();
                }
                continue;
            }
            for (UnorderedPair unorderedPair : pendingUPairs) {
                ArrayList<Object> dependentList = (ArrayList<Object>)stateUPairToDependentUPairList.get(unorderedPair);
                if (dependentList == null) {
                    dependentList = new ArrayList<Object>();
                    stateUPairToDependentUPairList.put(unorderedPair, dependentList);
                }
                dependentList.add(up);
            }
        }
        if (debug) {
            log.info("All pairs marked: " + (System.currentTimeMillis() - time));
            time = System.currentTimeMillis();
        }
        FastDisjointSet stateClasses = new FastDisjointSet(states);
        for (UnorderedPair up : stateUPairToDistinguished.keySet()) {
            if (!((Boolean)stateUPairToDistinguished.get(up)).equals(Boolean.FALSE)) continue;
            DFSAState dFSAState = (DFSAState)up.first;
            DFSAState state2 = (DFSAState)up.second;
            stateClasses.union(dFSAState, state2);
        }
        Map<DFSAState<T, S>, DFSAState<T, S>> stateToRep = Generics.newHashMap();
        for (DFSAState<T, S> dFSAState : states) {
            DFSAState<T, S> rep = stateClasses.find(dFSAState);
            stateToRep.put(dFSAState, rep);
        }
        if (debug) {
            log.info("Canonical states chosen: " + (System.currentTimeMillis() - time));
            time = System.currentTimeMillis();
        }
        for (DFSAState<T, S> dFSAState : states) {
            if (!dFSAState.equals(stateToRep.get(dFSAState))) continue;
            for (DFSATransition<T, S> transition : dFSAState.transitions()) {
                transition.target = stateClasses.find(transition.target);
            }
        }
        dfsa.initialState = stateClasses.find(dfsa.initialState);
        if (debug) {
            log.info("Done: " + (System.currentTimeMillis() - time));
        }
    }

    static class IntPair {
        int i;
        int j;

        IntPair(int i, int j) {
            this.i = i;
            this.j = j;
        }
    }
}

