/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.crf.TestThreadedCRFClassifier;
import java.util.Properties;
import junit.framework.TestCase;

public class ThreadedCRFClassifierITest
extends TestCase {
    Properties props;
    private static final String german1 = "edu/stanford/nlp/models/ner/german.conll.germeval2014.hgc_175m_600.crf.ser.gz";
    private static final String germanTestFile = "/u/nlp/data/german/ner/2016/deu.io.f15.utf8.testa";
    private static final String english1 = "/u/nlp/data/ner/goodClassifiers/english.all.3class.nodistsim.crf.ser.gz";
    private static final String english2 = "/u/nlp/data/ner/goodClassifiers/english.conll.4class.distsim.crf.ser.gz";
    private static final String englishTestFile = "/u/nlp/data/ner/column_data/conll.4class.testa";
    private static final String germanEncoding = "utf-8";
    private static final String englishEncoding = "utf-8";

    public void setUp() {
        this.props = new Properties();
    }

    public void testOneEnglishCRF() {
        this.props.setProperty("crf1", english1);
        this.props.setProperty("testFile", englishTestFile);
        this.props.setProperty("inputEncoding", "utf-8");
        TestThreadedCRFClassifier.runTest(this.props);
    }

    public void testOneGermanCRF() {
        this.props.setProperty("crf1", german1);
        this.props.setProperty("testFile", germanTestFile);
        this.props.setProperty("inputEncoding", "utf-8");
        TestThreadedCRFClassifier.runTest(this.props);
    }

    public void testTwoEnglishCRFs() {
        this.props.setProperty("crf1", english1);
        this.props.setProperty("crf2", english2);
        this.props.setProperty("testFile", englishTestFile);
        this.props.setProperty("inputEncoding", "utf-8");
        TestThreadedCRFClassifier.runTest(this.props);
    }
}

