/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.logging.StanfordRedwoodConfiguration;
import java.io.File;
import java.util.List;
import java.util.Scanner;
import org.junit.Assert;
import org.junit.Test;

public class TrainCRFClassifierSlowITest {
    private static final String crfTrainingWorkingDir = "/u/scr/nlp/data/stanford-corenlp-testing/crf-classifier-training";

    @Test
    public void testGermanCRFClassifierTraining() throws Exception {
        StanfordRedwoodConfiguration.apply(PropertiesUtils.asProperties("log.file", "/u/scr/nlp/data/stanford-corenlp-testing/crf-classifier-training/german-crf.results"));
        File originalModelFile = new File(crfTrainingWorkingDir, "german.hgc_175m_600.crf.ser.gz");
        originalModelFile.delete();
        CRFClassifier.main(new String[]{"-props", "edu/stanford/nlp/models/ner/german-2018.hgc_175m_600.prop", "-serializeTo", "/u/scr/nlp/data/stanford-corenlp-testing/crf-classifier-training/german.hgc_175m_600.crf.ser.gz"});
        List<String> germanTrainingResults = IOUtils.linesFromFile("/u/scr/nlp/data/stanford-corenlp-testing/crf-classifier-training/german-crf.results");
        String lastLineOfResults = germanTrainingResults.get(germanTrainingResults.size() - 1);
        Scanner scanner = new Scanner(lastLineOfResults);
        scanner.next();
        double p = scanner.nextDouble();
        Assert.assertEquals((String)"Precision outside target range", (double)0.8364, (double)p, (double)0.001);
        double r = scanner.nextDouble();
        Assert.assertEquals((String)"Recall outside target range", (double)0.6924, (double)r, (double)0.001);
        double f1 = scanner.nextDouble();
        Assert.assertEquals((String)"Precision outside target range", (double)0.7576, (double)f1, (double)0.001);
    }
}

