/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.qe;

public class Unit {
    protected String name;
    protected String symbol;
    protected String type;
    protected String system;
    protected String prefixSystem;
    protected Unit defaultUnit;
    protected double defaultUnitScale = 1.0;

    public Unit(String name, String symbol, String type) {
        this.name = name;
        this.symbol = symbol;
        this.type = type;
    }

    public Unit(String name, String symbol, String type, Unit defaultUnit, double defaultUnitScale) {
        this.name = name;
        this.symbol = symbol;
        this.type = type;
        this.defaultUnit = defaultUnit;
        this.defaultUnitScale = defaultUnitScale;
    }

    public String format(double amount) {
        return String.valueOf(amount) + this.symbol;
    }

    public String formatInDefaultUnit(double amount) {
        if (this.defaultUnit != null && this.defaultUnit != this) {
            return this.defaultUnit.formatInDefaultUnit(amount * this.defaultUnitScale);
        }
        return this.format(amount);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Unit getDefaultUnit() {
        return this.defaultUnit;
    }

    public void setDefaultUnit(Unit defaultUnit) {
        this.defaultUnit = defaultUnit;
    }

    public double getDefaultUnitScale() {
        return this.defaultUnitScale;
    }

    public void setDefaultUnitScale(double defaultUnitScale) {
        this.defaultUnitScale = defaultUnitScale;
    }
}

