/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.regexp;

import edu.stanford.nlp.ie.regexp.RegexNERSequenceClassifier;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RegexNERSequenceClassifierTest {
    private static File tempFile;
    private static final String[] words;
    private static final String[] tags;
    private static final String[] ner;
    private static final String[] expectedUncased;
    private static final String[] expectedCased;
    private static final String[] nerPatterns;
    private static final String[][] expectedNER;
    public List<List<CoreLabel>> sentences;
    private List<List<CoreLabel>> NERsentences;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() throws IOException {
        Class<RegexNERSequenceClassifierTest> clazz = RegexNERSequenceClassifierTest.class;
        synchronized (RegexNERSequenceClassifierTest.class) {
            if (tempFile == null) {
                tempFile = File.createTempFile("regexnertest.patterns", "txt");
                FileWriter fout = new FileWriter(tempFile);
                BufferedWriter bout = new BufferedWriter(fout);
                bout.write("sausage\tfood\n");
                bout.write("(avocet|curlew)(s?)\tshorebird\n");
                bout.write("shoreline park\tpark\n");
                bout.flush();
                fout.close();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.sentences = new ArrayList<List<CoreLabel>>();
            this.NERsentences = new ArrayList<List<CoreLabel>>();
            Assert.assertEquals((long)words.length, (long)tags.length);
            Assert.assertEquals((long)words.length, (long)ner.length);
            for (int snum = 0; snum < words.length; ++snum) {
                String[] wordPieces = words[snum].split(" ");
                String[] tagPieces = tags[snum].split(" ");
                String[] nerPieces = ner[snum].split(" ");
                Assert.assertEquals((long)wordPieces.length, (long)tagPieces.length);
                Assert.assertEquals((String)("Input " + snum + " " + words[snum] + " of different length than " + ner[snum]), (long)wordPieces.length, (long)nerPieces.length);
                ArrayList<CoreLabel> sentence = new ArrayList<CoreLabel>();
                ArrayList<CoreLabel> NERsentence = new ArrayList<CoreLabel>();
                for (int wnum = 0; wnum < wordPieces.length; ++wnum) {
                    CoreLabel token = new CoreLabel();
                    token.setWord(wordPieces[wnum]);
                    token.setTag(tagPieces[wnum]);
                    sentence.add(token);
                    CoreLabel NERtoken = new CoreLabel();
                    NERtoken.setWord(wordPieces[wnum]);
                    NERtoken.setTag(tagPieces[wnum]);
                    NERtoken.setNER(nerPieces[wnum]);
                    NERsentence.add(NERtoken);
                }
                this.sentences.add(sentence);
                this.NERsentences.add(NERsentence);
            }
            return;
        }
    }

    private static String listToString(List<CoreLabel> sentence) {
        StringBuilder sb = null;
        for (CoreLabel cl : sentence) {
            if (sb == null) {
                sb = new StringBuilder("[");
            } else {
                sb.append(", ");
            }
            sb.append(cl.toShortString(new String[0]));
        }
        if (sb == null) {
            sb = new StringBuilder("[");
        }
        sb.append(']');
        return sb.toString();
    }

    private static List<CoreLabel> deepCopy(List<CoreLabel> in) {
        ArrayList<CoreLabel> cll = new ArrayList<CoreLabel>(in.size());
        for (CoreLabel cl : in) {
            cll.add(new CoreLabel(cl));
        }
        return cll;
    }

    private static void compareAnswers(String[] expected, List<CoreLabel> sentence) {
        Assert.assertEquals((String)("Lengths different for " + StringUtils.join(expected) + " and " + SentenceUtils.listToString(sentence)), (long)expected.length, (long)sentence.size());
        String str = "Comparing " + Arrays.toString(expected) + " and " + RegexNERSequenceClassifierTest.listToString(sentence);
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i].equals("-")) {
                Assert.assertEquals((String)str, null, sentence.get(i).get(CoreAnnotations.AnswerAnnotation.class));
                continue;
            }
            Assert.assertEquals((String)str, (Object)expected[i], sentence.get(i).get(CoreAnnotations.AnswerAnnotation.class));
        }
    }

    @Test
    public void testUncased() {
        String tempFilename = tempFile.getPath();
        RegexNERSequenceClassifier uncased = new RegexNERSequenceClassifier(tempFilename, true, false);
        RegexNERSequenceClassifierTest.checkSentences(this.sentences, uncased, expectedUncased);
    }

    private static void checkSentences(List<List<CoreLabel>> sentences, RegexNERSequenceClassifier uncased, String[] expectedOutput) {
        Assert.assertEquals((long)expectedOutput.length, (long)sentences.size());
        for (int i = 0; i < sentences.size(); ++i) {
            List<CoreLabel> sentence = RegexNERSequenceClassifierTest.deepCopy(sentences.get(i));
            uncased.classify(sentence);
            String[] answers = expectedOutput[i].split(" ");
            RegexNERSequenceClassifierTest.compareAnswers(answers, sentence);
        }
    }

    @Test
    public void testCased() {
        String tempFilename = tempFile.getPath();
        RegexNERSequenceClassifier cased = new RegexNERSequenceClassifier(tempFilename, false, false);
        RegexNERSequenceClassifierTest.checkSentences(this.sentences, cased, expectedCased);
    }

    @Test
    public void testNEROverlaps() {
        Assert.assertEquals((long)nerPatterns.length, (long)expectedNER.length);
        for (int k = 0; k < nerPatterns.length; ++k) {
            BufferedReader r1 = new BufferedReader(new StringReader(nerPatterns[k]));
            RegexNERSequenceClassifier cased = new RegexNERSequenceClassifier(r1, false, false, null);
            Assert.assertEquals((long)this.NERsentences.size(), (long)expectedNER[k].length);
            for (int i = 0; i < this.NERsentences.size(); ++i) {
                List<CoreLabel> sentence = RegexNERSequenceClassifierTest.deepCopy(this.NERsentences.get(i));
                cased.classify(sentence);
                String[] answers = expectedNER[k][i].split(" ");
                RegexNERSequenceClassifierTest.compareAnswers(answers, sentence);
            }
        }
    }

    static {
        words = new String[]{"My dog likes to eat sausage : turkey , pork , beef , etc .", "I went to Shoreline Park and saw an avocet and some curlews ( shorebirds ) ."};
        tags = new String[]{"PRP$ NN RB VBZ VBG NN : NN , NN , NN , FW .", "PRP VBD TO NNP NNP CC VBD DT NN CC DT NNS -LRB- NNP -RRB- ."};
        ner = new String[]{"O O O O O O O O O O O O O O O", "O O O LOCATION LOCATION O O O O O O O O O O O"};
        expectedUncased = new String[]{"- - - - - food - - - - - - - - -", "- - - park park - - - shorebird - - shorebird - - - -"};
        expectedCased = new String[]{"- - - - - food - - - - - - - - -", "- - - - - - - - shorebird - - shorebird - - - -"};
        nerPatterns = new String[]{"Shoreline Park\tPARK\n", "Shoreline Park\tPARK\tLOCATION\n", "Shoreline\tPARK\n", "Shoreline Park and\tPARK\tLOCATION\n", "My\tPOSS\nsausage \\:\tFOO\n", "My\tPOSS\nsausage :\tFOO\n", "My\tPOSS\n\\. \\.\tFOO\n", "\\.\tPERIOD\n", ".\tPERIOD\n", "\\(|\\)\tPAREN\n"};
        expectedNER = new String[][]{{"- - - - - - - - - - - - - - -", "- - - - - - - - - - - - - - - -"}, {"- - - - - - - - - - - - - - -", "- - - PARK PARK - - - - - - - - - - -"}, {"- - - - - - - - - - - - - - -", "- - - - - - - - - - - - - - - -"}, {"- - - - - - - - - - - - - - -", "- - - PARK PARK PARK - - - - - - - - - -"}, {"POSS - - - - FOO FOO - - - - - - - -", "- - - - - - - - - - - - - - - -"}, {"POSS - - - - FOO FOO - - - - - - - -", "- - - - - - - - - - - - - - - -"}, {"POSS - - - - - - - - - - - - - -", "- - - - - - - - - - - - - - - -"}, {"- - - - - - - - - - - - - - PERIOD", "- - - - - - - - - - - - - - - PERIOD"}, {"- - - - - - PERIOD - PERIOD - PERIOD - PERIOD - PERIOD", "PERIOD - - - - - - - - - - - PERIOD - PERIOD PERIOD"}, {"- - - - - - - - - - - - - - -", "- - - - - - - - - - - - PAREN - PAREN -"}};
    }
}

