/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.arabic.pipeline;

import edu.stanford.nlp.international.arabic.pipeline.ATBArabicDataset;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.international.arabic.ATBTreeUtils;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DecimatedArabicDataset
extends ATBArabicDataset {
    private static Redwood.RedwoodChannels log = Redwood.channels(DecimatedArabicDataset.class);
    private boolean taggedOutput = false;
    private String wordTagDelim = "_";

    @Override
    public void build() {
        if (this.options.containsKey("SPLIT")) {
            System.err.printf("%s: Ignoring split parameter for this dataset type\n", this.getClass().getName());
        } else if (this.options.containsKey("TAGDELIM")) {
            this.wordTagDelim = this.options.getProperty("TAGDELIM");
            this.taggedOutput = true;
        }
        for (File path : this.pathsToData) {
            int prevSize = this.treebank.size();
            this.treebank.loadPath(path, this.treeFileExtension, false);
            this.toStringBuffer.append(String.format(" Loaded %d trees from %s\n", this.treebank.size() - prevSize, path.getPath()));
            int n = this.treebank.size();
        }
        ArabicTreeDecimatedNormalizer tv = new ArabicTreeDecimatedNormalizer(this.outFileName, this.makeFlatFile, this.taggedOutput);
        this.treebank.apply(tv);
        this.outputFileList.addAll(tv.getFilenames());
        tv.closeOutputFiles();
    }

    public class ArabicTreeDecimatedNormalizer
    extends ATBArabicDataset.ArabicRawTreeNormalizer {
        private int treesVisited;
        private final String trainExtension = ".train";
        private final String testExtension = ".test";
        private final String devExtension = ".dev";
        private final String flatExtension = ".flat";
        private boolean makeFlatFile;
        private boolean taggedOutput;
        private Map<String, String> outFilenames;
        private Map<String, PrintWriter> outFiles;

        public ArabicTreeDecimatedNormalizer(String filePrefix, boolean makeFlat, boolean makeTagged) {
            super(null, null);
            this.treesVisited = 0;
            this.trainExtension = ".train";
            this.testExtension = ".test";
            this.devExtension = ".dev";
            this.flatExtension = ".flat";
            this.makeFlatFile = false;
            this.taggedOutput = false;
            this.makeFlatFile = makeFlat;
            this.taggedOutput = makeTagged;
            this.outFilenames = Generics.newHashMap();
            this.outFilenames.put(".train", filePrefix + ".train");
            this.outFilenames.put(".test", filePrefix + ".test");
            this.outFilenames.put(".dev", filePrefix + ".dev");
            if (this.makeFlatFile) {
                this.outFilenames.put(".train.flat", filePrefix + ".train" + ".flat");
                this.outFilenames.put(".test.flat", filePrefix + ".test" + ".flat");
                this.outFilenames.put(".dev.flat", filePrefix + ".dev" + ".flat");
            }
            this.setupOutputFiles();
        }

        private void setupOutputFiles() {
            PrintWriter outfile = null;
            String curOutFileName = "";
            try {
                this.outFiles = Generics.newHashMap();
                for (String keyForFile : this.outFilenames.keySet()) {
                    curOutFileName = this.outFilenames.get(keyForFile);
                    if (!this.makeFlatFile && curOutFileName.contains(".flat")) continue;
                    outfile = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(curOutFileName), "UTF-8")));
                    this.outFiles.put(keyForFile, outfile);
                }
            }
            catch (UnsupportedEncodingException e) {
                System.err.printf("%s: Filesystem does not support UTF-8 output\n", this.getClass().getName());
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                System.err.printf("%s: Could not open %s for writing\n", this.getClass().getName(), curOutFileName);
            }
        }

        public void closeOutputFiles() {
            for (String keyForFile : this.outFiles.keySet()) {
                this.outFiles.get(keyForFile).close();
            }
        }

        @Override
        public void visitTree(Tree t) {
            String flatString;
            if (t == null || t.value().equals("X")) {
                return;
            }
            t = t.prune(this.nullFilter, new LabeledScoredTreeFactory());
            for (Tree node : t) {
                if (!node.isPreTerminal()) continue;
                this.processPreterminal(node);
            }
            ++this.treesVisited;
            String string = flatString = this.makeFlatFile ? ATBTreeUtils.flattenTree(t) : null;
            if (this.treesVisited % 9 == 0) {
                this.write(t, this.outFiles.get(".dev"));
                if (this.makeFlatFile) {
                    this.outFiles.get(".dev.flat").println(flatString);
                }
            } else if (this.treesVisited % 10 == 0) {
                this.write(t, this.outFiles.get(".test"));
                if (this.makeFlatFile) {
                    this.outFiles.get(".test.flat").println(flatString);
                }
            } else {
                this.write(t, this.outFiles.get(".train"));
                if (this.makeFlatFile) {
                    this.outFiles.get(".train.flat").println(flatString);
                }
            }
        }

        private void write(Tree t, PrintWriter pw) {
            if (this.taggedOutput) {
                pw.println(ATBTreeUtils.taggedStringFromTree(t, DecimatedArabicDataset.this.removeEscapeTokens, DecimatedArabicDataset.this.wordTagDelim));
            } else {
                t.pennPrint(pw);
            }
        }

        public List<String> getFilenames() {
            ArrayList<String> filenames = new ArrayList<String>();
            for (String keyForFile : this.outFilenames.keySet()) {
                filenames.add(this.outFilenames.get(keyForFile));
            }
            return filenames;
        }
    }
}

