/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.arabic.pipeline;

import edu.stanford.nlp.international.arabic.IBMArabicEscaper;
import edu.stanford.nlp.international.arabic.pipeline.DefaultLexicalMapper;
import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.trees.treebank.ConfigParser;
import edu.stanford.nlp.trees.treebank.Dataset;
import edu.stanford.nlp.trees.treebank.Mapper;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IBMMTArabicDataset
implements Dataset {
    private static Redwood.RedwoodChannels log = Redwood.channels(IBMMTArabicDataset.class);
    protected Mapper lexMapper = null;
    protected final List<File> pathsToData;
    protected String outFileName;
    protected final Pattern fileNameNormalizer = Pattern.compile("\\s+");
    protected final IBMArabicEscaper escaper;
    private static final Pattern utf8ArabicChart = Pattern.compile("[\u0600-\u06ff]");
    protected final Set<String> configuredOptions = Generics.newHashSet();
    protected final Set<String> requiredOptions;
    protected final StringBuilder toStringBuffer = new StringBuilder();

    public IBMMTArabicDataset() {
        this.pathsToData = new ArrayList<File>();
        this.escaper = new IBMArabicEscaper(true);
        this.escaper.disableWarnings();
        this.requiredOptions = Generics.newHashSet();
        this.requiredOptions.add("NAME");
        this.requiredOptions.add("PATH");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build() {
        LineNumberReader infile = null;
        String currentInfile = "";
        try (PrintWriter outfile = null;){
            outfile = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outFileName), "UTF-8")));
            for (File path : this.pathsToData) {
                infile = new LineNumberReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8")));
                currentInfile = path.getPath();
                while (infile.ready()) {
                    ArrayList<Word> sent = SentenceUtils.toUntaggedList(infile.readLine().split("\\s+"));
                    for (Word token : sent) {
                        Matcher hasArabic = utf8ArabicChart.matcher(token.word());
                        if (!hasArabic.find()) continue;
                        token.setWord(this.escaper.apply(token.word()));
                        token.setWord(this.lexMapper.map(null, token.word()));
                    }
                    outfile.println(SentenceUtils.listToString(sent));
                }
                this.toStringBuffer.append(String.format(" Read %d input lines from %s", infile.getLineNumber(), path.getPath()));
            }
            infile.close();
        }
    }

    @Override
    public List<String> getFilenames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.outFileName);
        return l;
    }

    public String toString() {
        return this.toStringBuffer.toString();
    }

    @Override
    public boolean setOptions(Properties opts) {
        for (String opt : opts.stringPropertyNames()) {
            String value = opts.getProperty(opt);
            if (value == null) {
                System.err.printf("%s: Read parameter with null value (%s)\n", this.getClass().getName(), opt);
                continue;
            }
            this.configuredOptions.add(opt);
            Matcher pathMatcher = ConfigParser.matchPath.matcher(opt);
            if (pathMatcher.lookingAt()) {
                this.pathsToData.add(new File(value));
                this.configuredOptions.add("PATH");
                continue;
            }
            if (!opt.equals("NAME")) continue;
            Matcher inThisFilename = this.fileNameNormalizer.matcher(value.trim());
            this.outFileName = inThisFilename.replaceAll("-");
            this.toStringBuffer.append(String.format("Dataset Name: %s\n", value.trim()));
        }
        if (!this.configuredOptions.containsAll(this.requiredOptions)) {
            return false;
        }
        this.outFileName = this.outFileName + ".txt";
        this.lexMapper = new DefaultLexicalMapper();
        return true;
    }
}

