/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.loglinear.model;

import edu.stanford.nlp.loglinear.model.proto.ConcatVectorProto;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.DoubleUnaryOperator;

public class ConcatVector {
    private static Redwood.RedwoodChannels log = Redwood.channels(ConcatVector.class);
    private double[][] pointers;
    private boolean[] sparse;
    private boolean[] copyOnWrite;
    private static boolean loadedNative = false;

    public ConcatVector(int numComponents) {
        this.pointers = new double[numComponents][];
        this.sparse = new boolean[numComponents];
        this.copyOnWrite = new boolean[numComponents];
    }

    private ConcatVector(ConcatVector clone) {
        this.pointers = new double[clone.pointers.length][];
        this.copyOnWrite = new boolean[clone.pointers.length];
        for (int i = 0; i < clone.pointers.length; ++i) {
            if (clone.pointers[i] == null) continue;
            this.pointers[i] = clone.pointers[i];
            this.copyOnWrite[i] = true;
            clone.copyOnWrite[i] = true;
        }
        this.sparse = new boolean[clone.pointers.length];
        if (clone.pointers.length > 0) {
            System.arraycopy(clone.sparse, 0, this.sparse, 0, clone.pointers.length);
        }
    }

    public ConcatVector newEmptyClone() {
        ConcatVector clone = new ConcatVector(this.getNumberOfComponents());
        for (int i = 0; i < this.pointers.length; ++i) {
            if (this.pointers[i] == null || this.sparse[i]) continue;
            clone.pointers[i] = new double[this.pointers[i].length];
            clone.sparse[i] = false;
        }
        return clone;
    }

    public void setDenseComponent(int component, double[] values) {
        if (component >= this.pointers.length) {
            this.increaseSizeTo(component + 1);
        }
        this.pointers[component] = values;
        this.sparse[component] = false;
        this.copyOnWrite[component] = true;
    }

    public void setSparseComponent(int component, int index, double value) {
        if (component >= this.pointers.length) {
            this.increaseSizeTo(component + 1);
        }
        double[] sparseInfo = new double[]{index, value};
        this.pointers[component] = sparseInfo;
        this.sparse[component] = true;
        this.copyOnWrite[component] = false;
    }

    public double dotProduct(ConcatVector other) {
        if (loadedNative) {
            return this.dotProductNative(other);
        }
        double sum = 0.0;
        for (int i = 0; i < Math.min(this.pointers.length, other.pointers.length); ++i) {
            int sparseIndex;
            if (this.pointers[i] == null || other.pointers[i] == null) continue;
            if (this.sparse[i] && other.sparse[i]) {
                if ((int)this.pointers[i][0] != (int)other.pointers[i][0]) continue;
                sum += this.pointers[i][1] * other.pointers[i][1];
                continue;
            }
            if (this.sparse[i] && !other.sparse[i]) {
                sparseIndex = (int)this.pointers[i][0];
                if (sparseIndex < 0 || sparseIndex >= other.pointers[i].length) continue;
                sum += other.pointers[i][sparseIndex] * this.pointers[i][1];
                continue;
            }
            if (!this.sparse[i] && other.sparse[i]) {
                sparseIndex = (int)other.pointers[i][0];
                if (sparseIndex < 0 || sparseIndex >= this.pointers[i].length) continue;
                sum += this.pointers[i][sparseIndex] * other.pointers[i][1];
                continue;
            }
            for (int j = 0; j < Math.min(this.pointers[i].length, other.pointers[i].length); ++j) {
                sum += this.pointers[i][j] * other.pointers[i][j];
            }
        }
        return sum;
    }

    public ConcatVector deepClone() {
        return new ConcatVector(this);
    }

    public void addVectorInPlace(ConcatVector other, double multiple) {
        if (this.pointers == null) {
            this.pointers = new double[other.pointers.length][];
            this.sparse = new boolean[other.pointers.length];
            this.copyOnWrite = new boolean[other.pointers.length];
        } else if (this.pointers.length < other.pointers.length) {
            this.increaseSizeTo(other.pointers.length);
        }
        for (int i = 0; i < other.pointers.length; ++i) {
            int sparseIndex;
            int j;
            if (other.pointers[i] == null) continue;
            if (this.pointers[i] == null || this.pointers[i].length == 0) {
                this.sparse[i] = other.sparse[i];
                if (multiple == 1.0) {
                    this.pointers[i] = other.pointers[i];
                    this.copyOnWrite[i] = true;
                    other.copyOnWrite[i] = true;
                    continue;
                }
                if (other.sparse[i]) {
                    this.pointers[i] = new double[2];
                    this.copyOnWrite[i] = false;
                    this.pointers[i][0] = other.pointers[i][0];
                    this.pointers[i][1] = other.pointers[i][1] * multiple;
                    continue;
                }
                this.pointers[i] = new double[other.pointers[i].length];
                this.copyOnWrite[i] = false;
                for (j = 0; j < other.pointers[i].length; ++j) {
                    this.pointers[i][j] = other.pointers[i][j] * multiple;
                }
                continue;
            }
            if (this.sparse[i] && !other.sparse[i]) {
                sparseIndex = (int)this.pointers[i][0];
                double sparseValue = this.pointers[i][1];
                this.sparse[i] = false;
                this.pointers[i] = new double[Math.max(sparseIndex + 1, other.pointers[i].length)];
                this.copyOnWrite[i] = false;
                if (sparseIndex >= 0) {
                    this.pointers[i][sparseIndex] = sparseValue;
                }
                for (int j2 = 0; j2 < other.pointers[i].length; ++j2) {
                    double[] dArray = this.pointers[i];
                    int n = j2;
                    dArray[n] = dArray[n] + other.pointers[i][j2] * multiple;
                }
                continue;
            }
            if (this.sparse[i] && other.sparse[i]) {
                int mySparseIndex = (int)this.pointers[i][0];
                int otherSparseIndex = (int)other.pointers[i][0];
                if (mySparseIndex == otherSparseIndex) {
                    if (this.copyOnWrite[i]) {
                        this.pointers[i] = (double[])this.pointers[i].clone();
                        this.copyOnWrite[i] = false;
                    }
                    double[] dArray = this.pointers[i];
                    dArray[1] = dArray[1] + other.pointers[i][1] * multiple;
                    continue;
                }
                this.sparse[i] = false;
                double mySparseValue = this.pointers[i][1];
                this.pointers[i] = new double[Math.max(mySparseIndex + 1, otherSparseIndex + 1)];
                this.copyOnWrite[i] = false;
                if (mySparseIndex >= 0) {
                    this.pointers[i][mySparseIndex] = mySparseValue;
                }
                if (otherSparseIndex < 0) continue;
                this.pointers[i][otherSparseIndex] = other.pointers[i][1] * multiple;
                continue;
            }
            if (!this.sparse[i] && other.sparse[i]) {
                sparseIndex = (int)other.pointers[i][0];
                if (sparseIndex >= this.pointers[i].length) {
                    int newSize;
                    for (newSize = this.pointers[i].length; newSize <= sparseIndex; newSize *= 2) {
                    }
                    double[] denseBuf = new double[newSize];
                    System.arraycopy(this.pointers[i], 0, denseBuf, 0, this.pointers[i].length);
                    this.copyOnWrite[i] = false;
                    this.pointers[i] = denseBuf;
                }
                if (sparseIndex < 0) continue;
                if (this.copyOnWrite[i]) {
                    this.pointers[i] = (double[])this.pointers[i].clone();
                    this.copyOnWrite[i] = false;
                }
                double[] dArray = this.pointers[i];
                int n = sparseIndex;
                dArray[n] = dArray[n] + other.pointers[i][1] * multiple;
                continue;
            }
            assert (!this.sparse[i] && !other.sparse[i]);
            if (this.pointers[i].length < other.pointers[i].length) {
                double[] denseBuf = new double[other.pointers[i].length];
                System.arraycopy(this.pointers[i], 0, denseBuf, 0, this.pointers[i].length);
                this.copyOnWrite[i] = false;
                this.pointers[i] = denseBuf;
            }
            if (this.copyOnWrite[i]) {
                this.pointers[i] = (double[])this.pointers[i].clone();
                this.copyOnWrite[i] = false;
            }
            for (j = 0; j < other.pointers[i].length; ++j) {
                double[] dArray = this.pointers[i];
                int n = j;
                dArray[n] = dArray[n] + other.pointers[i][j] * multiple;
            }
        }
    }

    public void elementwiseProductInPlace(ConcatVector other) {
        for (int i = 0; i < this.pointers.length; ++i) {
            int sparseIndex;
            int j;
            if (this.pointers[i] == null) continue;
            if (this.copyOnWrite[i]) {
                this.copyOnWrite[i] = false;
                this.pointers[i] = (double[])this.pointers[i].clone();
            }
            if (i >= other.pointers.length) {
                if (this.sparse[i]) {
                    this.pointers[i][1] = 0.0;
                    continue;
                }
                for (j = 0; j < this.pointers[i].length; ++j) {
                    this.pointers[i][j] = 0.0;
                }
                continue;
            }
            if (other.pointers[i] == null) {
                this.pointers[i] = null;
                continue;
            }
            if (this.sparse[i] && other.sparse[i]) {
                if ((int)this.pointers[i][0] == (int)other.pointers[i][0]) {
                    double[] dArray = this.pointers[i];
                    dArray[1] = dArray[1] * other.pointers[i][1];
                    continue;
                }
                this.pointers[i][1] = 0.0;
                continue;
            }
            if (this.sparse[i] && !other.sparse[i]) {
                sparseIndex = (int)this.pointers[i][0];
                if (sparseIndex >= 0 && sparseIndex < other.pointers[i].length) {
                    double[] dArray = this.pointers[i];
                    dArray[1] = dArray[1] * other.pointers[i][sparseIndex];
                    continue;
                }
                this.pointers[i][1] = 0.0;
                continue;
            }
            if (!this.sparse[i] && other.sparse[i]) {
                sparseIndex = (int)other.pointers[i][0];
                double sparseValue = 0.0;
                if (sparseIndex >= 0 && sparseIndex < this.pointers[i].length) {
                    sparseValue = this.pointers[i][sparseIndex] * other.pointers[i][1];
                }
                this.sparse[i] = true;
                this.pointers[i] = new double[]{sparseIndex, sparseValue};
                continue;
            }
            for (j = 0; j < Math.min(this.pointers[i].length, other.pointers[i].length); ++j) {
                double[] dArray = this.pointers[i];
                int n = j;
                dArray[n] = dArray[n] * other.pointers[i][j];
            }
            for (j = other.pointers[i].length; j < this.pointers[i].length; ++j) {
                this.pointers[i][j] = 0.0;
            }
        }
    }

    public void mapInPlace(DoubleUnaryOperator fn) {
        for (int i = 0; i < this.pointers.length; ++i) {
            if (this.pointers[i] == null) continue;
            if (this.copyOnWrite[i]) {
                this.copyOnWrite[i] = false;
                this.pointers[i] = (double[])this.pointers[i].clone();
            }
            if (this.sparse[i]) {
                this.pointers[i][1] = fn.applyAsDouble(this.pointers[i][1]);
                continue;
            }
            for (int j = 0; j < this.pointers[i].length; ++j) {
                this.pointers[i][j] = fn.applyAsDouble(this.pointers[i][j]);
            }
        }
    }

    public int getNumberOfComponents() {
        return this.pointers.length;
    }

    public boolean isComponentSparse(int i) {
        return this.sparse[i];
    }

    public double[] getDenseComponent(int i) {
        assert (!this.sparse[i]);
        if (this.pointers[i] == null) {
            return new double[0];
        }
        return this.pointers[i];
    }

    public double getValueAt(int component, int offset) {
        if (component < this.pointers.length) {
            if (this.pointers[component] == null) {
                return 0.0;
            }
            if (this.sparse[component]) {
                int sparseIndex = (int)this.pointers[component][0];
                if (sparseIndex == offset) {
                    return this.pointers[component][1];
                }
            } else if (offset < this.pointers[component].length) {
                return this.pointers[component][offset];
            }
        }
        return 0.0;
    }

    public int getSparseIndex(int component) {
        assert (this.sparse[component]);
        return (int)this.pointers[component][0];
    }

    public void writeToStream(OutputStream stream) throws IOException {
        this.getProtoBuilder().build().writeDelimitedTo(stream);
    }

    public static ConcatVector readFromStream(InputStream stream) throws IOException {
        return ConcatVector.readFromProto(ConcatVectorProto.ConcatVector.parseDelimitedFrom(stream));
    }

    public ConcatVectorProto.ConcatVector.Builder getProtoBuilder() {
        ConcatVectorProto.ConcatVector.Builder m = ConcatVectorProto.ConcatVector.newBuilder();
        for (int i = 0; i < this.pointers.length; ++i) {
            ConcatVectorProto.ConcatVector.Component.Builder c = ConcatVectorProto.ConcatVector.Component.newBuilder();
            c.setSparse(this.sparse[i]);
            if (this.pointers[i] != null) {
                for (int j = 0; j < this.pointers[i].length; ++j) {
                    c.addData(this.pointers[i][j]);
                }
            }
            m.addComponent(c);
        }
        return m;
    }

    public static ConcatVector readFromProto(ConcatVectorProto.ConcatVector m) {
        int components = m.getComponentCount();
        ConcatVector vec = new ConcatVector();
        vec.pointers = new double[components][];
        vec.sparse = new boolean[components];
        for (int i = 0; i < components; ++i) {
            ConcatVectorProto.ConcatVector.Component c = m.getComponent(i);
            vec.sparse[i] = c.getSparse();
            int dataSize = c.getDataCount();
            vec.pointers[i] = new double[dataSize];
            for (int j = 0; j < dataSize; ++j) {
                vec.pointers[i][j] = c.getData(j);
            }
        }
        return vec;
    }

    public boolean valueEquals(ConcatVector other, double tolerance) {
        for (int i = 0; i < Math.max(this.pointers.length, other.pointers.length); ++i) {
            int size = 0;
            if (i < this.pointers.length && i < other.pointers.length && this.pointers[i] == null && other.pointers[i] == null) {
                size = 0;
            } else if (i >= this.pointers.length || i < this.pointers.length && this.pointers[i] == null) {
                size = i >= other.pointers.length ? 0 : (other.sparse[i] ? other.getSparseIndex(i) + 1 : other.pointers[i].length);
            } else if (i >= other.pointers.length || i < other.pointers.length && other.pointers[i] == null) {
                size = i >= this.pointers.length ? 0 : (this.sparse[i] ? this.getSparseIndex(i) + 1 : this.pointers[i].length);
            } else {
                if (this.sparse[i] && this.getSparseIndex(i) >= size) {
                    size = this.getSparseIndex(i) + 1;
                } else if (!this.sparse[i] && this.pointers[i].length > size) {
                    size = this.pointers[i].length;
                }
                if (other.sparse[i] && other.getSparseIndex(i) >= size) {
                    size = other.getSparseIndex(i) + 1;
                } else if (!other.sparse[i] && other.pointers[i].length > size) {
                    size = other.pointers[i].length;
                }
            }
            for (int j = 0; j < size; ++j) {
                if (!(Math.abs(this.getValueAt(i, j) - other.getValueAt(i, j)) > tolerance)) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.pointers.length; ++i) {
            sb.append(" ..");
            if (this.pointers[i] == null) {
                sb.append("0=0.0");
            } else if (this.sparse[i]) {
                sb.append((int)this.pointers[i][0]).append("=").append(this.pointers[i][1]);
            } else {
                for (int j = 0; j < this.pointers[i].length; ++j) {
                    sb.append(this.pointers[i][j]);
                    if (j == this.pointers[i].length - 1) continue;
                    sb.append(" ");
                }
            }
            sb.append("..");
        }
        sb.append(" ]");
        return sb.toString();
    }

    private void increaseSizeTo(int newSize) {
        assert (newSize > this.pointers.length);
        double[][] pointersBuf = new double[newSize][];
        boolean[] sparseBuf = new boolean[newSize];
        boolean[] copyOnWriteBuf = new boolean[newSize];
        System.arraycopy(this.pointers, 0, pointersBuf, 0, this.pointers.length);
        System.arraycopy(this.sparse, 0, sparseBuf, 0, this.pointers.length);
        System.arraycopy(this.copyOnWrite, 0, copyOnWriteBuf, 0, this.pointers.length);
        this.pointers = pointersBuf;
        this.sparse = sparseBuf;
        this.copyOnWrite = copyOnWriteBuf;
    }

    private native double dotProductNative(ConcatVector var1);

    private ConcatVector() {
    }
}

