/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.naturalli.Monotonicity;
import edu.stanford.nlp.naturalli.MonotonicityType;
import edu.stanford.nlp.naturalli.NaturalLogicRelation;
import edu.stanford.nlp.naturalli.Polarity;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class PolarityTest {
    private static final Polarity none = new Polarity((List<Pair<Monotonicity, MonotonicityType>>)new ArrayList<Pair<Monotonicity, MonotonicityType>>(){});
    private static final Polarity additive = new Polarity((List<Pair<Monotonicity, MonotonicityType>>)new ArrayList<Pair<Monotonicity, MonotonicityType>>(){
        {
            this.add(Pair.makePair(Monotonicity.MONOTONE, MonotonicityType.ADDITIVE));
        }
    });
    private static final Polarity multiplicative = new Polarity((List<Pair<Monotonicity, MonotonicityType>>)new ArrayList<Pair<Monotonicity, MonotonicityType>>(){
        {
            this.add(Pair.makePair(Monotonicity.MONOTONE, MonotonicityType.MULTIPLICATIVE));
        }
    });
    private static final Polarity antimultiplicative = new Polarity((List<Pair<Monotonicity, MonotonicityType>>)new ArrayList<Pair<Monotonicity, MonotonicityType>>(){
        {
            this.add(Pair.makePair(Monotonicity.MONOTONE, MonotonicityType.ADDITIVE));
            this.add(Pair.makePair(Monotonicity.ANTITONE, MonotonicityType.MULTIPLICATIVE));
        }
    });
    private static final Polarity additiveAntiMultiplicative = new Polarity((List<Pair<Monotonicity, MonotonicityType>>)new ArrayList<Pair<Monotonicity, MonotonicityType>>(){
        {
            this.add(Pair.makePair(Monotonicity.MONOTONE, MonotonicityType.ADDITIVE));
            this.add(Pair.makePair(Monotonicity.ANTITONE, MonotonicityType.MULTIPLICATIVE));
        }
    });
    private static final Polarity multiplicativeAntiMultiplicative = new Polarity((List<Pair<Monotonicity, MonotonicityType>>)new ArrayList<Pair<Monotonicity, MonotonicityType>>(){
        {
            this.add(Pair.makePair(Monotonicity.MONOTONE, MonotonicityType.MULTIPLICATIVE));
            this.add(Pair.makePair(Monotonicity.ANTITONE, MonotonicityType.MULTIPLICATIVE));
        }
    });

    @Test
    public void equals() {
        Assert.assertEquals((Object)multiplicative, (Object)multiplicative);
        Assert.assertEquals((Object)multiplicative, (Object)new Polarity((List<Pair<Monotonicity, MonotonicityType>>)new ArrayList<Pair<Monotonicity, MonotonicityType>>(){
            {
                this.add(Pair.makePair(Monotonicity.MONOTONE, MonotonicityType.MULTIPLICATIVE));
            }
        }));
    }

    @Test
    public void equalsString() {
        Assert.assertEquals((Object)multiplicative, (Object)"up");
        Assert.assertEquals((Object)multiplicative, (Object)"upwards");
    }

    @Test
    public void noneProject() {
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.EQUIVALENT), (Object)((Object)none.projectLexicalRelation(NaturalLogicRelation.EQUIVALENT)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.FORWARD_ENTAILMENT), (Object)((Object)none.projectLexicalRelation(NaturalLogicRelation.FORWARD_ENTAILMENT)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.REVERSE_ENTAILMENT), (Object)((Object)none.projectLexicalRelation(NaturalLogicRelation.REVERSE_ENTAILMENT)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.NEGATION), (Object)((Object)none.projectLexicalRelation(NaturalLogicRelation.NEGATION)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.ALTERNATION), (Object)((Object)none.projectLexicalRelation(NaturalLogicRelation.ALTERNATION)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.COVER), (Object)((Object)none.projectLexicalRelation(NaturalLogicRelation.COVER)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.INDEPENDENCE), (Object)((Object)none.projectLexicalRelation(NaturalLogicRelation.INDEPENDENCE)));
    }

    @Test
    public void additive_antimultiplicativeProject() {
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.EQUIVALENT), (Object)((Object)additiveAntiMultiplicative.projectLexicalRelation(NaturalLogicRelation.EQUIVALENT)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.REVERSE_ENTAILMENT), (Object)((Object)additiveAntiMultiplicative.projectLexicalRelation(NaturalLogicRelation.FORWARD_ENTAILMENT)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.FORWARD_ENTAILMENT), (Object)((Object)additiveAntiMultiplicative.projectLexicalRelation(NaturalLogicRelation.REVERSE_ENTAILMENT)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.COVER), (Object)((Object)additiveAntiMultiplicative.projectLexicalRelation(NaturalLogicRelation.NEGATION)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.COVER), (Object)((Object)additiveAntiMultiplicative.projectLexicalRelation(NaturalLogicRelation.ALTERNATION)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.INDEPENDENCE), (Object)((Object)additiveAntiMultiplicative.projectLexicalRelation(NaturalLogicRelation.COVER)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.INDEPENDENCE), (Object)((Object)additiveAntiMultiplicative.projectLexicalRelation(NaturalLogicRelation.INDEPENDENCE)));
    }

    @Test
    public void multiplicative_antimultiplicativeProject() {
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.EQUIVALENT), (Object)((Object)multiplicativeAntiMultiplicative.projectLexicalRelation(NaturalLogicRelation.EQUIVALENT)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.REVERSE_ENTAILMENT), (Object)((Object)multiplicativeAntiMultiplicative.projectLexicalRelation(NaturalLogicRelation.FORWARD_ENTAILMENT)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.FORWARD_ENTAILMENT), (Object)((Object)multiplicativeAntiMultiplicative.projectLexicalRelation(NaturalLogicRelation.REVERSE_ENTAILMENT)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.INDEPENDENCE), (Object)((Object)multiplicativeAntiMultiplicative.projectLexicalRelation(NaturalLogicRelation.NEGATION)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.INDEPENDENCE), (Object)((Object)multiplicativeAntiMultiplicative.projectLexicalRelation(NaturalLogicRelation.ALTERNATION)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.INDEPENDENCE), (Object)((Object)multiplicativeAntiMultiplicative.projectLexicalRelation(NaturalLogicRelation.COVER)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.INDEPENDENCE), (Object)((Object)multiplicativeAntiMultiplicative.projectLexicalRelation(NaturalLogicRelation.INDEPENDENCE)));
    }

    @Test
    public void additiveProject() {
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.EQUIVALENT), (Object)((Object)additive.projectLexicalRelation(NaturalLogicRelation.EQUIVALENT)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.FORWARD_ENTAILMENT), (Object)((Object)additive.projectLexicalRelation(NaturalLogicRelation.FORWARD_ENTAILMENT)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.REVERSE_ENTAILMENT), (Object)((Object)additive.projectLexicalRelation(NaturalLogicRelation.REVERSE_ENTAILMENT)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.COVER), (Object)((Object)additive.projectLexicalRelation(NaturalLogicRelation.NEGATION)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.INDEPENDENCE), (Object)((Object)additive.projectLexicalRelation(NaturalLogicRelation.ALTERNATION)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.COVER), (Object)((Object)additive.projectLexicalRelation(NaturalLogicRelation.COVER)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.INDEPENDENCE), (Object)((Object)additive.projectLexicalRelation(NaturalLogicRelation.INDEPENDENCE)));
    }

    @Test
    public void antimultiplicativeProject() {
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.EQUIVALENT), (Object)((Object)antimultiplicative.projectLexicalRelation(NaturalLogicRelation.EQUIVALENT)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.REVERSE_ENTAILMENT), (Object)((Object)antimultiplicative.projectLexicalRelation(NaturalLogicRelation.FORWARD_ENTAILMENT)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.FORWARD_ENTAILMENT), (Object)((Object)antimultiplicative.projectLexicalRelation(NaturalLogicRelation.REVERSE_ENTAILMENT)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.COVER), (Object)((Object)antimultiplicative.projectLexicalRelation(NaturalLogicRelation.NEGATION)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.COVER), (Object)((Object)antimultiplicative.projectLexicalRelation(NaturalLogicRelation.ALTERNATION)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.INDEPENDENCE), (Object)((Object)antimultiplicative.projectLexicalRelation(NaturalLogicRelation.COVER)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.INDEPENDENCE), (Object)((Object)antimultiplicative.projectLexicalRelation(NaturalLogicRelation.INDEPENDENCE)));
    }

    @Test
    public void multiplicativeTruth() {
        Assert.assertEquals((Object)true, (Object)multiplicative.maintainsTruth(NaturalLogicRelation.EQUIVALENT));
        Assert.assertEquals((Object)true, (Object)multiplicative.maintainsTruth(NaturalLogicRelation.FORWARD_ENTAILMENT));
        Assert.assertEquals((Object)false, (Object)multiplicative.maintainsTruth(NaturalLogicRelation.REVERSE_ENTAILMENT));
        Assert.assertEquals((Object)false, (Object)multiplicative.maintainsTruth(NaturalLogicRelation.NEGATION));
        Assert.assertEquals((Object)false, (Object)multiplicative.maintainsTruth(NaturalLogicRelation.ALTERNATION));
        Assert.assertEquals((Object)false, (Object)multiplicative.maintainsTruth(NaturalLogicRelation.COVER));
        Assert.assertEquals((Object)false, (Object)multiplicative.maintainsTruth(NaturalLogicRelation.INDEPENDENCE));
        Assert.assertEquals((Object)false, (Object)multiplicative.negatesTruth(NaturalLogicRelation.EQUIVALENT));
        Assert.assertEquals((Object)false, (Object)multiplicative.negatesTruth(NaturalLogicRelation.FORWARD_ENTAILMENT));
        Assert.assertEquals((Object)false, (Object)multiplicative.negatesTruth(NaturalLogicRelation.REVERSE_ENTAILMENT));
        Assert.assertEquals((Object)true, (Object)multiplicative.negatesTruth(NaturalLogicRelation.NEGATION));
        Assert.assertEquals((Object)true, (Object)multiplicative.negatesTruth(NaturalLogicRelation.ALTERNATION));
        Assert.assertEquals((Object)false, (Object)multiplicative.negatesTruth(NaturalLogicRelation.COVER));
        Assert.assertEquals((Object)false, (Object)multiplicative.negatesTruth(NaturalLogicRelation.INDEPENDENCE));
    }

    @Test
    public void upwardDownward() {
        Assert.assertEquals((Object)true, (Object)multiplicative.isUpwards());
        Assert.assertEquals((Object)true, (Object)additive.isUpwards());
        Assert.assertEquals((Object)false, (Object)antimultiplicative.isUpwards());
        Assert.assertEquals((Object)false, (Object)multiplicativeAntiMultiplicative.isUpwards());
        Assert.assertEquals((Object)false, (Object)additiveAntiMultiplicative.isUpwards());
        Assert.assertEquals((Object)false, (Object)multiplicative.isDownwards());
        Assert.assertEquals((Object)false, (Object)additive.isDownwards());
        Assert.assertEquals((Object)true, (Object)antimultiplicative.isDownwards());
        Assert.assertEquals((Object)true, (Object)multiplicativeAntiMultiplicative.isDownwards());
        Assert.assertEquals((Object)true, (Object)additiveAntiMultiplicative.isDownwards());
    }
}

