/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.dvparser;

import edu.stanford.nlp.parser.common.ArgUtils;
import edu.stanford.nlp.parser.dvparser.CombinedDVModelReranker;
import edu.stanford.nlp.parser.dvparser.DVModel;
import edu.stanford.nlp.parser.dvparser.DVModelReranker;
import edu.stanford.nlp.parser.lexparser.EvaluateTreebank;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.Reranker;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;

public class CombineDVModels {
    private static Redwood.RedwoodChannels log = Redwood.channels(CombineDVModels.class);

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        ArrayList<DVModel> dvparsers;
        String modelPath = null;
        ArrayList<String> baseModelPaths = null;
        String testTreebankPath = null;
        FileFilter testTreebankFilter = null;
        ArrayList<String> unusedArgs = new ArrayList<String>();
        int argIndex = 0;
        while (argIndex < args.length) {
            if (args[argIndex].equalsIgnoreCase("-model")) {
                modelPath = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-testTreebank")) {
                Pair<String, FileFilter> treebankDescription = ArgUtils.getTreebankDescription(args, argIndex, "-testTreebank");
                argIndex = argIndex + ArgUtils.numSubArgs(args, argIndex) + 1;
                testTreebankPath = treebankDescription.first();
                testTreebankFilter = treebankDescription.second();
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-baseModels")) {
                ++argIndex;
                baseModelPaths = new ArrayList<String>();
                while (argIndex < args.length && args[argIndex].charAt(0) != '-') {
                    baseModelPaths.add(args[argIndex++]);
                }
                if (baseModelPaths.size() != 0) continue;
                throw new IllegalArgumentException("Found an argument -baseModels with no actual models named");
            }
            unusedArgs.add(args[argIndex++]);
        }
        String[] newArgs = unusedArgs.toArray(new String[unusedArgs.size()]);
        LexicalizedParser underlyingParser = null;
        Options options = null;
        LexicalizedParser combinedParser = null;
        if (baseModelPaths != null) {
            dvparsers = new ArrayList<DVModel>();
            for (String baseModelPath : baseModelPaths) {
                log.info("Loading serialized DVParser from " + baseModelPath);
                LexicalizedParser dvparser = LexicalizedParser.loadModel(baseModelPath, new String[0]);
                Reranker reranker = dvparser.reranker;
                if (!(reranker instanceof DVModelReranker)) {
                    throw new IllegalArgumentException("Expected parsers with DVModel embedded");
                }
                dvparsers.add(((DVModelReranker)reranker).getModel());
                if (underlyingParser == null) {
                    underlyingParser = dvparser;
                    options = underlyingParser.getOp();
                    options.setOptions(newArgs);
                }
                log.info("... done");
            }
        } else {
            throw new IllegalArgumentException("Need to specify -model to load an already prepared CombinedParser");
        }
        combinedParser = LexicalizedParser.copyLexicalizedParser(underlyingParser);
        CombinedDVModelReranker reranker = new CombinedDVModelReranker(options, dvparsers);
        combinedParser.reranker = reranker;
        combinedParser.saveParserToSerialized(modelPath);
        MemoryTreebank testTreebank = null;
        if (testTreebankPath != null) {
            log.info("Reading in trees from " + testTreebankPath);
            if (testTreebankFilter != null) {
                log.info("Filtering on " + testTreebankFilter);
            }
            testTreebank = combinedParser.getOp().tlpParams.memoryTreebank();
            testTreebank.loadPath(testTreebankPath, testTreebankFilter);
            log.info("Read in " + ((Treebank)testTreebank).size() + " trees for testing");
            EvaluateTreebank evaluator = new EvaluateTreebank(combinedParser.getOp(), null, combinedParser);
            evaluator.testOnTreebank(testTreebank);
        }
    }
}

