/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.parser.lexparser.TaggerReranker;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import java.io.IOException;

public class AddTaggerToParser {
    public static void main(String[] args) throws IOException, ClassNotFoundException {
        String taggerFile = null;
        String inputFile = null;
        String outputFile = null;
        double weight = 1.0;
        int argIndex = 0;
        while (argIndex < args.length) {
            if (args[argIndex].equalsIgnoreCase("-tagger")) {
                taggerFile = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-input")) {
                inputFile = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-output")) {
                outputFile = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-weight")) {
                weight = Double.valueOf(args[argIndex + 1]);
                argIndex += 2;
                continue;
            }
            throw new IllegalArgumentException("Unknown argument: " + args[argIndex]);
        }
        LexicalizedParser parser = LexicalizedParser.loadModel(inputFile, new String[0]);
        MaxentTagger tagger = new MaxentTagger(taggerFile);
        parser.reranker = new TaggerReranker(tagger, parser.getOp());
        parser.saveParserToSerialized(outputFile);
    }
}

