/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.AbstractTreeExtractor;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.Generics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class PathExtractor
extends AbstractTreeExtractor<Map<String, List<List<String>>>> {
    private static final String END = "END";
    private Map<String, List<List<String>>> allPaths = Generics.newHashMap();
    private HeadFinder hf;

    public PathExtractor(HeadFinder hf, Options op) {
        super(op);
        this.hf = hf;
    }

    private List<List<String>> getList(String key) {
        List<List<String>> result = this.allPaths.get(key);
        if (result == null) {
            result = new ArrayList<List<String>>();
            this.allPaths.put(key, result);
        }
        return result;
    }

    @Override
    protected void tallyInternalNode(Tree lt, double weight) {
        int i;
        Tree[] children = lt.children();
        Tree headChild = this.hf.determineHead(lt);
        if (children.length == 1) {
            return;
        }
        ArrayList<String> path = new ArrayList<String>();
        int headLoc = -1;
        for (i = 0; i < children.length; ++i) {
            if (children[i] != headChild) continue;
            headLoc = i;
        }
        path.add(children[headLoc].label().value());
        if (headLoc == 0) {
            for (i = headLoc + 1; i < children.length - 1; ++i) {
                path.add(children[i].label().value() + ">");
            }
            if (this.op.trainOptions.markFinalStates) {
                path.add(children[children.length - 1].label().value() + "]");
            } else {
                path.add(children[children.length - 1].label().value() + ">");
            }
        } else {
            for (i = headLoc + 1; i < children.length; ++i) {
                path.add(children[i].label().value() + ">");
            }
            for (i = headLoc - 1; i > 0; --i) {
                path.add(children[i].label().value() + "<");
            }
            if (this.op.trainOptions.markFinalStates) {
                path.add(children[0].label().value() + "[");
            } else {
                path.add(children[0].label().value() + "<");
            }
        }
        path.add(END);
        String label = lt.label().value();
        List<List<String>> l = this.getList(label);
        l.add(path);
    }

    @Override
    public Map<String, List<List<String>>> formResult() {
        return this.allPaths;
    }
}

