/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.Reranker;
import edu.stanford.nlp.parser.lexparser.RerankerQuery;
import edu.stanford.nlp.parser.metrics.Eval;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.trees.Tree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TaggerReranker
implements Reranker {
    MaxentTagger tagger;
    Options op;
    double weight = -1.0;
    private static final long serialVersionUID = 1L;

    public TaggerReranker(MaxentTagger tagger, Options op) {
        this.tagger = tagger;
        this.op = op;
    }

    @Override
    public RerankerQuery process(List<? extends HasWord> sentence) {
        return new Query(this.tagger.tagSentence(sentence));
    }

    @Override
    public List<Eval> getEvals() {
        return Collections.emptyList();
    }

    public class Query
    implements RerankerQuery {
        final List<TaggedWord> tagged;

        public Query(List<TaggedWord> tagged) {
            this.tagged = tagged;
        }

        @Override
        public double score(Tree tree) {
            ArrayList<TaggedWord> yield = tree.taggedYield();
            int wrong = 0;
            int len = Math.min(yield.size(), this.tagged.size());
            for (int i = 0; i < len; ++i) {
                String yieldTag = TaggerReranker.this.op.langpack().basicCategory(((TaggedWord)yield.get(i)).tag());
                if (yieldTag.equals(this.tagged.get(i).tag())) continue;
                ++wrong;
            }
            return (double)wrong * TaggerReranker.this.weight;
        }
    }
}

