/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.surface;

import edu.stanford.nlp.patterns.Pattern;
import edu.stanford.nlp.patterns.SQLConnection;
import edu.stanford.nlp.patterns.surface.PatternsForEachToken;
import edu.stanford.nlp.util.ArgumentParser;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PatternsForEachTokenDB<E extends Pattern>
extends PatternsForEachToken<E> {
    @ArgumentParser.Option(name="createTable")
    boolean createTable = false;
    @ArgumentParser.Option(name="deleteExisting")
    boolean deleteExisting = false;
    @ArgumentParser.Option(name="tableName")
    String tableName = null;
    @ArgumentParser.Option(name="patternindicesTable")
    String patternindicesTable = "patternindices";
    @ArgumentParser.Option(name="deleteDBResourcesOnExit")
    boolean deleteDBResourcesOnExit = true;
    public static final int SINGLE_BATCH = 1;
    public static final int SMALL_BATCH = 4;
    public static final int MEDIUM_BATCH = 11;
    public static final int LARGE_BATCH = 51;

    public PatternsForEachTokenDB(Properties props, Map<String, Map<Integer, Set<E>>> pats) {
        ArgumentParser.fillOptions((Object)this, props);
        ArgumentParser.fillOptions(SQLConnection.class, props);
        assert (this.tableName != null) : "tableName property is null!";
        this.tableName = this.tableName.toLowerCase();
        if (this.createTable && !this.deleteExisting) {
            throw new RuntimeException("Cannot have createTable as true and deleteExisting as false!");
        }
        if (this.createTable) {
            this.createTable();
            this.createUpsertFunction();
        } else assert (this.DBTableExists()) : "Table " + this.tableName + " does not exists. Pass createTable=true to create a new table";
        if (pats != null) {
            this.addPatterns(pats);
        }
    }

    public PatternsForEachTokenDB(Properties props) {
        this(props, null);
    }

    void createTable() {
        String query = "";
        try {
            Statement stmt;
            Connection conn = SQLConnection.getConnection();
            if (this.DBTableExists() && this.deleteExisting) {
                System.out.println("deleting table " + this.tableName);
                stmt = conn.createStatement();
                query = "drop table " + this.tableName;
                stmt.execute(query);
                stmt.close();
                Statement stmtindex = conn.createStatement();
                query = "DROP INDEX IF EXISTS " + this.tableName + "_index";
                stmtindex.execute(query);
                stmtindex.close();
            }
            System.out.println("creating table " + this.tableName);
            stmt = conn.createStatement();
            query = "create table IF NOT EXISTS " + this.tableName + " (sentid text, patterns bytea); ";
            stmt.execute(query);
            stmt.close();
            conn.close();
        }
        catch (SQLException e) {
            throw new RuntimeException("Error executing query " + query + "\n" + e);
        }
    }

    @Override
    public void addPatterns(Map<String, Map<Integer, Set<E>>> pats) {
        try {
            Connection conn = null;
            PreparedStatement pstmt = null;
            conn = SQLConnection.getConnection();
            pstmt = this.getPreparedStmt(conn);
            for (Map.Entry<String, Map<Integer, Set<E>>> en : pats.entrySet()) {
                this.addPattern(en.getKey(), en.getValue(), pstmt);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            conn.commit();
            pstmt.close();
            conn.close();
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addPatterns(String id, Map<Integer, Set<E>> p) {
        try {
            PreparedStatement pstmt = null;
            Connection conn = null;
            conn = SQLConnection.getConnection();
            pstmt = this.getPreparedStmt(conn);
            this.addPattern(id, p, pstmt);
            pstmt.execute();
            conn.commit();
            pstmt.close();
            conn.close();
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void addPattern(String sentId, Map<Integer, Set<E>> patterns, PreparedStatement pstmt) throws SQLException, IOException {
        if (pstmt != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(patterns);
            byte[] patsAsBytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(patsAsBytes);
            pstmt.setBinaryStream(2, (InputStream)bais, patsAsBytes.length);
            pstmt.setObject(1, sentId);
        }
    }

    public void createUpsertFunction() {
        try {
            Connection conn = SQLConnection.getConnection();
            String s = "CREATE OR REPLACE FUNCTION upsert_patterns(sentid1 text, pats1 bytea) RETURNS VOID AS $$\nDECLARE\nBEGIN\n    UPDATE " + this.tableName + " SET patterns = pats1 WHERE sentid = sentid1;\n    IF NOT FOUND THEN\n    INSERT INTO " + this.tableName + "  values (sentid1, pats1);\n    END IF;\nEND;\n$$ LANGUAGE 'plpgsql';\n";
            Statement st = conn.createStatement();
            st.execute(s);
            conn.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void createUpsertFunctionPatternIndex() throws SQLException {
        Connection conn = SQLConnection.getConnection();
        String s = "CREATE OR REPLACE FUNCTION upsert_patternindex(tablename1 text, index1 bytea) RETURNS VOID AS $$\nDECLARE\nBEGIN\n    UPDATE " + this.patternindicesTable + " SET index = index1 WHERE  tablename = tablename1;\n    IF NOT FOUND THEN\n    INSERT INTO " + this.patternindicesTable + "  values (tablename1, index1);\n    END IF;\nEND;\n$$ LANGUAGE 'plpgsql';\n";
        Statement st = conn.createStatement();
        st.execute(s);
        conn.close();
    }

    private PreparedStatement getPreparedStmt(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
        return conn.prepareStatement("select upsert_patterns(?,?)");
    }

    @Override
    public Map<Integer, Set<E>> getPatternsForAllTokens(String sentId) {
        try {
            Connection conn = SQLConnection.getConnection();
            String query = "Select patterns from " + this.tableName + " where sentid='" + sentId + "'";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            Map<Integer, Set<Object>> patsToken = new HashMap<Integer, Set<E>>();
            if (rs.next()) {
                byte[] st = (byte[])rs.getObject(1);
                ByteArrayInputStream baip = new ByteArrayInputStream(st);
                ObjectInputStream ois = new ObjectInputStream(baip);
                patsToken = (Map)ois.readObject();
            }
            conn.close();
            return patsToken;
        }
        catch (IOException | ClassNotFoundException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean save(String dir) {
        return false;
    }

    @Override
    public void setupSearch() {
    }

    public boolean containsSentId(String sentId) {
        try {
            Connection conn = SQLConnection.getConnection();
            String query = "Select tokenid from " + this.tableName + " where sentid='" + sentId + "' limit 1";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            boolean contains = false;
            if (rs.next()) {
                contains = true;
            }
            conn.close();
            return contains;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void createIndexIfUsingDBAndNotExists() {
        try {
            Redwood.log(new Object[]{Redwood.DBG, "Creating index for " + this.tableName});
            Connection conn = SQLConnection.getConnection();
            Statement stmt = conn.createStatement();
            boolean doesnotexist = false;
            try {
                Statement stmt2 = conn.createStatement();
                String query = "SELECT '" + this.tableName + "_index'::regclass";
                stmt2.execute(query);
            }
            catch (SQLException e) {
                doesnotexist = true;
            }
            if (doesnotexist) {
                String indexquery = "create index CONCURRENTLY " + this.tableName + "_index on " + this.tableName + " using hash(\"sentid\") ";
                stmt.execute(indexquery);
                Redwood.log(new Object[]{Redwood.DBG, "Done creating index for " + this.tableName});
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean DBTableExists() {
        try {
            Connection conn = null;
            conn = SQLConnection.getConnection();
            DatabaseMetaData dbm = conn.getMetaData();
            ResultSet tables = dbm.getTables(null, null, this.tableName, null);
            if (tables.next()) {
                System.out.println("Found table " + this.tableName);
                conn.close();
                return true;
            }
            conn.close();
            return false;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, Map<Integer, Set<E>>> getPatternsForAllTokens(Collection<String> sampledSentIds) {
        try {
            HashMap<String, Map<Integer, Set<E>>> pats = new HashMap<String, Map<Integer, Set<E>>>();
            Connection conn = SQLConnection.getConnection();
            Iterator<String> iter = sampledSentIds.iterator();
            int totalNumberOfValuesLeftToBatch = sampledSentIds.size();
            while (totalNumberOfValuesLeftToBatch > 0) {
                int batchSize = 1;
                if (totalNumberOfValuesLeftToBatch >= 51) {
                    batchSize = 51;
                } else if (totalNumberOfValuesLeftToBatch >= 11) {
                    batchSize = 11;
                } else if (totalNumberOfValuesLeftToBatch >= 4) {
                    batchSize = 4;
                }
                totalNumberOfValuesLeftToBatch -= batchSize;
                StringBuilder inClause = new StringBuilder();
                for (int i = 0; i < batchSize; ++i) {
                    inClause.append('?');
                    if (i == batchSize - 1) continue;
                    inClause.append(',');
                }
                PreparedStatement stmt = conn.prepareStatement("select sentid, patterns from " + this.tableName + " where sentid in (" + inClause.toString() + ")");
                for (int i = 0; i < batchSize && iter.hasNext(); ++i) {
                    stmt.setString(i + 1, iter.next());
                }
                stmt.execute();
                ResultSet rs = stmt.getResultSet();
                while (rs.next()) {
                    String sentid = rs.getString(1);
                    byte[] st = (byte[])rs.getObject(2);
                    ByteArrayInputStream baip = new ByteArrayInputStream(st);
                    ObjectInputStream ois = new ObjectInputStream(baip);
                    pats.put(sentid, (Map)ois.readObject());
                }
            }
            conn.close();
            return pats;
        }
        catch (IOException | ClassNotFoundException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void load(String allPatternsDir) {
    }

    @Override
    public int size() {
        return Integer.MAX_VALUE;
    }
}

