/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.ProtobufAnnotationSerializer;
import edu.stanford.nlp.pipeline.WebServiceAnnotator;
import edu.stanford.nlp.util.ArgumentParser;
import edu.stanford.nlp.util.CommandLineTokenizer;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;

public class GenericWebServiceAnnotator
extends WebServiceAnnotator {
    @ArgumentParser.Option(name="generic.endpoint")
    public String annotatorEndpoint = "https://localhost:8000/";
    @ArgumentParser.Option(name="generic.requires")
    public Set<Class<? extends CoreAnnotation>> annotatorRequires;
    @ArgumentParser.Option(name="generic.provides")
    public Set<Class<? extends CoreAnnotation>> annotatorProvides;
    @ArgumentParser.Option(name="generic.start")
    public Optional<String[]> startCommand;
    @ArgumentParser.Option(name="generic.stop")
    public Optional<String[]> stopCommand;
    protected ProtobufAnnotationSerializer serializer;

    private static Set<Class<? extends CoreAnnotation>> parseClasses(String classList) {
        HashSet<Class<? extends CoreAnnotation>> ret = new HashSet<Class<? extends CoreAnnotation>>();
        for (String s : classList.split(",")) {
            if ((s = s.trim()).length() == 0) continue;
            if (!s.contains(".")) {
                s = "edu.stanford.nlp.ling.CoreAnnotations$" + s;
            }
            try {
                ret.add(Class.forName(s));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return ret;
    }

    public GenericWebServiceAnnotator(Properties props) {
        this.annotatorEndpoint = props.getProperty("generic.endpoint");
        this.annotatorRequires = GenericWebServiceAnnotator.parseClasses(props.getProperty("generic.requires", ""));
        this.annotatorProvides = GenericWebServiceAnnotator.parseClasses(props.getProperty("generic.provides", ""));
        this.startCommand = Optional.ofNullable(props.getProperty("generic.start")).map(CommandLineTokenizer::tokenize);
        this.stopCommand = Optional.ofNullable(props.getProperty("generic.stop")).map(CommandLineTokenizer::tokenize);
        this.serializer = new ProtobufAnnotationSerializer();
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return this.annotatorProvides;
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        return this.annotatorRequires;
    }

    @Override
    protected Optional<String[]> startCommand() {
        return this.startCommand;
    }

    @Override
    protected Optional<String[]> stopCommand() {
        return this.stopCommand;
    }

    @Override
    protected boolean ready(boolean initialTest) {
        return this.ping(this.annotatorEndpoint + "/ping/");
    }

    private static <V> void copyValue(CoreMap source, CoreMap target, Class k) {
        Class k_ = k;
        target.set(k_, source.get(k_));
    }

    private static void copy(Annotation source, Annotation target) {
        source.keySet().forEach(k -> GenericWebServiceAnnotator.copyValue(source, target, k));
    }

    @Override
    protected void annotateImpl(Annotation ann) throws WebServiceAnnotator.ShouldRetryException, WebServiceAnnotator.PermanentlyFailedException {
        Annotation ann_;
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(this.annotatorEndpoint + "/annotate/").openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "application/octet-stream; charset=UTF-8");
            try (OutputStream outputStream = conn.getOutputStream();){
                this.serializer.toProto(ann).writeDelimitedTo(outputStream);
                outputStream.flush();
            }
            conn.connect();
            try {
                var5_7 = null;
                try (InputStream inputStream = conn.getInputStream();){
                    Pair<Annotation, InputStream> pair = this.serializer.read(inputStream);
                    ann_ = (Annotation)pair.first;
                }
                catch (Throwable throwable) {
                    var5_7 = throwable;
                    throw throwable;
                }
            }
            catch (IOException | ClassNotFoundException e) {
                throw new WebServiceAnnotator.PermanentlyFailedException(e);
            }
        }
        catch (MalformedURLException e) {
            throw new WebServiceAnnotator.PermanentlyFailedException(e);
        }
        catch (IOException e) {
            throw new WebServiceAnnotator.ShouldRetryException();
        }
        GenericWebServiceAnnotator.copy(ann_, ann);
    }
}

