/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.JSONOutputter;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.StringUtils;
import java.io.IOException;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class JSONOutputterTest {
    private static String indent(String in) {
        return in.replace("\t", "  ");
    }

    private static void testEscape(String input, String expected) {
        Assert.assertEquals((long)1L, (long)input.length());
        Assert.assertEquals((long)2L, (long)expected.length());
        Assert.assertEquals((Object)expected, (Object)StringUtils.escapeJsonString(input));
    }

    private static void testNoEscape(String input, String expected) {
        Assert.assertEquals((long)1L, (long)input.length());
        Assert.assertEquals((long)1L, (long)expected.length());
        Assert.assertEquals((Object)expected, (Object)StringUtils.escapeJsonString(input));
    }

    @Test
    public void testSanitizeJSONString() {
        JSONOutputterTest.testEscape("\b", "\\b");
        JSONOutputterTest.testEscape("\f", "\\f");
        JSONOutputterTest.testEscape("\n", "\\n");
        JSONOutputterTest.testEscape("\r", "\\r");
        JSONOutputterTest.testEscape("\t", "\\t");
        JSONOutputterTest.testNoEscape("'", "'");
        JSONOutputterTest.testNoEscape("/", "/");
        JSONOutputterTest.testNoEscape("-", "-");
        JSONOutputterTest.testEscape("\"", "\\\"");
        JSONOutputterTest.testEscape("\\", "\\\\");
        Assert.assertEquals((Object)"\\\\b", (Object)StringUtils.escapeJsonString("\\b"));
    }

    @Test
    public void testSimpleJSON() {
        Assert.assertEquals((Object)JSONOutputterTest.indent("{\n\t\"foo\": \"bar\"\n}"), (Object)JSONOutputter.JSONWriter.objectToJSON(writer -> writer.set("foo", "bar")));
        Assert.assertEquals((Object)JSONOutputterTest.indent("{\n\t\"foo\": \"bar\",\n\t\"baz\": \"hazzah\"\n}"), (Object)JSONOutputter.JSONWriter.objectToJSON(writer -> {
            writer.set("foo", "bar");
            writer.set("baz", "hazzah");
        }));
    }

    @Test
    public void testCollectionJSON() {
        Assert.assertEquals((Object)JSONOutputterTest.indent("{\n\t\"foo\": [\n\t\t\"bar\",\n\t\t\"baz\"\n\t]\n}"), (Object)JSONOutputter.JSONWriter.objectToJSON(writer -> writer.set("foo", Arrays.asList("bar", "baz"))));
    }

    @Test
    public void testNestedJSON() {
        Assert.assertEquals((Object)JSONOutputterTest.indent("{\n\t\"foo\": {\n\t\t\"bar\": \"baz\"\n\t}\n}"), (Object)JSONOutputter.JSONWriter.objectToJSON(writer -> writer.set("foo", writer1 -> writer1.set("bar", "baz"))));
    }

    @Test
    public void testComplexJSON() {
        Assert.assertEquals((Object)JSONOutputterTest.indent("{\n\t\"1.1\": {\n\t\t\"2.1\": [\n\t\t\t\"a\",\n\t\t\t\"b\",\n\t\t\t{\n\t\t\t\t\"3.1\": \"v3.1\"\n\t\t\t}\n\t\t],\n\t\t\"2.2\": \"v2.2\"\n\t}\n}"), (Object)JSONOutputter.JSONWriter.objectToJSON(l1 -> l1.set("1.1", l2 -> {
            l2.set("2.1", Arrays.asList("a", "b", l3 -> l3.set("3.1", "v3.1")));
            l2.set("2.2", "v2.2");
        })));
    }

    @Test
    public void testSimpleDocument() throws IOException {
        Annotation ann = new Annotation("JSON is neat. Better than XML.");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(PropertiesUtils.asProperties("annotators", "tokenize, ssplit"));
        pipeline.annotate(ann);
        String actual = new JSONOutputter().print(ann);
        String expected = JSONOutputterTest.indent("{\n\t\"sentences\": [\n\t\t{\n\t\t\t\"index\": 0,\n\t\t\t\"tokens\": [\n\t\t\t\t{\n\t\t\t\t\t\"index\": 1,\n\t\t\t\t\t\"word\": \"JSON\",\n\t\t\t\t\t\"originalText\": \"JSON\",\n\t\t\t\t\t\"characterOffsetBegin\": 0,\n\t\t\t\t\t\"characterOffsetEnd\": 4,\n\t\t\t\t\t\"before\": \"\",\n\t\t\t\t\t\"after\": \" \"\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"index\": 2,\n\t\t\t\t\t\"word\": \"is\",\n\t\t\t\t\t\"originalText\": \"is\",\n\t\t\t\t\t\"characterOffsetBegin\": 5,\n\t\t\t\t\t\"characterOffsetEnd\": 7,\n\t\t\t\t\t\"before\": \" \",\n\t\t\t\t\t\"after\": \" \"\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"index\": 3,\n\t\t\t\t\t\"word\": \"neat\",\n\t\t\t\t\t\"originalText\": \"neat\",\n\t\t\t\t\t\"characterOffsetBegin\": 8,\n\t\t\t\t\t\"characterOffsetEnd\": 12,\n\t\t\t\t\t\"before\": \" \",\n\t\t\t\t\t\"after\": \"\"\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"index\": 4,\n\t\t\t\t\t\"word\": \".\",\n\t\t\t\t\t\"originalText\": \".\",\n\t\t\t\t\t\"characterOffsetBegin\": 12,\n\t\t\t\t\t\"characterOffsetEnd\": 13,\n\t\t\t\t\t\"before\": \"\",\n\t\t\t\t\t\"after\": \" \"\n\t\t\t\t}\n\t\t\t]\n\t\t},\n\t\t{\n\t\t\t\"index\": 1,\n\t\t\t\"tokens\": [\n\t\t\t\t{\n\t\t\t\t\t\"index\": 1,\n\t\t\t\t\t\"word\": \"Better\",\n\t\t\t\t\t\"originalText\": \"Better\",\n\t\t\t\t\t\"characterOffsetBegin\": 14,\n\t\t\t\t\t\"characterOffsetEnd\": 20,\n\t\t\t\t\t\"before\": \" \",\n\t\t\t\t\t\"after\": \" \"\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"index\": 2,\n\t\t\t\t\t\"word\": \"than\",\n\t\t\t\t\t\"originalText\": \"than\",\n\t\t\t\t\t\"characterOffsetBegin\": 21,\n\t\t\t\t\t\"characterOffsetEnd\": 25,\n\t\t\t\t\t\"before\": \" \",\n\t\t\t\t\t\"after\": \" \"\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"index\": 3,\n\t\t\t\t\t\"word\": \"XML\",\n\t\t\t\t\t\"originalText\": \"XML\",\n\t\t\t\t\t\"characterOffsetBegin\": 26,\n\t\t\t\t\t\"characterOffsetEnd\": 29,\n\t\t\t\t\t\"before\": \" \",\n\t\t\t\t\t\"after\": \"\"\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"index\": 4,\n\t\t\t\t\t\"word\": \".\",\n\t\t\t\t\t\"originalText\": \".\",\n\t\t\t\t\t\"characterOffsetBegin\": 29,\n\t\t\t\t\t\"characterOffsetEnd\": 30,\n\t\t\t\t\t\"before\": \"\",\n\t\t\t\t\t\"after\": \"\"\n\t\t\t\t}\n\t\t\t]\n\t\t}\n\t]\n}\n");
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

