/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationSerializer;
import edu.stanford.nlp.pipeline.CoreDocument;
import edu.stanford.nlp.pipeline.ProtobufAnnotationSerializer;
import edu.stanford.nlp.pipeline.ProtobufAnnotationSerializerSlowITest;
import edu.stanford.nlp.pipeline.QuoteAnnotator;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;

public class ProtobufSerializationSanityITest
extends TestCase {
    public String sampleText = "Joe Smith works at the post office.  He said, \"I love working there.\" Postal worker Joe is good friends with Chris Anderson.  Chris and Joe like to eat lunch together every day. On Sunday, January 21st 2018, Chris and Joe Smith decided to get pizza at 3:00pm.  Joe said, \"I love pizza.\" Chris Anderson was born in California.";
    public StanfordCoreNLP pipeline;
    AnnotationSerializer serializer;

    public void setUp() {
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize,ssplit,pos,lemma,ner,parse,depparse,coref,natlog,openie,entitylink,kbp,sentiment,quote");
        this.pipeline = new StanfordCoreNLP(props);
        this.serializer = new ProtobufAnnotationSerializer();
    }

    public void compareTokensLists(Annotation originalDoc, Annotation newDoc) {
        List originalTokens = (List)originalDoc.get(CoreAnnotations.TokensAnnotation.class);
        List newTokens = (List)newDoc.get(CoreAnnotations.TokensAnnotation.class);
        if (originalTokens.size() != newTokens.size()) {
            System.err.println("---");
            System.err.println("token size mismatch!");
            System.err.println("original token size: " + originalTokens.size());
            System.err.println("new token size; " + newTokens.size());
        } else {
            for (int i = 0; i < originalTokens.size(); ++i) {
                if (((CoreLabel)originalTokens.get(i)).equals(newTokens.get(i))) continue;
                System.err.println("---");
                System.err.println("token mismatch detected!");
                System.err.println("token number: " + i);
                System.err.println(originalTokens.get(i));
            }
        }
    }

    public void compareEntityMentionsLists(Annotation originalDoc, Annotation newDoc) {
        List originalMentions = (List)originalDoc.get(CoreAnnotations.MentionsAnnotation.class);
        List newMentions = (List)newDoc.get(CoreAnnotations.MentionsAnnotation.class);
        if (originalMentions.size() != newMentions.size()) {
            System.err.println("---");
            System.err.println("entity mentions size mismatch!");
            System.err.println("original entity mention size: " + originalMentions.size());
            System.err.println("new entity mention size: " + newMentions.size());
        } else {
            for (int i = 0; i < originalMentions.size(); ++i) {
                if (((CoreMap)originalMentions.get(i)).equals(newMentions.get(i))) continue;
                System.err.println("---");
                System.err.println("entity mention mismatch detected!");
                System.err.println("entity mention number: " + i);
                System.err.println(originalMentions.get(i));
            }
        }
    }

    public void compareQuotesLists(Annotation originalDoc, Annotation newDoc) {
        List<CoreMap> originalQuotes = QuoteAnnotator.gatherQuotes(originalDoc);
        List<CoreMap> newQuotes = QuoteAnnotator.gatherQuotes(newDoc);
        for (CoreMap quote : originalQuotes) {
            quote.remove(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class);
            quote.remove(CoreAnnotations.QuotationsAnnotation.class);
        }
        if (originalQuotes.size() != newQuotes.size()) {
            System.err.println("---");
            System.err.println("quotes size mismatch!");
            System.err.println("original quotes size: " + originalQuotes.size());
            System.err.println("new quotes size: " + newQuotes.size());
        } else {
            for (int i = 0; i < originalQuotes.size(); ++i) {
                if (originalQuotes.get(i).equals(newQuotes.get(i))) continue;
                System.err.println("---");
                System.err.println("quote mismatch detected!");
                System.err.println("quote number: " + i);
                System.err.println(originalQuotes.get(i));
            }
        }
    }

    public void findCoreMapDifference(CoreMap originalCoreMap, CoreMap readCoreMap) {
        if (!((List)originalCoreMap.get(CoreAnnotations.TokensAnnotation.class)).equals(readCoreMap.get(CoreAnnotations.TokensAnnotation.class))) {
            System.err.println("tokens annotation difference detected!");
        }
        if (!((String)originalCoreMap.get(CoreAnnotations.TextAnnotation.class)).equals(readCoreMap.get(CoreAnnotations.TextAnnotation.class))) {
            System.err.println("text annotation difference detected!");
        }
        if (!((Map)originalCoreMap.get(CorefCoreAnnotations.CorefChainAnnotation.class)).equals(readCoreMap.get(CorefCoreAnnotations.CorefChainAnnotation.class))) {
            System.err.println("coref chain annotation difference detected!");
        }
        if (!((List)originalCoreMap.get(CorefCoreAnnotations.CorefMentionsAnnotation.class)).equals(readCoreMap.get(CorefCoreAnnotations.CorefMentionsAnnotation.class))) {
            System.err.println("coref mentions difference detected!");
        }
        if (!((Map)originalCoreMap.get(CoreAnnotations.EntityMentionToCorefMentionMappingAnnotation.class)).equals(readCoreMap.get(CoreAnnotations.EntityMentionToCorefMentionMappingAnnotation.class))) {
            System.err.println("entity mention to coref mapping difference detected!");
        }
        if (!((Map)originalCoreMap.get(CoreAnnotations.CorefMentionToEntityMentionMappingAnnotation.class)).equals(readCoreMap.get(CoreAnnotations.CorefMentionToEntityMentionMappingAnnotation.class))) {
            System.err.println("coref mention to entity mapping difference detected!");
        }
        if (!((List)originalCoreMap.get(CoreAnnotations.MentionsAnnotation.class)).equals(readCoreMap.get(CoreAnnotations.MentionsAnnotation.class))) {
            System.err.println("mentions annotation difference detected!");
        }
        if (!((List)originalCoreMap.get(CoreAnnotations.SentencesAnnotation.class)).equals(readCoreMap.get(CoreAnnotations.SentencesAnnotation.class))) {
            System.err.println("sentences annotation difference detected!");
        }
    }

    public void testBasicExample() throws ClassNotFoundException, IOException {
        CoreDocument sampleDocument = new CoreDocument(this.sampleText);
        this.pipeline.annotate(sampleDocument);
        ByteArrayOutputStream ks = new ByteArrayOutputStream();
        this.serializer.writeCoreDocument(sampleDocument, ks).close();
        ByteArrayInputStream kis = new ByteArrayInputStream(ks.toByteArray());
        Pair<Annotation, InputStream> pair = this.serializer.read(kis);
        ((InputStream)pair.second).close();
        Annotation readAnnotation = (Annotation)pair.first;
        ((InputStream)kis).close();
        this.compareTokensLists(sampleDocument.annotation(), readAnnotation);
        this.compareEntityMentionsLists(sampleDocument.annotation(), readAnnotation);
        this.compareQuotesLists(sampleDocument.annotation(), readAnnotation);
        this.findCoreMapDifference(sampleDocument.annotation(), readAnnotation);
        ProtobufAnnotationSerializerSlowITest.sameAsRead(sampleDocument.annotation(), readAnnotation);
    }
}

