/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class StanfordCoreNLPTest {
    @Test
    public void testPrereqAnnotatorsBasic() {
        Assert.assertEquals((Object)"tokenize,ssplit,pos,parse", (Object)StanfordCoreNLP.ensurePrerequisiteAnnotators(new String[]{"parse"}, new Properties()));
        Assert.assertEquals((Object)"tokenize,ssplit,pos,depparse", (Object)StanfordCoreNLP.ensurePrerequisiteAnnotators(new String[]{"depparse"}, new Properties()));
        Assert.assertEquals((Object)"tokenize,ssplit,pos,depparse", (Object)StanfordCoreNLP.ensurePrerequisiteAnnotators(new String[]{"depparse", "tokenize"}, new Properties()));
        Assert.assertEquals((Object)"tokenize,ssplit,pos,lemma,depparse,natlog", (Object)StanfordCoreNLP.ensurePrerequisiteAnnotators(new String[]{"natlog", "tokenize"}, new Properties()));
    }

    @Test
    public void testPrereqAnnotatorsOrderPreserving() {
        Assert.assertEquals((Object)"tokenize,ssplit,pos,lemma,depparse,natlog", (Object)StanfordCoreNLP.ensurePrerequisiteAnnotators(new String[]{"lemma", "depparse", "natlog"}, new Properties()));
        Assert.assertEquals((Object)"tokenize,ssplit,pos,depparse,lemma,natlog", (Object)StanfordCoreNLP.ensurePrerequisiteAnnotators(new String[]{"depparse", "lemma", "natlog"}, new Properties()));
        Assert.assertEquals((Object)"tokenize,ssplit,pos,lemma,ner,regexner", (Object)StanfordCoreNLP.ensurePrerequisiteAnnotators(new String[]{"ner", "regexner"}, new Properties()));
        Assert.assertEquals((Object)"tokenize,ssplit,pos,lemma,ner,depparse", (Object)StanfordCoreNLP.ensurePrerequisiteAnnotators(new String[]{"ner", "depparse"}, new Properties()));
        Assert.assertEquals((Object)"tokenize,ssplit,pos,lemma,depparse,ner", (Object)StanfordCoreNLP.ensurePrerequisiteAnnotators(new String[]{"depparse", "ner"}, new Properties()));
    }

    @Test
    public void testPrereqAnnotatorsRegexNERAfterNER() {
        Assert.assertEquals((Object)"tokenize,ssplit,pos,lemma,ner,regexner", (Object)StanfordCoreNLP.ensurePrerequisiteAnnotators(new String[]{"regexner", "ner"}, new Properties()));
    }

    @Test
    public void testPrereqAnnotatorsCorefBeforeOpenIE() {
        Assert.assertEquals((Object)"tokenize,ssplit,pos,lemma,depparse,natlog,ner,coref,openie", (Object)StanfordCoreNLP.ensurePrerequisiteAnnotators(new String[]{"openie", "coref"}, new Properties()));
        Assert.assertEquals((Object)"tokenize,ssplit,pos,lemma,ner,depparse,natlog,coref,openie", (Object)StanfordCoreNLP.ensurePrerequisiteAnnotators(new String[]{"coref", "openie"}, new Properties()));
    }

    @Test
    public void testPrereqAnnotatorsCoref() {
        Properties props = new Properties();
        Assert.assertEquals((Object)"tokenize,ssplit,pos,lemma,ner,depparse,coref", (Object)StanfordCoreNLP.ensurePrerequisiteAnnotators(new String[]{"coref"}, props));
        Assert.assertEquals((Object)"dep", (Object)props.getProperty("coref.md.type", ""));
    }

    @Test
    public void testPrereqAnnotatorsCorefWithParse() {
        Properties props = new Properties();
        Assert.assertEquals((Object)"tokenize,ssplit,pos,lemma,ner,parse,coref", (Object)StanfordCoreNLP.ensurePrerequisiteAnnotators(new String[]{"parse", "coref"}, props));
        Assert.assertEquals((Object)"__empty__", (Object)props.getProperty("coref.md.type", "__empty__"));
    }
}

