/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline.demo;

import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.coref.data.CorefChain;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class StanfordCoreNlpDemoChinese {
    private StanfordCoreNlpDemoChinese() {
    }

    public static void main(String[] args) throws IOException {
        PrintWriter out2 = args.length > 1 ? new PrintWriter(args[1]) : new PrintWriter(System.out);
        Properties props = new Properties();
        props.load(IOUtils.readerFromString("StanfordCoreNLP-chinese.properties"));
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        Annotation document = args.length > 0 ? new Annotation(IOUtils.slurpFileNoExceptions(args[0])) : new Annotation("\u514b\uf9f4\u987f\u8bf4\uff0c\u534e\u76db\u987f\u5c06\u9010\u6b65\uf918\u5b9e\u5bf9\u97e9\u56fd\u7684\u7ecf\u6d4e\u63f4\u52a9\u3002\uf90a\u5927\u4e2d\u5bf9\u514b\uf9f4\u987f\u7684\u8bb2\u8bdd\u62a5\u4ee5\u638c\u58f0\uff1a\u514b\uf9f4\u987f\u603b\u7edf\u5728\u4f1a\u8c08\u4e2d\u91cd\u7533\uff0c\u4ed6\u575a\u5b9a\u5730\u652f\u6301\u97e9\u56fd\u6446\u8131\u7ecf\u6d4e\u5371\u673a\u3002");
        pipeline.annotate(document);
        List sentences = (List)document.get(CoreAnnotations.SentencesAnnotation.class);
        int sentNo = 1;
        for (CoreMap sentence : sentences) {
            out2.println("Sentence #" + sentNo + " tokens are:");
            for (CoreMap token : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
                out2.println(token.toShorterString("Text", "CharacterOffsetBegin", "CharacterOffsetEnd", "Index", "PartOfSpeech", "NamedEntityTag"));
            }
            out2.println("Sentence #" + sentNo + " basic dependencies are:");
            out2.println(((SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class)).toString(SemanticGraph.OutputFormat.LIST));
            ++sentNo;
        }
        out2.println("Coreference information");
        Map corefChains = (Map)document.get(CorefCoreAnnotations.CorefChainAnnotation.class);
        if (corefChains == null) {
            return;
        }
        for (Map.Entry entry : corefChains.entrySet()) {
            out2.println("Chain " + entry.getKey());
            for (CorefChain.CorefMention m : ((CorefChain)entry.getValue()).getMentionsInTextualOrder()) {
                List tokens = (List)((CoreMap)sentences.get(m.sentNum - 1)).get(CoreAnnotations.TokensAnnotation.class);
                out2.println("  " + m + ":[" + ((CoreLabel)tokens.get(m.startIndex - 1)).beginPosition() + ", " + ((CoreLabel)tokens.get(m.endIndex - 2)).endPosition() + ')');
            }
        }
        IOUtils.closeIgnoringExceptions(out2);
    }
}

