/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.process.TSVUtils;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public class TSVUtilsTest {
    @Test
    public void testParseArrayTrivial() {
        Assert.assertEquals(Arrays.asList("foo", "bar"), TSVUtils.parseArray("{foo,bar}"));
    }

    @Test
    public void testParseArrayQuote() {
        Assert.assertEquals(Arrays.asList("foo", ",", "a,b", "bar"), TSVUtils.parseArray("{foo,\",\",\"a,b\",bar}"));
    }

    @Test
    public void testParseArrayEscape() {
        Assert.assertEquals(Arrays.asList("foo", "\"", "a\"b", "bar"), TSVUtils.parseArray("{foo,\"\\\"\",\"a\\\"b\",bar}"));
        Assert.assertEquals(Arrays.asList("foo", "\"", "bar"), TSVUtils.parseArray("{foo,\\\",bar}"));
        Assert.assertEquals(Collections.singletonList("aa\\bb"), TSVUtils.parseArray("{\"aa\\\\\\\\bb\"}"));
        Assert.assertEquals(Collections.singletonList("a\"b"), TSVUtils.parseArray("{\"a\"\"b\"}"));
    }

    @Test
    public void testRealSentence() {
        String array = "{\"<ref\u00a0name=\\\"Dr.\u00a0Mohmmad\u00a0Riaz\u00a0Suddle,\u00a0Director\u00a0of\u00a0the\u00a0Paksat-IR\u00a0programme\u00a0and\u00a0current\u00a0executive\u00a0member\u00a0of\u00a0the\u00a0Suparco's\u00a0plan\u00a0and\u00a0research\u00a0division\u00a0\\\"/>\",On,August,11th,\",\",Paksat-1R,|,'',Paksat-IR,'',was,launched,from,Xichang,Satellite,Launch,Center,by,Suparco,\",\",making,it,first,satellite,to,be,launched,under,this,programme,.}";
        Assert.assertEquals((long)31L, (long)TSVUtils.parseArray(array).size());
        Assert.assertEquals(Arrays.asList("<ref\u00a0name=\"Dr.\u00a0Mohmmad\u00a0Riaz\u00a0Suddle,\u00a0Director\u00a0of\u00a0the\u00a0Paksat-IR\u00a0programme\u00a0and\u00a0current\u00a0executive\u00a0member\u00a0of\u00a0the\u00a0Suparco's\u00a0plan\u00a0and\u00a0research\u00a0division\u00a0\"/>", "On", "August", "11th", ",", "Paksat-1R", "|", "''", "Paksat-IR", "''", "was", "launched", "from", "Xichang", "Satellite", "Launch", "Center", "by", "Suparco", ",", "making", "it", "first", "satellite", "to", "be", "launched", "under", "this", "programme", "."), TSVUtils.parseArray(array));
    }

    @Test
    public void testRealSentenceDoubleEscaped() {
        String array = "{\"<ref\u00a0name=\\\\\"Dr.\u00a0Mohmmad\u00a0Riaz\u00a0Suddle,\u00a0Director\u00a0of\u00a0the\u00a0Paksat-IR\u00a0programme\u00a0and\u00a0current\u00a0executive\u00a0member\u00a0of\u00a0the\u00a0Suparco's\u00a0plan\u00a0and\u00a0research\u00a0division\u00a0\\\\\"/>\",On,August,11th,\",\",Paksat-1R,|,'',Paksat-IR,'',was,launched,from,Xichang,Satellite,Launch,Center,by,Suparco,\",\",making,it,first,satellite,to,be,launched,under,this,programme,.}";
        Assert.assertEquals((long)31L, (long)TSVUtils.parseArray(array).size());
        Assert.assertEquals(Arrays.asList("<ref\u00a0name=\"Dr.\u00a0Mohmmad\u00a0Riaz\u00a0Suddle,\u00a0Director\u00a0of\u00a0the\u00a0Paksat-IR\u00a0programme\u00a0and\u00a0current\u00a0executive\u00a0member\u00a0of\u00a0the\u00a0Suparco's\u00a0plan\u00a0and\u00a0research\u00a0division\u00a0\"/>", "On", "August", "11th", ",", "Paksat-1R", "|", "''", "Paksat-IR", "''", "was", "launched", "from", "Xichang", "Satellite", "Launch", "Center", "by", "Suparco", ",", "making", "it", "first", "satellite", "to", "be", "launched", "under", "this", "programme", "."), TSVUtils.parseArray(array));
    }
}

