/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex.ssurgeon;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonEdit;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.StringUtils;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

public class CollapseSubtree
extends SsurgeonEdit {
    public static final String LABEL = "collapseSubtree";
    protected String rootName;

    public CollapseSubtree(String rootNodeName) {
        this.rootName = rootNodeName;
    }

    @Override
    public void evaluate(SemanticGraph sg, SemgrexMatcher sm) {
        IndexedWord rootNode = this.getNamedNode(this.rootName, sm);
        Set<IndexedWord> subgraphNodeSet = sg.getSubgraphVertices(rootNode);
        if (!sg.isDag(rootNode)) {
            for (IndexedWord child : sg.getChildren(rootNode)) {
                Set<IndexedWord> reachableSet = sg.getSubgraphVertices(child);
                if (!reachableSet.contains(rootNode)) continue;
                throw new IllegalArgumentException("Subtree cannot contain cycle leading back to root node!");
            }
        }
        ArrayList<IndexedWord> sortedSubgraphNodes = Generics.newArrayList(subgraphNodeSet);
        Collections.sort(sortedSubgraphNodes);
        IndexedWord newNode = new IndexedWord(rootNode.docID(), rootNode.sentIndex(), rootNode.index());
        for (Class<?> key : newNode.backingLabel().keySet()) {
            newNode.set(key, rootNode.get(key));
        }
        newNode.setValue(StringUtils.join(sortedSubgraphNodes.stream().map(IndexedWord::value), " "));
        newNode.setWord(StringUtils.join(sortedSubgraphNodes.stream().map(IndexedWord::word), " "));
        newNode.setLemma(StringUtils.join(sortedSubgraphNodes.stream().map(x -> x.lemma() == null ? x.word() : x.lemma()), " "));
        if (sg.getRoots().contains(rootNode)) {
            sg.getRoots().remove(rootNode);
            sg.addRoot(rootNode);
        }
        for (SemanticGraphEdge edge : sg.incomingEdgeIterable(rootNode)) {
            sg.addEdge(edge.getGovernor(), newNode, edge.getRelation(), edge.getWeight(), edge.isExtra());
        }
        for (IndexedWord node : sortedSubgraphNodes) {
            sg.removeVertex(node);
        }
    }

    @Override
    public String toEditString() {
        StringWriter buf = new StringWriter();
        buf.write(LABEL);
        buf.write("\t");
        buf.write("-node");
        buf.write(" ");
        buf.write(this.rootName);
        return buf.toString();
    }
}

