/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sentiment;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.neural.rnn.RNNCoreAnnotations;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.parser.lexparser.TreeBinarizer;
import edu.stanford.nlp.process.DocumentPreprocessor;
import edu.stanford.nlp.sentiment.CollapseUnaryTransformer;
import edu.stanford.nlp.sentiment.SentimentCostAndGradient;
import edu.stanford.nlp.sentiment.SentimentModel;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.StringReader;
import java.util.List;
import java.util.Map;

public class BuildBinarizedDataset {
    private static final Redwood.RedwoodChannels log = Redwood.channels(BuildBinarizedDataset.class);

    private BuildBinarizedDataset() {
    }

    public static void setUnknownLabels(Tree tree, Integer defaultLabel) {
        if (tree.isLeaf()) {
            return;
        }
        for (Tree child : tree.children()) {
            BuildBinarizedDataset.setUnknownLabels(child, defaultLabel);
        }
        tree.label().setValue(defaultLabel.toString());
    }

    public static void setPredictedLabels(Tree tree) {
        if (tree.isLeaf()) {
            return;
        }
        for (Tree child : tree.children()) {
            BuildBinarizedDataset.setPredictedLabels(child);
        }
        tree.label().setValue(Integer.toString(RNNCoreAnnotations.getPredictedClass(tree)));
    }

    public static void extractLabels(Map<Pair<Integer, Integer>, String> spanToLabels, List<HasWord> tokens, String line) {
        String[] pieces = line.trim().split("\\s+");
        if (pieces.length == 0) {
            return;
        }
        if (pieces.length == 1) {
            String error = "Found line with label " + line + " but no tokens to associate with that line";
            throw new RuntimeException(error);
        }
        for (int i = 0; i < tokens.size() - pieces.length + 2; ++i) {
            boolean found = true;
            for (int j = 1; j < pieces.length; ++j) {
                if (tokens.get(i + j - 1).word().equals(pieces[j])) continue;
                found = false;
                break;
            }
            if (!found) continue;
            spanToLabels.put(new Pair<Integer, Integer>(i, i + pieces.length - 1), pieces[0]);
        }
    }

    public static boolean setSpanLabel(Tree tree, Pair<Integer, Integer> span, String value) {
        if (!(tree.label() instanceof CoreLabel)) {
            throw new AssertionError((Object)"Expected CoreLabels");
        }
        CoreLabel label = (CoreLabel)tree.label();
        if (((Integer)label.get(CoreAnnotations.BeginIndexAnnotation.class)).equals(span.first) && ((Integer)label.get(CoreAnnotations.EndIndexAnnotation.class)).equals(span.second)) {
            label.setValue(value);
            return true;
        }
        if ((Integer)label.get(CoreAnnotations.BeginIndexAnnotation.class) > (Integer)span.first && (Integer)label.get(CoreAnnotations.EndIndexAnnotation.class) < (Integer)span.second) {
            return false;
        }
        for (Tree child : tree.children()) {
            if (!BuildBinarizedDataset.setSpanLabel(child, span, value)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        String[] chunks;
        CollapseUnaryTransformer transformer = new CollapseUnaryTransformer();
        String parserModel = "edu/stanford/nlp/models/lexparser/englishPCFG.ser.gz";
        String inputPath = null;
        String sentimentModelPath = null;
        SentimentModel sentimentModel = null;
        int argIndex = 0;
        while (argIndex < args.length) {
            if (args[argIndex].equalsIgnoreCase("-input")) {
                inputPath = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-parserModel")) {
                parserModel = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-sentimentModel")) {
                sentimentModelPath = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            log.info("Unknown argument " + args[argIndex]);
            System.exit(2);
        }
        if (inputPath == null) {
            throw new IllegalArgumentException("Must specify input file with -input");
        }
        LexicalizedParser parser = LexicalizedParser.loadModel(parserModel, new String[0]);
        TreeBinarizer binarizer = TreeBinarizer.simpleTreeBinarizer(parser.getTLPParams().headFinder(), parser.treebankLanguagePack());
        if (sentimentModelPath != null) {
            sentimentModel = SentimentModel.loadSerialized(sentimentModelPath);
        }
        String text = IOUtils.slurpFileNoExceptions(inputPath);
        for (String chunk : chunks = text.split("\\n\\s*\\n+")) {
            if (chunk.trim().isEmpty()) continue;
            String[] lines = chunk.trim().split("\\n");
            String sentence = lines[0];
            StringReader sin = new StringReader(sentence);
            DocumentPreprocessor document = new DocumentPreprocessor(sin);
            document.setSentenceFinalPuncWords(new String[]{"\n"});
            List<HasWord> tokens = document.iterator().next();
            Integer mainLabel = new Integer(tokens.get(0).word());
            tokens = tokens.subList(1, tokens.size());
            Map<Pair<Integer, Integer>, String> spanToLabels = Generics.newHashMap();
            for (int i = 1; i < lines.length; ++i) {
                BuildBinarizedDataset.extractLabels(spanToLabels, tokens, lines[i]);
            }
            Tree tree = parser.apply(tokens);
            Tree binarized = binarizer.transformTree(tree);
            Tree collapsedUnary = transformer.transformTree(binarized);
            if (sentimentModel != null) {
                Trees.convertToCoreLabels(collapsedUnary);
                SentimentCostAndGradient scorer = new SentimentCostAndGradient(sentimentModel, null);
                scorer.forwardPropagateTree(collapsedUnary);
                BuildBinarizedDataset.setPredictedLabels(collapsedUnary);
            } else {
                BuildBinarizedDataset.setUnknownLabels(collapsedUnary, mainLabel);
            }
            Trees.convertToCoreLabels(collapsedUnary);
            collapsedUnary.indexSpans();
            for (Map.Entry<Pair<Integer, Integer>, String> pairStringEntry : spanToLabels.entrySet()) {
                BuildBinarizedDataset.setSpanLabel(collapsedUnary, pairStringEntry.getKey(), pairStringEntry.getValue());
            }
            System.out.println(collapsedUnary);
        }
    }
}

