/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.ProbabilityDistribution;
import java.util.Random;

public class Multinomial<E>
implements ProbabilityDistribution<E> {
    private static final long serialVersionUID = -697457414113362926L;
    private Counter<E> parameters;
    private int hashCode = -1;

    public Multinomial(Counter<E> parameters) {
        double totalMass = parameters.totalCount();
        if (totalMass <= 0.0) {
            throw new RuntimeException("total mass must be positive!");
        }
        this.parameters = new ClassicCounter();
        for (E object : parameters.keySet()) {
            double oldCount = parameters.getCount(object);
            if (oldCount < 0.0) {
                throw new RuntimeException("no negative parameters allowed!");
            }
            this.parameters.setCount(object, oldCount / totalMass);
        }
    }

    public Counter<E> getParameters() {
        return new ClassicCounter<E>(this.parameters);
    }

    @Override
    public double probabilityOf(E object) {
        if (!this.parameters.keySet().contains(object)) {
            throw new RuntimeException("Not a valid object for this multinomial!");
        }
        return this.parameters.getCount(object);
    }

    @Override
    public double logProbabilityOf(E object) {
        if (!this.parameters.keySet().contains(object)) {
            throw new RuntimeException("Not a valid object for this multinomial!");
        }
        return Math.log(this.parameters.getCount(object));
    }

    @Override
    public E drawSample(Random random) {
        double r = random.nextDouble();
        double sum = 0.0;
        for (E object : this.parameters.keySet()) {
            if (!((sum += this.parameters.getCount(object)) >= r)) continue;
            return object;
        }
        throw new RuntimeException("This point should never be reached");
    }

    public boolean equals(Object o) {
        if (!(o instanceof Multinomial)) {
            return false;
        }
        Multinomial otherMultinomial = (Multinomial)o;
        return this.parameters.equals(otherMultinomial.parameters);
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.parameters.hashCode() + 17;
        }
        return this.hashCode;
    }
}

