/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.PairsHolder;
import edu.stanford.nlp.tagger.maxent.RareExtractor;
import edu.stanford.nlp.util.StringUtils;

class ExtractorWordPref
extends RareExtractor {
    private final int num;
    private final int position;
    private static final long serialVersionUID = 724767436531L;

    ExtractorWordPref(int num, int position) {
        this.num = num;
        this.position = position;
    }

    @Override
    String extract(History h, PairsHolder pH) {
        String word = pH.getWord(h, this.position);
        if (word.length() < this.num) {
            return "######";
        }
        return word.substring(0, this.num);
    }

    @Override
    public String toString() {
        return StringUtils.getShortClassName(this) + "(len" + this.num + ",w" + this.position + ')';
    }

    @Override
    public boolean isLocal() {
        return this.position == 0;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }
}

