/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.PairsHolder;
import edu.stanford.nlp.tagger.maxent.RareExtractor;

class PluralAcronymDetector
extends RareExtractor {
    private static final long serialVersionUID = 33L;

    private static boolean pluralAcronym(String s) {
        int len = s.length();
        if (s.charAt(--len) != 's') {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (Character.isUpperCase(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    String extract(History h, PairsHolder pH) {
        String s = pH.getWord(h, 0);
        if (PluralAcronymDetector.pluralAcronym(s)) {
            return "1";
        }
        return "0";
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }
}

