/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructureConversionUtils;
import edu.stanford.nlp.trees.NPTmpRetainingTreeNormalizer;
import edu.stanford.nlp.trees.PennTreeReaderFactory;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.UniversalEnglishGrammaticalStructure;
import edu.stanford.nlp.trees.UniversalSemanticHeadFinder;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class UniversalEnglishGrammaticalStructureTest
extends Assert {
    private String testTree;
    private String testAnswer;
    private TestType type;

    @Parameterized.Parameters
    public static Collection<Object[]> testCases() {
        return Arrays.asList({TestType.BASIC, "(ROOT (S (NP (NNP Reagan)) (VP (VBZ has) (VP (VBN died))) (. .)))", "nsubj(died-3, Reagan-1)\naux(died-3, has-2)\nroot(ROOT-0, died-3)\n"}, {TestType.BASIC, "(ROOT (S (NP (NNP Kennedy)) (VP (VBZ has) (VP (VBN been) (VP (VBN killed)))) (. .)))", "nsubjpass(killed-4, Kennedy-1)\naux(killed-4, has-2)\nauxpass(killed-4, been-3)\nroot(ROOT-0, killed-4)\n"}, {TestType.BASIC, "(ROOT (S (NP (NNP Bill)) (VP (VBZ is) (NP (DT an) (JJ honest) (NN man))) (. .)))", "nsubj(man-5, Bill-1)\ncop(man-5, is-2)\ndet(man-5, an-3)\namod(man-5, honest-4)\nroot(ROOT-0, man-5)\n"}, {TestType.BASIC, "(ROOT (S (NP (NNP Bill)) (VP (VBZ is) (ADJP (JJ big) (CC and) (JJ honest))) (. .)))", "nsubj(big-3, Bill-1)\ncop(big-3, is-2)\nroot(ROOT-0, big-3)\ncc(big-3, and-4)\nconj(big-3, honest-5)\n"}, {TestType.BASIC, "(ROOT (S (NP (NNP Clinton)) (VP (VBD defeated) (NP (NNP Dole))) (. .)))", "nsubj(defeated-2, Clinton-1)\nroot(ROOT-0, defeated-2)\ndobj(defeated-2, Dole-3)\n"}, {TestType.BASIC, "(ROOT (S (SBAR (WHNP (WP What)) (S (NP (PRP she)) (VP (VBD said)))) (VP (VBZ is) (ADJP (JJ untrue))) (. .)))", "dobj(said-3, What-1)\nnsubj(said-3, she-2)\ncsubj(untrue-5, said-3)\ncop(untrue-5, is-4)\nroot(ROOT-0, untrue-5)\n"}, {TestType.BASIC, "(ROOT (S (NP (NNP Dole)) (VP (VBD was) (VP (VBN defeated) (PP (IN by) (NP (NNP Clinton))))) (. .)))", "nsubjpass(defeated-3, Dole-1)\nauxpass(defeated-3, was-2)\nroot(ROOT-0, defeated-3)\ncase(Clinton-5, by-4)\nnmod(defeated-3, Clinton-5)\n"}, {TestType.BASIC, "(ROOT (S (SBAR (IN That) (S (NP (PRP she)) (VP (VBD lied)))) (VP (VBD was) (VP (VBN suspected) (PP (IN by) (NP (NN everyone))))) (. .)))", "mark(lied-3, That-1)\nnsubj(lied-3, she-2)\ncsubjpass(suspected-5, lied-3)\nauxpass(suspected-5, was-4)\nroot(ROOT-0, suspected-5)\ncase(everyone-7, by-6)\nnmod(suspected-5, everyone-7)\n"}, {TestType.BASIC, "(ROOT (S (NP (PRP She)) (VP (VBD gave) (NP (PRP me)) (NP (DT a) (NN raise))) (. .)))", "nsubj(gave-2, She-1)\nroot(ROOT-0, gave-2)\niobj(gave-2, me-3)\ndet(raise-5, a-4)\ndobj(gave-2, raise-5)\n"}, {TestType.BASIC, "(ROOT (S (NP (PRP I)) (VP (VBP like) (S (VP (TO to) (VP (VB swim))))) (. .)))", "nsubj(like-2, I-1)\nroot(ROOT-0, like-2)\nmark(swim-4, to-3)\nxcomp(like-2, swim-4)\n"}, {TestType.BASIC, "(ROOT (S (NP (PRP I)) (VP (VBD sat) (PP (IN on) (NP (DT the) (NN chair)))) (. .)))", "nsubj(sat-2, I-1)\nroot(ROOT-0, sat-2)\ncase(chair-5, on-3)\ndet(chair-5, the-4)\nnmod(sat-2, chair-5)\n"}, {TestType.BASIC, "(ROOT (S (NP (PRP We)) (VP (VBP have) (NP (NP (DT no) (JJ useful) (NN information)) (PP (IN on) (SBAR (IN whether) (S (NP (NNS users)) (VP (VBP are) (PP (IN at) (NP (NN risk))))))))) (. .)))", "nsubj(have-2, We-1)\nroot(ROOT-0, have-2)\nneg(information-5, no-3)\namod(information-5, useful-4)\ndobj(have-2, information-5)\nmark(risk-11, on-6)\nmark(risk-11, whether-7)\nnsubj(risk-11, users-8)\ncop(risk-11, are-9)\ncase(risk-11, at-10)\nacl(information-5, risk-11)\n"}, {TestType.BASIC, "(ROOT (S (NP (PRP They)) (VP (VBD heard) (PP (IN about) (NP (NN asbestos))) (S (VP (VBG having) (NP (JJ questionable) (NNS properties))))) (. .)))", "nsubj(heard-2, They-1)\nroot(ROOT-0, heard-2)\ncase(asbestos-4, about-3)\nnmod(heard-2, asbestos-4)\nxcomp(heard-2, having-5)\namod(properties-7, questionable-6)\ndobj(having-5, properties-7)\n"}, {TestType.BASIC, "(ROOT (S (NP (PRP He)) (VP (VBZ says) (SBAR (IN that) (S (NP (PRP you)) (VP (VBP like) (S (VP (TO to) (VP (VB swim)))))))) (. .)))", "nsubj(says-2, He-1)\nroot(ROOT-0, says-2)\nmark(like-5, that-3)\nnsubj(like-5, you-4)\nccomp(says-2, like-5)\nmark(swim-7, to-6)\nxcomp(like-5, swim-7)\n"}, {TestType.BASIC, "(ROOT (S (NP (PRP I)) (VP (VBP am) (ADJP (JJ certain) (SBAR (IN that) (S (NP (PRP he)) (VP (VBD did) (NP (PRP it))))))) (. .)))", "nsubj(certain-3, I-1)\ncop(certain-3, am-2)\nroot(ROOT-0, certain-3)\nmark(did-6, that-4)\nnsubj(did-6, he-5)\nccomp(certain-3, did-6)\ndobj(did-6, it-7)\n"}, {TestType.BASIC, "(ROOT (S (NP (PRP I)) (VP (VBP am) (ADJP (JJ ready) (S (VP (TO to) (VP (VB leave)))))) (. .)))", "nsubj(ready-3, I-1)\ncop(ready-3, am-2)\nroot(ROOT-0, ready-3)\nmark(leave-5, to-4)\nxcomp(ready-3, leave-5)\n"}, {TestType.BASIC, "(ROOT (S (NP (NNP U.S.) (NNS forces)) (VP (VBP have) (VP (VBN been) (VP (VBN engaged) (PP (IN in) (NP (JJ intense) (NN fighting))) (SBAR (IN after) (S (NP (NNS insurgents)) (VP (VBD launched) (NP (JJ simultaneous) (NNS attacks)))))))) (. .)))", "compound(forces-2, U.S.-1)\nnsubjpass(engaged-5, forces-2)\naux(engaged-5, have-3)\nauxpass(engaged-5, been-4)\nroot(ROOT-0, engaged-5)\ncase(fighting-8, in-6)\namod(fighting-8, intense-7)\nnmod(engaged-5, fighting-8)\nmark(launched-11, after-9)\nnsubj(launched-11, insurgents-10)\nadvcl(engaged-5, launched-11)\namod(attacks-13, simultaneous-12)\ndobj(launched-11, attacks-13)\n"}, {TestType.BASIC, "(ROOT (S (NP (PRP I)) (VP (VBD saw) (NP (NP (DT the) (NN man)) (SBAR (WHNP (WP who)) (S (NP (PRP you)) (VP (VBP love)))))) (. .)))", "nsubj(saw-2, I-1)\nroot(ROOT-0, saw-2)\ndet(man-4, the-3)\ndobj(saw-2, man-4)\ndobj(love-7, who-5)\nnsubj(love-7, you-6)\nacl:relcl(man-4, love-7)\n"}, {TestType.BASIC, "(ROOT (S (NP (PRP I)) (VP (VBD saw) (NP (NP (DT the) (NN man)) (SBAR (WHNP (WP$ whose) (NP (NN wife))) (S (NP (PRP you)) (VP (VBP love)))))) (. .)))", "nsubj(saw-2, I-1)\nroot(ROOT-0, saw-2)\ndet(man-4, the-3)\ndobj(saw-2, man-4)\nnmod:poss(wife-6, whose-5)\ndobj(love-8, wife-6)\nnsubj(love-8, you-7)\nacl:relcl(man-4, love-8)\n"}, {TestType.BASIC, "(ROOT (S (NP (PRP I)) (VP (VBD saw) (NP (NP (DT the) (NN man)) (SBAR (WHNP (WP$ whose) (NN wife)) (S (NP (PRP you)) (VP (VBP love)))))) (. .)))", "nsubj(saw-2, I-1)\nroot(ROOT-0, saw-2)\ndet(man-4, the-3)\ndobj(saw-2, man-4)\nnmod:poss(wife-6, whose-5)\ndobj(love-8, wife-6)\nnsubj(love-8, you-7)\nacl:relcl(man-4, love-8)\n"}, {TestType.BASIC, "(ROOT (S (NP (EX There)) (VP (VBZ is) (NP (NP (DT a) (NN statue)) (PP (IN in) (NP (DT the) (NN corner))))) (. .)))", "expl(is-2, There-1)\nroot(ROOT-0, is-2)\ndet(statue-4, a-3)\nnsubj(is-2, statue-4)\ncase(corner-7, in-5)\ndet(corner-7, the-6)\nnmod(statue-4, corner-7)\n"}, {TestType.BASIC, "(ROOT (S (NP (PRP She)) (VP (VBZ looks) (ADJP (RB very) (JJ beautiful))) (. .)))", "nsubj(looks-2, She-1)\nroot(ROOT-0, looks-2)\nadvmod(beautiful-4, very-3)\nxcomp(looks-2, beautiful-4)\n"}, {TestType.BASIC, "(ROOT (S (NP (DT The) (NN accident)) (VP (VBD happened) (SBAR (IN as) (S (NP (DT the) (NN night)) (VP (VBD was) (VP (VBG falling)))))) (. .)))", "det(accident-2, The-1)\nnsubj(happened-3, accident-2)\nroot(ROOT-0, happened-3)\nmark(falling-8, as-4)\ndet(night-6, the-5)\nnsubj(falling-8, night-6)\naux(falling-8, was-7)\nadvcl(happened-3, falling-8)\n"}, {TestType.BASIC, "(ROOT (S (SBAR (IN If) (S (NP (PRP you)) (VP (VBP know) (SBAR (WHNP (WP who)) (S (VP (VBD did) (NP (PRP it)))))))) (, ,) (NP (PRP you)) (VP (MD should) (VP (VB tell) (NP (DT the) (NN teacher)))) (. .)))", "mark(know-3, If-1)\nnsubj(know-3, you-2)\nadvcl(tell-10, know-3)\nnsubj(did-5, who-4)\nccomp(know-3, did-5)\ndobj(did-5, it-6)\nnsubj(tell-10, you-8)\naux(tell-10, should-9)\nroot(ROOT-0, tell-10)\ndet(teacher-12, the-11)\ndobj(tell-10, teacher-12)\n"}, {TestType.BASIC, "(ROOT (S (NP-TMP (JJ Last) (NN night)) (, ,) (NP (PRP I)) (VP (VBP swam) (PP (IN in) (NP (DT the) (NN pool)))) (. .)))", "amod(night-2, Last-1)\nnmod:tmod(swam-5, night-2)\nnsubj(swam-5, I-4)\nroot(ROOT-0, swam-5)\ncase(pool-8, in-6)\ndet(pool-8, the-7)\nnmod(swam-5, pool-8)\n"}, {TestType.BASIC, "(ROOT (S (NP (PRP He)) (VP (VBD talked) (PP (TO to) (NP (DT the) (NN president))) (SBAR (IN in) (NN order) (S (VP (TO to) (VP (VB secure) (NP (DT the) (NN account))))))) (. .)))", "nsubj(talked-2, He-1)\nroot(ROOT-0, talked-2)\ncase(president-5, to-3)\ndet(president-5, the-4)\nnmod(talked-2, president-5)\nmark(secure-9, in-6)\nmwe(in-6, order-7)\nmark(secure-9, to-8)\nadvcl(talked-2, secure-9)\ndet(account-11, the-10)\ndobj(secure-9, account-11)\n"}, {TestType.BASIC, "(ROOT (S (NP (PRP I)) (VP (VBD saw) (NP (NP (DT the) (NN book)) (SBAR (WHNP (WDT which)) (S (NP (PRP you)) (VP (VBD bought)))))) (. .)))", "nsubj(saw-2, I-1)\nroot(ROOT-0, saw-2)\ndet(book-4, the-3)\ndobj(saw-2, book-4)\ndobj(bought-7, which-5)\nnsubj(bought-7, you-6)\nacl:relcl(book-4, bought-7)\n"}, {TestType.BASIC, "(ROOT (S (NP (NNP Sam)) (VP (VBZ eats) (NP (CD 3) (NN sheep))) (. .)))", "nsubj(eats-2, Sam-1)\nroot(ROOT-0, eats-2)\nnummod(sheep-4, 3-3)\ndobj(eats-2, sheep-4)\n"}, {TestType.BASIC, "(ROOT (S (NP (PRP I)) (VP (VBD lost) (NP (QP ($ $) (CD 3.2) (CD billion)))) (. .)))", "nsubj(lost-2, I-1)\nroot(ROOT-0, lost-2)\ndobj(lost-2, $-3)\ncompound(billion-5, 3.2-4)\nnummod($-3, billion-5)\n"}, {TestType.BASIC, "(ROOT (S (NP (QP (RB About) (CD 200)) (NNS people)) (VP (VBD came) (PP (TO to) (NP (DT the) (NN party)))) (. .)))", "advmod(200-2, About-1)\nnummod(people-3, 200-2)\nnsubj(came-4, people-3)\nroot(ROOT-0, came-4)\ncase(party-7, to-5)\ndet(party-7, the-6)\nnmod(came-4, party-7)\n"}, {TestType.BASIC, "(ROOT (S (NP (NP (NNP Sam)) (, ,) (NP (PRP$ my) (NN brother)) (, ,)) (VP (VBZ eats) (NP (JJ red) (NN meat))) (. .)))", "nsubj(eats-6, Sam-1)\nnmod:poss(brother-4, my-3)\nappos(Sam-1, brother-4)\nroot(ROOT-0, eats-6)\namod(meat-8, red-7)\ndobj(eats-6, meat-8)\n"}, {TestType.BASIC, "(ROOT (NP (NP (DT The) (JJ Australian) (NNP Broadcasting) (NNP Corporation)) (PRN (-LRB- -LRB-) (NP (NNP ABC)) (-RRB- -RRB-)) (. .)))", "det(Corporation-4, The-1)\namod(Corporation-4, Australian-2)\ncompound(Corporation-4, Broadcasting-3)\nroot(ROOT-0, Corporation-4)\nappos(Corporation-4, ABC-6)\n"}, {TestType.BASIC, "(ROOT (S (NP (NNP Bill)) (VP (VBD picked) (NP (NNP Fred)) (PP (IN for) (NP (NP (DT the) (NN team)) (VP (VBG demonstrating) (NP (PRP$ his) (NN incompetence)))))) (. .)))", "nsubj(picked-2, Bill-1)\nroot(ROOT-0, picked-2)\ndobj(picked-2, Fred-3)\ncase(team-6, for-4)\ndet(team-6, the-5)\nnmod(picked-2, team-6)\nacl(team-6, demonstrating-7)\nnmod:poss(incompetence-9, his-8)\ndobj(demonstrating-7, incompetence-9)\n"}, {TestType.BASIC, "(ROOT (S (NP (NNP Bill)) (VP (VBZ is) (RB not) (NP (DT a) (NN scientist))) (. .)))", "nsubj(scientist-5, Bill-1)\ncop(scientist-5, is-2)\nneg(scientist-5, not-3)\ndet(scientist-5, a-4)\nroot(ROOT-0, scientist-5)\n"}, {TestType.BASIC, "(ROOT (S (NP (NNP Bill)) (VP (VBZ does) (RB n't) (VP (VB drive))) (. .)))", "nsubj(drive-4, Bill-1)\naux(drive-4, does-2)\nneg(drive-4, n't-3)\nroot(ROOT-0, drive-4)\n"}, {TestType.BASIC, "(ROOT (S (NP (DT The) (NN director)) (VP (VBZ is) (ADJP (NP (CD 65) (NNS years)) (JJ old))) (. .)))", "det(director-2, The-1)\nnsubj(old-6, director-2)\ncop(old-6, is-3)\nnummod(years-5, 65-4)\nnmod:npmod(old-6, years-5)\nroot(ROOT-0, old-6)\n"}, {TestType.BASIC, "(ROOT (S (NP (DT The) (NN man)) (VP (VBZ is) (ADVP (RB here))) (. .)))", "det(man-2, The-1)\nnsubj(is-3, man-2)\nroot(ROOT-0, is-3)\nadvmod(is-3, here-4)\n"}, {TestType.BASIC, "(ROOT (SBARQ (WHPP (IN In) (WHNP (WDT which) (NN city))) (SQ (VBP do) (NP (PRP you)) (VP (VB live))) (. ?)))", "case(city-3, In-1)\ndet(city-3, which-2)\nnmod(live-6, city-3)\naux(live-6, do-4)\nnsubj(live-6, you-5)\nroot(ROOT-0, live-6)\n"}, {TestType.BASIC, "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBD did) (NP (NNP Charles) (NNP Babbage)) (VP (VB invent))) (. ?)))", "dobj(invent-5, What-1)\naux(invent-5, did-2)\ncompound(Babbage-4, Charles-3)\nnsubj(invent-5, Babbage-4)\nroot(ROOT-0, invent-5)\n"}, {TestType.BASIC, "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBZ is) (NP (DT the) (NN esophagus)) (VP (VBN used) (PP (IN for)))) (. ?)))", "nmod(used-5, What-1)\nauxpass(used-5, is-2)\ndet(esophagus-4, the-3)\nnsubjpass(used-5, esophagus-4)\nroot(ROOT-0, used-5)\ncase(What-1, for-6)\n"}, {TestType.BASIC, "(ROOT (S (NP (PDT All) (DT the) (NNS boys)) (VP (VBP are) (ADVP (RB here))) (. .)))", "det:predet(boys-3, All-1)\ndet(boys-3, the-2)\nnsubj(are-4, boys-3)\nroot(ROOT-0, are-4)\nadvmod(are-4, here-5)\n"}, {TestType.BASIC, "(ROOT (S (NP (CC Both) (NP (DT the) (NNS boys)) (CC and) (NP (DT the) (NNS girls))) (VP (VBP are) (ADVP (RB here))) (. .)))", "cc:preconj(boys-3, Both-1)\ndet(boys-3, the-2)\nnsubj(are-7, boys-3)\ncc(boys-3, and-4)\ndet(girls-6, the-5)\nconj(boys-3, girls-6)\nroot(ROOT-0, are-7)\nadvmod(are-7, here-8)\n"}, {TestType.BASIC, "(ROOT (S (NP (PRP They)) (VP (VBD shut) (PRT (RP down)) (NP (DT the) (NN station))) (. .)))", "nsubj(shut-2, They-1)\nroot(ROOT-0, shut-2)\ncompound:prt(shut-2, down-3)\ndet(station-5, the-4)\ndobj(shut-2, station-5)\n"}, {TestType.BASIC, "(ROOT (S (NP (NP (NNS Truffles)) (VP (VBN picked) (PP (IN during) (NP (DT the) (NN spring))))) (VP (VBP are) (ADJP (JJ tasty))) (. .)))", "nsubj(tasty-7, Truffles-1)\nacl(Truffles-1, picked-2)\ncase(spring-5, during-3)\ndet(spring-5, the-4)\nnmod(picked-2, spring-5)\ncop(tasty-7, are-6)\nroot(ROOT-0, tasty-7)\n"}, {TestType.BASIC, "(ROOT (S  (NP-SBJ-38 (DT Neither) (NP (PRP they) ) (CC nor) (NP (NNP Mr.) (NNP McAlpine) )) (VP (MD could) (VP (VB be) (VP (VBN reached) (NP (-NONE- *-38) ) (PP-PRP (IN for) (NP (NN comment) ))))) (. .) ))", "cc:preconj(they-2, Neither-1)\nnsubjpass(reached-8, they-2)\ncc(they-2, nor-3)\ncompound(McAlpine-5, Mr.-4)\nconj(they-2, McAlpine-5)\naux(reached-8, could-6)\nauxpass(reached-8, be-7)\nroot(ROOT-0, reached-8)\ncase(comment-10, for-9)\nnmod(reached-8, comment-10)\n"}, {TestType.BASIC, "(ROOT (S (NP (NNP Xml) (NN field)) (VP (MD should) (VP (VB include) (NP (PDT both) (NP (DT the) (NN entity) (NN id)) (CC and) (NP (DT the) (NN entity) (NN name))) (SBAR (IN since) (S (NP (DT the) (NN entity) (NNS names)) (VP (VBP are) (RB not) (ADJP (JJ unique))))))) (. .)))", "compound(field-2, Xml-1)\nnsubj(include-4, field-2)\naux(include-4, should-3)\nroot(ROOT-0, include-4)\ncc:preconj(id-8, both-5)\ndet(id-8, the-6)\ncompound(id-8, entity-7)\ndobj(include-4, id-8)\ncc(id-8, and-9)\ndet(name-12, the-10)\ncompound(name-12, entity-11)\nconj(id-8, name-12)\nmark(unique-19, since-13)\ndet(names-16, the-14)\ncompound(names-16, entity-15)\nnsubj(unique-19, names-16)\ncop(unique-19, are-17)\nneg(unique-19, not-18)\nadvcl(include-4, unique-19)\n"}, {TestType.BASIC, "(ROOT (S (S (NP (DT The) (NN government)) (VP (VBZ counts) (NP (NN money)) (SBAR (IN as) (S (NP (PRP it)) (VP (VBZ is) (VP (VBN spent))))))) (: ;) (S (NP (NNP Dodge)) (VP (VBZ counts) (NP (NNS contracts)) (SBAR (WHADVP (WRB when)) (S (NP (PRP they)) (VP (VBP are) (VP (VBN awarded))))))) (. .)))", "det(government-2, The-1)\nnsubj(counts-3, government-2)\nroot(ROOT-0, counts-3)\ndobj(counts-3, money-4)\nmark(spent-8, as-5)\nnsubjpass(spent-8, it-6)\nauxpass(spent-8, is-7)\nadvcl(counts-3, spent-8)\nnsubj(counts-11, Dodge-10)\nparataxis(counts-3, counts-11)\ndobj(counts-11, contracts-12)\nadvmod(awarded-16, when-13)\nnsubjpass(awarded-16, they-14)\nauxpass(awarded-16, are-15)\nadvcl(counts-11, awarded-16)\n"}, {TestType.BASIC, "( (S (CC But) (NP (PRP she)) (VP (VBD did) (RB n't) (VP (VB deserve) (S (VP (TO to) (VP (VB have) (S (NP (PRP$ her) (NN head)) (VP (VBN chopped) (PRT (RP off))))))))) (. .)))", "cc(deserve-5, But-1)\nnsubj(deserve-5, she-2)\naux(deserve-5, did-3)\nneg(deserve-5, n't-4)\nroot(ROOT-0, deserve-5)\nmark(have-7, to-6)\nxcomp(deserve-5, have-7)\nnmod:poss(head-9, her-8)\nnsubj(chopped-10, head-9)\nccomp(have-7, chopped-10)\ncompound:prt(chopped-10, off-11)\n"}, {TestType.BASIC, "( (S (NP (PRP I)) (VP (VBP like) (NP (NP (NNS dogs)) (CONJP (RB rather) (IN than)) (NP (NNS cats)))) (. .)))", "nsubj(like-2, I-1)\nroot(ROOT-0, like-2)\ndobj(like-2, dogs-3)\ncc(dogs-3, rather-4)\nmwe(rather-4, than-5)\nconj(dogs-3, cats-6)\n"}, {TestType.BASIC, "( (S (NP (PRP I)) (VP (VBP like) (NP (NP (NN brandy)) (CONJP (RB not) (TO to) (VB mention)) (NP (NN cognac)))) (. .)))", "nsubj(like-2, I-1)\nroot(ROOT-0, like-2)\ndobj(like-2, brandy-3)\ncc(brandy-3, not-4)\nmwe(not-4, to-5)\nmwe(not-4, mention-6)\nconj(brandy-3, cognac-7)\n"}, {TestType.BASIC, "( (S (NP (PRP I)) (VP (VBP like) (NP (CONJP (RB not) (RB only)) (NP (NNS cats)) (CONJP (CC but) (RB also)) (NP (NN dogs)))) (. .)))", "nsubj(like-2, I-1)\nroot(ROOT-0, like-2)\nneg(only-4, not-3)\ncc:preconj(cats-5, only-4)\ndobj(like-2, cats-5)\ncc(cats-5, but-6)\nadvmod(dogs-8, also-7)\nconj(cats-5, dogs-8)\n"}, {TestType.BASIC, "( (S (NP (PRP He)) (VP (VBZ knows) (NP (DT the) (NML (JJ mechanical) (NN engineering)) (NN industry))) (. .)))", "nsubj(knows-2, He-1)\nroot(ROOT-0, knows-2)\ndet(industry-6, the-3)\namod(engineering-5, mechanical-4)\ncompound(industry-6, engineering-5)\ndobj(knows-2, industry-6)\n"}, {TestType.BASIC, "( (SBARQ (WHNP (WP What) (NN weapon)) (SQ (VBZ is) (NP (DT the) (JJ mythological) (NN character) (NN Apollo)) (ADJP (RBS most) (JJ proficient) (PP (IN with)))) (. ?)))", "det(weapon-2, What-1)\nnmod(proficient-9, weapon-2)\ncop(proficient-9, is-3)\ndet(Apollo-7, the-4)\namod(Apollo-7, mythological-5)\ncompound(Apollo-7, character-6)\nnsubj(proficient-9, Apollo-7)\nadvmod(proficient-9, most-8)\nroot(ROOT-0, proficient-9)\ncase(weapon-2, with-10)\n"}, {TestType.BASIC, "( (SINV (CC Nor) (VBP are) (NP (PRP you)) (ADJP (JJ free) (S (VP (TO to) (VP (VB reprint) (NP (JJ such) (NN material))))))) )", "cc(free-4, Nor-1)\ncop(free-4, are-2)\nnsubj(free-4, you-3)\nroot(ROOT-0, free-4)\nmark(reprint-6, to-5)\nxcomp(free-4, reprint-6)\namod(material-8, such-7)\ndobj(reprint-6, material-8)\n"}, {TestType.BASIC, "(ROOT (SBARQ (WHNP (WHADJP (WRB How) (JJ many)) (NP (NNP James) (NNP Bond) (NNS novels))) (SQ (VBP are) (NP (EX there))) (. ?)))", "advmod(many-2, How-1)\namod(novels-5, many-2)\ncompound(novels-5, James-3)\ncompound(novels-5, Bond-4)\nnsubj(are-6, novels-5)\nroot(ROOT-0, are-6)\nexpl(are-6, there-7)\n"}, {TestType.BASIC, "( (S (NP (NP (NNS Investments)) (PP (IN in) (NP (NNP South) (NNP Africa)))) (VP (MD will) (VP (VB be) (VP (VBN excluded)))) (. .)))", "nsubjpass(excluded-7, Investments-1)\ncase(Africa-4, in-2)\ncompound(Africa-4, South-3)\nnmod(Investments-1, Africa-4)\naux(excluded-7, will-5)\nauxpass(excluded-7, be-6)\nroot(ROOT-0, excluded-7)\n"}, {TestType.BASIC, "( (SINV (ADVP (RB Also)) (VP (VBN excluded)) (VP (MD will) (VP (VB be))) (NP (NP (NNS investments)) (PP (IN in) (NP (NNP South) (NNP Africa)))) (. .)))", "advmod(excluded-2, Also-1)\nroot(ROOT-0, excluded-2)\naux(be-4, will-3)\nauxpass(excluded-2, be-4)\nnsubjpass(excluded-2, investments-5)\ncase(Africa-8, in-6)\ncompound(Africa-8, South-7)\nnmod(investments-5, Africa-8)\n"}, {TestType.BASIC, "( (SINV (VP (VBG Defending) (NP (PRP$ their) (NNS ramparts))) (VP (VBP are)) (NP (NP (NNP Wall) (NNP Street) (POS 's)) (NNP Old) (NNP Guard)) (. .)))", "root(ROOT-0, Defending-1)\nnmod:poss(ramparts-3, their-2)\ndobj(Defending-1, ramparts-3)\naux(Defending-1, are-4)\ncompound(Street-6, Wall-5)\nnmod:poss(Guard-9, Street-6)\ncase(Street-6, 's-7)\ncompound(Guard-9, Old-8)\nnsubj(Defending-1, Guard-9)\n"}, {TestType.BASIC, "( (S (NP-SBJ (JJ Institutional) (NNS investors)) (ADVP (RB mostly)) (VP (VBD remained) (PP-LOC-PRD (IN on) (NP (DT the) (NNS sidelines))) (NP-TMP (NNP Tuesday))) (. .)))", "amod(investors-2, Institutional-1)\nnsubj(remained-4, investors-2)\nadvmod(remained-4, mostly-3)\nroot(ROOT-0, remained-4)\ncase(sidelines-7, on-5)\ndet(sidelines-7, the-6)\nnmod(remained-4, sidelines-7)\nnmod:tmod(remained-4, Tuesday-8)\n"}, {TestType.BASIC, "( (SQ (VBZ Is) (NP-SBJ (DT this)) (NP-PRD (NP (DT the) (NN future)) (PP (IN of) (NP (NN chamber) (NN music)))) (. ?)))", "cop(future-4, Is-1)\nnsubj(future-4, this-2)\ndet(future-4, the-3)\nroot(ROOT-0, future-4)\ncase(music-7, of-5)\ncompound(music-7, chamber-6)\nnmod(future-4, music-7)\n"}, {TestType.BASIC, "( (SQ (VBZ Is) (NP-SBJ (DT the) (NN trouble)) (ADVP-PRD (RP over)) (. ?)))", "root(ROOT-0, Is-1)\ndet(trouble-3, the-2)\nnsubj(Is-1, trouble-3)\nadvmod(Is-1, over-4)\n"}, {TestType.BASIC, "( (SBARQ (SBAR (IN Although) (S (NP (NNP Sue)) (VP (VBP is) (ADJP (JJ smart))))) (, ,) (WHNP (WP who)) (SQ (MD will) (VP (VB win))) (. ?)))", "mark(smart-4, Although-1)\nnsubj(smart-4, Sue-2)\ncop(smart-4, is-3)\nadvcl(win-8, smart-4)\nnsubj(win-8, who-6)\naux(win-8, will-7)\nroot(ROOT-0, win-8)\n"}, {TestType.BASIC, "(NP (NP (NNP Xerox))(, ,) (SBAR (WHNP (WHNP (WP$ whose) (JJ chief) (JJ executive) (NN officer))(, ,) (NP (NNP James) (NNP Gatward))(, ,)) (S (NP-SBJ (-NONE- *T*-1)) (VP (VBZ has) (VP (VBN resigned))))))", "root(ROOT-0, Xerox-1)\nnmod:poss(officer-6, whose-3)\namod(officer-6, chief-4)\namod(officer-6, executive-5)\nnsubj(resigned-12, officer-6)\ncompound(Gatward-9, James-8)\nappos(officer-6, Gatward-9)\naux(resigned-12, has-11)\nacl:relcl(Xerox-1, resigned-12)\n"}, {TestType.BASIC, "(ROOT (S (NP (PRP He)) (VP (VBZ gets) (NP (PRP me)) (ADVP-TMP (DT every) (NN time))) (. .)))", "nsubj(gets-2, He-1)\nroot(ROOT-0, gets-2)\ndobj(gets-2, me-3)\ndet(time-5, every-4)\nadvmod(gets-2, time-5)\n"}, {TestType.BASIC, "( (S (NP-SBJ (CC Both) (NP (NNP Mr.) (NNP Parenteau)) (CC and) (NP (NNP Ms.) (NNP Doyon))) (, ,) (ADVP (RB however)) (, ,) (VP (VBD were) (VP (VBG bleeding) (ADVP (RB badly)))) (. .)))", "cc:preconj(Parenteau-3, Both-1)\ncompound(Parenteau-3, Mr.-2)\nnsubj(bleeding-11, Parenteau-3)\ncc(Parenteau-3, and-4)\ncompound(Doyon-6, Ms.-5)\nconj(Parenteau-3, Doyon-6)\nadvmod(bleeding-11, however-8)\naux(bleeding-11, were-10)\nroot(ROOT-0, bleeding-11)\nadvmod(bleeding-11, badly-12)\n"}, {TestType.BASIC, "(NP-SBJ-1 (ADJP (ADJP (VBN Rusted) (RP out)) (CC and) (ADJP (JJ unsafe))) (NNS cars))", "amod(cars-5, Rusted-1)\ncompound:prt(Rusted-1, out-2)\ncc(Rusted-1, and-3)\nconj(Rusted-1, unsafe-4)\nroot(ROOT-0, cars-5)\n"}, {TestType.BASIC, "( (S (NP-SBJ (PRP u)) (VP (VBP r) (VP (VBG holding) (NP (PRP it)) (ADVP (RB too) (RB tight))))))", "nsubj(holding-3, u-1)\naux(holding-3, r-2)\nroot(ROOT-0, holding-3)\ndobj(holding-3, it-4)\nadvmod(tight-6, too-5)\nadvmod(holding-3, tight-6)\n"}, {TestType.BASIC, "( (S (NP-SBJ (PRP You)) (VP (MD should) (VP (GW e) (VB mail) (NP (PRP her)) (ADVP-TMP (RB sometimes)))) (. .)))", "nsubj(mail-4, You-1)\naux(mail-4, should-2)\ngoeswith(mail-4, e-3)\nroot(ROOT-0, mail-4)\ndobj(mail-4, her-5)\nadvmod(mail-4, sometimes-6)\n"}, {TestType.BASIC, "( (S (NP-SBJ (NN Interest)) (VP (VBZ is) (ADJP-PRD (ADJP (NP-ADV (DT a) (JJ great) (NN deal)) (JJR higher)) (SBAR (IN than) (S (NP-SBJ (PRP it)) (VP (VBD was) (ADJP-PRD (-NONE- *?*)) (ADVP-TMP (NP (DT a) (NN year)) (RB ago))))))) (. .)))", "nsubj(higher-6, Interest-1)\ncop(higher-6, is-2)\ndet(deal-5, a-3)\namod(deal-5, great-4)\nnmod:npmod(higher-6, deal-5)\nroot(ROOT-0, higher-6)\nmark(was-9, than-7)\nnsubj(was-9, it-8)\nccomp(higher-6, was-9)\ndet(year-11, a-10)\nnmod:npmod(ago-12, year-11)\nadvmod(was-9, ago-12)\n"}, {TestType.BASIC, "( (S (NP-SBJ (DT The) (NN strike)) (VP (MD may) (VP (VB have) (VP (VBN ended) (SBAR-TMP (ADVP (RB almost)) (IN before) (S (NP-SBJ (PRP it)) (VP (VBD began)))))))))", "det(strike-2, The-1)\nnsubj(ended-5, strike-2)\naux(ended-5, may-3)\naux(ended-5, have-4)\nroot(ROOT-0, ended-5)\nadvmod(began-9, almost-6)\nmark(began-9, before-7)\nnsubj(began-9, it-8)\nadvcl(ended-5, began-9)\n"}, {TestType.BASIC, "( (S (SBAR-ADV (IN Although) (S (VP (VBN set) (PP-LOC (IN in) (NP (NNP Japan)))))) (, ,) (NP-SBJ-2 (NP (DT the) (NN novel) (POS 's)) (NN texture)) (VP (VBZ is) (ADJP (JJ American))) (. .)))", "mark(set-2, Although-1)\nadvcl(American-11, set-2)\ncase(Japan-4, in-3)\nnmod(set-2, Japan-4)\ndet(novel-7, the-6)\nnmod:poss(texture-9, novel-7)\ncase(novel-7, 's-8)\nnsubj(American-11, texture-9)\ncop(American-11, is-10)\nroot(ROOT-0, American-11)\n"}, {TestType.BASIC, "( (S-IMP (INTJ (UH please)) (NP-SBJ (-NONE- *PRO*)) (VP (VB specify) (NP (WDT which) (NML (NNP royal) (CC or) (NNP carnival)) (NN ship))) (NFP -LRB-:)))", "discourse(specify-2, please-1)\nroot(ROOT-0, specify-2)\ndet(ship-7, which-3)\ncompound(ship-7, royal-4)\ncc(royal-4, or-5)\nconj(royal-4, carnival-6)\ndobj(specify-2, ship-7)\ndiscourse(specify-2, -LRB-:-8)\n"}, {TestType.BASIC, "(NP (DT those) (RRC (ADVP-TMP (RB still)) (PP-LOC (IN under) (NP (NNP GASB) (NNS rules)))))", "root(ROOT-0, those-1)\nadvmod(rules-5, still-2)\ncase(rules-5, under-3)\ncompound(rules-5, GASB-4)\nacl:relcl(those-1, rules-5)\n"}, {TestType.BASIC, "(NP (NP (DT the) (NN auction) (NN house)) (RRC (RRC (VP (VBN founded) (NP (-NONE- *)) (PP-LOC (IN in) (NP (NNP London))) (NP-TMP (CD 1744)))) (CC and) (RRC (ADVP-TMP (RB now)) (PP (IN under) (NP (NP (DT the) (NN umbrella)) (PP (IN of) (NP (NP (NNP Sotheby) (POS 's)) (NNPS Holdings) (NNP Inc.))))))))", "det(house-3, the-1)\ncompound(house-3, auction-2)\nroot(ROOT-0, house-3)\nacl:relcl(house-3, founded-4)\ncase(London-6, in-5)\nnmod(founded-4, London-6)\nnmod:tmod(founded-4, 1744-7)\ncc(founded-4, and-8)\nadvmod(umbrella-12, now-9)\ncase(umbrella-12, under-10)\ndet(umbrella-12, the-11)\nconj(founded-4, umbrella-12)\ncase(Inc.-17, of-13)\nnmod:poss(Inc.-17, Sotheby-14)\ncase(Sotheby-14, 's-15)\ncompound(Inc.-17, Holdings-16)\nnmod(umbrella-12, Inc.-17)\n"}, {TestType.BASIC, "(S (NP-SBJ (NNS morcillas)) (VP (VBP are) (ADVP (RB basically)) (ADJP-PRD (JJ impossible) (SBAR (WHNP-1 (-NONE- *0*)) (S (NP-SBJ (-NONE- *PRO*)) (VP (TO to) (VP (VB find) (NP-1 (-NONE- *T*)) (PP-LOC (IN in) (NP (NNP California))))))))))", "nsubj(impossible-4, morcillas-1)\ncop(impossible-4, are-2)\nadvmod(impossible-4, basically-3)\nroot(ROOT-0, impossible-4)\nmark(find-6, to-5)\nccomp(impossible-4, find-6)\ncase(California-8, in-7)\nnmod(find-6, California-8)\n"}, {TestType.BASIC, "( (S (S (NP-SBJ (-NONE- *)) (VP (VBP Do) (RB n't) (VP (VB wait)))) (: --) (S (NP-SBJ (-NONE- *)) (VP (VBP act) (ADVP-TMP (RB now)))) (. !)))", "aux(wait-3, Do-1)\nneg(wait-3, n't-2)\nroot(ROOT-0, wait-3)\nparataxis(wait-3, act-5)\nadvmod(act-5, now-6)\n"}, {TestType.BASIC, "( (S (NP-SBJ (DT The) (NNPS Parks) (NNP Council)) (VP (VBD wrote) (NP (DT the) (NNP BPCA)) (SBAR (IN that) (S (NP-SBJ (DT this) (ADJP (`` ``) (RB too) (`` `) (JJ private) ('' ') (: ...) (JJ exclusive) (, ,) ('' '') (JJ complex) (CC and) (JJ expensive)) (`` ``) (VBN enclosed) (NN garden)) (: ...) (VP (VBZ belongs) (PP-LOC-CLR (IN in) (NP (NP (RB almost) (DT any) (NN location)) (CC but) (NP (DT the) (NN waterfront)))))))) (. .) ('' '')))", "det(Council-3, The-1)\ncompound(Council-3, Parks-2)\nnsubj(wrote-4, Council-3)\nroot(ROOT-0, wrote-4)\ndet(BPCA-6, the-5)\ndobj(wrote-4, BPCA-6)\nmark(belongs-25, that-7)\ndet(garden-23, this-8)\nadvmod(private-12, too-10)\namod(garden-23, private-12)\nconj(private-12, exclusive-15)\nconj(private-12, complex-18)\ncc(private-12, and-19)\nconj(private-12, expensive-20)\namod(garden-23, enclosed-22)\nnsubj(belongs-25, garden-23)\nccomp(wrote-4, belongs-25)\ncase(location-29, in-26)\nadvmod(location-29, almost-27)\ndet(location-29, any-28)\nnmod(belongs-25, location-29)\ncc(location-29, but-30)\ndet(waterfront-32, the-31)\nconj(location-29, waterfront-32)\n"}, {TestType.BASIC, "( (S (`` ``) (CC And) (NP-SBJ (PRP you)) (VP (MD ca) (RB n't) (VP (VB have) (S (NP-SBJ (NP (NNS taxpayers)) (VP (VBG coming) (PP-DIR (IN into) (NP (DT an) (NN audit))))) (VP (VBG hearing) (NP (`` `) (UH oohs) (: ') (CC and) (`` `) (UH ahs)))))) (. .) ('' ') ('' '')))", "cc(have-6, And-2)\nnsubj(have-6, you-3)\naux(have-6, ca-4)\nneg(have-6, n't-5)\nroot(ROOT-0, have-6)\nnsubj(hearing-12, taxpayers-7)\nacl(taxpayers-7, coming-8)\ncase(audit-11, into-9)\ndet(audit-11, an-10)\nnmod(coming-8, audit-11)\nccomp(have-6, hearing-12)\ndobj(hearing-12, oohs-14)\ncc(oohs-14, and-16)\nconj(oohs-14, ahs-18)\n"}, {TestType.BASIC, "( (S (NP-SBJ-1 (VBN Freed) (JJ black) (NNS nationalists)) (VP (VP (VBD resumed) (NP (JJ political) (NN activity)) (PP-LOC (IN in) (NP (NNP South) (NNP Africa)))) (CC and) (VP (VBD vowed) (S (NP-SBJ (-NONE- *-1)) (VP (TO to) (VP (VB fight) (PP-CLR (IN against) (NP (NN apartheid))))))) (, ,) (S-ADV (NP-SBJ (-NONE- *)) (VP (VBG raising) (NP (NP (NNS fears)) (PP (IN of) (NP (DT a) (JJ possible) (JJ white) (NN backlash))))))) (. .)))", "amod(nationalists-3, Freed-1)\namod(nationalists-3, black-2)\nnsubj(resumed-4, nationalists-3)\nroot(ROOT-0, resumed-4)\namod(activity-6, political-5)\ndobj(resumed-4, activity-6)\ncase(Africa-9, in-7)\ncompound(Africa-9, South-8)\nnmod(resumed-4, Africa-9)\ncc(resumed-4, and-10)\nconj(resumed-4, vowed-11)\nmark(fight-13, to-12)\nxcomp(vowed-11, fight-13)\ncase(apartheid-15, against-14)\nnmod(fight-13, apartheid-15)\nadvcl(resumed-4, raising-17)\ndobj(raising-17, fears-18)\ncase(backlash-23, of-19)\ndet(backlash-23, a-20)\namod(backlash-23, possible-21)\namod(backlash-23, white-22)\nnmod(fears-18, backlash-23)\n"}, {TestType.BASIC, "( (S (S-NOM-SBJ (NP-SBJ-1 (-NONE- *)) (VP (VBG Being) (VP (VBN held) (S (NP-SBJ (-NONE- *-1)) (PP-PRD (ADVP (RB well)) (IN below) (NP (NN capacity))))))) (VP (VP (ADVP-MNR (RB greatly)) (VBZ irritates) (NP (PRP them))) (, ,) (CC and) (VP (VBZ has) (VP (VBN led) (PP-CLR (TO to) (NP (JJ widespread) (NN cheating)))))) (. .)))", "auxpass(held-2, Being-1)\ncsubj(irritates-7, held-2)\nadvmod(capacity-5, well-3)\ncase(capacity-5, below-4)\nnmod(held-2, capacity-5)\nadvmod(irritates-7, greatly-6)\nroot(ROOT-0, irritates-7)\ndobj(irritates-7, them-8)\ncc(irritates-7, and-10)\naux(led-12, has-11)\nconj(irritates-7, led-12)\ncase(cheating-15, to-13)\namod(cheating-15, widespread-14)\nnmod(led-12, cheating-15)\n"}, {TestType.BASIC, "( (S (NP-SBJ (PRP They)) (VP (VBD acquired) (NP (NP (NNS stakes)) (PP (IN in) (NP (NP (VBG bottling) (NNS companies)) (UCP-LOC (PP (IN in) (NP (DT the) (NNP U.S.))) (CC and) (ADVP (RB overseas))))))) (. .)))", "nsubj(acquired-2, They-1)\nroot(ROOT-0, acquired-2)\ndobj(acquired-2, stakes-3)\ncase(companies-6, in-4)\namod(companies-6, bottling-5)\nnmod(stakes-3, companies-6)\ncase(U.S.-9, in-7)\ndet(U.S.-9, the-8)\nnmod(companies-6, U.S.-9)\ncc(U.S.-9, and-10)\nconj(U.S.-9, overseas-11)\n"}, {TestType.BASIC, "(ROOT (S (NP (PRP I)) (VP (VBD saw) (NP (NP (DT the) (NN woman)) (SBAR (WHNP (WP whom)) (S (NP (PRP you)) (VP (VBD gave) (NP (DT the) (NN package)) (PP (TO to))))))) (. .)))", "nsubj(saw-2, I-1)\nroot(ROOT-0, saw-2)\ndet(woman-4, the-3)\ndobj(saw-2, woman-4)\nnmod(gave-7, whom-5)\nnsubj(gave-7, you-6)\nacl:relcl(woman-4, gave-7)\ndet(package-9, the-8)\ndobj(gave-7, package-9)\ncase(whom-5, to-10)\n"}, {TestType.BASIC, "( (S (NP-SBJ (PRP i)) (VP (VBP m) (ADJP-PRD (JJ fat)))))", "nsubj(fat-3, i-1)\ncop(fat-3, m-2)\nroot(ROOT-0, fat-3)\n"}, {TestType.BASIC, "(NP (NP (NNP Mr.) (NNP Laidig)) (, ,) (SBAR (WHNP-1 (WP whom)) (S (NP-SBJ (PRP he)) (VP (VBD referred) (PP-CLR (TO to) (NP (-NONE- *T*-1))) (PP-CLR (IN as) (NP (DT a) (NN friend)))))))", "compound(Laidig-2, Mr.-1)\nroot(ROOT-0, Laidig-2)\nnmod(referred-6, whom-4)\nnsubj(referred-6, he-5)\nacl:relcl(Laidig-2, referred-6)\ncase(whom-4, to-7)\ncase(friend-10, as-8)\ndet(friend-10, a-9)\nnmod(referred-6, friend-10)\n"}, {TestType.BASIC, "( (SBARQ (WHNP-9 (WP what)) (SQ (VBZ does) (NP-SBJ (PRP it)) (VP (VB mean) (NP-9 (-NONE- *T*)) (SBAR-TMP (WHADVP-1 (WRB when)) (S (NP-SBJ (DT a) (JJ veiled) (NN chameleon) (NN egg)) (VP (VBZ is) (ADJP-PRD (JJ soft)) (ADVP-TMP-1 (-NONE- *T*))))))) (. ?)))", "dobj(mean-4, what-1)\naux(mean-4, does-2)\nnsubj(mean-4, it-3)\nroot(ROOT-0, mean-4)\nadvmod(soft-11, when-5)\ndet(egg-9, a-6)\namod(egg-9, veiled-7)\ncompound(egg-9, chameleon-8)\nnsubj(soft-11, egg-9)\ncop(soft-11, is-10)\nadvcl(mean-4, soft-11)\n"}, {TestType.BASIC, "( (S (NP-SBJ (PRP it)) (VP (VBD wase) (RB nt) (VP (VBG going))) (. ....)))", "nsubj(going-4, it-1)\naux(going-4, wase-2)\nneg(going-4, nt-3)\nroot(ROOT-0, going-4)\n"}, {TestType.BASIC, "( (S (NP-SBJ (DT An) (NN arbitrator) ) (VP (VP (VBD awarded) (NP (NNP Eastern) (NNPS Airlines) (NNS pilots) ) (NP (NP (QP (IN between) ($ $) (CD 60) (CD million) (CC and) ($ $) (CD 100) (CD million) ) (-NONE- *U*) ) (PP (IN in) (NP (JJ back) (NN pay) )))) (, ,) (NP-ADV (NP (DT a) (NN decision) ) (SBAR (WHNP-285 (WDT that) ) (S (NP-SBJ (-NONE- *T*-285) ) (VP (MD could) (VP (VB complicate) (NP (NP (DT the) (NN carrier) (POS 's) ) (NN bankruptcy-law) (NN reorganization) ))))))) (. .) ))", "det(arbitrator-2, An-1)\nnsubj(awarded-3, arbitrator-2)\nroot(ROOT-0, awarded-3)\ncompound(pilots-6, Eastern-4)\ncompound(pilots-6, Airlines-5)\niobj(awarded-3, pilots-6)\nadvmod($-8, between-7)\ndobj(awarded-3, $-8)\ncompound(million-10, 60-9)\nnummod($-8, million-10)\ncc($-8, and-11)\nconj($-8, $-12)\ncompound(million-14, 100-13)\nnummod($-12, million-14)\ncase(pay-17, in-15)\namod(pay-17, back-16)\nnmod($-8, pay-17)\ndet(decision-20, a-19)\nnmod:npmod(awarded-3, decision-20)\nnsubj(complicate-23, that-21)\naux(complicate-23, could-22)\nacl:relcl(decision-20, complicate-23)\ndet(carrier-25, the-24)\nnmod:poss(reorganization-28, carrier-25)\ncase(carrier-25, 's-26)\ncompound(reorganization-28, bankruptcy-law-27)\ndobj(complicate-23, reorganization-28)\n"}, {TestType.BASIC, "(ROOT (S (NP (CD Two) (JJ former) (NNS ministers) ) (VP (VBD were) (ADJP (ADJP (ADVP (RB heavily) ) (VBN implicated) )) (PP (IN in) (NP (DT the) (NNP Koskotas) (NN affair) )))))", "nummod(ministers-3, Two-1)\namod(ministers-3, former-2)\nnsubjpass(implicated-6, ministers-3)\nauxpass(implicated-6, were-4)\nadvmod(implicated-6, heavily-5)\nroot(ROOT-0, implicated-6)\ncase(affair-10, in-7)\ndet(affair-10, the-8)\ncompound(affair-10, Koskotas-9)\nnmod(implicated-6, affair-10)\n"}, {TestType.BASIC, "( (S (NP-SBJ (CD Two) (JJ former) (NNS ministers) ) (VP (VBD were) (ADJP-PRD (ADJP (ADVP (RB heavily) ) (VBN implicated) )) (PP-LOC (IN in) (NP (DT the) (NNP Koskotas) (NN affair) )))))", "nummod(ministers-3, Two-1)\namod(ministers-3, former-2)\nnsubjpass(implicated-6, ministers-3)\nauxpass(implicated-6, were-4)\nadvmod(implicated-6, heavily-5)\nroot(ROOT-0, implicated-6)\ncase(affair-10, in-7)\ndet(affair-10, the-8)\ncompound(affair-10, Koskotas-9)\nnmod(implicated-6, affair-10)\n"}, {TestType.BASIC, "(NP-ADV (NP (DT The) (JJR more) (NNS accounts) ) (SBAR (WHNP-1 (-NONE- 0) ) (S (NP-SBJ (NNS customers) ) (VP (VBP have) (NP (-NONE- *T*-1) )))))", "det(accounts-3, The-1)\namod(accounts-3, more-2)\nroot(ROOT-0, accounts-3)\nnsubj(have-5, customers-4)\nacl:relcl(accounts-3, have-5)\n"}, {TestType.BASIC, "(NP-ADV (NP-ADV (DT a) (NN-ADV lesson)) (VP (ADVP (RB once)) (VBN learned) (PP (IN by) (NP (NNP Henry) (NNP Kissinger)))))", "det(lesson-2, a-1)\nroot(ROOT-0, lesson-2)\nadvmod(learned-4, once-3)\nacl(lesson-2, learned-4)\ncase(Kissinger-7, by-5)\ncompound(Kissinger-7, Henry-6)\nnmod(learned-4, Kissinger-7)\n"}, {TestType.BASIC, "(NP (NP (NNP U.S.)) (PP (CC v.) (NP (NNP Hudson) (CC and) (NNP Goodwin))))", "root(ROOT-0, U.S.-1)\ncase(Hudson-3, v.-2)\nnmod(U.S.-1, Hudson-3)\ncc(Hudson-3, and-4)\nconj(Hudson-3, Goodwin-5)\n"}, {TestType.BASIC, "(NP (NP (NN nothing)) (PP (CC but) (NP (PRP$ their) (NNS scratches))))", "root(ROOT-0, nothing-1)\ncase(scratches-4, but-2)\nnmod:poss(scratches-4, their-3)\nnmod(nothing-1, scratches-4)\n"}, {TestType.BASIC, "(FRAG (ADVP (ADVP (RB So) (RB long)) (SBAR (IN as) (S (NP-SBJ (PRP you)) (VP (VBP do) (RB n't) (VP (VB look) (ADVP-DIR (RB down))))))) (. .))", "advmod(long-2, So-1)\nroot(ROOT-0, long-2)\nmark(look-7, as-3)\nnsubj(look-7, you-4)\naux(look-7, do-5)\nneg(look-7, n't-6)\nadvcl(long-2, look-7)\nadvmod(look-7, down-8)\n"}, {TestType.BASIC, "(ROOT (S (NP (NNP Bill)) (VP (VBZ is) (PP (IN from) (NP (NNP California)))) (. .)))", "nsubj(California-4, Bill-1)\ncop(California-4, is-2)\ncase(California-4, from-3)\nroot(ROOT-0, California-4)\n"}, {TestType.BASIC, "( (SBARQ (WHNP (WDT What) (NN radio) (NN station)) (SQ (VBD did) (NP (NNP Paul) (NNP Harvey)) (VP (VB work) (PP (IN for)))) (. ?)))", "det(station-3, What-1)\ncompound(station-3, radio-2)\nnmod(work-7, station-3)\naux(work-7, did-4)\ncompound(Harvey-6, Paul-5)\nnsubj(work-7, Harvey-6)\nroot(ROOT-0, work-7)\ncase(station-3, for-8)\n"}, {TestType.BASIC, "((S (NP (NN Media) (NNS reports))(VP (VBP are)(NP (NP (DT a) (JJ poor) (NN approximation)) (PP (IN of) (NP (NN reality)))) (PP (IN because) (IN of) (NP (NP (DT the) (NN lack)) (PP (IN of) (NP (JJ good) (NNS sources)))))) (. .)))", "compound(reports-2, Media-1)\nnsubj(approximation-6, reports-2)\ncop(approximation-6, are-3)\ndet(approximation-6, a-4)\namod(approximation-6, poor-5)\nroot(ROOT-0, approximation-6)\ncase(reality-8, of-7)\nnmod(approximation-6, reality-8)\ncase(lack-12, because-9)\nmwe(because-9, of-10)\ndet(lack-12, the-11)\nnmod(approximation-6, lack-12)\ncase(sources-15, of-13)\namod(sources-15, good-14)\nnmod(lack-12, sources-15)\n"}, {TestType.BASIC, "((S (S-IMP (NP-SBJ (-NONE- *PRO*)) (VP (VP (VB Try) (S-NOM (NP-SBJ (-NONE- *PRO*)) (VP (VBG googling) (NP (PRP it))))) (CC or) (VP (VB type) (NP (PRP it)) (PP-CLR (IN into) (NP (NNP youtube)))))) (S (NP-SBJ (PRP you)) (VP (MD might) (VP (VB get) (ADJP-PRD (JJ lucky))))) (. .)))", "root(ROOT-0, Try-1)\nxcomp(Try-1, googling-2)\ndobj(googling-2, it-3)\ncc(Try-1, or-4)\nconj(Try-1, type-5)\ndobj(type-5, it-6)\ncase(youtube-8, into-7)\nnmod(type-5, youtube-8)\nnsubj(get-11, you-9)\naux(get-11, might-10)\nparataxis(Try-1, get-11)\nxcomp(get-11, lucky-12)\n"}, {TestType.BASIC, "(ROOT (S (NP (NNP Sue)) (VP (VBZ is) (VP (VBG speaking))) (. .)))", "nsubj(speaking-3, Sue-1)\naux(speaking-3, is-2)\nroot(ROOT-0, speaking-3)\n"}, {TestType.NON_COLLAPSED, "(ROOT (S (NP (NNP Sue)) (VP (VBZ is) (VP (VBG speaking))) (. .)))", "nsubj(speaking-3, Sue-1)\naux(speaking-3, is-2)\nroot(ROOT-0, speaking-3)\n"}, {TestType.BASIC, "(ROOT (SBARQ (WHNP (WP Who)) (SQ (VBZ is)  (VP (VBG speaking))) (. ?)))", "nsubj(speaking-3, Who-1)\naux(speaking-3, is-2)\nroot(ROOT-0, speaking-3)\n"}, {TestType.NON_COLLAPSED, "(ROOT (SBARQ (WHNP (WP Who)) (SQ (VBZ is)  (VP (VBG speaking))) (. ?)))", "nsubj(speaking-3, Who-1)\naux(speaking-3, is-2)\nroot(ROOT-0, speaking-3)\n"}, {TestType.BASIC, "(ROOT (S (VP (VB Be) (ADJP (JJ honest))) (. .)))", "cop(honest-2, Be-1)\nroot(ROOT-0, honest-2)\n"}, {TestType.NON_COLLAPSED, "(ROOT (S (VP (VB Be) (ADJP (JJ honest))) (. .)))", "cop(honest-2, Be-1)\nroot(ROOT-0, honest-2)\n"}, {TestType.BASIC, "(ROOT (SBARQ (WHNP (WP What) ) (SQ (VBZ is) (NP (PRP he) ) (VP (VBG doing)))))", "dobj(doing-4, What-1)\naux(doing-4, is-2)\nnsubj(doing-4, he-3)\nroot(ROOT-0, doing-4)\n"}, {TestType.NON_COLLAPSED, "(ROOT (SBARQ (WHNP (WP What) ) (SQ (VBZ is) (NP (PRP he) ) (VP (VBG doing)))))", "dobj(doing-4, What-1)\naux(doing-4, is-2)\nnsubj(doing-4, he-3)\nroot(ROOT-0, doing-4)\n"}, {TestType.BASIC, "(ROOT (SBARQ (WHNP (WP What) ) (SQ (VBP am) (NP (PRP I) ) (VP (VBG doing) (PP (IN in) (NP (NNP Jackson) (NNP Hole) )))) (. ?) ))", "dobj(doing-4, What-1)\naux(doing-4, am-2)\nnsubj(doing-4, I-3)\nroot(ROOT-0, doing-4)\ncase(Hole-7, in-5)\ncompound(Hole-7, Jackson-6)\nnmod(doing-4, Hole-7)\n"}, {TestType.NON_COLLAPSED, "(ROOT (SBARQ (WHNP (WP What) ) (SQ (VBP am) (NP (PRP I) ) (VP (VBG doing) (PP (IN in) (NP (NNP Jackson) (NNP Hole) )))) (. ?) ))", "dobj(doing-4, What-1)\naux(doing-4, am-2)\nnsubj(doing-4, I-3)\nroot(ROOT-0, doing-4)\ncase(Hole-7, in-5)\ncompound(Hole-7, Jackson-6)\nnmod(doing-4, Hole-7)\n"}, {TestType.BASIC, "(ROOT (SBARQ (WHNP (WP Who)) (SQ (VBP am) (NP (PRP I)) (S (VP (TO to) (VP (VB judge))))) (. ?)))", "root(ROOT-0, Who-1)\ncop(Who-1, am-2)\nnsubj(Who-1, I-3)\nmark(judge-5, to-4)\nadvcl(Who-1, judge-5)\n"}, {TestType.NON_COLLAPSED, "(ROOT (SBARQ (WHNP (WP Who)) (SQ (VBP am) (NP (PRP I)) (S (VP (TO to) (VP (VB judge))))) (. ?)))", "root(ROOT-0, Who-1)\ncop(Who-1, am-2)\nnsubj(Who-1, I-3)\nmark(judge-5, to-4)\nadvcl(Who-1, judge-5)\n"}, {TestType.BASIC, "(ROOT (S (NP (NNP Bill)) (VP (VBZ is) (NP (DT an) (JJ honest) (NN man))) (. .)))", "nsubj(man-5, Bill-1)\ncop(man-5, is-2)\ndet(man-5, an-3)\namod(man-5, honest-4)\nroot(ROOT-0, man-5)\n"}, {TestType.NON_COLLAPSED, "(ROOT (S (NP (NNP Bill)) (VP (VBZ is) (NP (DT an) (JJ honest) (NN man))) (. .)))", "nsubj(man-5, Bill-1)\ncop(man-5, is-2)\ndet(man-5, an-3)\namod(man-5, honest-4)\nroot(ROOT-0, man-5)\n"}, {TestType.BASIC, "(ROOT (SBARQ (WHNP (WP What) (NN dignity) ) (SQ (VBZ is) (NP (EX there)) (PP (IN in) (NP (DT that) ))) (. ?)))", "det(dignity-2, What-1)\nnsubj(is-3, dignity-2)\nroot(ROOT-0, is-3)\nexpl(is-3, there-4)\ncase(that-6, in-5)\nnmod(is-3, that-6)\n"}, {TestType.NON_COLLAPSED, "(ROOT (SBARQ (WHNP (WP What) (NN dignity) ) (SQ (VBZ is) (NP (EX there)) (PP (IN in) (NP (DT that) ))) (. ?)))", "det(dignity-2, What-1)\nnsubj(is-3, dignity-2)\nroot(ROOT-0, is-3)\nexpl(is-3, there-4)\ncase(that-6, in-5)\nnmod(is-3, that-6)\n"}, {TestType.BASIC, "(ROOT (S (NP (NN Hand-holding) ) (VP (VBZ is) (VP (VBG becoming) (NP (DT an) (NN investment-banking) (NN job) (NN requirement) ))) (. .) ))", "nsubj(becoming-3, Hand-holding-1)\naux(becoming-3, is-2)\nroot(ROOT-0, becoming-3)\ndet(requirement-7, an-4)\ncompound(requirement-7, investment-banking-5)\ncompound(requirement-7, job-6)\nxcomp(becoming-3, requirement-7)\n"}, {TestType.NON_COLLAPSED, "(ROOT (S (NP (NN Hand-holding) ) (VP (VBZ is) (VP (VBG becoming) (NP (DT an) (NN investment-banking) (NN job) (NN requirement) ))) (. .) ))", "nsubj(becoming-3, Hand-holding-1)\naux(becoming-3, is-2)\nroot(ROOT-0, becoming-3)\ndet(requirement-7, an-4)\ncompound(requirement-7, investment-banking-5)\ncompound(requirement-7, job-6)\nxcomp(becoming-3, requirement-7)\n"}, {TestType.BASIC, "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBZ is) (ADJP (JJ wrong) (PP (IN with) (S (VP (VBG expecting) (NP (NN pizza))))))) (. ?)))", "nsubj(wrong-3, What-1)\ncop(wrong-3, is-2)\nroot(ROOT-0, wrong-3)\nmark(expecting-5, with-4)\nadvcl(wrong-3, expecting-5)\ndobj(expecting-5, pizza-6)\n"}, {TestType.NON_COLLAPSED, "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBZ is) (ADJP (JJ wrong) (PP (IN with) (S (VP (VBG expecting) (NP (NN pizza))))))) (. ?)))", "nsubj(wrong-3, What-1)\ncop(wrong-3, is-2)\nroot(ROOT-0, wrong-3)\nmark(expecting-5, with-4)\nadvcl(wrong-3, expecting-5)\ndobj(expecting-5, pizza-6)\n"}, {TestType.BASIC, "(ROOT (SBARQ (WHNP (WP Who) ) (SQ (VBZ is) (VP (VBG going) (S (VP (TO to) (VP (VB carry) (NP (DT the) (NN water) )))))) (. ?)))", "nsubj(going-3, Who-1)\naux(going-3, is-2)\nroot(ROOT-0, going-3)\nmark(carry-5, to-4)\nxcomp(going-3, carry-5)\ndet(water-7, the-6)\ndobj(carry-5, water-7)\n"}, {TestType.NON_COLLAPSED, "(ROOT (SBARQ (WHNP (WP Who) ) (SQ (VBZ is) (VP (VBG going) (S (VP (TO to) (VP (VB carry) (NP (DT the) (NN water) )))))) (. ?)))", "nsubj(going-3, Who-1)\nnsubj:xsubj(carry-5, Who-1)\naux(going-3, is-2)\nroot(ROOT-0, going-3)\nmark(carry-5, to-4)\nxcomp(going-3, carry-5)\ndet(water-7, the-6)\ndobj(carry-5, water-7)\n"}, {TestType.BASIC, "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBP am) (NP (PRP I)) (VP (VBG doing) (S (VP (VBG dating) (NP (PRP her)))))) (. ?)))", "dobj(doing-4, What-1)\naux(doing-4, am-2)\nnsubj(doing-4, I-3)\nroot(ROOT-0, doing-4)\nadvcl(doing-4, dating-5)\ndobj(dating-5, her-6)\n"}, {TestType.NON_COLLAPSED, "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBP am) (NP (PRP I)) (VP (VBG doing) (S (VP (VBG dating) (NP (PRP her)))))) (. ?)))", "dobj(doing-4, What-1)\naux(doing-4, am-2)\nnsubj(doing-4, I-3)\nroot(ROOT-0, doing-4)\nadvcl(doing-4, dating-5)\ndobj(dating-5, her-6)\n"}, {TestType.BASIC, "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBZ is) (NP (DT that))) (. ?)))", "root(ROOT-0, What-1)\ncop(What-1, is-2)\nnsubj(What-1, that-3)\n"}, {TestType.NON_COLLAPSED, "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBZ is) (NP (DT that))) (. ?)))", "root(ROOT-0, What-1)\ncop(What-1, is-2)\nnsubj(What-1, that-3)\n"}, {TestType.BASIC, "(ROOT (SBARQ (WHNP (WP Who)) (SQ (VBZ is) (NP (NNP John))) (. ?)))", "root(ROOT-0, Who-1)\ncop(Who-1, is-2)\nnsubj(Who-1, John-3)\n"}, {TestType.NON_COLLAPSED, "(ROOT (SBARQ (WHNP (WP Who)) (SQ (VBZ is) (NP (NNP John))) (. ?)))", "root(ROOT-0, Who-1)\ncop(Who-1, is-2)\nnsubj(Who-1, John-3)\n"}, {TestType.BASIC, "(ROOT (SBARQ (WHNP (WDT What) (NN dog)) (SQ (VP (VBZ is) (VP (VBG barking) (ADVP (RB so) (RB loudly))))) (. ?)))", "det(dog-2, What-1)\nnsubj(barking-4, dog-2)\naux(barking-4, is-3)\nroot(ROOT-0, barking-4)\nadvmod(loudly-6, so-5)\nadvmod(barking-4, loudly-6)\n"}, {TestType.NON_COLLAPSED, "(ROOT (SBARQ (WHNP (WDT What) (NN dog)) (SQ (VP (VBZ is) (VP (VBG barking) (ADVP (RB so) (RB loudly))))) (. ?)))", "det(dog-2, What-1)\nnsubj(barking-4, dog-2)\naux(barking-4, is-3)\nroot(ROOT-0, barking-4)\nadvmod(loudly-6, so-5)\nadvmod(barking-4, loudly-6)\n"}, {TestType.BASIC, "(ROOT (SBARQ (WHNP (WP Who)) (SQ (VP (VBZ is) (VP (VBG barking) (ADVP (RB so) (RB much))))) (. ?)))", "nsubj(barking-3, Who-1)\naux(barking-3, is-2)\nroot(ROOT-0, barking-3)\nadvmod(much-5, so-4)\nadvmod(barking-3, much-5)\n"}, {TestType.NON_COLLAPSED, "(ROOT (SBARQ (WHNP (WP Who)) (SQ (VP (VBZ is) (VP (VBG barking) (ADVP (RB so) (RB much))))) (. ?)))", "nsubj(barking-3, Who-1)\naux(barking-3, is-2)\nroot(ROOT-0, barking-3)\nadvmod(much-5, so-4)\nadvmod(barking-3, much-5)\n"}, {TestType.BASIC, "(ROOT (SBARQ (WHADVP (WRB Why)) (SQ (VBZ is) (NP (NNP Dave)) (VP (VBG becoming) (NP (DT a) (NN problem)))) (. ?)))", "advmod(becoming-4, Why-1)\naux(becoming-4, is-2)\nnsubj(becoming-4, Dave-3)\nroot(ROOT-0, becoming-4)\ndet(problem-6, a-5)\nxcomp(becoming-4, problem-6)\n"}, {TestType.NON_COLLAPSED, "(ROOT (SBARQ (WHADVP (WRB Why)) (SQ (VBZ is) (NP (NNP Dave)) (VP (VBG becoming) (NP (DT a) (NN problem)))) (. ?)))", "advmod(becoming-4, Why-1)\naux(becoming-4, is-2)\nnsubj(becoming-4, Dave-3)\nroot(ROOT-0, becoming-4)\ndet(problem-6, a-5)\nxcomp(becoming-4, problem-6)\n"}, {TestType.BASIC, "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBZ is) (NP (NNP UAL) (NN stock) ) (ADJP (NN worth) )) (. ?)))", "dobj(worth-5, What-1)\ncop(worth-5, is-2)\ncompound(stock-4, UAL-3)\nnsubj(worth-5, stock-4)\nroot(ROOT-0, worth-5)\n"}, {TestType.NON_COLLAPSED, "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBZ is) (NP (NNP UAL) (NN stock) ) (ADJP (NN worth) )) (. ?)))", "dobj(worth-5, What-1)\ncop(worth-5, is-2)\ncompound(stock-4, UAL-3)\nnsubj(worth-5, stock-4)\nroot(ROOT-0, worth-5)\n"}, {TestType.BASIC, "(ROOT (SBARQ (WHNP (WP Who)) (SQ (VBP am) (NP (PRP I)) ) (. ?)))", "root(ROOT-0, Who-1)\ncop(Who-1, am-2)\nnsubj(Who-1, I-3)\n"}, {TestType.NON_COLLAPSED, "(ROOT (SBARQ (WHNP (WP Who)) (SQ (VBP am) (NP (PRP I)) ) (. ?)))", "root(ROOT-0, Who-1)\ncop(Who-1, am-2)\nnsubj(Who-1, I-3)\n"}, {TestType.BASIC, "(ROOT (SBARQ (WHNP (WP Who)) (SQ (VP (VBD told) (NP (PRP him)))) (. ?)))", "nsubj(told-2, Who-1)\nroot(ROOT-0, told-2)\ndobj(told-2, him-3)\n"}, {TestType.NON_COLLAPSED, "(ROOT (SBARQ (WHNP (WP Who)) (SQ (VP (VBD told) (NP (PRP him)))) (. ?)))", "nsubj(told-2, Who-1)\nroot(ROOT-0, told-2)\ndobj(told-2, him-3)\n"}, {TestType.BASIC, "(ROOT (S (NP (NNP Sue)) (VP (VBZ is) (NP (DT a) (NN lawyer))) (. .)))", "nsubj(lawyer-4, Sue-1)\ncop(lawyer-4, is-2)\ndet(lawyer-4, a-3)\nroot(ROOT-0, lawyer-4)\n"}, {TestType.NON_COLLAPSED, "(ROOT (S (NP (NNP Sue)) (VP (VBZ is) (NP (DT a) (NN lawyer))) (. .)))", "nsubj(lawyer-4, Sue-1)\ncop(lawyer-4, is-2)\ndet(lawyer-4, a-3)\nroot(ROOT-0, lawyer-4)\n"}, {TestType.BASIC, "(ROOT (S (NP (NNP Sue)) (VP (VBZ is) (ADJP (JJ intelligent))) (. .)))", "nsubj(intelligent-3, Sue-1)\ncop(intelligent-3, is-2)\nroot(ROOT-0, intelligent-3)\n"}, {TestType.NON_COLLAPSED, "(ROOT (S (NP (NNP Sue)) (VP (VBZ is) (ADJP (JJ intelligent))) (. .)))", "nsubj(intelligent-3, Sue-1)\ncop(intelligent-3, is-2)\nroot(ROOT-0, intelligent-3)\n"}, {TestType.BASIC, "(ROOT (SBARQ (WHNP (WP Who)) (SQ (VBZ is) (ADJP (JJ nervous))) (. ?)))", "nsubj(nervous-3, Who-1)\ncop(nervous-3, is-2)\nroot(ROOT-0, nervous-3)\n"}, {TestType.NON_COLLAPSED, "(ROOT (SBARQ (WHNP (WP Who)) (SQ (VBZ is) (ADJP (JJ nervous))) (. ?)))", "nsubj(nervous-3, Who-1)\ncop(nervous-3, is-2)\nroot(ROOT-0, nervous-3)\n"}, {TestType.BASIC, "(ROOT (S (NP (EX There)) (VP (VBZ is) (NP (NP (DT a) (NN cow))) (PP (IN in) (NP (DT the) (NN field)))) (. .)))", "expl(is-2, There-1)\nroot(ROOT-0, is-2)\ndet(cow-4, a-3)\nnsubj(is-2, cow-4)\ncase(field-7, in-5)\ndet(field-7, the-6)\nnmod(is-2, field-7)\n"}, {TestType.NON_COLLAPSED, "(ROOT (S (NP (EX There)) (VP (VBZ is) (NP (NP (DT a) (NN cow))) (PP (IN in) (NP (DT the) (NN field)))) (. .)))", "expl(is-2, There-1)\nroot(ROOT-0, is-2)\ndet(cow-4, a-3)\nnsubj(is-2, cow-4)\ncase(field-7, in-5)\ndet(field-7, the-6)\nnmod(is-2, field-7)\n"}, {TestType.BASIC, "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBZ is) (NP (EX there)) (PP (IN in) (NP (DT the) (NN field)))) (. ?)))", "nsubj(is-2, What-1)\nroot(ROOT-0, is-2)\nexpl(is-2, there-3)\ncase(field-6, in-4)\ndet(field-6, the-5)\nnmod(is-2, field-6)\n"}, {TestType.NON_COLLAPSED, "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBZ is) (NP (EX there)) (PP (IN in) (NP (DT the) (NN field)))) (. ?)))", "nsubj(is-2, What-1)\nroot(ROOT-0, is-2)\nexpl(is-2, there-3)\ncase(field-6, in-4)\ndet(field-6, the-5)\nnmod(is-2, field-6)\n"}, {TestType.BASIC, "(ROOT (SINV (ADVP (RB Here)) (VP (VBP are)) (NP (DT some) (NNS bags))))", "advmod(are-2, Here-1)\nroot(ROOT-0, are-2)\ndet(bags-4, some-3)\nnsubj(are-2, bags-4)\n"}, {TestType.NON_COLLAPSED, "(ROOT (SINV (ADVP (RB Here)) (VP (VBP are)) (NP (DT some) (NNS bags))))", "advmod(are-2, Here-1)\nroot(ROOT-0, are-2)\ndet(bags-4, some-3)\nnsubj(are-2, bags-4)\n"}, {TestType.BASIC, "(ROOT (S (NP (PRP He)) (VP (VBZ is) (PP (IN in) (NP (DT the) (NN garden))))))", "nsubj(garden-5, He-1)\ncop(garden-5, is-2)\ncase(garden-5, in-3)\ndet(garden-5, the-4)\nroot(ROOT-0, garden-5)\n"}, {TestType.NON_COLLAPSED, "(ROOT (S (NP (PRP He)) (VP (VBZ is) (PP (IN in) (NP (DT the) (NN garden))))))", "nsubj(garden-5, He-1)\ncop(garden-5, is-2)\ncase(garden-5, in-3)\ndet(garden-5, the-4)\nroot(ROOT-0, garden-5)\n"}, {TestType.BASIC, "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBZ 's) (PP (IN on) (NP (DT the) (NN test)))) (. ?)))", "nsubj('s-2, What-1)\nroot(ROOT-0, 's-2)\ncase(test-5, on-3)\ndet(test-5, the-4)\nnmod('s-2, test-5)\n"}, {TestType.NON_COLLAPSED, "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBZ 's) (PP (IN on) (NP (DT the) (NN test)))) (. ?)))", "nsubj('s-2, What-1)\nroot(ROOT-0, 's-2)\ncase(test-5, on-3)\ndet(test-5, the-4)\nnmod('s-2, test-5)\n"}, {TestType.BASIC, "(ROOT (SBARQ (WHADVP (WRB Why)) (SQ (VBZ is) (NP (DT the) (NN dog)) (ADJP (JJ pink))) (. ?)))", "advmod(pink-5, Why-1)\ncop(pink-5, is-2)\ndet(dog-4, the-3)\nnsubj(pink-5, dog-4)\nroot(ROOT-0, pink-5)\n"}, {TestType.NON_COLLAPSED, "(ROOT (SBARQ (WHADVP (WRB Why)) (SQ (VBZ is) (NP (DT the) (NN dog)) (ADJP (JJ pink))) (. ?)))", "advmod(pink-5, Why-1)\ncop(pink-5, is-2)\ndet(dog-4, the-3)\nnsubj(pink-5, dog-4)\nroot(ROOT-0, pink-5)\n"}, {TestType.BASIC, "(ROOT (S (NP (DT The) (NN dog)) (VP (VBZ is) (ADJP (JJ pink))) (. .)))", "det(dog-2, The-1)\nnsubj(pink-4, dog-2)\ncop(pink-4, is-3)\nroot(ROOT-0, pink-4)\n"}, {TestType.NON_COLLAPSED, "(ROOT (S (NP (DT The) (NN dog)) (VP (VBZ is) (ADJP (JJ pink))) (. .)))", "det(dog-2, The-1)\nnsubj(pink-4, dog-2)\ncop(pink-4, is-3)\nroot(ROOT-0, pink-4)\n"}, {TestType.BASIC, "(ROOT (SBARQ (WHNP (WDT What) (NN disease)) (SQ (VP (VBZ causes) (NP (NN pain)))) (. ?)))", "det(disease-2, What-1)\nnsubj(causes-3, disease-2)\nroot(ROOT-0, causes-3)\ndobj(causes-3, pain-4)\n"}, {TestType.NON_COLLAPSED, "(ROOT (SBARQ (WHNP (WDT What) (NN disease)) (SQ (VP (VBZ causes) (NP (NN pain)))) (. ?)))", "det(disease-2, What-1)\nnsubj(causes-3, disease-2)\nroot(ROOT-0, causes-3)\ndobj(causes-3, pain-4)\n"}, {TestType.BASIC, "(ROOT (SBARQ (WHNP (WDT What) (NN disease)) (SQ (VBZ causes) (NP (NN pain))) (. ?)))", "det(disease-2, What-1)\nnsubj(causes-3, disease-2)\nroot(ROOT-0, causes-3)\ndobj(causes-3, pain-4)\n"}, {TestType.NON_COLLAPSED, "(ROOT (SBARQ (WHNP (WDT What) (NN disease)) (SQ (VBZ causes) (NP (NN pain))) (. ?)))", "det(disease-2, What-1)\nnsubj(causes-3, disease-2)\nroot(ROOT-0, causes-3)\ndobj(causes-3, pain-4)\n"}, {TestType.BASIC, "(ROOT (S (VP (VB Be) (VP (VBG waiting) (PP (IN in) (NP (NN line))) (PP-TMP (IN at) (NP (CD 3) (NN p.m.))))) (. !)))", "aux(waiting-2, Be-1)\nroot(ROOT-0, waiting-2)\ncase(line-4, in-3)\nnmod(waiting-2, line-4)\ncase(p.m.-7, at-5)\nnummod(p.m.-7, 3-6)\nnmod(waiting-2, p.m.-7)\n"}, {TestType.NON_COLLAPSED, "(ROOT (S (VP (VB Be) (VP (VBG waiting) (PP (IN in) (NP (NN line))) (PP-TMP (IN at) (NP (CD 3) (NN p.m.))))) (. !)))", "aux(waiting-2, Be-1)\nroot(ROOT-0, waiting-2)\ncase(line-4, in-3)\nnmod(waiting-2, line-4)\ncase(p.m.-7, at-5)\nnummod(p.m.-7, 3-6)\nnmod(waiting-2, p.m.-7)\n"}, {TestType.BASIC, "(ROOT (S (VP (VB Be) (NP (DT a) (NN man))) (. !)))", "cop(man-3, Be-1)\ndet(man-3, a-2)\nroot(ROOT-0, man-3)\n"}, {TestType.NON_COLLAPSED, "(ROOT (S (VP (VB Be) (NP (DT a) (NN man))) (. !)))", "cop(man-3, Be-1)\ndet(man-3, a-2)\nroot(ROOT-0, man-3)\n"}, {TestType.BASIC, "(ROOT (SBARQ (RB So) (WHNP (WP what)) (SQ (VBZ is) (NP (NNP Santa) (NNP Fe) ) (ADJP (IN worth) )) (. ?) ))", "advmod(worth-6, So-1)\ndobj(worth-6, what-2)\ncop(worth-6, is-3)\ncompound(Fe-5, Santa-4)\nnsubj(worth-6, Fe-5)\nroot(ROOT-0, worth-6)\n"}, {TestType.NON_COLLAPSED, "(ROOT (SBARQ (RB So) (WHNP (WP what)) (SQ (VBZ is) (NP (NNP Santa) (NNP Fe) ) (ADJP (IN worth) )) (. ?) ))", "advmod(worth-6, So-1)\ndobj(worth-6, what-2)\ncop(worth-6, is-3)\ncompound(Fe-5, Santa-4)\nnsubj(worth-6, Fe-5)\nroot(ROOT-0, worth-6)\n"}, {TestType.BASIC, "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBZ is) (NP (NP (PRP$ your) (NN sister) (POS 's)) (NN name))) (. ?)))", "root(ROOT-0, What-1)\ncop(What-1, is-2)\nnmod:poss(sister-4, your-3)\nnmod:poss(name-6, sister-4)\ncase(sister-4, 's-5)\nnsubj(What-1, name-6)\n"}, {TestType.NON_COLLAPSED, "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBZ is) (NP (NP (PRP$ your) (NN sister) (POS 's)) (NN name))) (. ?)))", "root(ROOT-0, What-1)\ncop(What-1, is-2)\nnmod:poss(sister-4, your-3)\nnmod:poss(name-6, sister-4)\ncase(sister-4, 's-5)\nnsubj(What-1, name-6)\n"}, {TestType.BASIC, "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBZ is) (NP (NP (DT the) (NN fear)) (PP (IN of) (NP (NNS cockroaches)))) (VP (VBN called))) (. ?)))", "dobj(called-7, What-1)\nauxpass(called-7, is-2)\ndet(fear-4, the-3)\nnsubjpass(called-7, fear-4)\ncase(cockroaches-6, of-5)\nnmod(fear-4, cockroaches-6)\nroot(ROOT-0, called-7)\n"}, {TestType.NON_COLLAPSED, "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBZ is) (NP (NP (DT the) (NN fear)) (PP (IN of) (NP (NNS cockroaches)))) (VP (VBN called))) (. ?)))", "dobj(called-7, What-1)\nauxpass(called-7, is-2)\ndet(fear-4, the-3)\nnsubjpass(called-7, fear-4)\ncase(cockroaches-6, of-5)\nnmod(fear-4, cockroaches-6)\nroot(ROOT-0, called-7)\n"}, {TestType.COPULA_HEAD, "(ROOT (S (NP (NNP Reagan)) (VP (VBZ has) (VP (VBN died))) (. .)))", "nsubj(died-3, Reagan-1)\naux(died-3, has-2)\nroot(ROOT-0, died-3)\n"}, {TestType.COPULA_HEAD, "(ROOT (S (NP (NNP Kennedy)) (VP (VBZ has) (VP (VBN been) (VP (VBN killed)))) (. .)))", "nsubjpass(killed-4, Kennedy-1)\naux(killed-4, has-2)\nauxpass(killed-4, been-3)\nroot(ROOT-0, killed-4)\n"}, {TestType.COPULA_HEAD, "(ROOT (S (NP (NNP Bill)) (VP (VBZ is) (NP (DT an) (JJ honest) (NN man))) (. .)))", "nsubj(is-2, Bill-1)\nroot(ROOT-0, is-2)\ndet(man-5, an-3)\namod(man-5, honest-4)\nxcomp(is-2, man-5)\n"}, {TestType.COPULA_HEAD, "(ROOT (S (NP (NNP Bill)) (VP (VBZ is) (ADJP (JJ big) (CC and) (JJ honest))) (. .)))", "nsubj(is-2, Bill-1)\nroot(ROOT-0, is-2)\nxcomp(is-2, big-3)\ncc(big-3, and-4)\nconj(big-3, honest-5)\n"}, {TestType.COPULA_HEAD, "(ROOT (S (NP (NNP Clinton)) (VP (VBD defeated) (NP (NNP Dole))) (. .)))", "nsubj(defeated-2, Clinton-1)\nroot(ROOT-0, defeated-2)\ndobj(defeated-2, Dole-3)\n"}, {TestType.COPULA_HEAD, "(ROOT (S (SBAR (WHNP (WP What)) (S (NP (PRP she)) (VP (VBD said)))) (VP (VBZ is) (ADJP (JJ untrue))) (. .)))", "dobj(said-3, What-1)\nnsubj(said-3, she-2)\ncsubj(is-4, said-3)\nroot(ROOT-0, is-4)\nxcomp(is-4, untrue-5)\n"}, {TestType.COPULA_HEAD, "(ROOT (S (NP (NNP Dole)) (VP (VBD was) (VP (VBN defeated) (PP (IN by) (NP (NNP Clinton))))) (. .)))", "nsubjpass(defeated-3, Dole-1)\nauxpass(defeated-3, was-2)\nroot(ROOT-0, defeated-3)\ncase(Clinton-5, by-4)\nnmod(defeated-3, Clinton-5)\n"}, {TestType.COPULA_HEAD, "(ROOT (S (NP (PRP I)) (VP (VBP like) (S (VP (TO to) (VP (VB swim))))) (. .)))", "nsubj(like-2, I-1)\nroot(ROOT-0, like-2)\nmark(swim-4, to-3)\nxcomp(like-2, swim-4)\n"}, {TestType.COPULA_HEAD, "(ROOT (S (NP (PRP We)) (VP (VBP have) (NP (NP (DT no) (JJ useful) (NN information)) (PP (IN on) (SBAR (IN whether) (S (NP (NNS users)) (VP (VBP are) (PP (IN at) (NP (NN risk))))))))) (. .)))", "nsubj(have-2, We-1)\nroot(ROOT-0, have-2)\nneg(information-5, no-3)\namod(information-5, useful-4)\ndobj(have-2, information-5)\nmark(are-9, on-6)\nmark(are-9, whether-7)\nnsubj(are-9, users-8)\nacl(information-5, are-9)\ncase(risk-11, at-10)\nnmod(are-9, risk-11)\n"}, {TestType.COPULA_HEAD, "(ROOT (S (NP (PRP I)) (VP (VBP am) (ADJP (JJ certain) (SBAR (IN that) (S (NP (PRP he)) (VP (VBD did) (NP (PRP it))))))) (. .)))", "nsubj(am-2, I-1)\nroot(ROOT-0, am-2)\nxcomp(am-2, certain-3)\nmark(did-6, that-4)\nnsubj(did-6, he-5)\nccomp(certain-3, did-6)\ndobj(did-6, it-7)\n"}, {TestType.COPULA_HEAD, "(ROOT (S (NP (PRP I)) (VP (VBP am) (ADJP (JJ ready) (S (VP (TO to) (VP (VB leave)))))) (. .)))", "nsubj(am-2, I-1)\nroot(ROOT-0, am-2)\nxcomp(am-2, ready-3)\nmark(leave-5, to-4)\nxcomp(ready-3, leave-5)\n"}, {TestType.COPULA_HEAD, "(ROOT (S (NP (EX There)) (VP (VBZ is) (NP (NP (DT a) (NN statue)) (PP (IN in) (NP (DT the) (NN corner))))) (. .)))", "expl(is-2, There-1)\nroot(ROOT-0, is-2)\ndet(statue-4, a-3)\nnsubj(is-2, statue-4)\ncase(corner-7, in-5)\ndet(corner-7, the-6)\nnmod(statue-4, corner-7)\n"}, {TestType.COPULA_HEAD, "(ROOT (S (NP (DT The) (NN director)) (VP (VBZ is) (ADJP (NP (CD 65) (NNS years)) (JJ old))) (. .)))", "det(director-2, The-1)\nnsubj(is-3, director-2)\nroot(ROOT-0, is-3)\nnummod(years-5, 65-4)\nnmod:npmod(old-6, years-5)\nxcomp(is-3, old-6)\n"}, {TestType.COPULA_HEAD, "(ROOT (S (NP (DT The) (NN man)) (VP (VBZ is) (ADVP (RB here))) (. .)))", "det(man-2, The-1)\nnsubj(is-3, man-2)\nroot(ROOT-0, is-3)\nadvmod(is-3, here-4)\n"}, {TestType.COPULA_HEAD, "(ROOT (S (NP (NNP Xml) (NN field)) (VP (MD should) (VP (VB include) (NP (PDT both) (NP (DT the) (NN entity) (NN id)) (CC and) (NP (DT the) (NN entity) (NN name))) (SBAR (IN since) (S (NP (DT the) (NN entity) (NNS names)) (VP (VBP are) (RB not) (ADJP (JJ unique))))))) (. .)))", "compound(field-2, Xml-1)\nnsubj(include-4, field-2)\naux(include-4, should-3)\nroot(ROOT-0, include-4)\ncc:preconj(id-8, both-5)\ndet(id-8, the-6)\ncompound(id-8, entity-7)\ndobj(include-4, id-8)\ncc(id-8, and-9)\ndet(name-12, the-10)\ncompound(name-12, entity-11)\nconj(id-8, name-12)\nmark(are-17, since-13)\ndet(names-16, the-14)\ncompound(names-16, entity-15)\nnsubj(are-17, names-16)\nadvcl(include-4, are-17)\nneg(are-17, not-18)\nxcomp(are-17, unique-19)\n"}, {TestType.COPULA_HEAD, "(ROOT (S (S (NP (DT The) (NN government)) (VP (VBZ counts) (NP (NN money)) (SBAR (IN as) (S (NP (PRP it)) (VP (VBZ is) (VP (VBN spent))))))) (: ;) (S (NP (NNP Dodge)) (VP (VBZ counts) (NP (NNS contracts)) (SBAR (WHADVP (WRB when)) (S (NP (PRP they)) (VP (VBP are) (VP (VBN awarded))))))) (. .)))", "det(government-2, The-1)\nnsubj(counts-3, government-2)\nroot(ROOT-0, counts-3)\ndobj(counts-3, money-4)\nmark(spent-8, as-5)\nnsubjpass(spent-8, it-6)\nauxpass(spent-8, is-7)\nadvcl(counts-3, spent-8)\nnsubj(counts-11, Dodge-10)\nparataxis(counts-3, counts-11)\ndobj(counts-11, contracts-12)\nadvmod(awarded-16, when-13)\nnsubjpass(awarded-16, they-14)\nauxpass(awarded-16, are-15)\nadvcl(counts-11, awarded-16)\n"}, {TestType.NON_COLLAPSED, "(ROOT (S (NP (PRP I)) (VP (VBP like) (S (VP (TO to) (VP (VB swim))))) (. .)))", "nsubj(like-2, I-1)\nnsubj:xsubj(swim-4, I-1)\nroot(ROOT-0, like-2)\nmark(swim-4, to-3)\nxcomp(like-2, swim-4)\n"}, {TestType.NON_COLLAPSED, "(ROOT (S (NP (PRP He)) (VP (VBZ says) (SBAR (IN that) (S (NP (PRP you)) (VP (VBP like) (S (VP (TO to) (VP (VB swim)))))))) (. .)))", "nsubj(says-2, He-1)\nroot(ROOT-0, says-2)\nmark(like-5, that-3)\nnsubj(like-5, you-4)\nnsubj:xsubj(swim-7, you-4)\nccomp(says-2, like-5)\nmark(swim-7, to-6)\nxcomp(like-5, swim-7)\n"}, {TestType.NON_COLLAPSED, "(ROOT (S (NP (PRP I)) (VP (VBD saw) (NP (NP (DT the) (NN man)) (SBAR (WHNP (WP who)) (S (NP (PRP you)) (VP (VBP love)))))) (. .)))", "nsubj(saw-2, I-1)\nroot(ROOT-0, saw-2)\ndet(man-4, the-3)\ndobj(saw-2, man-4)\nref(man-4, who-5)\ndobj(love-7, who-5)\nnsubj(love-7, you-6)\nacl:relcl(man-4, love-7)\n"}, {TestType.NON_COLLAPSED, "(ROOT (S (NP (PRP I)) (VP (VBD saw) (NP (NP (DT the) (NN man)) (SBAR (WHNP (WP$ whose) (NP (NN wife))) (S (NP (PRP you)) (VP (VBP love)))))) (. .)))", "nsubj(saw-2, I-1)\nroot(ROOT-0, saw-2)\ndet(man-4, the-3)\ndobj(saw-2, man-4)\nref(man-4, whose-5)\nnmod:poss(wife-6, whose-5)\ndobj(love-8, wife-6)\nnsubj(love-8, you-7)\nacl:relcl(man-4, love-8)\n"}, {TestType.NON_COLLAPSED, "(ROOT (S (NP (PRP I)) (VP (VBD saw) (NP (NP (DT the) (NN book)) (SBAR (WHNP (WDT which)) (S (NP (PRP you)) (VP (VBD bought)))))) (. .)))", "nsubj(saw-2, I-1)\nroot(ROOT-0, saw-2)\ndet(book-4, the-3)\ndobj(saw-2, book-4)\nref(book-4, which-5)\ndobj(bought-7, which-5)\nnsubj(bought-7, you-6)\nacl:relcl(book-4, bought-7)\n"}, {TestType.NON_COLLAPSED, "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBZ is) (NP (DT the) (NN esophagus)) (VP (VBN used) (PP (IN for)))) (. ?)))", "nmod(used-5, What-1)\nauxpass(used-5, is-2)\ndet(esophagus-4, the-3)\nnsubjpass(used-5, esophagus-4)\nroot(ROOT-0, used-5)\ncase(What-1, for-6)\n"}, {TestType.NON_COLLAPSED, "(ROOT (S (NP (PRP I)) (VP (VBD saw) (NP (NP (DT the) (NN woman)) (SBAR (WHNP (WP whom)) (S (NP (PRP you)) (VP (VBD gave) (NP (DT the) (NN package)) (PP (TO to))))))) (. .)))", "nsubj(saw-2, I-1)\nroot(ROOT-0, saw-2)\ndet(woman-4, the-3)\ndobj(saw-2, woman-4)\nref(woman-4, whom-5)\nnmod(gave-7, whom-5)\nnsubj(gave-7, you-6)\nacl:relcl(woman-4, gave-7)\ndet(package-9, the-8)\ndobj(gave-7, package-9)\ncase(whom-5, to-10)\n"}, {TestType.NON_COLLAPSED_SEPARATOR, "(ROOT (S (NP (PRP I)) (VP (VBP like) (S (VP (TO to) (VP (VB swim))))) (. .)))", "nsubj(like-2, I-1)\nroot(ROOT-0, like-2)\nmark(swim-4, to-3)\nxcomp(like-2, swim-4)\n======\nnsubj:xsubj(swim-4, I-1)\n"}, {TestType.COLLAPSED, "(ROOT (S (NP (NNP Lufthansa)) (VP (VBZ flies) (PP (TO to) (CC and) (IN from) (NP (NNP Serbia)))) (. .)))", "nsubj(flies-2, Lufthansa-1)\nroot(ROOT-0, flies-2)\nconj:and(flies-2, flies-2')\ncase(Serbia-6, to-3)\ncc(to-3, and-4)\nconj:and(to-3, from-5)\nnmod:from(flies-2', Serbia-6)\nnmod:to(flies-2, Serbia-6)\n"}, {TestType.COLLAPSED, "(ROOT (S (NP (NNP Lufthansa)) (VP (VBZ flies) (PP (TO to) (CC and) (IN from) (NP (NP (NNP Serbia)) (CC and) (NP (NNP France))))) (. .)))", "nsubj(flies-2, Lufthansa-1)\nroot(ROOT-0, flies-2)\nconj:and(flies-2, flies-2')\ncase(Serbia-6, to-3)\ncc(to-3, and-4)\nconj:and(to-3, from-5)\nnmod:from(flies-2', Serbia-6)\nnmod:to(flies-2, Serbia-6)\ncc(Serbia-6, and-7)\nconj:and(Serbia-6, France-8)\n"}, {TestType.COLLAPSED, "(ROOT (S (NP (NNP Lufthansa)) (VP (VP (VBZ flies) (PP (IN from) (NP (NNP Serbia)))) (CC and) (VP (VBZ flies) (PP (TO to) (NP (NNP Serbia))))) (. .)))", "nsubj(flies-2, Lufthansa-1)\nroot(ROOT-0, flies-2)\ncase(Serbia-4, from-3)\nnmod:from(flies-2, Serbia-4)\ncc(flies-2, and-5)\nconj:and(flies-2, flies-6)\ncase(Serbia-8, to-7)\nnmod:to(flies-6, Serbia-8)\n"}, {TestType.COLLAPSED, "(ROOT (S (NP (NNP Lufthansa)) (VP (VBZ flies) (PP (PP (IN from) (NP (NNP Serbia))) (CC and) (PP (TO to) (NP (NNP France))))) (. .)))", "nsubj(flies-2, Lufthansa-1)\nroot(ROOT-0, flies-2)\nconj:and(flies-2, flies-2')\ncase(Serbia-4, from-3)\nnmod:from(flies-2, Serbia-4)\ncc(flies-2, and-5)\ncase(France-7, to-6)\nnmod:to(flies-2', France-7)\n"}, {TestType.COLLAPSED, "(ROOT (S (NP (NNP Lufthansa)) (VP (VBZ flies) (PP (PP (IN from) (NP (NNP Austria))) (, ,) (PP (TO to) (NP (NNP Syria))) (CC and) (PP (IN through) (NP (NNP Serbia))))) (. .)))", "nsubj(flies-2, Lufthansa-1)\nroot(ROOT-0, flies-2)\nconj:and(flies-2, flies-2')\nconj:and(flies-2, flies-2'')\ncase(Austria-4, from-3)\nnmod:from(flies-2, Austria-4)\ncase(Syria-7, to-6)\nnmod:to(flies-2', Syria-7)\ncc(flies-2, and-8)\ncase(Serbia-10, through-9)\nnmod:through(flies-2'', Serbia-10)\n"}, {TestType.COLLAPSED, "(ROOT (S (NP (NNP Dole)) (VP (VBD was) (VP (VBN defeated) (PP (IN by) (NP (NNP Clinton))))) (. .)))", "nsubjpass(defeated-3, Dole-1)\nauxpass(defeated-3, was-2)\nroot(ROOT-0, defeated-3)\ncase(Clinton-5, by-4)\nnmod:agent(defeated-3, Clinton-5)\n"}, {TestType.COLLAPSED, "(ROOT (S (SBAR (IN That) (S (NP (PRP she)) (VP (VBD lied)))) (VP (VBD was) (VP (VBN suspected) (PP (IN by) (NP (NN everyone))))) (. .)))", "mark(lied-3, That-1)\nnsubj(lied-3, she-2)\ncsubjpass(suspected-5, lied-3)\nauxpass(suspected-5, was-4)\nroot(ROOT-0, suspected-5)\ncase(everyone-7, by-6)\nnmod:agent(suspected-5, everyone-7)\n"}, {TestType.COLLAPSED, "(ROOT (S (NP (PRP I)) (VP (VBP like) (S (VP (TO to) (VP (VB swim))))) (. .)))", "nsubj(like-2, I-1)\nnsubj:xsubj(swim-4, I-1)\nroot(ROOT-0, like-2)\nmark(swim-4, to-3)\nxcomp(like-2, swim-4)\n"}, {TestType.COLLAPSED, "(ROOT (S (NP (PRP I)) (VP (VBD sat) (PP (IN on) (NP (DT the) (NN chair)))) (. .)))", "nsubj(sat-2, I-1)\nroot(ROOT-0, sat-2)\ncase(chair-5, on-3)\ndet(chair-5, the-4)\nnmod:on(sat-2, chair-5)\n"}, {TestType.COLLAPSED, "(ROOT (S (NP (PRP We)) (VP (VBP have) (NP (NP (DT no) (JJ useful) (NN information)) (PP (IN on) (SBAR (IN whether) (S (NP (NNS users)) (VP (VBP are) (PP (IN at) (NP (NN risk))))))))) (. .)))", "nsubj(have-2, We-1)\nroot(ROOT-0, have-2)\nneg(information-5, no-3)\namod(information-5, useful-4)\ndobj(have-2, information-5)\nmark(risk-11, on-6)\nmark(risk-11, whether-7)\nnsubj(risk-11, users-8)\ncop(risk-11, are-9)\ncase(risk-11, at-10)\nacl(information-5, risk-11)\n"}, {TestType.COLLAPSED, "(ROOT (S (NP (PRP They)) (VP (VBD heard) (PP (IN about) (NP (NN asbestos))) (S (VP (VBG having) (NP (JJ questionable) (NNS properties))))) (. .)))", "nsubj(heard-2, They-1)\nroot(ROOT-0, heard-2)\ncase(asbestos-4, about-3)\nnmod:about(heard-2, asbestos-4)\nxcomp(heard-2, having-5)\namod(properties-7, questionable-6)\ndobj(having-5, properties-7)\n"}, {TestType.COLLAPSED, "(ROOT (S (NP (PRP He)) (VP (VBZ says) (SBAR (IN that) (S (NP (PRP you)) (VP (VBP like) (S (VP (TO to) (VP (VB swim)))))))) (. .)))", "nsubj(says-2, He-1)\nroot(ROOT-0, says-2)\nmark(like-5, that-3)\nnsubj(like-5, you-4)\nnsubj:xsubj(swim-7, you-4)\nccomp(says-2, like-5)\nmark(swim-7, to-6)\nxcomp(like-5, swim-7)\n"}, {TestType.COLLAPSED, "(ROOT (S (NP (NNP U.S.) (NNS forces)) (VP (VBP have) (VP (VBN been) (VP (VBN engaged) (PP (IN in) (NP (JJ intense) (NN fighting))) (SBAR (IN after) (S (NP (NNS insurgents)) (VP (VBD launched) (NP (JJ simultaneous) (NNS attacks)))))))) (. .)))", "compound(forces-2, U.S.-1)\nnsubjpass(engaged-5, forces-2)\naux(engaged-5, have-3)\nauxpass(engaged-5, been-4)\nroot(ROOT-0, engaged-5)\ncase(fighting-8, in-6)\namod(fighting-8, intense-7)\nnmod:in(engaged-5, fighting-8)\nmark(launched-11, after-9)\nnsubj(launched-11, insurgents-10)\nadvcl(engaged-5, launched-11)\namod(attacks-13, simultaneous-12)\ndobj(launched-11, attacks-13)\n"}, {TestType.COLLAPSED, "(ROOT (S (NP (PRP I)) (VP (VBD saw) (NP (NP (DT the) (NN man)) (SBAR (WHNP (WP who)) (S (NP (PRP you)) (VP (VBP love)))))) (. .)))", "nsubj(saw-2, I-1)\nroot(ROOT-0, saw-2)\ndet(man-4, the-3)\ndobj(saw-2, man-4)\ndobj(love-7, man-4)\nref(man-4, who-5)\nnsubj(love-7, you-6)\nacl:relcl(man-4, love-7)\n"}, {TestType.COLLAPSED, "(ROOT (S (NP (PRP I)) (VP (VBD saw) (NP (NP (DT the) (NN man)) (SBAR (WHNP (WP$ whose) (NP (NN wife))) (S (NP (PRP you)) (VP (VBP love)))))) (. .)))", "nsubj(saw-2, I-1)\nroot(ROOT-0, saw-2)\ndet(man-4, the-3)\ndobj(saw-2, man-4)\nnmod:poss(wife-6, man-4)\nref(man-4, whose-5)\ndobj(love-8, wife-6)\nnsubj(love-8, you-7)\nacl:relcl(man-4, love-8)\n"}, {TestType.COLLAPSED, "(ROOT (S (NP (EX There)) (VP (VBZ is) (NP (NP (DT a) (NN statue)) (PP (IN in) (NP (DT the) (NN corner))))) (. .)))", "expl(is-2, There-1)\nroot(ROOT-0, is-2)\ndet(statue-4, a-3)\nnsubj(is-2, statue-4)\ncase(corner-7, in-5)\ndet(corner-7, the-6)\nnmod:in(statue-4, corner-7)\n"}, {TestType.COLLAPSED, "(ROOT (S (NP (PRP He)) (VP (VBD talked) (PP (TO to) (NP (DT the) (NN president))) (SBAR (IN in) (NN order) (S (VP (TO to) (VP (VB secure) (NP (DT the) (NN account))))))) (. .)))", "nsubj(talked-2, He-1)\nroot(ROOT-0, talked-2)\ncase(president-5, to-3)\ndet(president-5, the-4)\nnmod:to(talked-2, president-5)\nmark(secure-9, in-6)\nmwe(in-6, order-7)\nmark(secure-9, to-8)\nadvcl(talked-2, secure-9)\ndet(account-11, the-10)\ndobj(secure-9, account-11)\n"}, {TestType.COLLAPSED, "(ROOT (S (NP (PRP I)) (VP (VBD saw) (NP (NP (DT the) (NN book)) (SBAR (WHNP (WDT which)) (S (NP (PRP you)) (VP (VBD bought)))))) (. .)))", "nsubj(saw-2, I-1)\nroot(ROOT-0, saw-2)\ndet(book-4, the-3)\ndobj(saw-2, book-4)\ndobj(bought-7, book-4)\nref(book-4, which-5)\nnsubj(bought-7, you-6)\nacl:relcl(book-4, bought-7)\n"}, {TestType.COLLAPSED, "(ROOT (S (NP (NNP Bill)) (VP (VBD picked) (NP (NP (NNP Fred)) (PP (IN for) (NP (NP (DT the) (NN team)) (VP (VBG demonstrating) (NP (PRP$ his) (NN incompetence))))))) (. .)))", "nsubj(picked-2, Bill-1)\nroot(ROOT-0, picked-2)\ndobj(picked-2, Fred-3)\ncase(team-6, for-4)\ndet(team-6, the-5)\nnmod:for(Fred-3, team-6)\nacl(team-6, demonstrating-7)\nnmod:poss(incompetence-9, his-8)\ndobj(demonstrating-7, incompetence-9)\n"}, {TestType.COLLAPSED, "(ROOT (SBARQ (WHPP (IN In) (WHNP (WDT which) (NN city))) (SQ (VBP do) (NP (PRP you)) (VP (VB live))) (. ?)))", "case(city-3, In-1)\ndet(city-3, which-2)\nnmod:in(live-6, city-3)\naux(live-6, do-4)\nnsubj(live-6, you-5)\nroot(ROOT-0, live-6)\n"}, {TestType.COLLAPSED, "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBZ is) (NP (DT the) (NN esophagus)) (VP (VBN used) (PP (IN for)))) (. ?)))", "nmod:for(used-5, What-1)\nauxpass(used-5, is-2)\ndet(esophagus-4, the-3)\nnsubjpass(used-5, esophagus-4)\nroot(ROOT-0, used-5)\ncase(What-1, for-6)\n"}, {TestType.COLLAPSED, "(ROOT (S (NP (CC Both) (NP (DT the) (NNS boys)) (CC and) (NP (DT the) (NNS girls))) (VP (VBP are) (ADVP (RB here))) (. .)))", "cc:preconj(boys-3, Both-1)\ndet(boys-3, the-2)\nnsubj(are-7, boys-3)\ncc(boys-3, and-4)\ndet(girls-6, the-5)\nconj:and(boys-3, girls-6)\nroot(ROOT-0, are-7)\nadvmod(are-7, here-8)\n"}, {TestType.COLLAPSED, "( (S (NP (NNP Fred)) (VP (VBD flew) (PP (IN across) (CC or) (IN across) (NP (NNP Serbia)))) (. .)))", "nsubj(flew-2, Fred-1)\nroot(ROOT-0, flew-2)\nconj:or(flew-2, flew-2')\ncase(Serbia-6, across-3)\ncc(across-3, or-4)\nconj:or(across-3, across-5)\nnmod:across(flew-2, Serbia-6)\nnmod:across(flew-2', Serbia-6)\n"}, {TestType.COLLAPSED, "(ROOT (SBARQ (WHPP (IN For) (WHNP (WRB how) (JJ long))) (SQ (VBZ is) (NP (DT an) (NN elephant)) (ADJP (JJ pregnant))) (. ?)))", "case(long-3, For-1)\nadvmod(long-3, how-2)\nnmod:for(pregnant-7, long-3)\ncop(pregnant-7, is-4)\ndet(elephant-6, an-5)\nnsubj(pregnant-7, elephant-6)\nroot(ROOT-0, pregnant-7)\n"}, {TestType.COLLAPSED, "( (S (NP-SBJ-1 (PRP He)) (VP (VBD achieved) (NP (DT this)) (PP-MNR (PP (IN in) (NP (NN part))) (IN through) (NP (DT an) (JJ uncanny) (NN talent)))) (. .)))", "nsubj(achieved-2, He-1)\nroot(ROOT-0, achieved-2)\ndobj(achieved-2, this-3)\ncase(part-5, in-4)\nnmod:in(talent-9, part-5)\ncase(talent-9, through-6)\ndet(talent-9, an-7)\namod(talent-9, uncanny-8)\nnmod:through(achieved-2, talent-9)\n"}, {TestType.COLLAPSED, "(ROOT (S (NP (DT The) (NN turf)) (ADVP (RB recently)) (VP (VBZ has) (VP (VBN ranged) (PP (PP (IN from) (NP (NNP Chile))) (PP (TO to) (NP (NNP Austria))) (PP (TO to) (NP (NNP Portugal)))))) (. .)))", "det(turf-2, The-1)\nnsubj(ranged-5, turf-2)\nadvmod(ranged-5, recently-3)\naux(ranged-5, has-4)\nroot(ROOT-0, ranged-5)\ncase(Chile-7, from-6)\nnmod:from(ranged-5, Chile-7)\ncase(Austria-9, to-8)\nnmod:to(Chile-7, Austria-9)\ncase(Portugal-11, to-10)\nnmod:to(Chile-7, Portugal-11)\n"}, {TestType.COLLAPSED, "( (S (CC But) (NP (NP (NNP Ms.) (NNP Poore)) (, ,) (NP (NP (DT the) (NN magazine) (POS 's)) (NN editor) (CC and) (NN publisher)) (, ,)) (VP (VBD resigned)) (. .)))", "cc(resigned-12, But-1)\ncompound(Poore-3, Ms.-2)\nnsubj(resigned-12, Poore-3)\ndet(magazine-6, the-5)\nnmod:poss(editor-8, magazine-6)\ncase(magazine-6, 's-7)\nappos(Poore-3, editor-8)\ncc(editor-8, and-9)\nconj:and(editor-8, publisher-10)\nroot(ROOT-0, resigned-12)\n"}, {TestType.COLLAPSED, "( (S (NP (EX There)) (VP (VBZ 's) (ADVP (RB never)) (VP (VBN been) (NP (DT an) (NN exception)))) (. .)))", "expl(exception-6, There-1)\nauxpass(exception-6, 's-2)\nneg(exception-6, never-3)\ncop(exception-6, been-4)\ndet(exception-6, an-5)\nroot(ROOT-0, exception-6)\n"}, {TestType.COLLAPSED, "( (S (NP (NNP Sotheby) (POS 's)) (PRN (, ,) (S (NP (PRP she)) (VP (VBZ says))) (, ,)) (VP (VBZ is) (VP (`` ``) (VBG wearing) (NP (DT both) (NNS hats)))) (. .) ('' '')))", "nsubj(wearing-9, Sotheby-1)\ncase(Sotheby-1, 's-2)\nnsubj(says-5, she-4)\nparataxis(wearing-9, says-5)\naux(wearing-9, is-7)\nroot(ROOT-0, wearing-9)\ndet(hats-11, both-10)\ndobj(wearing-9, hats-11)\n"}, {TestType.COLLAPSED, "( (S (NP (NP (JJ Average) (NN maturity)) (PP (IN of) (NP (NP (NML (DT the) (NNS funds)) (POS ')) (NNS investments)))) (VP (VBD lengthened)) (. .)))", "amod(maturity-2, Average-1)\nnsubj(lengthened-8, maturity-2)\ncase(investments-7, of-3)\ndet(funds-5, the-4)\nnmod:poss(investments-7, funds-5)\ncase(funds-5, '-6)\nnmod:of(maturity-2, investments-7)\nroot(ROOT-0, lengthened-8)\n"}, {TestType.CC_PROCESSED, "(ROOT (S (NP (NNP Bill)) (VP (VBZ is) (ADJP (JJ big) (CC and) (JJ honest))) (. .)))", "nsubj(big-3, Bill-1)\nnsubj(honest-5, Bill-1)\ncop(big-3, is-2)\nroot(ROOT-0, big-3)\ncc(big-3, and-4)\nconj:and(big-3, honest-5)\n"}, {TestType.CC_PROCESSED, "(ROOT (S (NP (CC Both) (NP (DT the) (NNS boys)) (CC and) (NP (DT the) (NNS girls))) (VP (VBP are) (ADVP (RB here))) (. .)))", "cc:preconj(boys-3, Both-1)\ndet(boys-3, the-2)\nnsubj(are-7, boys-3)\ncc(boys-3, and-4)\ndet(girls-6, the-5)\nconj:and(boys-3, girls-6)\nnsubj(are-7, girls-6)\nroot(ROOT-0, are-7)\nadvmod(are-7, here-8)\n"}, {TestType.CC_PROCESSED, "(ROOT (S (NP-SBJ-38 (DT Neither) (NP (PRP they) ) (CC nor) (NP (NNP Mr.) (NNP McAlpine) )) (VP (MD could) (VP (VB be) (VP (VBN reached) (NP (-NONE- *-38) ) (PP-PRP (IN for) (NP (NN comment) ))))) (. .) ))", "cc:preconj(they-2, Neither-1)\nnsubjpass(reached-8, they-2)\ncc(they-2, nor-3)\ncompound(McAlpine-5, Mr.-4)\nconj:nor(they-2, McAlpine-5)\nnsubjpass(reached-8, McAlpine-5)\naux(reached-8, could-6)\nauxpass(reached-8, be-7)\nroot(ROOT-0, reached-8)\ncase(comment-10, for-9)\nnmod:for(reached-8, comment-10)\n"}, {TestType.CC_PROCESSED, "(ROOT (S (NP (NNP John)) (VP (VBZ works) (PP (DT both) (PP (IN in) (NP (NNP Zurich))) (CC and) (PP (IN in) (NP (NNP London))))) (. .)))", "nsubj(works-2, John-1)\nnsubj(works-2', John-1)\nroot(ROOT-0, works-2)\nconj:and(works-2, works-2')\ncc:preconj(Zurich-5, both-3)\ncase(Zurich-5, in-4)\nnmod:in(works-2, Zurich-5)\ncc(works-2, and-6)\ncase(London-8, in-7)\nnmod:in(works-2', London-8)\n"}, {TestType.CC_PROCESSED, "(ROOT (S (NP (NP (NNS Languages)) (PP (PP (IN with) (NP (NNS alphabets))) (CC and) (PP (IN without) (NP (NNS alphabets))))) (VP (VBP are) (ADJP (JJ difficult))) (. .)))", "conj:and(Languages-1, Languages-1')\nnsubj(difficult-8, Languages-1)\nnsubj(difficult-8, Languages-1')\ncase(alphabets-3, with-2)\nnmod:with(Languages-1, alphabets-3)\ncc(Languages-1, and-4)\ncase(alphabets-6, without-5)\nnmod:without(Languages-1', alphabets-6)\ncop(difficult-8, are-7)\nroot(ROOT-0, difficult-8)\n"}, {TestType.CC_PROCESSED, "(ROOT (S (NP (PRP$ His) (NN term)) (VP (VP (VBZ has) (VP (VBN produced) (NP (NP (DT no) (JJ spectacular) (NNS failures)) (PP (PP (IN in) (NP (NNS politics))) (, ,) (PP (IN in) (NP (DT the) (NN economy))) (CC or) (PP (IN on) (NP (DT the) (JJ military) (NN front))))))) (, ,) (CC and) (VP (VBZ has) (VP (VBN chalked) (PRT (RP up)) (NP (DT some) (NNS successes))))) (. .)))", "nmod:poss(term-2, His-1)\nnsubj(produced-4, term-2)\nnsubj(chalked-22, term-2)\naux(produced-4, has-3)\nroot(ROOT-0, produced-4)\nneg(failures-7, no-5)\namod(failures-7, spectacular-6)\ndobj(produced-4, failures-7)\ndobj(produced-4, failures-7')\ndobj(produced-4, failures-7'')\nconj:or(failures-7, failures-7')\nconj:or(failures-7, failures-7'')\ncase(politics-9, in-8)\nnmod:in(failures-7, politics-9)\ncase(economy-13, in-11)\ndet(economy-13, the-12)\nnmod:in(failures-7'', economy-13)\ncc(failures-7, or-14)\ncase(front-18, on-15)\ndet(front-18, the-16)\namod(front-18, military-17)\nnmod:on(failures-7', front-18)\ncc(produced-4, and-20)\naux(chalked-22, has-21)\nconj:and(produced-4, chalked-22)\ncompound:prt(chalked-22, up-23)\ndet(successes-25, some-24)\ndobj(chalked-22, successes-25)\n"}, {TestType.CC_PROCESSED, "(ROOT (S (NP (NNP Fred)) (VP (VBD walked) (PP (PP (IN out) (NP (DT the) (NN door))) (CC and) (PP (RB right) (IN into) (NP (DT a) (NN trap))))) (. .)))", "nsubj(walked-2, Fred-1)\nnsubj(walked-2', Fred-1)\nroot(ROOT-0, walked-2)\nconj:and(walked-2, walked-2')\ncase(door-5, out-3)\ndet(door-5, the-4)\nnmod:out(walked-2, door-5)\ncc(walked-2, and-6)\nadvmod(trap-10, right-7)\ncase(trap-10, into-8)\ndet(trap-10, a-9)\nnmod:into(walked-2', trap-10)\n"}, {TestType.CC_PROCESSED, "(ROOT (S (NP (NNP Fred)) (VP (VBD walked) (PP (PP (IN into) (NP (DT the) (NN house))) (CC and) (PP (RB right) (IN into) (NP (DT a) (NN trap))))) (. .)))", "nsubj(walked-2, Fred-1)\nnsubj(walked-2', Fred-1)\nroot(ROOT-0, walked-2)\nconj:and(walked-2, walked-2')\ncase(house-5, into-3)\ndet(house-5, the-4)\nnmod:into(walked-2, house-5)\ncc(walked-2, and-6)\nadvmod(trap-10, right-7)\ncase(trap-10, into-8)\ndet(trap-10, a-9)\nnmod:into(walked-2', trap-10)\n"}, {TestType.CC_PROCESSED, "(ROOT (S (NP (NNP Marie) (CC and) (NNP Chris)) (VP (VP (VBD went) (PRT (RP out))) (, ,) (VP (VBD drank) (NP (NN coffee))) (, ,) (CC and) (VP (VBD talked) (PP (IN about) (NP (NNP Stanford) (NNPS Dependencies))))) (. .)))", "nsubj(went-4, Marie-1)\nnsubj(drank-7, Marie-1)\nnsubj(talked-11, Marie-1)\ncc(Marie-1, and-2)\nconj:and(Marie-1, Chris-3)\nnsubj(went-4, Chris-3)\nroot(ROOT-0, went-4)\ncompound:prt(went-4, out-5)\nconj:and(went-4, drank-7)\ndobj(drank-7, coffee-8)\ncc(went-4, and-10)\nconj:and(went-4, talked-11)\ncase(Dependencies-14, about-12)\ncompound(Dependencies-14, Stanford-13)\nnmod:about(talked-11, Dependencies-14)\n"}, {TestType.CC_PROCESSED, "(ROOT (S (NP (NNP Jill)) (VP (VBD walked) (PP (PP (IN out) (NP (DT the) (NN door))) (, ,) (PP (IN over) (NP (DT the) (NN road))) (, ,) (PP (IN across) (NP (DT the) (JJ deserted) (NN block))) (, ,) (PP (IN around) (NP (DT the) (NN corner))) (, ,) (CC and) (PP (IN through) (NP (DT the) (NN park))))) (. .)))", "nsubj(walked-2, Jill-1)\nnsubj(walked-2', Jill-1)\nnsubj(walked-2'', Jill-1)\nnsubj(walked-2''', Jill-1)\nnsubj(walked-2'''', Jill-1)\nroot(ROOT-0, walked-2)\nconj:and(walked-2, walked-2')\nconj:and(walked-2, walked-2'')\nconj:and(walked-2, walked-2''')\nconj:and(walked-2, walked-2'''')\ncase(door-5, out-3)\ndet(door-5, the-4)\nnmod:out(walked-2, door-5)\ncase(road-9, over-7)\ndet(road-9, the-8)\nnmod:over(walked-2''', road-9)\ncase(block-14, across-11)\ndet(block-14, the-12)\namod(block-14, deserted-13)\nnmod:across(walked-2'''', block-14)\ncase(corner-18, around-16)\ndet(corner-18, the-17)\nnmod:around(walked-2', corner-18)\ncc(walked-2, and-20)\ncase(park-23, through-21)\ndet(park-23, the-22)\nnmod:through(walked-2'', park-23)\n"}, {TestType.CC_PROCESSED, "(ROOT (S (NP (NNP John)) (VP (VP (VBD noticed) (NP (DT a) (NN cockroach))) (CC and) (VP (VBD departed))) (. .)))", "nsubj(noticed-2, John-1)\nnsubj(departed-6, John-1)\nroot(ROOT-0, noticed-2)\ndet(cockroach-4, a-3)\ndobj(noticed-2, cockroach-4)\ncc(noticed-2, and-5)\nconj:and(noticed-2, departed-6)\n"}, {TestType.CC_PROCESSED, "( (S (S (NP (RBR More) (JJ common) (NN chrysotile) (NNS fibers)) (VP (VP (VBP are) (ADJP (JJ curly))) (CC and) (VP (VBP are) (VP (ADVP (RBR more) (RB easily)) (VBN rejected) (PP (IN by) (NP (DT the) (NN body))))))) (, ,) (NP (NNP Dr.) (NNP Mossman)) (VP (VBD explained)) (. .)))", "advmod(fibers-4, More-1)\namod(fibers-4, common-2)\ncompound(fibers-4, chrysotile-3)\nnsubj(curly-6, fibers-4)\nnsubjpass(rejected-11, fibers-4)\ncop(curly-6, are-5)\nccomp(explained-18, curly-6)\ncc(curly-6, and-7)\nauxpass(rejected-11, are-8)\nadvmod(easily-10, more-9)\nadvmod(rejected-11, easily-10)\nconj:and(curly-6, rejected-11)\nccomp(explained-18, rejected-11)\ncase(body-14, by-12)\ndet(body-14, the-13)\nnmod:agent(rejected-11, body-14)\ncompound(Mossman-17, Dr.-16)\nnsubj(explained-18, Mossman-17)\nroot(ROOT-0, explained-18)\n"}, {TestType.CC_PROCESSED, "( (S (NP (NNP John)) (VP (VP (VBD is) (VP (VBN appalled))) (CC and) (VP (MD will) (VP (VB complain)))) (. .)))", "nsubjpass(appalled-3, John-1)\nnsubj(complain-6, John-1)\nauxpass(appalled-3, is-2)\nroot(ROOT-0, appalled-3)\ncc(appalled-3, and-4)\naux(complain-6, will-5)\nconj:and(appalled-3, complain-6)\n"}, {TestType.CC_PROCESSED, "( (SBARQ (WHNP (WP What)) (SQ (VP (VBP are) (NP (NP (NP (NP (NNP Christopher) (NNP Marlowe) (POS 's)) (CC and) (NP (NNP Shakespeare) (POS 's))) (JJ literary) (NNS contributions)) (PP (TO to) (NP (JJ English) (NN literature)))))) (. ?)))", "nsubj(contributions-10, What-1)\ncop(contributions-10, are-2)\ncompound(Marlowe-4, Christopher-3)\nnmod:poss(contributions-10, Marlowe-4)\ncase(Marlowe-4, 's-5)\ncc(Marlowe-4, and-6)\nconj:and(Marlowe-4, Shakespeare-7)\nnmod:poss(contributions-10, Shakespeare-7)\ncase(Shakespeare-7, 's-8)\namod(contributions-10, literary-9)\nroot(ROOT-0, contributions-10)\ncase(literature-13, to-11)\namod(literature-13, English-12)\nnmod:to(contributions-10, literature-13)\n"}, {TestType.CC_PROCESSED, "( (SBARQ (WHNP (WP What)) (SQ (VP (VBP are) (NP (NP (NP (NP (NP (NNP Christopher) (NNP Marlowe)) (CC and) (NP (NNP Shakespeare))) (POS 's)) (JJ literary) (NNS contributions)) (PP (TO to) (NP (JJ English) (NN literature)))))) (. ?)))", "nsubj(contributions-9, What-1)\ncop(contributions-9, are-2)\ncompound(Marlowe-4, Christopher-3)\nnmod:poss(contributions-9, Marlowe-4)\ncc(Marlowe-4, and-5)\nconj:and(Marlowe-4, Shakespeare-6)\nnmod:poss(contributions-9, Shakespeare-6)\ncase(Marlowe-4, 's-7)\namod(contributions-9, literary-8)\nroot(ROOT-0, contributions-9)\ncase(literature-12, to-10)\namod(literature-12, English-11)\nnmod:to(contributions-9, literature-12)\n"}, {TestType.CC_PROCESSED, "( (S (NP (PRP I)) (VP (VBP like) (NP (NP (NNS dogs)) (CONJP (RB as) (RB well) (IN as)) (NP (NNS cats)))) (. .)))", "nsubj(like-2, I-1)\nroot(ROOT-0, like-2)\ndobj(like-2, dogs-3)\ncc(dogs-3, as-4)\nmwe(as-4, well-5)\nmwe(as-4, as-6)\ndobj(like-2, cats-7)\nconj:and(dogs-3, cats-7)\n"}, {TestType.CC_PROCESSED, "( (S (NP (PRP I)) (VP (VBP like) (NP (NP (NNS dogs)) (CONJP (RB rather) (IN than)) (NP (NNS cats)))) (. .)))", "nsubj(like-2, I-1)\nroot(ROOT-0, like-2)\ndobj(like-2, dogs-3)\ncc(dogs-3, rather-4)\nmwe(rather-4, than-5)\ndobj(like-2, cats-6)\nconj:negcc(dogs-3, cats-6)\n"}, {TestType.CC_PROCESSED, "( (S (NP (PRP I)) (VP (VBP like) (NP (NP (NN brandy)) (CONJP (RB not) (TO to) (VB mention)) (NP (NN cognac)))) (. .)))", "nsubj(like-2, I-1)\nroot(ROOT-0, like-2)\ndobj(like-2, brandy-3)\ncc(brandy-3, not-4)\nmwe(not-4, to-5)\nmwe(not-4, mention-6)\ndobj(like-2, cognac-7)\nconj:and(brandy-3, cognac-7)\n"}, {TestType.CC_PROCESSED, "( (S (NP (PRP I)) (VP (VBP like) (NP (CONJP (RB not) (RB only)) (NP (NNS cats)) (CONJP (CC but) (RB also)) (NP (NN dogs)))) (. .)))", "nsubj(like-2, I-1)\nroot(ROOT-0, like-2)\nneg(only-4, not-3)\ncc:preconj(cats-5, only-4)\ndobj(like-2, cats-5)\ncc(cats-5, but-6)\nadvmod(dogs-8, also-7)\ndobj(like-2, dogs-8)\nconj:and(cats-5, dogs-8)\n"}, {TestType.CC_PROCESSED, "((S (NP (NNP Fred)) (VP (VBD flew) (PP (CONJP (RB not) (JJ only)) (PP (TO to) (NP (NNP Greece))) (CONJP (CC but) (RB also)) (PP (TO to) (NP (NNP Serbia))))) (. .)))", "nsubj(flew-2, Fred-1)\nnsubj(flew-2', Fred-1)\nroot(ROOT-0, flew-2)\nconj:and(flew-2, flew-2')\nneg(only-4, not-3)\ncc:preconj(Greece-6, only-4)\ncase(Greece-6, to-5)\nnmod:to(flew-2, Greece-6)\ncc(flew-2, but-7)\nadvmod(Serbia-10, also-8)\ncase(Serbia-10, to-9)\nnmod:to(flew-2', Serbia-10)\n"}, {TestType.CC_PROCESSED, "( (SINV (ADVP-TMP (RB Only) (RB recently)) (SINV (VBZ has) (NP (PRP it)) (VP (VBN been) (VP (ADVP-MNR (RB attractively)) (VBN redesigned)))) (CC and) (SINV (NP (PRP$ its) (JJ editorial) (NN product)) (VP (VBN improved))) (. .)))", "advmod(recently-2, Only-1)\nadvmod(redesigned-7, recently-2)\naux(redesigned-7, has-3)\nnsubjpass(redesigned-7, it-4)\nauxpass(redesigned-7, been-5)\nadvmod(redesigned-7, attractively-6)\nroot(ROOT-0, redesigned-7)\ncc(redesigned-7, and-8)\nnmod:poss(product-11, its-9)\namod(product-11, editorial-10)\nnsubj(improved-12, product-11)\nconj:and(redesigned-7, improved-12)\n"}, {TestType.CC_PROCESSED, "( (S (NP-SBJ (JJP (JJ Political) (CC and) (NN currency)) (NNS gyrations)) (VP (MD can) (VP (VB whipsaw) (NP (DT the) (NNS funds)))) (. .)))", "amod(gyrations-4, Political-1)\ncc(Political-1, and-2)\nconj:and(Political-1, currency-3)\namod(gyrations-4, currency-3)\nnsubj(whipsaw-6, gyrations-4)\naux(whipsaw-6, can-5)\nroot(ROOT-0, whipsaw-6)\ndet(funds-8, the-7)\ndobj(whipsaw-6, funds-8)\n"}, {TestType.CC_PROCESSED, "(NP-SBJ (NNS Managers) (CC and) (NNS presenters))", "root(ROOT-0, Managers-1)\ncc(Managers-1, and-2)\nconj:and(Managers-1, presenters-3)\n"}, {TestType.CC_PROCESSED, "(NP (NN education) (, ,) (NN science) (CC and) (NN culture))", "root(ROOT-0, education-1)\nconj:and(education-1, science-3)\ncc(education-1, and-4)\nconj:and(education-1, culture-5)\n"}, {TestType.CC_PROCESSED, "(NP (NN education) (, ,) (NN science) (, ,) (CC and) (NN culture))", "root(ROOT-0, education-1)\nconj:and(education-1, science-3)\ncc(education-1, and-5)\nconj:and(education-1, culture-6)\n"}, {TestType.CC_PROCESSED, "(NP (NNP Digital) (, ,) (NNP Hewlett) (CC and) (NNP Sun) ) ", "root(ROOT-0, Digital-1)\nconj:and(Digital-1, Hewlett-3)\ncc(Digital-1, and-4)\nconj:and(Digital-1, Sun-5)\n"}, {TestType.CC_PROCESSED, "(NP (NNP Digital) (, ,) (NNP Hewlett) (, ,) (CC and) (NNP Sun))", "root(ROOT-0, Digital-1)\nconj:and(Digital-1, Hewlett-3)\ncc(Digital-1, and-5)\nconj:and(Digital-1, Sun-6)\n"}, {TestType.CC_PROCESSED, "(NP (NP (NNP Home) (NNP Depot) ) (, ,) (NP (NNP Sun) ) (, ,) (CC and) (NP (NNP Coke) ) )", "compound(Depot-2, Home-1)\nroot(ROOT-0, Depot-2)\nconj:and(Depot-2, Sun-4)\ncc(Depot-2, and-6)\nconj:and(Depot-2, Coke-7)\n"}, {TestType.CC_PROCESSED, "(NP (NP (NNP Home) (NNP Depot) ) (, ,) (NP (NNP Sun) ) (CC and)  (NP (NNP Coke) ) )", "compound(Depot-2, Home-1)\nroot(ROOT-0, Depot-2)\nconj:and(Depot-2, Sun-4)\ncc(Depot-2, and-5)\nconj:and(Depot-2, Coke-6)\n"}, {TestType.CC_PROCESSED, "(S (NP (NP (NN Activation)) (PP (IN of) (NP (NP (NN Akt)) (, ,) (NP (NN NFkappaB)) (, ,) (CC and) (NP (NN Stat3)) (CONJP (CC but) (RB not)) (NP (NN MAPK) (NNS pathways))))) (VP (VBP are) (NP (NP (NNS characteristics)) (VP (VBN associated) (PP (IN with) (NP (NP (JJ malignant) (NN transformation)) ))))))", "nsubj(characteristics-14, Activation-1)\ncase(Akt-3, of-2)\nnmod:of(Activation-1, Akt-3)\nnmod:of(Activation-1, NFkappaB-5)\nconj:and(Akt-3, NFkappaB-5)\ncc(Akt-3, and-7)\nnmod:of(Activation-1, Stat3-8)\nconj:and(Akt-3, Stat3-8)\ncc(not-10, but-9)\ncc(Akt-3, not-10)\ncompound(pathways-12, MAPK-11)\nnmod:of(Activation-1, pathways-12)\nconj:negcc(Akt-3, pathways-12)\ncop(characteristics-14, are-13)\nroot(ROOT-0, characteristics-14)\nacl(characteristics-14, associated-15)\ncase(transformation-18, with-16)\namod(transformation-18, malignant-17)\nnmod:with(associated-15, transformation-18)\n"}, {TestType.COLLAPSED, "(ROOT (S (NP (NNP Bill)) (VP (VBD went) (PP (PP (IN over) (NP (DT the) (NN river))) (CC and) (PP (IN through) (NP (DT the) (NNS woods))))) (. .)))", "nsubj(went-2, Bill-1)\nroot(ROOT-0, went-2)\nconj:and(went-2, went-2')\ncase(river-5, over-3)\ndet(river-5, the-4)\nnmod:over(went-2, river-5)\ncc(went-2, and-6)\ncase(woods-9, through-7)\ndet(woods-9, the-8)\nnmod:through(went-2', woods-9)\n"}, {TestType.CC_PROCESSED, "(ROOT (S (NP (NNP Lufthansa)) (VP (VBZ flies) (PP (TO to) (CC and) (IN from) (NP (NP (NNP Serbia)) (CC and) (NP (NNP France))))) (. .)))", "nsubj(flies-2, Lufthansa-1)\nnsubj(flies-2', Lufthansa-1)\nroot(ROOT-0, flies-2)\nconj:and(flies-2, flies-2')\ncase(Serbia-6, to-3)\ncc(to-3, and-4)\nconj:and(to-3, from-5)\nnmod:from(flies-2', Serbia-6)\nnmod:to(flies-2, Serbia-6)\ncc(Serbia-6, and-7)\nnmod:from(flies-2', France-8)\nnmod:to(flies-2, France-8)\nconj:and(Serbia-6, France-8)\n"}, {TestType.CC_PROCESSED, "((S (NP-SBJ (NP (DT The) (NN apartment)) (PP-LOC (IN across) (PP (IN from) (NP (PRP mine))))) (VP (VBD belonged) (PP-CLR (IN to) (NP (NP (DT a) (NN gang)) (PP (IN of) (NP (NNS bikers)))))) (. .)))", "det(apartment-2, The-1)\nnsubj(belonged-6, apartment-2)\ncase(mine-5, across-3)\nmwe(across-3, from-4)\nnmod:across_from(apartment-2, mine-5)\nroot(ROOT-0, belonged-6)\ncase(gang-9, to-7)\ndet(gang-9, a-8)\nnmod:to(belonged-6, gang-9)\ncase(bikers-11, of-10)\nnmod:of(gang-9, bikers-11)\n"}, {TestType.CC_PROCESSED, "((S (NP-SBJ (PRP He)) (VP (VBZ is) (ADJP-PRD (JJ close) (PP (IN by) (NP (DT the ) (NN train) (NN station))))) (. .)))", "nsubj(station-7, He-1)\ncop(station-7, is-2)\ncase(station-7, close-3)\nmwe(close-3, by-4)\ndet(station-7, the-5)\ncompound(station-7, train-6)\nroot(ROOT-0, station-7)\n"}, {TestType.CC_PROCESSED, "(ROOT (S (PP (ADVP (RB Apart)) (IN from) (NP (DT the) (NN roof))) (, ,) (NP (DT the) (NN house)) (VP (VBZ is) (PP (IN in) (NP (JJ good) (NN shape)))) (. .)))", "case(roof-4, Apart-1)\nmwe(Apart-1, from-2)\ndet(roof-4, the-3)\nnmod:apart_from(shape-11, roof-4)\ndet(house-7, the-6)\nnsubj(shape-11, house-7)\ncop(shape-11, is-8)\ncase(shape-11, in-9)\namod(shape-11, good-10)\nroot(ROOT-0, shape-11)\n"});
    }

    public UniversalEnglishGrammaticalStructureTest(TestType type, String testTree, String testAnswer) {
        this.testTree = testTree;
        this.testAnswer = testAnswer;
        this.type = type;
    }

    @Test
    public void doTest() {
        switch (this.type) {
            case BASIC: {
                this.testBasicRelation();
                break;
            }
            case COPULA_HEAD: {
                this.testBasicRelationWithCopulaAsHead();
                break;
            }
            case NON_COLLAPSED: {
                this.testNonCollapsedRelation();
                break;
            }
            case NON_COLLAPSED_SEPARATOR: {
                this.testNonCollapsedSeparator();
                break;
            }
            case COLLAPSED: {
                this.testCollapsedRelation();
                break;
            }
            case CC_PROCESSED: {
                this.testCCProcessedRelation();
                break;
            }
            default: {
                throw new RuntimeException("No test defined for test type " + (Object)((Object)this.type));
            }
        }
    }

    public void testBasicRelation() {
        NPTmpRetainingTreeNormalizer.NPTmpAdvRetainingTreeReaderFactory trf = new NPTmpRetainingTreeNormalizer.NPTmpAdvRetainingTreeReaderFactory();
        Tree tree = Tree.valueOf(this.testTree, trf);
        UniversalEnglishGrammaticalStructure gs = new UniversalEnglishGrammaticalStructure(tree);
        UniversalEnglishGrammaticalStructureTest.assertEquals((String)("Unexpected basic dependencies for tree " + this.testTree), (Object)this.testAnswer, (Object)GrammaticalStructureConversionUtils.dependenciesToString(gs, gs.typedDependencies(), tree, false, false, false));
    }

    public void testBasicRelationWithCopulaAsHead() {
        NPTmpRetainingTreeNormalizer.NPTmpAdvRetainingTreeReaderFactory trf = new NPTmpRetainingTreeNormalizer.NPTmpAdvRetainingTreeReaderFactory();
        Tree tree = Tree.valueOf(this.testTree, trf);
        UniversalEnglishGrammaticalStructure gs = new UniversalEnglishGrammaticalStructure(tree, new PennTreebankLanguagePack().punctuationWordRejectFilter(), new UniversalSemanticHeadFinder(false));
        UniversalEnglishGrammaticalStructureTest.assertEquals((String)("Unexpected basic dependencies with copula as head for tree " + this.testTree), (Object)this.testAnswer, (Object)GrammaticalStructureConversionUtils.dependenciesToString(gs, gs.typedDependencies(), tree, false, false, false));
    }

    public void testNonCollapsedRelation() {
        NPTmpRetainingTreeNormalizer.NPTmpAdvRetainingTreeReaderFactory trf = new NPTmpRetainingTreeNormalizer.NPTmpAdvRetainingTreeReaderFactory();
        Tree tree = Tree.valueOf(this.testTree, trf);
        UniversalEnglishGrammaticalStructure gs = new UniversalEnglishGrammaticalStructure(tree);
        UniversalEnglishGrammaticalStructureTest.assertEquals((String)("Unexpected non-collapsed dependencies for tree " + this.testTree), (Object)this.testAnswer, (Object)GrammaticalStructureConversionUtils.dependenciesToString(gs, gs.allTypedDependencies(), tree, false, false, false));
    }

    public void testNonCollapsedSeparator() {
        PennTreeReaderFactory trf = new PennTreeReaderFactory();
        Tree tree = Tree.valueOf(this.testTree, trf);
        UniversalEnglishGrammaticalStructure gs = new UniversalEnglishGrammaticalStructure(tree);
        UniversalEnglishGrammaticalStructureTest.assertEquals((String)("Unexpected basic dependencies for tree " + this.testTree), (Object)this.testAnswer, (Object)GrammaticalStructureConversionUtils.dependenciesToString(gs, gs.allTypedDependencies(), tree, false, true, false));
    }

    public void testCollapsedRelation() {
        PennTreeReaderFactory trf = new PennTreeReaderFactory();
        Tree tree = Tree.valueOf(this.testTree, trf);
        UniversalEnglishGrammaticalStructure gs = new UniversalEnglishGrammaticalStructure(tree);
        String depString = GrammaticalStructureConversionUtils.dependenciesToString(gs, gs.typedDependenciesCollapsed(GrammaticalStructure.Extras.MAXIMAL), tree, false, false, false);
        UniversalEnglishGrammaticalStructureTest.assertEquals((String)("Unexpected collapsed dependencies for tree " + this.testTree), (Object)this.testAnswer, (Object)depString);
    }

    public void testCCProcessedRelation() {
        PennTreeReaderFactory trf = new PennTreeReaderFactory();
        Tree tree = Tree.valueOf(this.testTree, trf);
        UniversalEnglishGrammaticalStructure gs = new UniversalEnglishGrammaticalStructure(tree);
        UniversalEnglishGrammaticalStructureTest.assertEquals((String)("Unexpected CC processed dependencies for tree " + this.testTree), (Object)this.testAnswer, (Object)GrammaticalStructureConversionUtils.dependenciesToString(gs, gs.typedDependenciesCCprocessed(GrammaticalStructure.Extras.MAXIMAL), tree, false, false, false));
    }

    private static enum TestType {
        BASIC,
        COPULA_HEAD,
        NON_COLLAPSED,
        NON_COLLAPSED_SEPARATOR,
        COLLAPSED,
        CC_PROCESSED;

    }
}

