/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.arabic;

import edu.stanford.nlp.io.EncodingPrintWriter;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ArabicUtils {
    private static Redwood.RedwoodChannels log = Redwood.channels(ArabicUtils.class);

    public static Map<String, String> presToLogicalMap() {
        Map<String, String> rules = Generics.newHashMap();
        rules.put("\\ufc5e", " \u064c\u0651");
        rules.put("\\ufc5f", " \u064d\u0651");
        rules.put("\\ufc60", " \u064e\u0651");
        rules.put("\\ufc61", " \u064f\u0651");
        rules.put("\\ufc62", " \u0650\u0651");
        rules.put("\\ufe80", "\u0621");
        rules.put("[\\ufe81\\ufe82]", "\u0622");
        rules.put("[\\ufe83\\ufe84]", "\u0623");
        rules.put("[\\ufe85\\ufe86]", "\u0624");
        rules.put("[\\ufe87\\ufe88]", "\u0625");
        rules.put("[\\ufe89\\ufe8a\\ufe8b\\ufe8c]", "\u0626");
        rules.put("[\\ufe8d\\ufe8e]", "\u0627");
        rules.put("[\\ufe8f\\ufe90\\ufe91\\ufe92]", "\u0628");
        rules.put("[\\ufe93\\ufe94]", "\u0629");
        rules.put("[\\ufe95\\ufe96\\ufe97\\ufe98]", "\u062a");
        rules.put("[\\ufe99\\ufe9a\\ufe9b\\ufe9c]", "\u062b");
        rules.put("[\\ufe9d\\ufe9e\\ufe9f\\ufea0]", "\u062c");
        rules.put("[\\ufea1\\ufea2\\ufea3\\ufea4]", "\u062d");
        rules.put("[\\ufea5\\ufea6\\ufea7\\ufea8]", "\u062e");
        rules.put("[\\ufea9\\ufeaa]", "\u062f");
        rules.put("[\\ufeab\\ufeac]", "\u0630");
        rules.put("[\\ufead\\ufeae]", "\u0631");
        rules.put("[\\ufeaf\\ufeb0]", "\u0632");
        rules.put("[\\ufeb1\\ufeb2\\ufeb3\\ufeb4]", "\u0633");
        rules.put("[\\ufeb5\\ufeb6\\ufeb7\\ufeb8]", "\u0634");
        rules.put("[\\ufeb9\\ufeba\\ufebb\\ufebc]", "\u0635");
        rules.put("[\\ufebd\\ufebe\\ufebf\\ufec0]", "\u0636");
        rules.put("[\\ufec1\\ufec2\\ufec3\\ufec4]", "\u0637");
        rules.put("[\\ufec5\\ufec6\\ufec7\\ufec8]", "\u0638");
        rules.put("[\\ufec9\\ufeca\\ufecb\\ufecc]", "\u0639");
        rules.put("[\\ufecd\\ufece\\ufecf\\ufed0]", "\u063a");
        rules.put("[\\ufed1\\ufed2\\ufed3\\ufed4]", "\u0641");
        rules.put("[\\ufed5\\ufed6\\ufed7\\ufed8]", "\u0642");
        rules.put("[\\ufed9\\ufeda\\ufedb\\ufedc]", "\u0643");
        rules.put("[\\ufedd\\ufede\\ufedf\\ufee0]", "\u0644");
        rules.put("[\\ufee1\\ufee2\\ufee3\\ufee4]", "\u0645");
        rules.put("[\\ufee5\\ufee6\\ufee7\\ufee8]", "\u0646");
        rules.put("[\\ufee9\\ufeea\\ufeeb\\ufeec]", "\u0647");
        rules.put("[\\ufeed\\ufeee]", "\u0648");
        rules.put("[\\ufeef\\ufef0]", "\u0649");
        rules.put("[\\ufef1\\ufef2\\ufef3\\ufef4]", "\u064a");
        rules.put("[\\ufef5\\ufef6]", "\u0644\u0622");
        rules.put("[\\ufef7\\ufef8]", "\u0644\u0623");
        rules.put("[\\ufef9\\ufefa]", "\u0644\u0625");
        rules.put("[\\ufefb\\ufefc]", "\u0644\u0627");
        return rules;
    }

    public static Map<String, String> getArabicIBMNormalizerMap() {
        Map<String, String> rules = Generics.newHashMap();
        try {
            rules.put("[\\u0622\\u0623\\u0625]", "\u0627");
            rules.put("[\\u0649]", "\u064a");
            rules.put("[\\u064B\\u064C\\u064D\\u064E\\u064F\\u0650\\u0651\\u0652\\u0653\\u0670]", "");
            rules.put("\\u0640(?=\\s*\\S)", "");
            rules.put("(\\S)\\u0640", "$1");
            rules.put("[\\ufeff\\u00a0]", " ");
            rules.put("\\u060c", ",");
            rules.put("\\u061b", ";");
            rules.put("\\u061f", "?");
            rules.put("\\u066a", "%");
            rules.put("\\u066b", ".");
            rules.put("\\u066c", ",");
            rules.put("\\u066d", "*");
            rules.put("\\u06d4", ".");
            rules.put("[\\u0660\\u06f0\\u0966]", "0");
            rules.put("[\\u0661\\u06f1\\u0967]", "1");
            rules.put("[\\u0662\\u06f2\\u0968]", "2");
            rules.put("[\\u0663\\u06f3\\u0969]", "3");
            rules.put("[\\u0664\\u06f4\\u096a]", "4");
            rules.put("[\\u0665\\u06f5\\u096b]", "5");
            rules.put("[\\u0666\\u06f6\\u096c]", "6");
            rules.put("[\\u0667\\u06f7\\u096d]", "7");
            rules.put("[\\u0668\\u06f8\\u096e]", "8");
            rules.put("[\\u0669\\u06f9\\u096f]", "9");
            rules.put("[\\u0654\\u0655\\u0670]", "");
            rules.put("\\u064A\\u0621", "\u0626");
            rules.put("\\u2013", "-");
            rules.put("\\u2014", "--");
            rules.put("[\\u0091\\u0092\\u2018\\u2019]", "'");
            rules.put("[\\u0093\\u0094\\u201C\\u201D]", "\"");
        }
        catch (Exception e) {
            log.info("Caught exception creating Arabic normalizer map: " + e.toString());
        }
        return rules;
    }

    public static String normalize(String in) {
        Map<String, String> ruleMap = ArabicUtils.getArabicIBMNormalizerMap();
        ruleMap.putAll(ArabicUtils.presToLogicalMap());
        Set<Map.Entry<String, String>> rules = ruleMap.entrySet();
        Iterator<Map.Entry<String, String>> ruleIter = rules.iterator();
        String out2 = in;
        while (ruleIter.hasNext()) {
            Map.Entry<String, String> thisRule = ruleIter.next();
            out2 = out2.replaceAll(thisRule.getKey(), thisRule.getValue());
        }
        return out2;
    }

    public static void main(String[] args) throws IOException {
        Properties p = StringUtils.argsToProperties(args);
        if (p.containsKey("input")) {
            String thisLine;
            FileInputStream fis = new FileInputStream(p.getProperty("input"));
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
            BufferedReader reader = new BufferedReader(isr);
            while ((thisLine = reader.readLine()) != null) {
                EncodingPrintWriter.out.println(ArabicUtils.normalize(thisLine), "UTF-8");
            }
        }
    }
}

