/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.ArraySet;
import java.util.HashSet;
import junit.framework.TestCase;

public class ArraySetTest
extends TestCase {
    ArraySet<Integer> set;

    public void setUp() {
        this.set = new ArraySet();
        this.set.add(5);
        this.set.add(10);
        this.set.add(8);
    }

    public void testEquals() {
        ArraySetTest.assertTrue((boolean)this.set.equals(this.set));
        HashSet<Integer> hset = new HashSet<Integer>();
        hset.addAll(this.set);
        ArraySetTest.assertTrue((boolean)this.set.equals(hset));
        ArraySetTest.assertTrue((boolean)hset.equals(this.set));
    }

    public void testAdd() {
        ArraySetTest.assertTrue((boolean)this.set.contains(5));
        ArraySetTest.assertFalse((boolean)this.set.contains(4));
        for (int i = 0; i < 11; ++i) {
            this.set.add(i);
        }
        ArraySetTest.assertEquals((int)11, (int)this.set.size());
        ArraySetTest.assertTrue((boolean)this.set.contains(5));
        ArraySetTest.assertTrue((boolean)this.set.contains(4));
    }

    public void testRemove() {
        ArraySetTest.assertFalse((boolean)this.set.contains(2));
        ArraySetTest.assertTrue((boolean)this.set.contains(5));
        this.set.remove(5);
        ArraySetTest.assertEquals((int)2, (int)this.set.size());
        ArraySetTest.assertFalse((boolean)this.set.contains(2));
        ArraySetTest.assertFalse((boolean)this.set.contains(5));
    }

    public void testClear() {
        ArraySetTest.assertFalse((boolean)this.set.isEmpty());
        ArraySetTest.assertEquals((int)3, (int)this.set.size());
        this.set.clear();
        ArraySetTest.assertTrue((boolean)this.set.isEmpty());
        ArraySetTest.assertEquals((int)0, (int)this.set.size());
    }
}

