/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.DeltaIndex;
import edu.stanford.nlp.util.HashIndex;
import junit.framework.TestCase;

public class DeltaIndexTest
extends TestCase {
    HashIndex<String> underlying;
    DeltaIndex<String> spillover;

    public void setUp() {
        this.underlying = new HashIndex();
        this.underlying.add("foo0");
        this.underlying.add("foo1");
        this.underlying.add("foo2");
        this.underlying.add("foo3");
        this.underlying.add("foo4");
        DeltaIndexTest.assertEquals((int)5, (int)this.underlying.size());
        this.spillover = new DeltaIndex<String>(this.underlying);
        this.spillover.add("foo1");
        this.spillover.add("foo5");
        this.spillover.add("foo6");
    }

    public void testSize() {
        DeltaIndexTest.assertEquals((int)5, (int)this.underlying.size());
        DeltaIndexTest.assertEquals((int)7, (int)this.spillover.size());
    }

    public void testContains() {
        DeltaIndexTest.assertTrue((boolean)this.underlying.contains("foo1"));
        DeltaIndexTest.assertFalse((boolean)this.underlying.contains("foo5"));
        DeltaIndexTest.assertFalse((boolean)this.underlying.contains("foo7"));
        DeltaIndexTest.assertTrue((boolean)this.spillover.contains("foo1"));
        DeltaIndexTest.assertTrue((boolean)this.spillover.contains("foo5"));
        DeltaIndexTest.assertFalse((boolean)this.spillover.contains("foo7"));
    }

    public void testIndex() {
        DeltaIndexTest.assertEquals((int)4, (int)this.spillover.indexOf("foo4"));
        DeltaIndexTest.assertEquals((int)6, (int)this.spillover.indexOf("foo6"));
        DeltaIndexTest.assertEquals((int)-1, (int)this.spillover.indexOf("foo7"));
    }

    public void testGet() {
        DeltaIndexTest.assertEquals((String)"foo4", (String)this.spillover.get(4));
        DeltaIndexTest.assertEquals((String)"foo5", (String)this.spillover.get(5));
        DeltaIndexTest.assertEquals((String)"foo6", (String)this.spillover.get(6));
    }
}

