/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Iterables;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Triple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;

public class IterablesTest {
    @Test
    public void testZip() {
        String[] s1 = new String[]{"a", "b", "c"};
        Integer[] s2 = new Integer[]{1, 2, 3, 4};
        int count = 0;
        for (Pair<String, Integer> pair : Iterables.zip(s1, s2)) {
            Assert.assertEquals(pair.first, (Object)s1[count]);
            Assert.assertEquals(pair.second, (Object)s2[count]);
            ++count;
        }
        Assert.assertEquals((long)(s1.length < s2.length ? (long)s1.length : (long)s2.length), (long)count);
    }

    @Test
    public void testChain() {
        List<String> s1 = Arrays.asList("hi", "there");
        List<String> s2 = Arrays.asList(new String[0]);
        List<String> s3 = Arrays.asList("yoo");
        List<String> s4 = Arrays.asList(new String[0]);
        List<String> answer = Arrays.asList("yoo", "hi", "there", "yoo");
        ArrayList<String> chained = new ArrayList<String>();
        for (String s : Iterables.chain(s3, s1, s2, s3, s4)) {
            chained.add(s);
        }
        Assert.assertEquals(answer, chained);
    }

    @Test
    public void testFilter() {
        List<String> values = Arrays.asList("a", "HI", "tHere", "YO");
        Iterator<String> iterator = Iterables.filter(values, in -> in.equals(in.toUpperCase())).iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)iterator.next(), (Object)"HI");
        Assert.assertEquals((Object)iterator.next(), (Object)"YO");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testTransform() {
        List<Integer> values = Arrays.asList(1, 2, 3, 4);
        List<Integer> squares = Arrays.asList(1, 4, 9, 16);
        Function<Integer, Integer> squarer = in -> in * in;
        for (Pair<Integer, Integer> pair : Iterables.zip(Iterables.transform(values, squarer), squares)) {
            Assert.assertEquals(pair.first, pair.second);
        }
    }

    @Test
    public void testMerge() {
        List<String> a = Arrays.asList("a", "b", "d", "e");
        List<String> b = Arrays.asList("b", "c", "d", "e");
        Comparator comparator = Comparator.naturalOrder();
        Iterator<Pair<String, String>> iter = Iterables.merge(a, b, comparator).iterator();
        Assert.assertEquals(iter.next(), new Pair<String, String>("b", "b"));
        Assert.assertEquals(iter.next(), new Pair<String, String>("d", "d"));
        Assert.assertEquals(iter.next(), new Pair<String, String>("e", "e"));
        Assert.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
    }

    @Test
    public void testMerge3() {
        List<String> a = Arrays.asList("a", "b", "d", "e");
        List<String> b = Arrays.asList("b", "c", "d", "e");
        List<String> c = Arrays.asList("a", "b", "c", "e", "f");
        Comparator comparator = Comparator.naturalOrder();
        Iterator<Triple<String, String, String>> iter = Iterables.merge(a, b, c, comparator).iterator();
        Assert.assertEquals(iter.next(), new Triple<String, String, String>("b", "b", "b"));
        Assert.assertEquals(iter.next(), new Triple<String, String, String>("e", "e", "e"));
        Assert.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
    }

    @Test
    public void testGroup() {
        String[] input = new String[]{"0 ab", "0 bb", "0 cc", "1 dd", "2 dd", "2 kj", "3 kj", "3 kk"};
        int[] counts = new int[]{3, 1, 2, 2};
        Comparator<String> fieldOne = Comparator.comparing(o -> o.split(" ")[0]);
        int index = 0;
        int group = 0;
        for (Iterable<String> set : Iterables.group(Arrays.asList(input), fieldOne)) {
            String sharedKey = null;
            int thisCount = 0;
            for (String line : set) {
                String thisKey = line.split(" ")[0];
                if (sharedKey == null) {
                    sharedKey = thisKey;
                } else {
                    Assert.assertEquals((String)"Wrong key", (Object)sharedKey, (Object)thisKey);
                }
                Assert.assertEquals((String)"Wrong input line", (Object)line, (Object)input[index++]);
                ++thisCount;
            }
            Assert.assertEquals((String)"Wrong number of items in this iterator", (long)counts[group++], (long)thisCount);
        }
        Assert.assertEquals((String)"Didn't get all inputs", (long)input.length, (long)index);
        Assert.assertEquals((String)"Wrong number of groups", (long)counts.length, (long)group);
    }

    @Test
    public void testSample() {
        List<Integer> items = Arrays.asList(5, 4, 3, 2, 1);
        int count = 0;
        for (Integer item : Iterables.sample(items, 5, 2, new Random())) {
            ++count;
            Assert.assertTrue((item <= 5 ? 1 : 0) != 0);
            Assert.assertTrue((item >= 1 ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)2L, (long)count);
    }
}

