/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Generics;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class OneToOneMap<L, R>
implements Serializable {
    private Map<L, R> m_leftAsKey = Generics.newHashMap();
    private Map<R, L> m_rightAsKey = Generics.newHashMap();
    private static final long serialVersionUID = 1L;

    public boolean isEmpty() {
        return this.m_leftAsKey.isEmpty();
    }

    public int size() {
        return this.m_leftAsKey.size();
    }

    public void put(L l, R r) throws OneToOneMapException {
        boolean hasRight;
        boolean hasLeft = this.m_leftAsKey.containsKey(l);
        if (hasLeft != (hasRight = this.m_rightAsKey.containsKey(r))) {
            throw new OneToOneMapException("Error: cannot insert multiple keys with the same value");
        }
        this.m_leftAsKey.put(l, r);
        this.m_rightAsKey.put(r, l);
    }

    public R getLeftAsKey(L l) {
        return this.m_leftAsKey.get(l);
    }

    public L getRightAsKey(R r) {
        return this.m_rightAsKey.get(r);
    }

    public R removeLeftAsKey(L l) {
        R r = this.m_leftAsKey.remove(l);
        if (r != null) {
            this.m_rightAsKey.remove(r);
        }
        return r;
    }

    public L removeRightAsKey(R r) {
        L l = this.m_rightAsKey.remove(r);
        if (l != null) {
            this.m_leftAsKey.remove(l);
        }
        return l;
    }

    public Collection<R> valuesLeftAsKey() {
        return this.m_leftAsKey.values();
    }

    public Collection<L> valuesRightAsKey() {
        return this.m_rightAsKey.values();
    }

    public Set<Map.Entry<L, R>> entrySetLeftAsKey() {
        return this.m_leftAsKey.entrySet();
    }

    public Set<Map.Entry<R, L>> entrySetRightAsKey() {
        return this.m_rightAsKey.entrySet();
    }

    public boolean containsLeftAsKey(L l) {
        return this.m_leftAsKey.containsKey(l);
    }

    public boolean containsRightAsKey(R r) {
        return this.m_rightAsKey.containsKey(r);
    }

    public void clear() {
        this.m_leftAsKey.clear();
        this.m_rightAsKey.clear();
    }

    public static class OneToOneMapException
    extends Exception {
        private static final long serialVersionUID = 7743164489912070054L;

        public OneToOneMapException(String iDesc) {
            super(iDesc);
        }
    }
}

