/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.BinaryHeapPriorityQueue;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.FixedPrioritiesPriorityQueue;
import edu.stanford.nlp.util.PriorityQueue;
import java.util.AbstractCollection;
import junit.framework.TestCase;

public class PriorityQueueTest
extends TestCase {
    public void testBinaryHeapPriorityQueue() {
        PriorityQueueTest.runBasicTests("edu.stanford.nlp.util.BinaryHeapPriorityQueue");
        PriorityQueueTest.runRelaxingTests("edu.stanford.nlp.util.BinaryHeapPriorityQueue");
    }

    public void testFixedPrioritiesPriorityQueue() {
        PriorityQueueTest.runBasicTests("edu.stanford.nlp.util.FixedPrioritiesPriorityQueue");
        PriorityQueueTest.runNotRelaxingTests("edu.stanford.nlp.util.FixedPrioritiesPriorityQueue");
    }

    private static void runBasicTests(String className) {
        PriorityQueue queue;
        try {
            queue = (PriorityQueue)ErasureUtils.uncheckedCast(Class.forName(className).newInstance());
        }
        catch (Exception e) {
            PriorityQueueTest.fail((String)e.toString());
            return;
        }
        PriorityQueueTest.runBasicTests(queue);
    }

    protected static void runBasicTests(PriorityQueue<String> queue) {
        queue.add("a", 1.0);
        PriorityQueueTest.assertEquals((String)"Added a:1", (String)"[a=1.0]", (String)queue.toString());
        queue.add("b", 2.0);
        PriorityQueueTest.assertEquals((String)"Added b:2", (String)"[b=2.0, a=1.0]", (String)queue.toString());
        queue.add("c", 1.5);
        PriorityQueueTest.assertEquals((String)"Added c:1.5", (String)"[b=2.0, c=1.5, a=1.0]", (String)queue.toString());
        PriorityQueueTest.assertEquals((String)"removeFirst()", (String)"b", (String)queue.removeFirst());
        PriorityQueueTest.assertEquals((String)"queue", (String)"[c=1.5, a=1.0]", (String)queue.toString());
        PriorityQueueTest.assertEquals((String)"removeFirst()", (String)"c", (String)queue.removeFirst());
        PriorityQueueTest.assertEquals((String)"queue", (String)"[a=1.0]", (String)queue.toString());
        PriorityQueueTest.assertEquals((String)"removeFirst()", (String)"a", (String)queue.removeFirst());
        PriorityQueueTest.assertTrue((boolean)queue.isEmpty());
    }

    private static void runRelaxingTests(String className) {
        BinaryHeapPriorityQueue queue;
        try {
            queue = (BinaryHeapPriorityQueue)ErasureUtils.uncheckedCast(Class.forName(className).newInstance());
        }
        catch (Exception e) {
            PriorityQueueTest.fail((String)e.toString());
            return;
        }
        PriorityQueueTest.runRelaxingTests(queue);
    }

    protected static void runRelaxingTests(BinaryHeapPriorityQueue<String> queue) {
        queue.add("a", 1.0);
        PriorityQueueTest.assertEquals((String)"Added a:1", (String)"[a=1.0]", (String)queue.toString());
        queue.add("b", 2.0);
        PriorityQueueTest.assertEquals((String)"Added b:2", (String)"[b=2.0, a=1.0]", (String)queue.toString());
        queue.add("c", 1.5);
        PriorityQueueTest.assertEquals((String)"Added c:1.5", (String)"[b=2.0, c=1.5, a=1.0]", (String)queue.toString());
        queue.relaxPriority("a", 3.0);
        PriorityQueueTest.assertEquals((String)"Increased a to 3", (String)"[a=3.0, b=2.0, c=1.5]", (String)queue.toString());
        queue.decreasePriority("b", 0.0);
        PriorityQueueTest.assertEquals((String)"Decreased b to 0", (String)"[a=3.0, c=1.5, b=0.0]", (String)queue.toString());
        PriorityQueueTest.assertEquals((String)"removeFirst()", (String)"a", (String)queue.removeFirst());
        PriorityQueueTest.assertEquals((String)"queue", (String)"[c=1.5, b=0.0]", (String)queue.toString());
        PriorityQueueTest.assertEquals((String)"removeFirst()", (String)"c", (String)queue.removeFirst());
        PriorityQueueTest.assertEquals((String)"queue", (String)"[b=0.0]", (String)queue.toString());
        PriorityQueueTest.assertEquals((String)"removeFirst()", (String)"b", (String)queue.removeFirst());
        PriorityQueueTest.assertTrue((boolean)queue.isEmpty());
    }

    private static void runNotRelaxingTests(String className) {
        FixedPrioritiesPriorityQueue pq;
        try {
            pq = (FixedPrioritiesPriorityQueue)ErasureUtils.uncheckedCast(Class.forName(className).newInstance());
        }
        catch (Exception e) {
            PriorityQueueTest.fail((String)e.toString());
            return;
        }
        PriorityQueueTest.assertEquals((String)"[]", (String)pq.toString());
        pq.add("one", 1.0);
        PriorityQueueTest.assertEquals((String)"[one=1.0]", (String)pq.toString());
        pq.add("three", 3.0);
        PriorityQueueTest.assertEquals((String)"[three=3.0, one=1.0]", (String)pq.toString());
        pq.add("one", 1.1);
        PriorityQueueTest.assertEquals((String)"[three=3.0, one=1.1, one=1.0]", (String)pq.toString());
        pq.add("two", 2.0);
        PriorityQueueTest.assertEquals((String)"[three=3.0, two=2.0, one=1.1, one=1.0]", (String)pq.toString());
        PriorityQueueTest.assertEquals((String)"[three=3.000, two=2.000, ...]", (String)pq.toString(2));
        Object clone = pq.clone();
        PriorityQueueTest.assertEquals((Object)3.0, (Object)((FixedPrioritiesPriorityQueue)clone).getPriority());
        PriorityQueueTest.assertEquals((String)((String)pq.next()), (String)((String)((FixedPrioritiesPriorityQueue)clone).next()));
        PriorityQueueTest.assertEquals((Object)2.0, (Object)((FixedPrioritiesPriorityQueue)clone).getPriority());
        PriorityQueueTest.assertEquals((String)((String)pq.next()), (String)((String)((FixedPrioritiesPriorityQueue)clone).next()));
        PriorityQueueTest.assertEquals((Object)1.1, (Object)((FixedPrioritiesPriorityQueue)clone).getPriority());
        PriorityQueueTest.assertEquals((String)((String)pq.next()), (String)((String)((FixedPrioritiesPriorityQueue)clone).next()));
        PriorityQueueTest.assertEquals((Object)1.0, (Object)((FixedPrioritiesPriorityQueue)clone).getPriority());
        PriorityQueueTest.assertEquals((String)((String)pq.next()), (String)((String)((FixedPrioritiesPriorityQueue)clone).next()));
        PriorityQueueTest.assertFalse((boolean)((FixedPrioritiesPriorityQueue)clone).hasNext());
        PriorityQueueTest.assertTrue((boolean)((AbstractCollection)clone).isEmpty());
    }
}

