/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.pascal;

import edu.stanford.nlp.ie.pascal.ISODateInstance;
import junit.framework.TestCase;

public class ISODateInstanceTest
extends TestCase {
    private String[] dateStrings = new String[]{"February 5, 1923", "Mar 3", "18 July 2005", "18 Sep 05", "Jan. 13 , '90", "Jan. 13", "01/03/07", "03-27-85", "1900-1946", "1900--1946", "June 8-10", "today, Saturday", "Saturday, June 10", "Dec. 27", "1438143814381434"};
    private String[] dateAnswers = new String[]{"19230205", "****0303", "20050718", "20050918", "19900113", "****0113", "20070103", "19850327", "1900/1946", "1900/1946", "****0608/****0610", "saturday", "****0610", "****1227", "1438"};
    private String[] staticCompatibleStrings1 = new String[]{"20071203", "****1203", "200712", "****1112"};
    private String[] staticCompatibleStrings2 = new String[]{"20071203", "20071203", "200412", "******12"};
    private boolean[] staticCompatibleAnswers = new boolean[]{true, true, false, true};
    private String[] staticAfterStrings2 = new String[]{"20071203", "20071203", "200712", "200712", "200701", "****05", "200703", "200703", "****11", "******03"};
    private String[] staticAfterStrings1 = new String[]{"20071207", "2008", "2008", "2007", "200703", "****06", "2006", "200701", "******03", "****11"};
    private boolean[] staticAfterAnswers = new boolean[]{true, true, true, false, true, true, false, false, true, true};
    private String[] originalDates = new String[]{"18 July 2005", "18 July 2005", "18 July 2005", "1 February 2008", "1 February 2008", "1 February", "1 February", "1 January 2008", "31 December 2007", "1 January", "31 December"};
    private String[] relativeArguments = new String[]{"today", "tomorrow", "yesterday", "tomorrow", "yesterday", "tomorrow", "yesterday", "yesterday", "tomorrow", "yesterday", "tomorrow"};
    private String[] relativeDateAnswers = new String[]{"20050718", "20050719", "20050717", "20080202", "20080131", "****0202", "****0131", "20071231", "20080101", "****1231", "****0101"};

    public void testDateNormalization() {
        ISODateInstanceTest.assertEquals((int)this.dateStrings.length, (int)this.dateAnswers.length);
        for (int i = 0; i < this.dateStrings.length; ++i) {
            ISODateInstance d = new ISODateInstance(this.dateStrings[i]);
            ISODateInstanceTest.assertEquals((String)("Testing " + this.dateStrings[i]), (String)this.dateAnswers[i], (String)d.toString());
        }
    }

    public void testIsAfter() {
        for (int i = 0; i < this.staticAfterStrings1.length; ++i) {
            ISODateInstanceTest.assertEquals((String)("Testing " + this.staticAfterStrings1[i] + " and " + this.staticAfterStrings2[i]), (boolean)this.staticAfterAnswers[i], (boolean)ISODateInstance.isAfter(this.staticAfterStrings1[i], this.staticAfterStrings2[i]));
        }
    }

    public void testIsCompatible() {
        for (int i = 0; i < this.staticCompatibleStrings1.length; ++i) {
            ISODateInstanceTest.assertEquals((String)("Testing " + this.staticCompatibleStrings1[i] + " and " + this.staticCompatibleStrings2[i]), (boolean)this.staticCompatibleAnswers[i], (boolean)ISODateInstance.isCompatible(this.staticCompatibleStrings1[i], this.staticCompatibleStrings2[i]));
        }
    }

    public void testRelativeDateCreation() {
        for (int i = 0; i < this.originalDates.length; ++i) {
            ISODateInstanceTest.assertEquals((String)("Testing " + this.relativeArguments[i] + " with respect to " + this.originalDates[i]), (String)this.relativeDateAnswers[i], (String)new ISODateInstance(new ISODateInstance(this.originalDates[i]), this.relativeArguments[i]).getDateString());
        }
    }

    public void testContains() {
    }
}

