/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.qe;

import edu.stanford.nlp.ie.qe.Unit;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.tokensregex.Env;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;

public class UnitPrefix {
    public String name;
    public String symbol;
    public Double scale;
    public String system;

    public UnitPrefix(String name, String symbol, Double scale, String system) {
        this.name = name;
        this.symbol = symbol;
        this.scale = scale;
        this.system = system;
    }

    private Unit convert(Unit u) {
        return new Unit(this.name + u.getName(), this.symbol + u.getSymbol(), u.getType(), u, this.scale);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public Double getScale() {
        return this.scale;
    }

    public void setScale(Double scale) {
        this.scale = scale;
    }

    public void setScale(Number scale) {
        this.scale = scale.doubleValue();
    }

    public static void registerPrefixes(Env env, String filename) throws IOException {
        List<UnitPrefix> prefixes = UnitPrefix.loadPrefixes(filename);
        UnitPrefix.registerPrefixes(env, prefixes);
    }

    public static void registerPrefixes(Env env, List<UnitPrefix> prefixes) {
        for (UnitPrefix prefix : prefixes) {
            UnitPrefix.registerPrefix(env, prefix);
        }
    }

    public static void registerPrefix(Env env, UnitPrefix prefix) {
        env.bind(prefix.getName().toUpperCase(), prefix);
    }

    public static List<UnitPrefix> loadPrefixes(String filename) throws IOException {
        String line;
        Pattern commaPattern = Pattern.compile("\\s*,\\s*");
        BufferedReader br = IOUtils.getBufferedFileReader(filename);
        String headerString = br.readLine();
        String[] header = commaPattern.split(headerString);
        HashMap<String, Integer> headerIndex = new HashMap<String, Integer>();
        for (int i = 0; i < header.length; ++i) {
            headerIndex.put(header[i], i);
        }
        int iName = (Integer)headerIndex.get("name");
        int iPrefix = (Integer)headerIndex.get("prefix");
        int iBase = (Integer)headerIndex.get("base");
        int iExp = (Integer)headerIndex.get("exp");
        int iSystem = (Integer)headerIndex.get("system");
        ArrayList<UnitPrefix> list = new ArrayList<UnitPrefix>();
        while ((line = br.readLine()) != null) {
            String[] fields = commaPattern.split(line);
            double base = Double.parseDouble(fields[iBase]);
            double exp = Double.parseDouble(fields[iExp]);
            double scale = Math.pow(base, exp);
            UnitPrefix unitPrefix = new UnitPrefix(fields[iName], fields[iPrefix], scale, fields[iSystem]);
            list.add(unitPrefix);
        }
        br.close();
        return list;
    }
}

