/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.parser.common.ParserAnnotations;
import edu.stanford.nlp.parser.common.ParserConstraint;
import edu.stanford.nlp.parser.common.ParserQuery;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreePrint;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class LexicalizedParserITest
extends TestCase {
    private static LexicalizedParser englishParser = null;
    private static TreePrint tagPrint = null;
    private static TreePrint pennPrint = null;
    private static TreePrint typDepPrint = null;
    private static TreePrint typDepColPrint = null;
    private static LexicalizedParser chineseParser = null;
    private static TreePrint chinesePennPrint = null;
    private static TreePrint chineseTypDepPrint = null;
    private static final String chineseTest = "\u6211 \u770b \u4e86 \u4e00 \u6761 \u72d7";
    private static final String expectedChineseTree = "(ROOT (IP (NP (PN \u6211)) (VP (VV \u770b) (AS \u4e86) (NP (QP (CD \u4e00) (CLP (M \u6761))) (NP (NN \u72d7))))))";
    private static final String expectedChineseDeps = "nsubj(\u770b-2, \u6211-1) root(ROOT-0, \u770b-2) asp(\u770b-2, \u4e86-3) nummod(\u6761-5, \u4e00-4) clf(\u72d7-6, \u6761-5) dobj(\u770b-2, \u72d7-6)";
    private static final String chineseTest2 = "\u8fd9\u91cc \u662f \u65b0\u95fb \u4e4b \u591c \uff0e";
    private static final String expectedChineseTree2 = "(ROOT (IP (NP (PN \u8fd9\u91cc)) (VP (VC \u662f) (NP (DNP (NP (NN \u65b0\u95fb)) (DEG \u4e4b)) (NP (NN \u591c)))) (PU \uff0e)))";
    private static final String expectedChineseDeps2 = "nsubj(\u591c-5, \u8fd9\u91cc-1) cop(\u591c-5, \u662f-2) assmod(\u591c-5, \u65b0\u95fb-3) case(\u65b0\u95fb-3, \u4e4b-4) root(ROOT-0, \u591c-5)";
    private static final String expectedChineseDeps2sd = "top(\u662f-2, \u8fd9\u91cc-1) root(ROOT-0, \u662f-2) assmod(\u591c-5, \u65b0\u95fb-3) assm(\u65b0\u95fb-3, \u4e4b-4) attr(\u662f-2, \u591c-5)";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        Class<LexicalizedParserITest> clazz = LexicalizedParserITest.class;
        synchronized (LexicalizedParserITest.class) {
            if (englishParser == null) {
                englishParser = LexicalizedParser.loadModel();
                TreebankLanguagePack tLP = LexicalizedParserITest.englishParser.getOp().tlpParams.treebankLanguagePack();
                tagPrint = new TreePrint("wordsAndTags", tLP);
                pennPrint = new TreePrint("penn", tLP);
                typDepPrint = new TreePrint("typedDependencies", "basicDependencies", tLP);
                typDepColPrint = new TreePrint("typedDependencies", tLP);
                File englishPath = new File(LexicalizedParser.DEFAULT_PARSER_LOC);
                String chinesePath = englishPath.getParent() + File.separator + "chineseFactored.ser.gz";
                chineseParser = LexicalizedParser.loadModel(chinesePath, new String[0]);
                tLP = LexicalizedParserITest.chineseParser.getOp().tlpParams.treebankLanguagePack();
                chineseParser.getTLPParams().setGenerateOriginalDependencies(true);
                chinesePennPrint = new TreePrint("penn", tLP);
                chineseTypDepPrint = new TreePrint("typedDependencies", "basicDependencies", tLP);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void compareSingleOutput(Tree results, boolean outputResults, TreePrint printer, String expectedOutput) {
        StringWriter sw = new StringWriter();
        printer.printTree(results, new PrintWriter(sw));
        if (expectedOutput != null) {
            expectedOutput = expectedOutput.replaceAll("\\s+", " ").trim();
        }
        String actualOutput = sw.toString().replaceAll("\\s+", " ").trim();
        if (outputResults) {
            if (expectedOutput != null) {
                System.out.println(expectedOutput);
            }
            System.out.println(actualOutput);
        }
        if (expectedOutput != null) {
            LexicalizedParserITest.assertEquals((String)expectedOutput, (String)actualOutput);
        }
    }

    private static void compareOutput(Tree results, boolean outputResults, String expectedTags, String expectedPenn, String expectedDep, String expectedDepCol) {
        LexicalizedParserITest.compareSingleOutput(results, outputResults, tagPrint, expectedTags);
        LexicalizedParserITest.compareSingleOutput(results, outputResults, pennPrint, expectedPenn);
        LexicalizedParserITest.compareSingleOutput(results, outputResults, typDepPrint, expectedDep);
        LexicalizedParserITest.compareSingleOutput(results, outputResults, typDepColPrint, expectedDepCol);
    }

    private static List<CoreLabel> sampleSausage() {
        String[] words = new String[]{"My", "dog", "also", "likes", "eating", "sausage", "."};
        return SentenceUtils.toCoreLabelList(words);
    }

    public void testParseString() {
        Tree results = englishParser.parse("My dog likes to eat yoghurt.");
        LexicalizedParserITest.compareOutput(results, false, "My/PRP$ dog/NN likes/VBZ to/TO eat/VB yoghurt/NN ./.", "(ROOT (S (NP (PRP$ My) (NN dog)) (VP (VBZ likes) (S (VP (TO to) (VP (VB eat) (NP (NN yoghurt)))))) (. .)))", "nmod:poss(dog-2, My-1) nsubj(likes-3, dog-2) root(ROOT-0, likes-3) mark(eat-5, to-4) xcomp(likes-3, eat-5) dobj(eat-5, yoghurt-6)", "nmod:poss(dog-2, My-1) nsubj(likes-3, dog-2) nsubj:xsubj(eat-5, dog-2) root(ROOT-0, likes-3) mark(eat-5, to-4) xcomp(likes-3, eat-5) dobj(eat-5, yoghurt-6)");
    }

    public void testParserQuery() {
        List<CoreLabel> sentence = LexicalizedParserITest.sampleSausage();
        ParserQuery pq = englishParser.parserQuery();
        pq.parse(sentence);
        LexicalizedParserITest.compareSingleOutput(pq.getBestParse(), false, pennPrint, "(ROOT (S (NP (PRP$ My) (NN dog)) (ADVP (RB also)) (VP (VBZ likes) (S (VP (VBG eating) (NP (NN sausage))))) (. .)))");
    }

    public void testParseMultiple() {
        ArrayList<List<CoreLabel>> sentences = new ArrayList<List<CoreLabel>>();
        sentences.add(SentenceUtils.toCoreLabelList("The", "Flyers", "lost", "again", "last", "night", "."));
        sentences.add(SentenceUtils.toCoreLabelList("If", "this", "continues", ",", "they", "will", "miss", "the", "playoffs", "."));
        sentences.add(SentenceUtils.toCoreLabelList("Hopefully", "they", "can", "turn", "it", "around", "."));
        sentences.add(SentenceUtils.toCoreLabelList("Winning", "on", "Wednesday", "would", "be", "a", "good", "first", "step", "."));
        sentences.add(SentenceUtils.toCoreLabelList("Their", "next", "opponent", "is", "quite", "bad", "."));
        List<Tree> results1 = englishParser.parseMultiple(sentences);
        List<Tree> results2 = englishParser.parseMultiple(sentences, 3);
        LexicalizedParserITest.assertEquals(results1, results2);
    }

    public void testConstraints() {
        List<CoreLabel> sentence = LexicalizedParserITest.sampleSausage();
        ParserQuery pq = englishParser.parserQuery();
        ParserConstraint constraint = new ParserConstraint(0, 2, "SBAR|SBAR[^a-zA-Z].*");
        ArrayList<ParserConstraint> constraints = new ArrayList<ParserConstraint>();
        constraints.add(constraint);
        pq.setConstraints(constraints);
        pq.parse(sentence);
        StringWriter sw = new StringWriter();
        pennPrint.printTree(pq.getBestParse(), new PrintWriter(sw));
        String actualOutput = sw.toString().replaceAll("\\s+", " ").trim();
        String expectedOutput = "(ROOT (S (NP (PRP$ My) (NN dog)) (ADVP (RB also)) (VP (VBZ likes) (S (VP (VBG eating) (NP (NN sausage))))) (. .)))";
        expectedOutput = expectedOutput.replaceAll("\\s+", " ").trim();
        LexicalizedParserITest.assertFalse((String)"Tree should not match the original tree any more", (boolean)expectedOutput.equals(actualOutput));
        LexicalizedParserITest.assertTrue((String)"Tree should be forced to contain SBAR", (boolean)actualOutput.contains("SBAR"));
    }

    public static void testChineseDependencies() {
        Tree tree = chineseParser.parse(chineseTest);
        LexicalizedParserITest.compareSingleOutput(tree, false, chinesePennPrint, expectedChineseTree);
        LexicalizedParserITest.compareSingleOutput(tree, false, chineseTypDepPrint, expectedChineseDeps);
    }

    public void testChineseDependenciesSemanticHead() {
        Tree tree = chineseParser.parse(chineseTest2);
        LexicalizedParserITest.compareSingleOutput(tree, false, chinesePennPrint, expectedChineseTree2);
        LexicalizedParserITest.compareSingleOutput(tree, false, chineseTypDepPrint, expectedChineseDeps2sd);
        TreePrint paramsTreePrint = new TreePrint("typedDependencies", "basicDependencies", chineseParser.treebankLanguagePack(), chineseParser.getTLPParams().headFinder(), chineseParser.getTLPParams().typedDependencyHeadFinder());
        LexicalizedParserITest.compareSingleOutput(tree, false, paramsTreePrint, expectedChineseDeps2sd);
    }

    public void testAlreadyTagged() {
        List<CoreLabel> words = SentenceUtils.toCoreLabelList("foo", "bar", "baz");
        words.get(1).setTag("JJ");
        Tree tree = englishParser.parse(words);
        LexicalizedParserITest.assertEquals((String)"JJ", (String)tree.taggedYield().get(1).tag());
        words.get(1).setTag("NN");
        tree = englishParser.parse(words);
        LexicalizedParserITest.assertEquals((String)"NN", (String)tree.taggedYield().get(1).tag());
    }

    public void testTagRegex() {
        List<CoreLabel> words = SentenceUtils.toCoreLabelList("foo", "bar", "baz");
        words.get(1).set(ParserAnnotations.CandidatePartOfSpeechAnnotation.class, "JJ");
        Tree tree = englishParser.parse(words);
        LexicalizedParserITest.assertEquals((String)"JJ", (String)tree.taggedYield().get(1).tag());
        words.get(1).set(ParserAnnotations.CandidatePartOfSpeechAnnotation.class, "NN|NNP");
        tree = englishParser.parse(words);
        LexicalizedParserITest.assertTrue((tree.taggedYield().get(1).tag().equals("NN") || tree.taggedYield().get(1).tag().equals("NNP") ? 1 : 0) != 0);
    }

    public void testCharOffsets() {
        String text = "  You can  eat fruits   such as apples and   oranges.";
        String[] tokens = new String[]{"You", "can", "eat", "fruits", "such", "as", "apples", "and", "oranges", "."};
        int[] begins = new int[]{2, 6, 11, 15, 24, 29, 32, 39, 45, 52};
        int[] ends = new int[]{5, 9, 14, 21, 28, 31, 38, 42, 52, 53};
        Tree tree = englishParser.parse(text);
        List yield = tree.yield(new ArrayList());
        LexicalizedParserITest.assertEquals((String)"Wrong number of tokens in parser output", (int)tokens.length, (int)yield.size());
        int i = 0;
        for (CoreLabel cl : yield) {
            LexicalizedParserITest.assertEquals((String)"Wrong token", (String)tokens[i], (String)cl.word());
            LexicalizedParserITest.assertEquals((String)"Wrong char begin", (int)begins[i], (int)((Integer)cl.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class)));
            LexicalizedParserITest.assertEquals((String)"Wrong char end", (int)ends[i], (int)((Integer)cl.get(CoreAnnotations.CharacterOffsetEndAnnotation.class)));
            ++i;
        }
    }
}

