/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.metrics;

import edu.stanford.nlp.util.Pair;

public class EvaluationMetric {
    private double numTestInstances = 0.0;
    private double exact = 0.0;
    private double precisions = 0.0;
    private double precisions2 = 0.0;
    private double recalls = 0.0;
    private double recalls2 = 0.0;
    private double pnums2 = 0.0;
    private double rnums2 = 0.0;
    private double f1s = 0.0;
    private double lastP = 0.0;
    private double lastR = 0.0;
    private double lastF1 = 0.0;

    public void update(double curP, double curPnum, double curR, double curRnum) {
        double curF1;
        this.numTestInstances += 1.0;
        double d = curF1 = curP > 0.0 && curR > 0.0 ? 2.0 / (1.0 / curP + 1.0 / curR) : 0.0;
        if (curF1 >= 0.9999) {
            this.exact += 1.0;
        }
        this.precisions += curP;
        this.recalls += curR;
        this.f1s += curF1;
        this.precisions2 += curPnum * curP;
        this.pnums2 += curPnum;
        this.recalls2 += curRnum * curR;
        this.rnums2 += curRnum;
        this.lastP = curP;
        this.lastR = curR;
        this.lastF1 = curF1;
    }

    public Pair<Double, Double> getPFractionals() {
        return new Pair<Double, Double>(this.precisions2, this.pnums2);
    }

    public Pair<Double, Double> getRFractionals() {
        return new Pair<Double, Double>(this.recalls2, this.rnums2);
    }

    public double getTestInstances() {
        return this.numTestInstances;
    }

    public double numRelevantExamples() {
        return this.rnums2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        double pSent = this.numTestInstances > 0.0 ? this.precisions / this.numTestInstances : 0.0;
        double pEvalB = this.pnums2 > 0.0 ? this.precisions2 / this.pnums2 : 0.0;
        sb.append(String.format("P: %.2f (sent ave: %.2f) (evalb: %.2f)%n", this.lastP * 100.0, pSent * 100.0, pEvalB * 100.0));
        double rSent = this.numTestInstances > 0.0 ? this.recalls / this.numTestInstances : 0.0;
        double rEvalB = this.rnums2 > 0.0 ? this.recalls2 / this.rnums2 : 0.0;
        sb.append(String.format("R: %.2f (sent ave: %.2f) (evalb: %.2f)%n", this.lastR * 100.0, rSent * 100.0, rEvalB * 100.0));
        double f1Sent = this.numTestInstances > 0.0 ? this.f1s / this.numTestInstances : 0.0;
        double f1EvalB = pEvalB > 0.0 && rEvalB > 0.0 ? 2.0 / (1.0 / pEvalB + 1.0 / rEvalB) : 0.0;
        sb.append(String.format("F1: %.2f (sent ave: %.2f) (evalb: %.2f)%n", this.lastF1 * 100.0, f1Sent * 100.0, f1EvalB * 100.0));
        sb.append(String.format("Num:\t%.2f (test instances)%n", this.numTestInstances));
        sb.append(String.format("Rel:\t%.0f (relevant examples)%n", this.rnums2));
        sb.append(String.format("Exact:\t%.2f (test instances)%n", this.exact));
        return sb.toString();
    }
}

